/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.jmx.MBeanRegistrar;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.message.store.MessageStore;
import org.apache.synapse.message.store.MessageStoreObserver;
import org.apache.synapse.message.store.MessageStoreView;

public abstract class AbstractMessageStore
implements MessageStore {
    private static final Log logger = LogFactory.getLog((String)AbstractMessageStore.class.getName());
    protected String name;
    protected String sequence;
    protected MessageStoreView messageStoreMBean;
    protected SynapseConfiguration synapseConfiguration;
    protected SynapseEnvironment synapseEnvironment;
    protected Map<String, Object> parameters;
    protected Map<String, String> parameterKeyMap;
    protected String description;
    protected String fileName;
    protected List<MessageStoreObserver> messageStoreObservers = new ArrayList<MessageStoreObserver>();
    protected Lock lock = new ReentrantLock();
    private MessageStore store;
    private AtomicInteger producerId = new AtomicInteger(0);
    private AtomicInteger consumerId = new AtomicInteger(0);
    private int maxProducerId = Integer.MAX_VALUE;
    private AtomicLong enqueued = new AtomicLong(0L);
    private AtomicLong dequeued = new AtomicLong(0L);
    private static final long maxEnDequeuable = Long.MAX_VALUE;
    private final Object messageCountLock = new Object();
    private String artifactContainerName;
    private boolean isEdited;

    @Override
    public void init(SynapseEnvironment se) {
        this.synapseEnvironment = se;
        this.synapseConfiguration = this.synapseEnvironment.getSynapseConfiguration();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Initialized store [" + this.getName() + "]..."));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (name == null || "".equals(name)) {
            logger.warn((Object)"Invalid name.");
            return;
        }
        this.name = name;
        this.messageStoreMBean = new MessageStoreView(name, this);
        MBeanRegistrar.getInstance().registerMBean((Object)this.messageStoreMBean, "MessageStore", this.name);
    }

    public void registerObserver(MessageStoreObserver observer) {
        if (observer != null && !this.messageStoreObservers.contains(observer)) {
            this.messageStoreObservers.add(observer);
        }
    }

    public void unregisterObserver(MessageStoreObserver observer) {
        if (observer != null && this.messageStoreObservers.contains(observer)) {
            this.messageStoreObservers.remove(observer);
        }
    }

    protected void notifyMessageAddition(String messageId) {
        for (MessageStoreObserver o : this.messageStoreObservers) {
            o.messageAdded(messageId);
        }
    }

    protected void notifyMessageRemoval(String messageId) {
        for (MessageStoreObserver o : this.messageStoreObservers) {
            o.messageRemoved(messageId);
        }
    }

    @Override
    public int size() {
        return -1;
    }

    @Override
    public Map<String, Object> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public void setParameters(Map<String, Object> parameters) {
        if (parameters == null) {
            this.parameters = new HashMap<String, Object>();
            return;
        }
        this.parameters = parameters;
    }

    @Override
    public void addParameter(String name, String key) {
        this.parameters.put(name, key);
    }

    @Override
    public void addParameterKey(String name, String key) {
        if (this.parameterKeyMap == null) {
            this.parameterKeyMap = new HashMap<String, String>();
        }
        this.parameterKeyMap.put(name, key);
    }

    @Override
    public String getParameterKey(String name) {
        if (this.parameterKeyMap != null) {
            return this.parameterKeyMap.get(name);
        }
        return null;
    }

    @Override
    public Map<String, String> getParameterKeyMap() {
        return this.parameterKeyMap;
    }

    @Override
    public void destroy() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Destroyed store [" + this.getName() + "]..."));
        }
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setFileName(String filename) {
        this.fileName = filename;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public int getType() {
        return 4;
    }

    public Lock getLock() {
        return this.lock;
    }

    public int nextProducerId() {
        int id = this.producerId.incrementAndGet();
        if (id == this.maxProducerId) {
            logger.info((Object)"Setting producer ID generator to 0...");
            this.producerId.set(0);
            id = this.producerId.incrementAndGet();
        }
        return id;
    }

    public int nextConsumerId() {
        int id = this.consumerId.incrementAndGet();
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueued() {
        Object object = this.messageCountLock;
        synchronized (object) {
            this.enqueued.compareAndSet(Long.MAX_VALUE, 0L);
            this.enqueued.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dequeued() {
        Object object = this.messageCountLock;
        synchronized (object) {
            this.dequeued.compareAndSet(Long.MAX_VALUE, 0L);
            this.dequeued.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long difference() {
        Object object = this.messageCountLock;
        synchronized (object) {
            long diff = this.enqueued.get() - this.dequeued.get();
            return diff;
        }
    }

    @Override
    public boolean isEdited() {
        return this.isEdited;
    }

    @Override
    public void setIsEdited(boolean isEdited) {
        this.isEdited = isEdited;
    }

    @Override
    public String getArtifactContainerName() {
        return this.artifactContainerName;
    }

    @Override
    public void setArtifactContainerName(String artifactContainerName) {
        this.artifactContainerName = artifactContainerName;
    }
}

