/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.senders.blocking;

import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.util.JavaUtils;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.SOAPUtils;
import org.apache.synapse.endpoints.EndpointDefinition;
import org.apache.synapse.util.MessageHelper;

public class BlockingMsgSenderUtils {
    private static String[] allowedProperties = new String[]{"JSON_OBJECT", "JSON_STRING", "setCharacterEncoding", "distributedTx", "distributedTxMgr", "HTTP_METHOD", "messageType", "ContentType", "REST_URL_POSTFIX", "REQUEST_HOST_HEADER"};

    public static void fillClientOptions(EndpointDefinition endpoint, Options clientOptions, MessageContext synapseInMsgCtx) {
        org.apache.axis2.context.MessageContext axisInMsgCtx = ((Axis2MessageContext)synapseInMsgCtx).getAxis2MessageContext();
        if (endpoint != null) {
            boolean wsSecurityEnabled = endpoint.isSecurityOn();
            if (wsSecurityEnabled) {
                String wsSecPolicyKey = endpoint.getWsSecPolicyKey();
                if (wsSecPolicyKey != null) {
                    if (endpoint.isDynamicPolicy()) {
                        wsSecPolicyKey = endpoint.evaluateDynamicEndpointSecurityPolicy(synapseInMsgCtx);
                    }
                    clientOptions.setProperty("rampartPolicy", (Object)MessageHelper.getPolicy(synapseInMsgCtx, wsSecPolicyKey));
                } else {
                    String inboundWsSecPolicyKey = endpoint.getInboundWsSecPolicyKey();
                    String outboundWsSecPolicyKey = endpoint.getOutboundWsSecPolicyKey();
                    if (inboundWsSecPolicyKey != null) {
                        clientOptions.setProperty("rampartInPolicy", (Object)MessageHelper.getPolicy(synapseInMsgCtx, inboundWsSecPolicyKey));
                    }
                    if (outboundWsSecPolicyKey != null) {
                        clientOptions.setProperty("rampartOutPolicy", (Object)MessageHelper.getPolicy(synapseInMsgCtx, outboundWsSecPolicyKey));
                    }
                }
            }
            clientOptions.setUseSeparateListener(endpoint.isUseSeparateListener());
        }
        if (axisInMsgCtx.getSoapAction() != null) {
            clientOptions.setAction(axisInMsgCtx.getSoapAction());
        }
        clientOptions.setExceptionToBeThrownOnSOAPFault("true".equals(synapseInMsgCtx.getProperty("FORCE_ERROR_ON_SOAP_FAULT")));
        if (axisInMsgCtx.getProperty("DISABLE_CHUNKING") != null && JavaUtils.isTrueExplicitly((Object)axisInMsgCtx.getProperty("DISABLE_CHUNKING"))) {
            clientOptions.setProperty("__CHUNKED__", (Object)"false");
        }
    }

    public static void fillMessageContext(EndpointDefinition endpoint, org.apache.axis2.context.MessageContext axisOutMsgCtx, MessageContext synapseInMsgCtx) throws AxisFault {
        String preserveAddressingProperty;
        boolean isRest;
        org.apache.axis2.context.MessageContext axisInMsgCtx = ((Axis2MessageContext)synapseInMsgCtx).getAxis2MessageContext();
        BlockingMsgSenderUtils.setProperties(axisInMsgCtx, axisOutMsgCtx);
        axisOutMsgCtx.setProperty("TRANSPORT_HEADERS", axisInMsgCtx.getProperty("TRANSPORT_HEADERS"));
        if (endpoint.getFormat() != null) {
            String format = endpoint.getFormat();
            if ("pox".equals(format)) {
                axisOutMsgCtx.setDoingREST(true);
                axisOutMsgCtx.setProperty("messageType", (Object)"application/xml");
                axisOutMsgCtx.setProperty("ContentType", (Object)"application/xml");
            } else if ("get".equals(format)) {
                axisOutMsgCtx.setDoingREST(true);
                axisOutMsgCtx.setProperty("HTTP_METHOD", (Object)"GET");
                axisOutMsgCtx.setProperty("messageType", (Object)"application/x-www-form-urlencoded");
            } else if ("soap11".equals(format)) {
                axisOutMsgCtx.setDoingREST(false);
                axisOutMsgCtx.removeProperty("messageType");
                axisOutMsgCtx.setProperty("HTTP_METHOD", (Object)"POST");
                if (axisOutMsgCtx.getSoapAction() == null && axisOutMsgCtx.getWSAAction() != null) {
                    axisOutMsgCtx.setSoapAction(axisOutMsgCtx.getWSAAction());
                }
                if (!axisOutMsgCtx.isSOAP11()) {
                    SOAPUtils.convertSOAP12toSOAP11(axisOutMsgCtx);
                }
            } else if ("soap12".equals(format)) {
                axisOutMsgCtx.setDoingREST(false);
                axisOutMsgCtx.removeProperty("messageType");
                axisOutMsgCtx.setProperty("HTTP_METHOD", (Object)"POST");
                if (axisOutMsgCtx.getSoapAction() == null && axisOutMsgCtx.getWSAAction() != null) {
                    axisOutMsgCtx.setSoapAction(axisOutMsgCtx.getWSAAction());
                }
                if (axisOutMsgCtx.isSOAP11()) {
                    SOAPUtils.convertSOAP11toSOAP12(axisOutMsgCtx);
                }
            } else if ("rest".equals(format)) {
                if (axisInMsgCtx.getProperty("HTTP_METHOD") != null && (axisInMsgCtx.getProperty("HTTP_METHOD").toString().equals("GET") || axisInMsgCtx.getProperty("HTTP_METHOD").toString().equals("DELETE"))) {
                    axisOutMsgCtx.removeProperty("messageType");
                }
                axisOutMsgCtx.setDoingREST(true);
            }
        }
        if (endpoint.isUseMTOM()) {
            axisOutMsgCtx.setDoingMTOM(true);
            axisOutMsgCtx.setProperty("enableMTOM", (Object)"true");
            axisOutMsgCtx.setDoingMTOM(true);
        } else if (endpoint.isUseSwa()) {
            axisOutMsgCtx.setDoingSwA(true);
            axisOutMsgCtx.setProperty("enableSwA", (Object)"true");
            axisOutMsgCtx.setDoingSwA(true);
        }
        if (endpoint.getCharSetEncoding() != null) {
            axisOutMsgCtx.setProperty("CHARACTER_SET_ENCODING", (Object)endpoint.getCharSetEncoding());
        }
        if (endpoint.isHTTPEndpoint()) {
            axisOutMsgCtx.setProperty("HTTP_METHOD", synapseInMsgCtx.getProperty("HTTP_METHOD"));
        }
        if (!((isRest = "rest".equals(endpoint.getFormat()) | axisInMsgCtx.isDoingREST()) || endpoint.isForceSOAP11() || endpoint.isForceSOAP12())) {
            isRest = BlockingMsgSenderUtils.isRequestRest(axisInMsgCtx);
        }
        String restURLPostfix = (String)axisOutMsgCtx.getProperty("REST_URL_POSTFIX");
        if (endpoint.getAddress() != null) {
            String address = endpoint.getAddress(synapseInMsgCtx);
            if (isRest && restURLPostfix != null && !"".equals(restURLPostfix) && (address.startsWith("http://") || address.startsWith("https://"))) {
                address = BlockingMsgSenderUtils.getEPRWithRestURLPostfix(restURLPostfix, address);
            }
            axisOutMsgCtx.setTo(new EndpointReference(address));
        } else {
            EndpointReference endpointReference = axisOutMsgCtx.getTo();
            if (endpointReference != null) {
                if (isRest && restURLPostfix != null && !"".equals(restURLPostfix)) {
                    String address = endpointReference.getAddress();
                    address = BlockingMsgSenderUtils.getEPRWithRestURLPostfix(restURLPostfix, address);
                    axisOutMsgCtx.setTo(new EndpointReference(address));
                } else {
                    axisInMsgCtx.setTo(endpointReference);
                }
            }
        }
        if (endpoint.isUseSeparateListener()) {
            axisOutMsgCtx.getOptions().setUseSeparateListener(true);
        }
        if (endpoint.getEffectiveTimeout() > 0L) {
            if (!endpoint.isDynamicTimeoutEndpoint()) {
                long effectiveTimeout = endpoint.getEffectiveTimeout();
                axisOutMsgCtx.setProperty("SEND_TIMEOUT", (Object)effectiveTimeout);
                axisOutMsgCtx.setProperty("SO_TIMEOUT", (Object)((int)effectiveTimeout));
            } else {
                long dynamicTimeout = endpoint.evaluateDynamicEndpointTimeout(synapseInMsgCtx);
                axisOutMsgCtx.setProperty("SEND_TIMEOUT", (Object)dynamicTimeout);
                axisOutMsgCtx.setProperty("SO_TIMEOUT", (Object)((int)dynamicTimeout));
            }
        }
        if ((preserveAddressingProperty = (String)synapseInMsgCtx.getProperty("PRESERVE_WS_ADDRESSING")) != null && Boolean.parseBoolean(preserveAddressingProperty)) {
            axisOutMsgCtx.setMessageID(axisInMsgCtx.getMessageID());
        } else {
            MessageHelper.removeAddressingHeaders(axisOutMsgCtx);
            axisOutMsgCtx.setProperty("disableAddressingForOutMessages", (Object)Boolean.TRUE);
        }
    }

    private static String getEPRWithRestURLPostfix(String restURLPostfix, String address) {
        String url = !address.endsWith("/") && !restURLPostfix.startsWith("/") && !restURLPostfix.startsWith("?") ? address + "/" + restURLPostfix : (address.endsWith("/") && restURLPostfix.startsWith("/") ? address + restURLPostfix.substring(1) : (address.endsWith("/") && restURLPostfix.startsWith("?") ? address.substring(0, address.length() - 1) + restURLPostfix : address + restURLPostfix));
        return url;
    }

    private static boolean isRequestRest(org.apache.axis2.context.MessageContext originalInMsgCtx) {
        boolean isRestRequest;
        boolean bl = isRestRequest = originalInMsgCtx.getProperty("synapse.internal.rest.contentType") != null;
        if (!isRestRequest) {
            String httpMethod = (String)originalInMsgCtx.getProperty("HTTP_METHOD");
            boolean bl2 = isRestRequest = "GET".equals(httpMethod) || "DELETE".equals(httpMethod) || "PUT".equals(httpMethod) || "OPTIONS".equals(httpMethod) || "HEAD".equals(httpMethod);
            if (!isRestRequest) {
                isRestRequest = "POST".equals(httpMethod) && HTTPTransportUtils.isRESTRequest((String)String.valueOf(originalInMsgCtx.getProperty("messageType")));
            }
        }
        return isRestRequest;
    }

    private static void setProperties(org.apache.axis2.context.MessageContext axisInMsgCtx, org.apache.axis2.context.MessageContext axisOutMsgCtx) {
        for (String propertyName : allowedProperties) {
            Object property = axisInMsgCtx.getProperty(propertyName);
            if (property == null) continue;
            axisOutMsgCtx.setProperty(propertyName, property);
        }
    }
}

