/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.senders.blocking;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseHandler;
import org.apache.synapse.commons.json.JsonUtil;
import org.apache.synapse.core.axis2.AnonymousServiceFactory;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.EndpointDefinition;
import org.apache.synapse.endpoints.IndirectEndpoint;
import org.apache.synapse.endpoints.OAuthConfiguredHTTPEndpoint;
import org.apache.synapse.endpoints.ResolvingEndpoint;
import org.apache.synapse.endpoints.TemplateEndpoint;
import org.apache.synapse.endpoints.oauth.MessageCache;
import org.apache.synapse.endpoints.oauth.OAuthUtils;
import org.apache.synapse.message.senders.blocking.BlockingMsgSenderUtils;
import org.apache.synapse.util.MediatorPropertyUtils;
import org.apache.synapse.util.MessageHelper;
import org.apache.synapse.util.xpath.SynapseXPath;

public class BlockingMsgSender {
    public static final String DEFAULT_CLIENT_REPO = "./repository/deployment/client";
    public static final String DEFAULT_AXIS2_XML;
    private static Log log;
    private String clientRepository = null;
    private String axis2xml = null;
    private ConfigurationContext configurationContext = null;
    boolean initClientOptions = true;
    private static final String LOCAL_ANON_SERVICE = "__LOCAL_ANON_SERVICE__";
    private Pattern errorMsgPattern = Pattern.compile("Transport error: \\d{3} .*");
    private Pattern statusCodePattern = Pattern.compile("\\d{3}");

    public void init() {
        try {
            if (this.configurationContext == null) {
                this.configurationContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)(this.clientRepository != null ? this.clientRepository : DEFAULT_CLIENT_REPO), (String)(this.axis2xml != null ? this.axis2xml : DEFAULT_AXIS2_XML));
            }
        }
        catch (AxisFault e) {
            this.handleException("Error initializing BlockingMessageSender", (Exception)((Object)e));
        }
    }

    public MessageContext send(Endpoint endpoint, MessageContext synapseInMsgCtx) throws Exception {
        Options clientOptions;
        AxisService anonymousService;
        Set keySet;
        AbstractEndpoint abstractEndpoint;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start Sending the Message ");
        }
        if (endpoint instanceof IndirectEndpoint) {
            String endpointKey = ((IndirectEndpoint)endpoint).getKey();
            endpoint = synapseInMsgCtx.getEndpoint(endpointKey);
        }
        if (endpoint instanceof TemplateEndpoint) {
            endpoint = ((TemplateEndpoint)endpoint).getRealEndpoint();
        }
        if (endpoint instanceof ResolvingEndpoint) {
            SynapseXPath keyExpression = ((ResolvingEndpoint)endpoint).getKeyExpression();
            String key = keyExpression.stringValueOf(synapseInMsgCtx);
            endpoint = ((ResolvingEndpoint)endpoint).loadAndInitEndpoint(((Axis2MessageContext)synapseInMsgCtx).getAxis2MessageContext().getConfigurationContext(), key);
        }
        if (!(abstractEndpoint = (AbstractEndpoint)endpoint).isLeafEndpoint()) {
            this.handleException("Endpoint Type not supported");
        }
        if ((keySet = synapseInMsgCtx.getPropertyKeySet()) != null) {
            keySet.remove("DYNAMIC_URL_VALUE");
        }
        abstractEndpoint.executeEpTypeSpecificFunctions(synapseInMsgCtx);
        EndpointDefinition endpointDefinition = abstractEndpoint.getDefinition();
        org.apache.axis2.context.MessageContext axisInMsgCtx = ((Axis2MessageContext)synapseInMsgCtx).getAxis2MessageContext();
        org.apache.axis2.context.MessageContext axisOutMsgCtx = new org.apache.axis2.context.MessageContext();
        String endpointReferenceValue = null;
        if (endpointDefinition.getAddress() != null) {
            endpointReferenceValue = endpointDefinition.getAddress();
        } else if (axisInMsgCtx.getTo() != null) {
            endpointReferenceValue = axisInMsgCtx.getTo().getAddress();
        } else {
            this.handleException("Service url, Endpoint or 'To' header is required");
        }
        EndpointReference epr = new EndpointReference(endpointReferenceValue);
        axisOutMsgCtx.setTo(epr);
        if (endpointReferenceValue != null && endpointReferenceValue.startsWith("local")) {
            this.configurationContext = axisInMsgCtx.getConfigurationContext();
            anonymousService = AnonymousServiceFactory.getAnonymousService(this.configurationContext.getAxisConfiguration(), LOCAL_ANON_SERVICE);
        } else {
            anonymousService = AnonymousServiceFactory.getAnonymousService(null, this.configurationContext.getAxisConfiguration(), endpointDefinition.isAddressingOn() | endpointDefinition.isReliableMessagingOn(), endpointDefinition.isReliableMessagingOn(), endpointDefinition.isSecurityOn(), false);
        }
        axisOutMsgCtx.setConfigurationContext(this.configurationContext);
        axisOutMsgCtx.setEnvelope(axisInMsgCtx.getEnvelope());
        axisOutMsgCtx.setProperty("non.error.http.status.codes", axisInMsgCtx.getProperty("non.error.http.status.codes"));
        axisOutMsgCtx.setProperty("error.http.status.codes", axisInMsgCtx.getProperty("error.http.status.codes"));
        axisOutMsgCtx.setProperty("DISABLE_CHUNKING", axisInMsgCtx.getProperty("DISABLE_CHUNKING"));
        axisOutMsgCtx.setProperty("NO_KEEPALIVE", axisInMsgCtx.getProperty("NO_KEEPALIVE"));
        axisOutMsgCtx.setProperty("NoDefaultContentType", axisInMsgCtx.getProperty("NoDefaultContentType"));
        BlockingMsgSenderUtils.fillMessageContext(endpointDefinition, axisOutMsgCtx, synapseInMsgCtx);
        if (JsonUtil.hasAJsonPayload((org.apache.axis2.context.MessageContext)axisInMsgCtx)) {
            JsonUtil.cloneJsonPayload((org.apache.axis2.context.MessageContext)axisInMsgCtx, (org.apache.axis2.context.MessageContext)axisOutMsgCtx);
        }
        if (this.initClientOptions) {
            clientOptions = new Options();
        } else {
            clientOptions = axisInMsgCtx.getOptions();
            clientOptions.setTo(epr);
        }
        BlockingMsgSenderUtils.fillClientOptions(endpointDefinition, clientOptions, synapseInMsgCtx);
        anonymousService.getParent().addParameter("hiddenService", (Object)"true");
        ServiceGroupContext serviceGroupContext = new ServiceGroupContext(this.configurationContext, (AxisServiceGroup)anonymousService.getParent());
        ServiceContext serviceCtx = serviceGroupContext.getServiceContext(anonymousService);
        axisOutMsgCtx.setServiceContext(serviceCtx);
        boolean isOutOnly = this.isOutOnly(synapseInMsgCtx, axisOutMsgCtx);
        try {
            if (!isOutOnly) {
                org.apache.axis2.context.MessageContext result = this.sendReceive(axisOutMsgCtx, clientOptions, anonymousService, serviceCtx, synapseInMsgCtx);
                if (result.getEnvelope() != null) {
                    synapseInMsgCtx.setEnvelope(result.getEnvelope());
                    if (JsonUtil.hasAJsonPayload((org.apache.axis2.context.MessageContext)result)) {
                        JsonUtil.cloneJsonPayload((org.apache.axis2.context.MessageContext)result, (org.apache.axis2.context.MessageContext)((Axis2MessageContext)synapseInMsgCtx).getAxis2MessageContext());
                    }
                }
                String statusCode = String.valueOf(result.getProperty("transport.http.statusCode")).trim();
                axisInMsgCtx.setProperty("HTTP_SC", (Object)statusCode);
                if ("false".equals(synapseInMsgCtx.getProperty("BLOCKING_SENDER_PRESERVE_REQ_HEADERS"))) {
                    axisInMsgCtx.setProperty("TRANSPORT_HEADERS", result.getProperty("TRANSPORT_HEADERS"));
                }
                synapseInMsgCtx.setProperty("blocking.sender.error", "false");
                this.invokeHandlers(synapseInMsgCtx);
                return synapseInMsgCtx;
            }
            this.sendRobust(axisOutMsgCtx, clientOptions, anonymousService, serviceCtx, synapseInMsgCtx);
            String httpStatusCode = String.valueOf(axisOutMsgCtx.getProperty("transport.http.statusCode")).trim();
            axisInMsgCtx.setProperty("HTTP_SC", (Object)httpStatusCode);
        }
        catch (Exception ex) {
            String errorStatusCode = this.extractStatusCodeFromException(ex);
            axisInMsgCtx.setProperty("HTTP_SC", (Object)errorStatusCode);
            if (!isOutOnly) {
                synapseInMsgCtx.setProperty("blocking.sender.error", "true");
                synapseInMsgCtx.setProperty("ERROR_EXCEPTION", ex);
                if (ex instanceof AxisFault) {
                    AxisFault fault = (AxisFault)((Object)ex);
                    this.setErrorDetails(synapseInMsgCtx, fault);
                    org.apache.axis2.context.MessageContext faultMC = fault.getFaultMessageContext();
                    if (faultMC != null) {
                        Object statusCode = faultMC.getProperty("transport.http.statusCode");
                        synapseInMsgCtx.setProperty("HTTP_SC", statusCode);
                        axisInMsgCtx.setProperty("HTTP_SC", statusCode);
                        synapseInMsgCtx.setEnvelope(faultMC.getEnvelope());
                    }
                }
                return synapseInMsgCtx;
            }
            if (ex instanceof AxisFault) {
                AxisFault fault = (AxisFault)((Object)ex);
                this.setErrorDetails(synapseInMsgCtx, fault);
            }
            this.handleException("Error sending Message to url : " + ((AbstractEndpoint)endpoint).getDefinition().getAddress(), ex);
        }
        return null;
    }

    public void send(EndpointDefinition endpointDefinition, MessageContext synapseInMsgCtx) throws AxisFault {
        block26: {
            Options clientOptions;
            AxisService anonymousService;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Start Sending the Message ");
            }
            org.apache.axis2.context.MessageContext axisInMsgCtx = ((Axis2MessageContext)synapseInMsgCtx).getAxis2MessageContext();
            org.apache.axis2.context.MessageContext axisOutMsgCtx = new org.apache.axis2.context.MessageContext();
            String endpointReferenceValue = null;
            if (endpointDefinition.getAddress() != null) {
                endpointReferenceValue = endpointDefinition.getAddress();
            } else if (axisInMsgCtx.getTo() != null) {
                endpointReferenceValue = axisInMsgCtx.getTo().getAddress();
            } else {
                this.handleException("Service url, Endpoint or 'To' header is required");
            }
            EndpointReference epr = new EndpointReference(endpointReferenceValue);
            axisOutMsgCtx.setTo(epr);
            if (endpointReferenceValue != null && endpointReferenceValue.startsWith("local")) {
                this.configurationContext = axisInMsgCtx.getConfigurationContext();
                anonymousService = AnonymousServiceFactory.getAnonymousService(this.configurationContext.getAxisConfiguration(), LOCAL_ANON_SERVICE);
            } else {
                anonymousService = AnonymousServiceFactory.getAnonymousService(null, this.configurationContext.getAxisConfiguration(), endpointDefinition.isAddressingOn() | endpointDefinition.isReliableMessagingOn(), endpointDefinition.isReliableMessagingOn(), endpointDefinition.isSecurityOn(), false);
            }
            axisOutMsgCtx.setConfigurationContext(this.configurationContext);
            axisOutMsgCtx.setEnvelope(axisInMsgCtx.getEnvelope());
            axisOutMsgCtx.setProperty("non.error.http.status.codes", axisInMsgCtx.getProperty("non.error.http.status.codes"));
            axisOutMsgCtx.setProperty("error.http.status.codes", axisInMsgCtx.getProperty("error.http.status.codes"));
            axisOutMsgCtx.setProperty("DISABLE_CHUNKING", axisInMsgCtx.getProperty("DISABLE_CHUNKING"));
            axisOutMsgCtx.setProperty("NO_KEEPALIVE", axisInMsgCtx.getProperty("NO_KEEPALIVE"));
            axisOutMsgCtx.setProperty("NoDefaultContentType", axisInMsgCtx.getProperty("NoDefaultContentType"));
            BlockingMsgSenderUtils.fillMessageContext(endpointDefinition, axisOutMsgCtx, synapseInMsgCtx);
            if (JsonUtil.hasAJsonPayload((org.apache.axis2.context.MessageContext)axisInMsgCtx)) {
                JsonUtil.cloneJsonPayload((org.apache.axis2.context.MessageContext)axisInMsgCtx, (org.apache.axis2.context.MessageContext)axisOutMsgCtx);
            }
            if (this.initClientOptions) {
                clientOptions = new Options();
            } else {
                clientOptions = axisInMsgCtx.getOptions();
                clientOptions.setTo(epr);
            }
            BlockingMsgSenderUtils.fillClientOptions(endpointDefinition, clientOptions, synapseInMsgCtx);
            anonymousService.getParent().addParameter("hiddenService", (Object)"true");
            ServiceGroupContext serviceGroupContext = new ServiceGroupContext(this.configurationContext, (AxisServiceGroup)anonymousService.getParent());
            ServiceContext serviceCtx = serviceGroupContext.getServiceContext(anonymousService);
            axisOutMsgCtx.setServiceContext(serviceCtx);
            boolean isOutOnly = this.isOutOnly(synapseInMsgCtx, axisOutMsgCtx);
            try {
                if (isOutOnly) {
                    this.sendRobust(axisOutMsgCtx, clientOptions, anonymousService, serviceCtx, synapseInMsgCtx);
                    String httpStatusCode = String.valueOf(axisOutMsgCtx.getProperty("transport.http.statusCode")).trim();
                    axisInMsgCtx.setProperty("HTTP_SC", (Object)httpStatusCode);
                    synapseInMsgCtx.setProperty("blocking.sender.error", "false");
                } else {
                    org.apache.axis2.context.MessageContext result = this.sendReceive(axisOutMsgCtx, clientOptions, anonymousService, serviceCtx, synapseInMsgCtx);
                    synapseInMsgCtx.setEnvelope(result.getEnvelope());
                    if (JsonUtil.hasAJsonPayload((org.apache.axis2.context.MessageContext)result)) {
                        JsonUtil.cloneJsonPayload((org.apache.axis2.context.MessageContext)result, (org.apache.axis2.context.MessageContext)((Axis2MessageContext)synapseInMsgCtx).getAxis2MessageContext());
                    }
                    String statusCode = String.valueOf(result.getProperty("transport.http.statusCode")).trim();
                    axisInMsgCtx.setProperty("HTTP_SC", (Object)statusCode);
                    if ("false".equals(synapseInMsgCtx.getProperty("BLOCKING_SENDER_PRESERVE_REQ_HEADERS"))) {
                        axisInMsgCtx.setProperty("TRANSPORT_HEADERS", result.getProperty("TRANSPORT_HEADERS"));
                    }
                    synapseInMsgCtx.setProperty("blocking.sender.error", "false");
                    this.invokeHandlers(synapseInMsgCtx);
                }
            }
            catch (Exception ex) {
                org.apache.axis2.context.MessageContext faultMC;
                String errorStatusCode = this.extractStatusCodeFromException(ex);
                axisInMsgCtx.setProperty("HTTP_SC", (Object)errorStatusCode);
                synapseInMsgCtx.setProperty("blocking.sender.error", "true");
                synapseInMsgCtx.setProperty("ERROR_EXCEPTION", ex);
                if (!(ex instanceof AxisFault)) break block26;
                AxisFault fault = (AxisFault)((Object)ex);
                int errorCode = 401002;
                if (fault.getFaultCode() != null && fault.getFaultCode().getLocalPart() != null && !"".equals(fault.getFaultCode().getLocalPart())) {
                    try {
                        errorCode = Integer.parseInt(fault.getFaultCode().getLocalPart());
                    }
                    catch (NumberFormatException e) {
                        errorCode = 401002;
                    }
                }
                synapseInMsgCtx.setProperty("ERROR_CODE", errorCode);
                synapseInMsgCtx.setProperty("ERROR_MESSAGE", fault.getMessage());
                synapseInMsgCtx.setProperty("ERROR_DETAIL", fault.getDetail() != null ? fault.getDetail().getText() : "");
                if (isOutOnly || (faultMC = fault.getFaultMessageContext()) == null) break block26;
                Object statusCode = faultMC.getProperty("transport.http.statusCode");
                synapseInMsgCtx.setProperty("HTTP_SC", statusCode);
                axisInMsgCtx.setProperty("HTTP_SC", statusCode);
                synapseInMsgCtx.setEnvelope(faultMC.getEnvelope());
            }
        }
        MessageContext originalMC = MessageCache.getInstance().removeMessageContext(synapseInMsgCtx.getMessageID());
        if ("true".equals(synapseInMsgCtx.getProperty("blocking.sender.error"))) {
            synapseInMsgCtx.getFaultStack().pop().handleFault(synapseInMsgCtx, (Exception)synapseInMsgCtx.getProperty("ERROR_EXCEPTION"));
        } else {
            Stack<FaultHandler> faultStack = synapseInMsgCtx.getFaultStack();
            if (faultStack != null && !faultStack.isEmpty()) {
                AbstractEndpoint successfulEndpoint = null;
                if (faultStack.peek() instanceof AbstractEndpoint) {
                    successfulEndpoint = (AbstractEndpoint)faultStack.pop();
                    successfulEndpoint.onSuccess();
                }
                if (successfulEndpoint instanceof OAuthConfiguredHTTPEndpoint) {
                    OAuthConfiguredHTTPEndpoint httpEndpoint = (OAuthConfiguredHTTPEndpoint)successfulEndpoint;
                    if (originalMC != null && OAuthUtils.retryOnOAuthFailure(httpEndpoint, synapseInMsgCtx, synapseInMsgCtx)) {
                        MessageContext messageContext = httpEndpoint.retryCallWithNewToken(originalMC);
                        ((Axis2MessageContext)synapseInMsgCtx).setAxis2MessageContext(((Axis2MessageContext)messageContext).getAxis2MessageContext());
                    }
                }
                while (!faultStack.empty() && faultStack.peek() instanceof AbstractEndpoint) {
                    faultStack.pop();
                }
            }
        }
    }

    private void sendRobust(org.apache.axis2.context.MessageContext axisOutMsgCtx, Options clientOptions, AxisService anonymousService, ServiceContext serviceCtx, MessageContext synapseInMsgCtx) throws AxisFault {
        AxisOperation axisAnonymousOperation = anonymousService.getOperation(new QName("anonOutonlyOp"));
        OperationClient operationClient = axisAnonymousOperation.createClient(serviceCtx, clientOptions);
        operationClient.addMessageContext(axisOutMsgCtx);
        axisOutMsgCtx.setAxisMessage(axisAnonymousOperation.getMessage("Out"));
        operationClient.execute(true);
        axisOutMsgCtx.getTransportOut().getSender().cleanup(axisOutMsgCtx);
    }

    private org.apache.axis2.context.MessageContext sendReceive(org.apache.axis2.context.MessageContext axisOutMsgCtx, Options clientOptions, AxisService anonymousService, ServiceContext serviceCtx, MessageContext synapseInMsgCtx) throws AxisFault {
        AxisOperation axisAnonymousOperation = anonymousService.getOperation(new QName("anonOutInOp"));
        OperationClient operationClient = axisAnonymousOperation.createClient(serviceCtx, clientOptions);
        operationClient.addMessageContext(axisOutMsgCtx);
        axisOutMsgCtx.setAxisMessage(axisAnonymousOperation.getMessage("Out"));
        operationClient.execute(true);
        org.apache.axis2.context.MessageContext resultMsgCtx = operationClient.getMessageContext("In");
        org.apache.axis2.context.MessageContext returnMsgCtx = new org.apache.axis2.context.MessageContext();
        if (resultMsgCtx.getEnvelope() != null) {
            returnMsgCtx.setEnvelope(MessageHelper.cloneSOAPEnvelope(resultMsgCtx.getEnvelope()));
            if (JsonUtil.hasAJsonPayload((org.apache.axis2.context.MessageContext)resultMsgCtx)) {
                JsonUtil.cloneJsonPayload((org.apache.axis2.context.MessageContext)resultMsgCtx, (org.apache.axis2.context.MessageContext)returnMsgCtx);
            }
        } else if (axisOutMsgCtx.isSOAP11()) {
            returnMsgCtx.setEnvelope(OMAbstractFactory.getSOAP11Factory().getDefaultEnvelope());
        } else {
            returnMsgCtx.setEnvelope(OMAbstractFactory.getSOAP12Factory().getDefaultEnvelope());
        }
        try {
            MediatorPropertyUtils.serializeOMElement(resultMsgCtx);
        }
        catch (Exception e) {
            this.handleException("Error while serializing the  message", e);
        }
        returnMsgCtx.setProperty("transport.http.statusCode", resultMsgCtx.getProperty("transport.http.statusCode"));
        axisOutMsgCtx.getTransportOut().getSender().cleanup(axisOutMsgCtx);
        returnMsgCtx.setProperty("TRANSPORT_HEADERS", resultMsgCtx.getProperty("TRANSPORT_HEADERS"));
        return returnMsgCtx;
    }

    private boolean isOutOnly(MessageContext messageIn, org.apache.axis2.context.MessageContext axis2Ctx) {
        return "true".equals(messageIn.getProperty("OUT_ONLY")) || axis2Ctx.getOperationContext() != null && "http://www.w3.org/ns/wsdl/in-only".equals(axis2Ctx.getOperationContext().getAxisOperation().getMessageExchangePattern());
    }

    public void setClientRepository(String clientRepository) {
        this.clientRepository = clientRepository;
    }

    public void setAxis2xml(String axis2xml) {
        this.axis2xml = axis2xml;
    }

    public void setConfigurationContext(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    public void setInitClientOptions(boolean initClientOptions) {
        this.initClientOptions = initClientOptions;
    }

    private void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private String extractStatusCodeFromException(Exception exception) {
        String responseStatusCode = "";
        Matcher errMsgMatcher = this.errorMsgPattern.matcher(exception.getMessage());
        Matcher statusCodeMatcher = this.statusCodePattern.matcher(exception.getMessage());
        if (errMsgMatcher.find() && statusCodeMatcher.find()) {
            responseStatusCode = statusCodeMatcher.group().trim();
        }
        return responseStatusCode;
    }

    private void invokeHandlers(MessageContext synCtx) {
        Iterator<SynapseHandler> iterator = synCtx.getEnvironment().getSynapseHandlers().iterator();
        if (iterator.hasNext()) {
            do {
                SynapseHandler handler;
                if ((handler = iterator.next()).handleResponseInFlow(synCtx)) continue;
                log.warn((Object)"Synapse not executed in the response in path");
            } while (iterator.hasNext());
        }
    }

    private void setErrorDetails(MessageContext synapseInMsgCtx, AxisFault fault) {
        int errorCode = 401002;
        if (fault.getFaultCode() != null && fault.getFaultCode().getLocalPart() != null && !"".equals(fault.getFaultCode().getLocalPart())) {
            try {
                errorCode = Integer.parseInt(fault.getFaultCode().getLocalPart());
            }
            catch (NumberFormatException e) {
                errorCode = 401002;
            }
        }
        synapseInMsgCtx.setProperty("ERROR_CODE", errorCode);
        synapseInMsgCtx.setProperty("ERROR_MESSAGE", fault.getMessage());
        synapseInMsgCtx.setProperty("ERROR_DETAIL", fault.getDetail() != null ? fault.getDetail().getText() : this.getStackTrace(fault));
    }

    private String getStackTrace(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    static {
        String confPath = System.getProperty("conf.location");
        if (confPath == null && (confPath = System.getProperty("carbon.config.dir.path")) == null) {
            confPath = Paths.get("repository", "conf").toString();
        }
        DEFAULT_AXIS2_XML = Paths.get(confPath, "axis2", "axis2_blocking_client.xml").toString();
        log = LogFactory.getLog(BlockingMsgSender.class);
    }
}

