/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.processor.impl.sampler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.ElementHelper;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.message.MessageConsumer;
import org.apache.synapse.message.processor.MessageProcessor;
import org.apache.synapse.task.Task;

public class SamplingService
implements Task,
ManagedLifecycle {
    private static Log log = LogFactory.getLog(SamplingService.class);
    private MessageConsumer messageConsumer;
    private MessageProcessor messageProcessor;
    private int concurrency = 1;
    private String sequence;
    private SynapseEnvironment synapseEnvironment;
    private boolean initialized = false;
    private final String concurrencyPropName;
    private final String sequencePropName;
    private int maxConnectionAttemptsToStore = -1;
    private int storeConnectionAttemptDelay = 1000;
    private boolean isDeactivatedAtStartup = false;

    public SamplingService(MessageProcessor messageProcessor, SynapseEnvironment synapseEnvironment, String concurrencyPropName, String sequencePropName) {
        this.messageProcessor = messageProcessor;
        this.synapseEnvironment = synapseEnvironment;
        this.concurrencyPropName = concurrencyPropName;
        this.sequencePropName = sequencePropName;
    }

    public SamplingService(MessageProcessor messageProcessor, SynapseEnvironment synapseEnvironment, String concurrencyPropName, String sequencePropName, boolean isDeactivatedAtStartup) {
        this.messageProcessor = messageProcessor;
        this.synapseEnvironment = synapseEnvironment;
        this.concurrencyPropName = concurrencyPropName;
        this.sequencePropName = sequencePropName;
        this.isDeactivatedAtStartup = isDeactivatedAtStartup;
    }

    public void execute() {
        if (this.isDeactivatedAtStartup) {
            try {
                TimeUnit.MILLISECONDS.sleep(2000L);
            }
            catch (InterruptedException exception) {
                log.warn((Object)"Initial delay interrupted when Sampling service started as inactive ", (Throwable)exception);
            }
            this.isDeactivatedAtStartup = false;
        }
        try {
            if (!this.initialized) {
                this.init(this.synapseEnvironment);
            }
            if (!this.messageProcessor.isDeactivated()) {
                for (int i = 0; i < this.concurrency; ++i) {
                    MessageContext messageContext = this.fetch();
                    if (messageContext != null) {
                        this.dispatch(messageContext);
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("No messages were received for message processor [" + this.messageProcessor.getName() + "]"));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Exiting service since the message processor is deactivated");
            }
        }
        catch (Throwable t) {
            log.fatal((Object)("Deactivating the message processor [" + this.messageProcessor.getName() + "]"), t);
            this.messageProcessor.stop();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exiting service thread of message processor [" + this.messageProcessor.getName() + "]"));
        }
    }

    @Override
    public void init(SynapseEnvironment se) {
        this.setMessageConsumer();
        Map<String, Object> parameterMap = this.messageProcessor.getParameters();
        String maxConnectionAttemptsToStore = (String)parameterMap.get("max.store.connection.attempts");
        String storeConnectionAttemptDelay = (String)parameterMap.get("store.connection.retry.interval");
        if (null != maxConnectionAttemptsToStore) {
            this.maxConnectionAttemptsToStore = Integer.parseInt(maxConnectionAttemptsToStore);
        }
        if (null != storeConnectionAttemptDelay) {
            this.storeConnectionAttemptDelay = Integer.parseInt(storeConnectionAttemptDelay);
        }
        this.sequence = (String)parameterMap.get(this.sequencePropName);
        String conc = (String)parameterMap.get(this.concurrencyPropName);
        if (conc != null) {
            try {
                this.concurrency = Integer.parseInt(conc);
            }
            catch (NumberFormatException e) {
                parameterMap.remove(this.concurrencyPropName);
                log.error((Object)"Invalid value for concurrency switching back to default value", (Throwable)e);
            }
        }
        this.initialized = true;
    }

    public MessageContext fetch() {
        MessageContext newMsg = null;
        for (int connAttempt = 0; connAttempt < this.maxConnectionAttemptsToStore || this.maxConnectionAttemptsToStore == -1; ++connAttempt) {
            try {
                newMsg = this.messageConsumer.receive();
                if (newMsg == null) break;
                this.messageConsumer.ack();
                break;
            }
            catch (SynapseException synapseException) {
                if (synapseException.getMessage().contains("STORE_CONNECTION_ERROR")) {
                    try {
                        if (connAttempt == this.maxConnectionAttemptsToStore - 1) {
                            throw new SynapseException("Error while connecting to message store " + this.messageProcessor.getName(), synapseException);
                        }
                        Thread.sleep(this.storeConnectionAttemptDelay);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                throw new SynapseException("Error while fetching message from " + this.messageProcessor.getName(), synapseException);
            }
        }
        return newMsg;
    }

    public void dispatch(final MessageContext messageContext) {
        this.setSoapHeaderBlock(messageContext);
        ExecutorService executor = messageContext.getEnvironment().getExecutorService();
        executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Mediator processingSequence = messageContext.getSequence(SamplingService.this.sequence);
                    if (processingSequence != null) {
                        processingSequence.mediate(messageContext);
                    }
                }
                catch (SynapseException syne) {
                    if (!messageContext.getFaultStack().isEmpty()) {
                        messageContext.getFaultStack().pop().handleFault(messageContext, syne);
                    }
                    log.error((Object)"Error occurred while executing the message", (Throwable)syne);
                }
                catch (Throwable t) {
                    log.error((Object)"Error occurred while executing the message", t);
                }
            }
        });
    }

    public boolean terminate() {
        if (this.messageConsumer != null) {
            this.messageConsumer.cleanup();
        }
        return true;
    }

    private boolean setMessageConsumer() {
        String messageStore = this.messageProcessor.getMessageStoreName();
        this.messageConsumer = this.synapseEnvironment.getSynapseConfiguration().getMessageStore(messageStore).getConsumer();
        return this.messageProcessor.setMessageConsumer(this.messageConsumer);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void destroy() {
        this.terminate();
    }

    private void setSoapHeaderBlock(MessageContext synCtx) {
        if (synCtx.getEnvelope().getHeader() != null) {
            Iterator iHeader = synCtx.getEnvelope().getHeader().getChildren();
            SOAPFactory fac = "http://schemas.xmlsoap.org/soap/envelope/".equals(synCtx.getEnvelope().getBody().getNamespace().getNamespaceURI()) ? OMAbstractFactory.getSOAP11Factory() : OMAbstractFactory.getSOAP12Factory();
            ArrayList<SOAPHeaderBlock> newHeaderNodes = new ArrayList<SOAPHeaderBlock>();
            while (iHeader.hasNext()) {
                try {
                    Object element = iHeader.next();
                    if (element instanceof SOAPHeaderBlock) continue;
                    if (element instanceof OMElement) {
                        newHeaderNodes.add(ElementHelper.toSOAPHeaderBlock((OMElement)((OMElement)element), (SOAPFactory)fac));
                    }
                    iHeader.remove();
                }
                catch (OMException e) {
                    log.error((Object)"Unable to convert to SoapHeader Block", (Throwable)e);
                }
                catch (Exception e) {
                    log.error((Object)"Unable to convert to SoapHeader Block", (Throwable)e);
                }
            }
            for (OMNode oMNode : newHeaderNodes) {
                synCtx.getEnvelope().getHeader().addChild(oMNode);
            }
        }
    }
}

