/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.processor.impl.forwarder;

import org.apache.synapse.SynapseException;
import org.apache.synapse.commons.jmx.MBeanRegistrar;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.message.processor.impl.ScheduledMessageProcessor;
import org.apache.synapse.message.processor.impl.forwarder.ForwardingService;
import org.apache.synapse.message.processor.impl.forwarder.MessageForwardingProcessorView;
import org.apache.synapse.task.Task;

public class ScheduledMessageForwardingProcessor
extends ScheduledMessageProcessor {
    private MessageForwardingProcessorView view;

    @Override
    public void init(SynapseEnvironment se) {
        this.parameters.put("throttle", String.valueOf(this.isThrottling(this.interval)));
        if (this.isThrottling(this.cronExpression)) {
            this.parameters.put("throttle.interval", String.valueOf(this.interval));
            this.parameters.put("cron.expression", this.cronExpression);
        }
        if (this.nonRetryStatusCodes != null) {
            this.parameters.put("non.retry.status.codes", this.nonRetryStatusCodes);
        }
        if (this.targetEndpoint != null) {
            this.parameters.put("target.endpoint", this.targetEndpoint);
        }
        super.init(se);
        try {
            this.view = new MessageForwardingProcessorView(this);
        }
        catch (Exception e) {
            throw new SynapseException(e);
        }
        MBeanRegistrar.getInstance().registerMBean((Object)this.view, "Message Forwarding Processor view", this.getName());
    }

    public MessageForwardingProcessorView getView() {
        return this.view;
    }

    @Override
    protected Task getTask() {
        return new ForwardingService(this, this.sender, this.synapseEnvironment, this.interval, this.isProcessorStartAsDeactivated());
    }
}

