/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.processor.impl.forwarder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.ElementHelper;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.commons.json.JsonUtil;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.EndpointDefinition;
import org.apache.synapse.endpoints.TemplateEndpoint;
import org.apache.synapse.message.MessageConsumer;
import org.apache.synapse.message.StoreForwardException;
import org.apache.synapse.message.processor.MessageProcessor;
import org.apache.synapse.message.processor.impl.ScheduledMessageProcessor;
import org.apache.synapse.message.senders.blocking.BlockingMsgSender;
import org.apache.synapse.message.store.MessageStore;
import org.apache.synapse.task.Task;
import org.apache.synapse.util.MessageHelper;

public class ForwardingService
implements Task,
ManagedLifecycle {
    private static final Log log = LogFactory.getLog(ForwardingService.class);
    private MessageConsumer messageConsumer;
    private MessageProcessor messageProcessor;
    private BlockingMsgSender sender;
    private int retryInterval = 1000;
    private String faultSeq = null;
    private String replySeq = null;
    private String deactivateSeq = null;
    private String targetEndpoint = null;
    private MessageStore failMessageStore = null;
    private String cronExpression = null;
    private String[] nonRetryStatusCodes = null;
    private boolean isSuccessful = false;
    private volatile boolean isTerminated = false;
    private int maxDeliverAttempts = 4;
    private int attemptCount = 0;
    private int maxConnectionAttemptsToStore = -1;
    private int storeConnectionAttemptDelay = 1000;
    private boolean isThrottling = true;
    private long throttlingInterval = -1L;
    private long interval;
    private boolean isMaxDeliveryAttemptDropEnabled = false;
    private SynapseEnvironment synapseEnvironment;
    private boolean initialized = false;
    private boolean isDeactivatedAtStartup = false;
    private boolean isResponseValidationNotRequired = false;
    Pattern httpPattern = Pattern.compile("^(http|https|hl7):");

    public ForwardingService(MessageProcessor messageProcessor, BlockingMsgSender sender, SynapseEnvironment synapseEnvironment, long threshouldInterval) {
        this.messageProcessor = messageProcessor;
        this.sender = sender;
        this.synapseEnvironment = synapseEnvironment;
        this.interval = threshouldInterval;
    }

    public ForwardingService(MessageProcessor messageProcessor, BlockingMsgSender sender, SynapseEnvironment synapseEnvironment, long thresholdInterval, boolean isDeactivatedAtStartup) {
        this.messageProcessor = messageProcessor;
        this.sender = sender;
        this.synapseEnvironment = synapseEnvironment;
        this.interval = thresholdInterval;
        this.isDeactivatedAtStartup = isDeactivatedAtStartup;
    }

    public void execute() {
        long startTime = new Date().getTime();
        if (this.isDeactivatedAtStartup) {
            try {
                TimeUnit.MILLISECONDS.sleep(2000L);
            }
            catch (InterruptedException exception) {
                log.warn((Object)"Initial delay interrupted when Forwarding service started as inactive ", (Throwable)exception);
            }
            this.isDeactivatedAtStartup = false;
        }
        if (!this.initialized) {
            try {
                this.init(this.synapseEnvironment);
            }
            catch (SynapseException e) {
                log.fatal((Object)("Deactivating the message processor [" + this.messageProcessor.getName() + "] due to initialization issue"), (Throwable)e);
                this.deactivateMessageProcessor(null);
            }
        }
        do {
            this.resetService();
            MessageContext messageContext = null;
            try {
                if (!this.messageProcessor.isDeactivated()) {
                    messageContext = this.fetch();
                    if (messageContext != null) {
                        Set proSet = messageContext.getPropertyKeySet();
                        if (proSet != null && proSet.contains("blocking.sender.error")) {
                            proSet.remove("blocking.sender.error");
                        }
                        this.isTerminated = this.messageProcessor.isDeactivated();
                        this.dispatch(messageContext);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("No messages were received for message processor [" + this.messageProcessor.getName() + "]"));
                        }
                        if (this.isRunningUnderCronExpression()) {
                            break;
                        }
                    }
                } else {
                    this.isTerminated = true;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Exiting service since the message processor is deactivated");
                    }
                }
            }
            catch (Throwable e) {
                log.fatal((Object)("Deactivating the message processor [" + this.messageProcessor.getName() + "]"), e);
                this.deactivateMessageProcessor(messageContext);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exiting the iteration of message processor [" + this.messageProcessor.getName() + "]"));
            }
            if (this.isRunningUnderCronExpression()) {
                try {
                    Thread.sleep(this.throttlingInterval);
                }
                catch (InterruptedException e) {
                    log.debug((Object)"Current Thread was interrupted while it is sleeping.");
                }
            }
            if (this.interval <= 0L || this.interval >= 1000L || this.isRunningUnderCronExpression()) continue;
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                log.debug((Object)"Current Thread was interrupted while it is sleeping.");
            }
        } while (!(this.isThrottling && new Date().getTime() - startTime > 1000L && !this.isRunningUnderCronExpression() || !this.isThrottling && !this.isRunningUnderCronExpression()) && !this.isTerminated);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exiting service thread of message processor [" + this.messageProcessor.getName() + "]"));
        }
    }

    @Override
    public void init(SynapseEnvironment se) throws SynapseException {
        try {
            this.setMessageConsumer();
        }
        catch (StoreForwardException e) {
            throw new SynapseException("Error while initializing consumer " + this.messageProcessor.getName(), e);
        }
        Map<String, Object> parametersMap = this.messageProcessor.getParameters();
        if (parametersMap.get("max.delivery.attempts") != null) {
            this.maxDeliverAttempts = Integer.parseInt((String)parametersMap.get("max.delivery.attempts"));
        }
        if (parametersMap.get("client.retry.interval") != null) {
            this.retryInterval = Integer.parseInt((String)parametersMap.get("client.retry.interval"));
        }
        String maxConnectionAttemptsToStore = (String)parametersMap.get("max.store.connection.attempts");
        String storeConnectionAttemptDelay = (String)parametersMap.get("store.connection.retry.interval");
        if (null != maxConnectionAttemptsToStore) {
            this.maxConnectionAttemptsToStore = Integer.parseInt(maxConnectionAttemptsToStore);
        }
        if (null != storeConnectionAttemptDelay) {
            this.storeConnectionAttemptDelay = Integer.parseInt(storeConnectionAttemptDelay);
        }
        this.replySeq = (String)parametersMap.get("message.processor.reply.sequence");
        this.faultSeq = (String)parametersMap.get("message.processor.fault.sequence");
        this.deactivateSeq = (String)parametersMap.get("message.processor.deactivate.sequence");
        this.targetEndpoint = (String)parametersMap.get("target.endpoint");
        String failMessageStoreName = (String)parametersMap.get("message.processor.failMessagesStore");
        if (null != failMessageStoreName && !failMessageStoreName.isEmpty()) {
            this.failMessageStore = se.createMessageContext().getConfiguration().getMessageStore(failMessageStoreName);
        }
        if (parametersMap.get("throttle") != null) {
            this.isThrottling = Boolean.parseBoolean((String)parametersMap.get("throttle"));
        }
        if (parametersMap.get("cron.expression") != null) {
            this.cronExpression = String.valueOf(parametersMap.get("cron.expression"));
        }
        if (this.cronExpression != null && parametersMap.get("throttle.interval") != null) {
            this.throttlingInterval = Long.parseLong((String)parametersMap.get("throttle.interval"));
        }
        this.nonRetryStatusCodes = (String[])parametersMap.get("non.retry.status.codes");
        if (parametersMap.get("max.delivery.drop") != null && parametersMap.get("max.delivery.drop").toString().equals("Enabled") && this.maxDeliverAttempts > 0) {
            this.isMaxDeliveryAttemptDropEnabled = true;
        }
        this.interval = Long.parseLong((String)parametersMap.get("interval"));
        this.initialized = true;
    }

    private Set<Integer> getNonRetryStatusCodes() {
        HashSet<Integer> nonRetryCodes = new HashSet<Integer>();
        if (this.nonRetryStatusCodes != null) {
            for (String code : this.nonRetryStatusCodes) {
                try {
                    int codeI = Integer.parseInt(code.trim());
                    nonRetryCodes.add(codeI);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return nonRetryCodes;
    }

    public MessageContext fetch() throws StoreForwardException {
        MessageContext fetchedMessage = null;
        for (int connAttempt = 0; connAttempt < this.maxConnectionAttemptsToStore || this.maxConnectionAttemptsToStore == -1; ++connAttempt) {
            try {
                fetchedMessage = this.messageConsumer.receive();
                break;
            }
            catch (SynapseException e) {
                if (e.getLocalizedMessage().contains("STORE_CONNECTION_ERROR")) {
                    try {
                        if (connAttempt == this.maxConnectionAttemptsToStore - 1) {
                            throw new SynapseException("Error while connecting to message store " + this.messageProcessor.getName(), e);
                        }
                        Thread.sleep(this.storeConnectionAttemptDelay);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                throw new SynapseException("Error while fetching message from " + this.messageProcessor.getName(), e);
            }
        }
        return fetchedMessage;
    }

    public void dispatch(MessageContext messageContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending the message to client with message processor [" + this.messageProcessor.getName() + "]"));
        }
        if (this.targetEndpoint == null) {
            this.targetEndpoint = (String)messageContext.getProperty("target.endpoint");
        }
        if (this.targetEndpoint != null) {
            Object o;
            AbstractEndpoint abstractEndpoint;
            EndpointDefinition endpointDefinition;
            Endpoint endpoint = messageContext.getEndpoint(this.targetEndpoint);
            if (endpoint == null) {
                log.error((Object)"Endpoint does not exists. Deactivating the message processor");
                this.deactivateMessageProcessor(messageContext);
                return;
            }
            if (endpoint instanceof TemplateEndpoint) {
                endpoint = ((TemplateEndpoint)endpoint).getRealEndpoint();
            }
            if ((endpointDefinition = (abstractEndpoint = (AbstractEndpoint)endpoint).getDefinition()).getAddress() != null) {
                String endpointReferenceValue = endpointDefinition.getAddress();
                this.isResponseValidationNotRequired = !this.isResponseValidationRequiredEndpoint(endpointReferenceValue);
            }
            SOAPEnvelope originalEnvelop = messageContext.getEnvelope();
            ByteArrayInputStream originalByteArrayInputStream = null;
            org.apache.axis2.context.MessageContext origAxis2Ctx = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
            if (JsonUtil.hasAJsonPayload((org.apache.axis2.context.MessageContext)origAxis2Ctx) && (o = origAxis2Ctx.getProperty("org.apache.synapse.commons.json.JsonInputStream")) instanceof InputStream) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                InputStream originalInputStream = (InputStream)o;
                try {
                    IOUtils.copy((InputStream)originalInputStream, (OutputStream)baos);
                    originalByteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
                }
                catch (IOException e) {
                    log.warn((Object)"Copying the json stream failed");
                }
            }
            try {
                while (!this.isSuccessful && !this.isTerminated) {
                    this.tryToDispatchToEndpoint(messageContext, endpoint, originalEnvelop, originalByteArrayInputStream);
                    this.isTerminated = this.messageProcessor.isDeactivated();
                    if (!this.isTerminated && this.messageProcessor instanceof ScheduledMessageProcessor) {
                        boolean bl = this.isTerminated = !((ScheduledMessageProcessor)this.messageProcessor).isActive();
                    }
                    if (this.isSuccessful) continue;
                    this.prepareToRetry(messageContext, originalEnvelop, originalByteArrayInputStream);
                }
            }
            catch (Exception e) {
                log.error((Object)("Message processor [" + this.messageProcessor.getName() + "] failed to send the message to client"), (Throwable)e);
            }
        } else {
            log.error((Object)"Neither targetEndpoint defined in the MessageProcessor configuration nor Property target.endpoint is found in the message context, hence deactivating the MessageProcessor");
            this.deactivateMessageProcessor(messageContext);
        }
    }

    private void getFreshCopyOfOriginalMessage(MessageContext messageToDispatch, SOAPEnvelope originalEnvelop, ByteArrayInputStream originalJsonInputStream) throws AxisFault {
        messageToDispatch.setEnvelope(MessageHelper.cloneSOAPEnvelope(originalEnvelop));
        this.setSoapHeaderBlock(messageToDispatch);
        this.updateAxis2MessageContext(messageToDispatch);
        if (originalJsonInputStream != null) {
            org.apache.axis2.context.MessageContext origAxis2Ctx = ((Axis2MessageContext)messageToDispatch).getAxis2MessageContext();
            JsonUtil.getNewJsonPayload((org.apache.axis2.context.MessageContext)origAxis2Ctx, (InputStream)originalJsonInputStream, (boolean)true, (boolean)true);
        }
    }

    private void tryToDispatchToEndpoint(MessageContext messageToDispatch, Endpoint endpoint, SOAPEnvelope originalEnvelop, ByteArrayInputStream originalJsonInputStream) {
        this.isSuccessful = false;
        MessageContext outCtx = null;
        try {
            this.getFreshCopyOfOriginalMessage(messageToDispatch, originalEnvelop, originalJsonInputStream);
            if (this.messageConsumer != null && this.messageConsumer.isAlive()) {
                messageToDispatch.setProperty("blockingMsgSender", this.sender);
                Set keySet = messageToDispatch.getPropertyKeySet();
                if (keySet != null) {
                    keySet.remove("RECEIVING_SEQUENCE");
                    keySet.remove("DYNAMIC_URL_VALUE");
                    keySet.remove("last_endpoint");
                    keySet.remove("blocking.sender.error");
                }
                endpoint.send(messageToDispatch);
                if ("true".equals(messageToDispatch.getProperty("OUT_ONLY"))) {
                    if ("true".equals(messageToDispatch.getProperty("blocking.sender.error"))) {
                        throw new SynapseException("Error sending Message to the endpoint", (Exception)messageToDispatch.getProperty("ERROR_EXCEPTION"));
                    }
                } else {
                    outCtx = messageToDispatch;
                }
            }
            if (this.isResponseValidationNotRequired) {
                this.isSuccessful = true;
                this.onForwardSuccess(endpoint);
                return;
            }
            if (outCtx == null) {
                if (this.validateResponse(messageToDispatch)) {
                    this.onForwardSuccess(endpoint);
                } else {
                    this.isSuccessful = false;
                    this.onForwardFailure();
                }
            } else {
                if ("true".equals(outCtx.getProperty("blocking.sender.error"))) {
                    log.error((Object)("Blocking Sender Error " + outCtx.getProperty("ERROR_EXCEPTION")));
                    this.isSuccessful = false;
                    this.handleFailedInvocations(outCtx);
                    return;
                }
                if (this.validateResponse(outCtx)) {
                    this.isSuccessful = true;
                    this.sendThroughReplySeq(outCtx);
                    this.onForwardSuccess(endpoint);
                } else {
                    this.isSuccessful = false;
                    this.handleFailedInvocations(outCtx);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("[ " + this.messageProcessor.getName() + " ] Error while forwarding message to endpoint " + this.targetEndpoint + "."), (Throwable)e);
            this.handleFailedInvocations(outCtx);
        }
    }

    private void handleFailedInvocations(MessageContext outCtx) {
        this.isSuccessful = false;
        this.onForwardFailure();
        this.sendThroughFaultSeq(outCtx);
    }

    private void onForwardSuccess(Endpoint endpoint) {
        this.messageConsumer.ack();
        this.attemptCount = 0;
        this.isSuccessful = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Successfully forwarded the message to endpoint [" + endpoint.getName() + "] with message processor [" + this.messageProcessor.getName() + "]."));
        }
    }

    private void onForwardFailure() {
        log.error((Object)("BlockingMessageSender of message processor [" + this.messageProcessor.getName() + "] failed to forward message to endpoint " + this.messageProcessor.getTargetEndpoint()));
    }

    private boolean validateResponse(MessageContext responseMessage) {
        String responseSc = "";
        Object httpSc = ((Axis2MessageContext)responseMessage).getAxis2MessageContext().getProperty("HTTP_SC");
        if (httpSc != null) {
            responseSc = httpSc.toString();
        }
        int sc = 0;
        try {
            sc = Integer.parseInt(responseSc.trim());
            this.isSuccessful = this.getHTTPStatusCodeFamily(sc).equals((Object)HTTPStatusCodeFamily.SUCCESSFUL) || this.isNonRetryErrorCode(responseSc);
        }
        catch (NumberFormatException nfe) {
            this.isSuccessful = false;
        }
        if (!this.isSuccessful) {
            String statusCode = " ";
            if (sc != 0) {
                statusCode = Integer.toString(sc);
            }
            log.info((Object)("Message processor [" + this.messageProcessor.getName() + "] received a response with HTTP_SC: " + statusCode + " from backend " + this.targetEndpoint + ". Message forwarding failed."));
        }
        return this.isSuccessful;
    }

    private void updateAxis2MessageContext(MessageContext messageToDispatch) {
        OMElement clonedFirstElement;
        OMElement firstChild = null;
        org.apache.axis2.context.MessageContext origAxis2Ctx = ((Axis2MessageContext)messageToDispatch).getAxis2MessageContext();
        if (JsonUtil.hasAJsonPayload((org.apache.axis2.context.MessageContext)origAxis2Ctx)) {
            firstChild = origAxis2Ctx.getEnvelope().getBody().getFirstElement();
        }
        if (JsonUtil.hasAJsonPayload(firstChild) && (clonedFirstElement = messageToDispatch.getEnvelope().getBody().getFirstElement()) != null) {
            clonedFirstElement.detach();
            messageToDispatch.getEnvelope().getBody().addChild((OMNode)firstChild);
        }
        origAxis2Ctx.setProperty("non.error.http.status.codes", this.getNonRetryStatusCodes());
    }

    public void sendThroughFaultSeq(MessageContext msgCtx) {
        if (this.faultSeq == null) {
            log.warn((Object)"Failed to send the message through the fault sequence. Sequence name does not Exist.");
            return;
        }
        Mediator mediator = msgCtx.getSequence(this.faultSeq);
        if (mediator == null) {
            log.warn((Object)("Failed to send the message through the fault sequence. Sequence [" + this.faultSeq + "] does not Exist."));
            return;
        }
        mediator.mediate(msgCtx);
    }

    public void sendThroughDeactivateSeq(MessageContext msgCtx) {
        if (this.deactivateSeq == null) {
            log.warn((Object)"Failed to send the message through the deactivate sequence. Sequence name does not Exist.");
            return;
        }
        Mediator mediator = msgCtx.getSequence(this.deactivateSeq);
        if (mediator == null) {
            log.warn((Object)("Failed to send the message through the deactivate sequence. Sequence [" + this.deactivateSeq + "] does not Exist."));
            return;
        }
        mediator.mediate(msgCtx);
    }

    public void sendThroughReplySeq(MessageContext outCtx) {
        if (this.replySeq == null) {
            this.deactivateMessageProcessor(outCtx);
            log.error((Object)"Failed to send the out message. Reply sequence does not Exist. Deactivated the message processor.");
            return;
        }
        Mediator mediator = outCtx.getSequence(this.replySeq);
        if (mediator == null) {
            this.deactivateMessageProcessor(outCtx);
            log.error((Object)("Failed to send the out message. Reply sequence [" + this.replySeq + "] does not exist. Deactivated the message processor."));
            return;
        }
        mediator.mediate(outCtx);
    }

    public boolean terminate() {
        try {
            this.isTerminated = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Successfully terminated job of message processor [" + this.messageProcessor.getName() + "]"));
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)("Failed to terminate the job of message processor [" + this.messageProcessor.getName() + "]"));
            return false;
        }
    }

    private void checkAndDeactivateProcessor(MessageContext msgCtx, SOAPEnvelope originalEnvelop, ByteArrayInputStream originalJsonInputStream) throws AxisFault {
        if (this.maxDeliverAttempts > 0) {
            ++this.attemptCount;
            if (this.attemptCount >= this.maxDeliverAttempts) {
                if (this.isMaxDeliveryAttemptDropEnabled) {
                    this.dropMessageAndContinueMessageProcessor();
                    log.warn((Object)("Message processor [" + this.messageProcessor.getName() + "] failed to forward message " + this.maxDeliverAttempts + " times. Drop message and continue."));
                } else if (null != this.failMessageStore) {
                    this.getFreshCopyOfOriginalMessage(msgCtx, originalEnvelop, originalJsonInputStream);
                    this.storeMessageToBackupStoreAndContinue(msgCtx, this.failMessageStore);
                } else {
                    this.terminate();
                    this.deactivateMessageProcessor(msgCtx);
                    log.warn((Object)("Message processor [" + this.messageProcessor.getName() + "] failed to forward message " + this.maxDeliverAttempts + " times. Deactivating message processor."));
                }
            }
        }
    }

    private void prepareToRetry(MessageContext msgCtx, SOAPEnvelope originalEnvelop, ByteArrayInputStream originalJsonInputStream) throws AxisFault {
        if (!this.isTerminated) {
            this.checkAndDeactivateProcessor(msgCtx, originalEnvelop, originalJsonInputStream);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed to send to client retrying after " + this.retryInterval + "s with attempt count - " + this.attemptCount));
            }
            try {
                Thread.sleep(this.retryInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void deactivateMessageProcessor(MessageContext messageContext) {
        if (null != messageContext) {
            this.sendThroughDeactivateSeq(messageContext);
        }
        this.messageProcessor.deactivate();
    }

    private void resetService() {
        this.isSuccessful = false;
        this.attemptCount = 0;
    }

    private boolean isNonRetryErrorCode(String responseHttpSc) {
        boolean isNonRetryErrCode = false;
        if (this.nonRetryStatusCodes != null) {
            for (String nonretrySc : this.nonRetryStatusCodes) {
                if (!nonretrySc.trim().contains(responseHttpSc.trim())) continue;
                isNonRetryErrCode = true;
                break;
            }
        }
        return isNonRetryErrCode;
    }

    private boolean isRunningUnderCronExpression() {
        return this.cronExpression != null && this.throttlingInterval > -1L;
    }

    private void dropMessageAndContinueMessageProcessor() {
        this.messageConsumer.ack();
        this.attemptCount = 0;
        this.isSuccessful = true;
    }

    private void storeMessageToBackupStoreAndContinue(MessageContext forwardFailedMessage, MessageStore messageStore) {
        if (null == messageStore) {
            log.error((Object)("Message processor [" + this.messageProcessor.getName() + "] failed to forward message " + this.maxDeliverAttempts + " times. Cannot find fail-messages-store to backup. Hence deactivating message processor."));
            this.deactivateMessageProcessor(forwardFailedMessage);
            return;
        }
        boolean produceStatus = messageStore.getProducer().storeMessage(forwardFailedMessage);
        if (produceStatus) {
            this.messageConsumer.ack();
            this.attemptCount = 0;
            this.isSuccessful = true;
            log.info((Object)("Message processor [" + this.messageProcessor.getName() + "] failed to forward message " + this.maxDeliverAttempts + " times. Moved failed message to fail-messages-store and continue"));
        } else {
            log.error((Object)("Message processor [" + this.messageProcessor.getName() + "] failed to forward message " + this.maxDeliverAttempts + " times but failed to store message in fail-messages-store and continue. Hence deactivating message processor."));
            this.deactivateMessageProcessor(forwardFailedMessage);
        }
    }

    private void setMessageConsumer() throws StoreForwardException {
        String messageStore = this.messageProcessor.getMessageStoreName();
        this.messageConsumer = this.synapseEnvironment.getSynapseConfiguration().getMessageStore(messageStore).getConsumer();
        if (!((ScheduledMessageProcessor)this.messageProcessor).getIsActivatedParamValue()) {
            this.messageConsumer.cleanup();
        }
        this.messageProcessor.setMessageConsumer(this.messageConsumer);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void destroy() {
        this.terminate();
    }

    private boolean isResponseValidationRequiredEndpoint(String epAddress) {
        Matcher match = this.httpPattern.matcher(epAddress);
        return match.find();
    }

    private HTTPStatusCodeFamily getHTTPStatusCodeFamily(int statusCode) {
        switch (statusCode / 100) {
            case 1: {
                return HTTPStatusCodeFamily.INFORMATIONAL;
            }
            case 2: {
                return HTTPStatusCodeFamily.SUCCESSFUL;
            }
            case 3: {
                return HTTPStatusCodeFamily.REDIRECTION;
            }
            case 4: {
                return HTTPStatusCodeFamily.CLIENT_ERROR;
            }
            case 5: {
                return HTTPStatusCodeFamily.SERVER_ERROR;
            }
        }
        return HTTPStatusCodeFamily.OTHER;
    }

    private void setSoapHeaderBlock(MessageContext synCtx) {
        if (synCtx.getEnvelope().getHeader() != null) {
            Iterator iHeader = synCtx.getEnvelope().getHeader().getChildren();
            SOAPFactory fac = "http://schemas.xmlsoap.org/soap/envelope/".equals(synCtx.getEnvelope().getBody().getNamespace().getNamespaceURI()) ? OMAbstractFactory.getSOAP11Factory() : OMAbstractFactory.getSOAP12Factory();
            ArrayList<SOAPHeaderBlock> newHeaderNodes = new ArrayList<SOAPHeaderBlock>();
            while (iHeader.hasNext()) {
                try {
                    Object element = iHeader.next();
                    if (!(element instanceof OMElement) || element instanceof SOAPHeaderBlock) continue;
                    newHeaderNodes.add(ElementHelper.toSOAPHeaderBlock((OMElement)((OMElement)element), (SOAPFactory)fac));
                    iHeader.remove();
                }
                catch (OMException e) {
                    log.error((Object)"Unable to convert to SoapHeader Block", (Throwable)e);
                }
                catch (Exception e) {
                    log.error((Object)"Unable to convert to SoapHeader Block", (Throwable)e);
                }
            }
            for (OMNode oMNode : newHeaderNodes) {
                synCtx.getEnvelope().getHeader().addChild(oMNode);
            }
        }
    }

    private static enum HTTPStatusCodeFamily {
        INFORMATIONAL,
        SUCCESSFUL,
        REDIRECTION,
        CLIENT_ERROR,
        SERVER_ERROR,
        OTHER;

    }
}

