/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.processor.impl.failover;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.commons.json.JsonUtil;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.message.MessageConsumer;
import org.apache.synapse.message.MessageProducer;
import org.apache.synapse.message.StoreForwardException;
import org.apache.synapse.message.processor.MessageProcessor;
import org.apache.synapse.message.store.MessageStore;
import org.apache.synapse.task.Task;
import org.apache.synapse.util.MessageHelper;

public class FailoverForwardingService
implements Task,
ManagedLifecycle {
    private static final Log log = LogFactory.getLog(FailoverForwardingService.class);
    private MessageConsumer messageConsumer;
    private MessageProducer targetMessageProducer;
    private String targetMessageStoreName;
    private MessageProcessor messageProcessor;
    private int retryInterval = 1000;
    private String faultSeq = null;
    private String deactivateSeq = null;
    private String cronExpression = null;
    private boolean isSuccessful = false;
    private volatile boolean isTerminated = false;
    private int maxDeliverAttempts = -1;
    private int attemptCount = 0;
    private boolean isThrottling = true;
    private long throttlingInterval = -1L;
    private long interval;
    private boolean isMaxDeliveryAttemptDropEnabled = false;
    private SynapseEnvironment synapseEnvironment;
    private boolean initialized = false;
    private boolean isDeactivatedAtStartup = false;

    public FailoverForwardingService(MessageProcessor messageProcessor, SynapseEnvironment synapseEnvironment, long threshouldInterval, boolean isDeactivatedAtStartup) {
        this.messageProcessor = messageProcessor;
        this.synapseEnvironment = synapseEnvironment;
        this.interval = threshouldInterval;
        this.isDeactivatedAtStartup = isDeactivatedAtStartup;
    }

    public void execute() {
        long startTime = new Date().getTime();
        if (this.isDeactivatedAtStartup) {
            try {
                TimeUnit.MILLISECONDS.sleep(2000L);
            }
            catch (InterruptedException exception) {
                log.warn((Object)"Initial delay interrupted when Failover Forwarding service started as inactive ", (Throwable)exception);
            }
            this.isDeactivatedAtStartup = false;
        }
        try {
            if (!this.initialized) {
                this.init(this.synapseEnvironment);
            }
        }
        catch (SynapseException e) {
            throw new SynapseException("Error while initializing forwarding service " + this.targetMessageStoreName, e);
        }
        do {
            this.resetService();
            MessageContext messageContext = null;
            try {
                if (!this.messageProcessor.isDeactivated()) {
                    messageContext = this.fetch(this.messageConsumer);
                    if (messageContext != null) {
                        this.isTerminated = this.messageProcessor.isDeactivated();
                        this.dispatch(messageContext);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("No messages were received for message processor [" + this.messageProcessor.getName() + "]"));
                        }
                        if (this.isRunningUnderCronExpression()) {
                            break;
                        }
                    }
                } else {
                    this.isTerminated = true;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Exiting service since the message processor is deactivated");
                    }
                }
            }
            catch (Throwable e) {
                log.fatal((Object)("Deactivating the message processor [" + this.messageProcessor.getName() + "]"), e);
                this.deactivateMessageProcessor(messageContext);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exiting the iteration of message processor [" + this.messageProcessor.getName() + "]"));
            }
            if (this.isRunningUnderCronExpression()) {
                try {
                    Thread.sleep(this.throttlingInterval);
                }
                catch (InterruptedException e) {
                    log.debug((Object)"Current Thread was interrupted while it is sleeping.");
                }
            }
            if (this.interval <= 0L || this.interval >= 1000L) continue;
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                log.debug((Object)"Current Thread was interrupted while it is sleeping.");
            }
        } while (!(this.isThrottling && new Date().getTime() - startTime > 1000L || !this.isThrottling && !this.isRunningUnderCronExpression()) && !this.isTerminated);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exiting service thread of message processor [" + this.messageProcessor.getName() + "]"));
        }
    }

    @Override
    public void init(SynapseEnvironment se) throws SynapseException {
        try {
            this.setMessageConsumerAndProducer();
        }
        catch (StoreForwardException e) {
            throw new SynapseException("Error while initializing Message Consumer " + this.messageProcessor.getName() + "and Message Producer " + this.targetMessageStoreName, e);
        }
        Map<String, Object> parametersMap = this.messageProcessor.getParameters();
        if (parametersMap.get("max.delivery.attempts") != null) {
            this.maxDeliverAttempts = Integer.parseInt((String)parametersMap.get("max.delivery.attempts"));
        }
        if (parametersMap.get("client.retry.interval") != null) {
            this.retryInterval = Integer.parseInt((String)parametersMap.get("client.retry.interval"));
        }
        this.faultSeq = (String)parametersMap.get("message.processor.fault.sequence");
        this.deactivateSeq = (String)parametersMap.get("message.processor.deactivate.sequence");
        if (parametersMap.get("throttle") != null) {
            this.isThrottling = Boolean.parseBoolean((String)parametersMap.get("throttle"));
        }
        if (parametersMap.get("cron.expression") != null) {
            this.cronExpression = String.valueOf(parametersMap.get("cron.expression"));
        }
        if (this.cronExpression != null && parametersMap.get("throttle.interval") != null) {
            this.throttlingInterval = Long.parseLong((String)parametersMap.get("throttle.interval"));
        }
        if (parametersMap.get("max.delivery.drop") != null && parametersMap.get("max.delivery.drop").toString().equals("Enabled") && this.maxDeliverAttempts > 0) {
            this.isMaxDeliveryAttemptDropEnabled = true;
        }
        this.interval = Long.parseLong((String)parametersMap.get("interval"));
        this.initialized = true;
    }

    public MessageContext fetch(MessageConsumer msgConsumer) throws StoreForwardException {
        return this.messageConsumer.receive();
    }

    public void dispatch(MessageContext messageContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending the message to client with message processor [" + this.messageProcessor.getName() + "]"));
        }
        SOAPEnvelope originalEnvelop = messageContext.getEnvelope();
        if (this.targetMessageStoreName != null) {
            try {
                while (!this.isSuccessful && !this.isTerminated) {
                    try {
                        OMElement clonedFirstElement;
                        messageContext.setEnvelope(MessageHelper.cloneSOAPEnvelope(originalEnvelop));
                        OMElement firstChild = null;
                        org.apache.axis2.context.MessageContext origAxis2Ctx = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
                        if (JsonUtil.hasAJsonPayload((org.apache.axis2.context.MessageContext)origAxis2Ctx)) {
                            firstChild = origAxis2Ctx.getEnvelope().getBody().getFirstElement();
                        }
                        if (JsonUtil.hasAJsonPayload(firstChild) && (clonedFirstElement = messageContext.getEnvelope().getBody().getFirstElement()) != null) {
                            clonedFirstElement.detach();
                            messageContext.getEnvelope().getBody().addChild((OMNode)firstChild);
                        }
                        if (this.messageConsumer != null && this.messageConsumer.isAlive() && this.targetMessageStoreName != null) {
                            this.targetMessageProducer = this.synapseEnvironment.getSynapseConfiguration().getMessageStore(this.targetMessageStoreName).getProducer();
                            this.isSuccessful = this.targetMessageProducer != null ? this.targetMessageProducer.storeMessage(messageContext) : false;
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("Message store messageSender of message processor [" + this.messageProcessor.getName() + "] failed to send message to the target message store"));
                        this.sendThroughFaultSeq(messageContext);
                    }
                    if (this.isSuccessful) {
                        this.messageConsumer.ack();
                        this.attemptCount = 0;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Successfully sent the message to message store [" + this.targetMessageStoreName + "] with message processor [" + this.messageProcessor.getName() + "]"));
                        }
                        if (!this.messageProcessor.isPaused()) continue;
                        this.messageProcessor.resumeService();
                        log.info((Object)("Resuming the service of message processor [" + this.messageProcessor.getName() + "]"));
                        continue;
                    }
                    this.prepareToRetry(messageContext);
                }
            }
            catch (Exception e) {
                log.error((Object)("Message processor [" + this.messageProcessor.getName() + "] failed to send the message to target store"), (Throwable)e);
            }
        } else {
            log.warn((Object)"Property message.target.store.name not found in the message context , Hence removing the message ");
            this.messageConsumer.ack();
        }
    }

    public void sendThroughFaultSeq(MessageContext msgCtx) {
        if (this.faultSeq == null) {
            log.warn((Object)"Failed to send the message through the fault sequence. Sequence name does not Exist.");
            return;
        }
        Mediator mediator = msgCtx.getSequence(this.faultSeq);
        if (mediator == null) {
            log.warn((Object)("Failed to send the message through the fault sequence. Sequence [" + this.faultSeq + "] does not Exist."));
            return;
        }
        mediator.mediate(msgCtx);
    }

    public void sendThroughDeactivateSeq(MessageContext msgCtx) {
        if (this.deactivateSeq == null) {
            log.warn((Object)"Failed to send the message through the deactivate sequence. Sequence name does not Exist.");
            return;
        }
        Mediator mediator = msgCtx.getSequence(this.deactivateSeq);
        if (mediator == null) {
            log.warn((Object)("Failed to send the message through the deactivate sequence. Sequence [" + this.deactivateSeq + "] does not Exist."));
            return;
        }
        mediator.mediate(msgCtx);
    }

    public boolean terminate() {
        try {
            this.isTerminated = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Successfully terminated job of message processor [" + this.messageProcessor.getName() + "]"));
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)("Failed to terminate the job of message processor [" + this.messageProcessor.getName() + "]"));
            return false;
        }
    }

    private void checkAndDeactivateProcessor(MessageContext msgCtx) {
        if (this.maxDeliverAttempts > 0) {
            ++this.attemptCount;
            if (this.attemptCount >= this.maxDeliverAttempts) {
                if (this.isMaxDeliveryAttemptDropEnabled) {
                    this.dropMessageAndContinueMessageProcessor();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Message processor [" + this.messageProcessor.getName() + "] Dropped the failed message and continue due to reach of max attempts"));
                    }
                } else {
                    this.terminate();
                    this.deactivateMessageProcessor(msgCtx);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Message processor [" + this.messageProcessor.getName() + "] stopped due to reach of max attempts"));
                    }
                }
            }
        }
    }

    private void prepareToRetry(MessageContext msgCtx) {
        if (!this.isTerminated) {
            this.checkAndDeactivateProcessor(msgCtx);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Failed to send to target store retrying after " + this.retryInterval + "s with attempt count - " + this.attemptCount));
            }
            try {
                Thread.sleep(this.retryInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void deactivateMessageProcessor(MessageContext messageContext) {
        this.sendThroughDeactivateSeq(messageContext);
        this.messageProcessor.deactivate();
    }

    private void resetService() {
        this.isSuccessful = false;
        this.attemptCount = 0;
    }

    private boolean isRunningUnderCronExpression() {
        return this.cronExpression != null && this.throttlingInterval > -1L;
    }

    private void dropMessageAndContinueMessageProcessor() {
        this.messageConsumer.ack();
        this.attemptCount = 0;
        this.isSuccessful = true;
        if (this.messageProcessor.isPaused()) {
            this.messageProcessor.resumeService();
        }
        log.info((Object)("Removed failed message and continue the message processor [" + this.messageProcessor.getName() + "]"));
    }

    private boolean setMessageConsumerAndProducer() throws StoreForwardException {
        String messageStoreName = this.messageProcessor.getMessageStoreName();
        MessageStore messageStore = this.synapseEnvironment.getSynapseConfiguration().getMessageStore(messageStoreName);
        this.messageConsumer = messageStore.getConsumer();
        if (this.messageProcessor.getParameters().get("message.target.store.name") != null) {
            this.targetMessageStoreName = (String)this.messageProcessor.getParameters().get("message.target.store.name");
        }
        return this.messageProcessor.setMessageConsumer(this.messageConsumer);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void destroy() {
        this.terminate();
    }
}

