/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.processor.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.message.MessageConsumer;
import org.apache.synapse.message.processor.MessageProcessorCleanupService;
import org.apache.synapse.message.processor.impl.AbstractMessageProcessor;
import org.apache.synapse.message.processor.impl.failover.FailoverForwardingService;
import org.apache.synapse.message.processor.impl.forwarder.ForwardingService;
import org.apache.synapse.message.processor.impl.sampler.SamplingService;
import org.apache.synapse.message.senders.blocking.BlockingMsgSender;
import org.apache.synapse.registry.Registry;
import org.apache.synapse.task.SynapseTaskException;
import org.apache.synapse.task.Task;
import org.apache.synapse.task.TaskDescription;
import org.apache.synapse.task.TaskManager;
import org.apache.synapse.task.TaskManagerObserver;

public abstract class ScheduledMessageProcessor
extends AbstractMessageProcessor
implements TaskManagerObserver {
    private static final Log logger = LogFactory.getLog((String)ScheduledMessageProcessor.class.getName());
    protected long interval = 1000L;
    protected String cronExpression = null;
    protected String[] nonRetryStatusCodes = null;
    protected BlockingMsgSender sender;
    protected SynapseEnvironment synapseEnvironment;
    private TaskManager taskManager = null;
    private Task task;
    private int memberCount = 1;
    private Registry registry;
    private static final String REG_PROCESSOR_BASE_PATH = "/repository/components/org.apache.synapse.message.processor/";
    private static final String MP_STATE = "MESSAGE_PROCESSOR_STATE";
    private static final String TASK_PREFIX = "MSMP_";
    private static final String SYMBOL_UNDERSCORE = "_";
    private static final String DEFAULT_TASK_SUFFIX = "0";

    @Override
    public void init(SynapseEnvironment se) {
        this.synapseEnvironment = se;
        this.initMessageSender(this.parameters);
        this.registry = se.getSynapseConfiguration().getRegistry();
        super.init(se);
        if (this.taskManager == null) {
            this.taskManager = this.synapseEnvironment.getSynapseConfiguration().getTaskManager();
        }
        if (this.taskManager == null) {
            throw new SynapseException("Task Manager not defined in the configuration.");
        }
        if (!this.taskManager.isInitialized()) {
            this.taskManager.addObserver((TaskManagerObserver)this);
            return;
        }
        this.start();
    }

    public boolean getIsActivatedParamValue() {
        Object isActiveParam = this.parameters.get("is.active");
        boolean isActivated = true;
        if (isActiveParam != null) {
            isActivated = Boolean.parseBoolean(String.valueOf(isActiveParam));
        }
        return isActivated;
    }

    protected boolean isProcessorStartAsDeactivated() {
        if (this.getProcessorState() == ProcessorState.INITIAL) {
            return !this.getIsActivatedParamValue();
        }
        return this.getProcessorState() == ProcessorState.PAUSED;
    }

    @Override
    public boolean start() {
        for (int i = 0; i < this.memberCount; ++i) {
            this.task = this.getTask();
            TaskDescription taskDescription = new TaskDescription();
            taskDescription.setName(TASK_PREFIX + this.name + SYMBOL_UNDERSCORE + i);
            taskDescription.setTaskGroup("synapse.message.processor.quartz");
            if (this.interval < 1000L) {
                taskDescription.setInterval(1000L);
            } else {
                taskDescription.setInterval(this.interval);
            }
            taskDescription.setIntervalInMs(true);
            taskDescription.addResource("Instance", (Object)this.task);
            taskDescription.addResource("ClassName", (Object)this.task.getClass().getName());
            if (this.cronExpression != null) {
                taskDescription.setCronExpression(this.cronExpression);
            }
            this.taskManager.schedule(taskDescription);
        }
        logger.info((Object)("Started message processor. [" + this.getName() + "]."));
        if (this.isProcessorStartAsDeactivated()) {
            this.deactivate();
        }
        return true;
    }

    @Override
    public boolean isDeactivated() {
        return this.taskManager.isTaskDeactivated(TASK_PREFIX + this.name + SYMBOL_UNDERSCORE + DEFAULT_TASK_SUFFIX);
    }

    @Override
    public void setParameters(Map<String, Object> parameters) {
        super.setParameters(parameters);
        if (parameters != null && !parameters.isEmpty()) {
            Object o = parameters.get("cronExpression");
            if (o != null) {
                this.cronExpression = o.toString();
            }
            if ((o = parameters.get("interval")) != null) {
                this.interval = Integer.parseInt(o.toString());
            }
            if ((o = parameters.get("member.count")) != null) {
                this.memberCount = Integer.parseInt(o.toString());
            }
            if ((o = parameters.get("is.active")) != null) {
                this.setActivated(Boolean.valueOf(o.toString()));
            }
            if ((o = parameters.get("non.retry.status.codes")) != null) {
                this.nonRetryStatusCodes = o.toString().split(",");
            }
        }
    }

    @Override
    public boolean stop() {
        boolean isStopped = false;
        try {
            isStopped = this.stopTasks(this.memberCount);
        }
        catch (SynapseTaskException e) {
            logger.error((Object)("Cannot stop tasks. Error: " + e.getLocalizedMessage()), (Throwable)e);
        }
        return isStopped;
    }

    private boolean stopTasks(int taskCount) {
        if (this.taskManager != null && this.taskManager.isInitialized()) {
            for (int i = 0; i < taskCount; ++i) {
                if (this.taskManager.isTaskExist(TASK_PREFIX + this.name + SYMBOL_UNDERSCORE + i) && this.taskManager.isTaskRunning(TASK_PREFIX + this.name + SYMBOL_UNDERSCORE + i)) {
                    this.taskManager.pause(TASK_PREFIX + this.name + SYMBOL_UNDERSCORE + i);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("ShuttingDown Message Processor Scheduler : " + this.taskManager.getName()));
                }
                this.taskManager.delete(TASK_PREFIX + this.name + SYMBOL_UNDERSCORE + i + "::" + "synapse.message.processor.quartz");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Stopped message processor [" + this.getName() + "]."));
            }
            return true;
        }
        return false;
    }

    @Override
    public void destroy() {
        this.destroy(false);
    }

    @Override
    public void destroy(boolean preserveState) {
        this.destroy(preserveState, false);
    }

    @Override
    public void destroy(boolean preserveState, boolean isArtifactUpdate) {
        if (!preserveState) {
            this.deleteMessageProcessorState();
        }
        if (isArtifactUpdate || !preserveState) {
            this.stop();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            logger.error((Object)"The thread was interrupted while sleeping", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        if (this.getMessageConsumer() != null && !this.messageConsumers.isEmpty()) {
            this.cleanupLocalResources();
            for (MessageConsumer msgConsumer : this.messageConsumers) {
                msgConsumer.setAlive(false);
            }
        } else {
            logger.warn((Object)("[" + this.getName() + "] Could not find the message consumer to cleanup."));
        }
        this.taskManager.sendClusterMessage(this.getMessageProcessorCleanupTask());
        if (logger.isDebugEnabled()) {
            logger.info((Object)("Successfully destroyed message processor [" + this.getName() + "]."));
        }
    }

    @Override
    public boolean deactivate() {
        if (this.taskManager != null && this.taskManager.isInitialized()) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Deactivating message processor [" + this.getName() + "]"));
                }
                this.pauseService();
                this.setMessageProcessorState(ProcessorState.PAUSED);
                logger.info((Object)("Successfully deactivated the message processor [" + this.getName() + "]"));
            }
            finally {
                this.cleanupLocalResources();
                this.taskManager.sendClusterMessage(this.getMessageProcessorCleanupTask());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean activate() {
        if (this.taskManager != null && this.isDeactivated()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Starting Message Processor Scheduler : " + this.taskManager.getName()));
            }
            this.resumeService();
            this.setMessageProcessorState(ProcessorState.RUNNING);
            logger.info((Object)("Successfully re-activated the message processor [" + this.getName() + "]"));
            return true;
        }
        return false;
    }

    @Override
    public void pauseService() {
        if (this.task instanceof ForwardingService) {
            ((ForwardingService)this.task).terminate();
        } else if (this.task instanceof SamplingService) {
            ((SamplingService)this.task).terminate();
        } else if (this.task instanceof FailoverForwardingService) {
            ((FailoverForwardingService)this.task).terminate();
        }
        for (int i = 0; i < this.memberCount; ++i) {
            this.taskManager.pause(TASK_PREFIX + this.name + SYMBOL_UNDERSCORE + i);
        }
    }

    @Override
    public void resumeService() {
        for (int i = 0; i < this.memberCount; ++i) {
            this.taskManager.resume(TASK_PREFIX + this.name + SYMBOL_UNDERSCORE + i);
        }
    }

    public boolean isActive() {
        return this.taskManager.isTaskRunning(TASK_PREFIX + this.name + SYMBOL_UNDERSCORE + DEFAULT_TASK_SUFFIX) || this.taskManager.isTaskBlocked(TASK_PREFIX + this.name + SYMBOL_UNDERSCORE + DEFAULT_TASK_SUFFIX);
    }

    @Override
    public boolean isPaused() {
        return this.taskManager.isTaskDeactivated(TASK_PREFIX + this.name + SYMBOL_UNDERSCORE + DEFAULT_TASK_SUFFIX);
    }

    public boolean getActivated() {
        return this.taskManager.isTaskRunning(TASK_PREFIX + this.name + SYMBOL_UNDERSCORE + DEFAULT_TASK_SUFFIX);
    }

    private void setActivated(boolean activated) {
        this.parameters.put("is.active", String.valueOf(activated));
    }

    protected boolean isThrottling(long interval) {
        return interval < 1000L;
    }

    public boolean isThrottling(String cronExpression) {
        return cronExpression != null;
    }

    private BlockingMsgSender initMessageSender(Map<String, Object> params) {
        String axis2repo = (String)params.get("axis2.repo");
        String axis2Config = (String)params.get("axis2.config");
        this.sender = new BlockingMsgSender();
        if (axis2repo != null) {
            this.sender.setClientRepository(axis2repo);
        }
        if (axis2Config != null) {
            this.sender.setAxis2xml(axis2Config);
        }
        this.sender.init();
        return this.sender;
    }

    protected abstract Task getTask();

    public void update() {
        String[] tasksInRegistry = this.taskManager.getTaskNames();
        int taskCountInRegistry = 0;
        for (String taskName : tasksInRegistry) {
            String task;
            if (!taskName.startsWith(TASK_PREFIX) || !(task = taskName.substring(0, taskName.lastIndexOf(SYMBOL_UNDERSCORE))).equals(TASK_PREFIX + this.name)) continue;
            ++taskCountInRegistry;
        }
        if (taskCountInRegistry > this.memberCount) {
            this.stopTasks(taskCountInRegistry);
        }
        this.start();
    }

    @Override
    public void cleanupLocalResources() {
        if (this.messageConsumers != null) {
            for (MessageConsumer messageConsumer : this.messageConsumers) {
                messageConsumer.cleanup();
            }
        }
    }

    private Callable<Void> getMessageProcessorCleanupTask() {
        Iterator<MessageProcessorCleanupService> it;
        MessageProcessorCleanupService cleanupTask = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Trying to fetch InboundRequestProcessor from classpath.. ");
        }
        if ((it = ServiceLoader.load(MessageProcessorCleanupService.class).iterator()).hasNext()) {
            cleanupTask = it.next();
            cleanupTask.setName(this.name);
            if (cleanupTask != null && logger.isDebugEnabled()) {
                logger.debug((Object)("Message Processor Cleanup Service found  : " + cleanupTask.getClass().getName()));
            }
            return cleanupTask;
        }
        return null;
    }

    private ProcessorState getProcessorState() {
        Properties resourceProperties = this.registry.getResourceProperties(REG_PROCESSOR_BASE_PATH + this.getName());
        if (resourceProperties == null) {
            return ProcessorState.INITIAL;
        }
        String state = resourceProperties.getProperty(MP_STATE);
        if (ProcessorState.RUNNING.toString().equalsIgnoreCase(state)) {
            return ProcessorState.RUNNING;
        }
        return ProcessorState.PAUSED;
    }

    private void setMessageProcessorState(ProcessorState state) {
        this.registry.newNonEmptyResource(REG_PROCESSOR_BASE_PATH + this.getName(), false, "text/plain", state.toString(), MP_STATE);
    }

    private void deleteMessageProcessorState() {
        if (this.registry.getResourceProperties(REG_PROCESSOR_BASE_PATH + this.getName()) != null) {
            this.registry.delete(REG_PROCESSOR_BASE_PATH + this.getName());
        }
    }

    private static enum ProcessorState {
        INITIAL,
        RUNNING,
        PAUSED;

    }
}

