/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.processor.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.message.MessageConsumer;
import org.apache.synapse.message.processor.MessageProcessor;

public abstract class AbstractMessageProcessor
implements MessageProcessor {
    private static final Log logger = LogFactory.getLog((String)AbstractMessageProcessor.class.getName());
    protected String messageStore;
    protected String description;
    protected String name;
    protected String fileName;
    protected SynapseConfiguration configuration;
    protected List<MessageConsumer> messageConsumers = new ArrayList<MessageConsumer>();
    protected String artifactContainerName;
    protected boolean isEdited;
    protected String targetEndpoint;
    protected Map<String, Object> parameters = null;

    @Override
    public void init(SynapseEnvironment se) {
        this.configuration = se.getSynapseConfiguration();
    }

    @Override
    public void setMessageStoreName(String messageStore) {
        if (messageStore == null) {
            throw new SynapseException("Error Can't set Message store to null");
        }
        this.messageStore = messageStore;
    }

    @Override
    public String getMessageStoreName() {
        return this.messageStore;
    }

    @Override
    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setFileName(String filename) {
        this.fileName = filename;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public List<MessageConsumer> getMessageConsumer() {
        return this.messageConsumers;
    }

    @Override
    public boolean setMessageConsumer(MessageConsumer consumer) {
        if (consumer == null) {
            logger.error((Object)("[" + this.getName() + "] Faulty message consumer."));
            return false;
        }
        this.messageConsumers.add(consumer);
        return true;
    }

    @Override
    public void setTargetEndpoint(String targetEndpoint) {
        this.targetEndpoint = targetEndpoint;
    }

    @Override
    public String getTargetEndpoint() {
        return this.targetEndpoint;
    }

    @Override
    public boolean isEdited() {
        return this.isEdited;
    }

    @Override
    public void setIsEdited(boolean isEdited) {
        this.isEdited = isEdited;
    }

    @Override
    public String getArtifactContainerName() {
        return this.artifactContainerName;
    }

    @Override
    public void setArtifactContainerName(String artifactContainerName) {
        this.artifactContainerName = artifactContainerName;
    }

    public void destroy(boolean preserveState) {
    }

    public void destroy(boolean preserveState, boolean isUpdate) {
    }
}

