/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.transform.pfutils;

import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.synapse.MessageContext;
import org.apache.synapse.commons.json.JsonUtil;
import org.apache.synapse.config.xml.SynapsePath;
import org.apache.synapse.mediators.transform.Argument;
import org.apache.synapse.mediators.transform.ArgumentDetails;
import org.apache.synapse.mediators.transform.pfutils.TemplateProcessorException;

public abstract class TemplateProcessor {
    protected static final String JSON_TYPE = "json";
    protected static final String XML_TYPE = "xml";
    protected static final String TEXT_TYPE = "text";
    protected static final String STRING_TYPE = "str";
    protected static final String ESCAPE_DOUBLE_QUOTE_WITH_FIVE_BACK_SLASHES = "\\\\\"";
    protected static final String ESCAPE_DOUBLE_QUOTE_WITH_NINE_BACK_SLASHES = "\\\\\\\\\"";
    protected static final String ESCAPE_BACK_SLASH_WITH_SIXTEEN_BACK_SLASHES = "\\\\\\\\\\\\\\\\";
    protected static final String ESCAPE_DOLLAR_WITH_SIX_BACK_SLASHES = "\\\\\\$";
    protected static final String ESCAPE_DOLLAR_WITH_TEN_BACK_SLASHES = "\\\\\\\\\\$";
    protected static final String ESCAPE_BACKSPACE_WITH_EIGHT_BACK_SLASHES = "\\\\\\\\b";
    protected static final String ESCAPE_FORMFEED_WITH_EIGHT_BACK_SLASHES = "\\\\\\\\f";
    protected static final String ESCAPE_NEWLINE_WITH_EIGHT_BACK_SLASHES = "\\\\\\\\n";
    protected static final String ESCAPE_CRETURN_WITH_EIGHT_BACK_SLASHES = "\\\\\\\\r";
    protected static final String ESCAPE_TAB_WITH_EIGHT_BACK_SLASHES = "\\\\\\\\t";
    private static final Pattern validJsonNumber = Pattern.compile("^-?(0|([1-9]\\d*))(\\.\\d+)?([eE][+-]?\\d+)?$");
    private static final Log log = LogFactory.getLog(TemplateProcessor.class);
    protected final XMLInputFactory inputFactory = XMLInputFactory.newInstance();
    private final List<Argument> pathArgumentList = new ArrayList<Argument>();
    private boolean escapeXmlChars = false;
    private String format;
    private String mediaType = "xml";

    public abstract String processTemplate(String var1, String var2, MessageContext var3);

    public abstract void init();

    protected HashMap<String, ArgumentDetails>[] getArgValues(String mediaType, MessageContext synCtx) {
        HashMap[] argValues = new HashMap[this.pathArgumentList.size()];
        String value = "";
        for (int i = 0; i < this.pathArgumentList.size(); ++i) {
            Argument arg = this.pathArgumentList.get(i);
            ArgumentDetails details = new ArgumentDetails();
            if (arg.getValue() != null) {
                value = arg.getValue();
                details.setXml(this.isXML(value));
                if (!details.isXml()) {
                    value = StringEscapeUtils.escapeXml10((String)value);
                }
                value = Matcher.quoteReplacement(value);
            } else if (arg.getExpression() != null) {
                value = arg.getExpression().stringValueOf(synCtx);
                details.setLiteral(arg.isLiteral());
                if (value != null) {
                    details.setXml(this.isXML(value));
                    if (!details.isXml() && XML_TYPE.equals(mediaType) && !this.isJson(value.trim(), arg.getExpression())) {
                        value = StringEscapeUtils.escapeXml10((String)value);
                    }
                    value = Matcher.quoteReplacement(value);
                } else {
                    value = "";
                }
            } else {
                this.handleException("Unexpected arg type detected");
            }
            HashMap<String, ArgumentDetails> valueMap = new HashMap<String, ArgumentDetails>();
            if (null != arg.getExpression()) {
                details.setPathType(arg.getExpression().getPathType());
                valueMap.put(value, details);
            } else {
                details.setPathType("X_PATH");
                valueMap.put(value, details);
            }
            argValues[i] = valueMap;
        }
        return argValues;
    }

    protected String prepareReplacementValue(String mediaType, MessageContext synCtx, Map.Entry<String, ArgumentDetails> replacementEntry) {
        String replacementValue = null;
        if (mediaType.equals(JSON_TYPE) && this.inferReplacementType(replacementEntry).equals(XML_TYPE)) {
            replacementValue = this.convertXmlArgumentToJson(replacementEntry, replacementValue);
        } else if (mediaType.equals(XML_TYPE) && this.inferReplacementType(replacementEntry).equals(JSON_TYPE)) {
            replacementValue = this.convertJsonArgumentToXml(replacementEntry, replacementValue);
        } else {
            replacementValue = replacementEntry.getKey();
            String trimmedReplacementValue = replacementValue.trim();
            if (mediaType.equals(XML_TYPE) && this.inferReplacementType(replacementEntry).equals(STRING_TYPE) && this.isJson(trimmedReplacementValue)) {
                replacementValue = this.convertJsonStringToXml(replacementValue);
            } else if (mediaType.equals(JSON_TYPE) && this.inferReplacementType(replacementEntry).equals(JSON_TYPE) && this.isEscapeXmlChars()) {
                replacementValue = this.escapeXMLSpecialChars(replacementValue);
            } else if (mediaType.equals(JSON_TYPE) && this.inferReplacementType(replacementEntry).equals(STRING_TYPE)) {
                Object force_string_quote;
                replacementValue = this.escapeSpecialChars(replacementValue);
                if (!(this.isJson(trimmedReplacementValue) || (force_string_quote = synCtx.getProperty("QUOTE_STRING_IN_PAYLOAD_FACTORY_JSON")) == null || !((String)force_string_quote).equalsIgnoreCase("true") || trimmedReplacementValue.equals("true") || trimmedReplacementValue.equals("false") || trimmedReplacementValue.equals("null") || validJsonNumber.matcher(trimmedReplacementValue).matches())) {
                    replacementValue = "\"" + replacementValue + "\"";
                }
            }
        }
        return replacementValue;
    }

    private String convertJsonStringToXml(String replacementValue) {
        try {
            replacementValue = this.escapeSpecialCharactersOfXml(replacementValue);
            OMElement omXML = JsonUtil.toXml((InputStream)IOUtils.toInputStream((String)replacementValue), (boolean)false);
            if (JsonUtil.isAJsonPayloadElement((OMElement)omXML)) {
                Iterator children = omXML.getChildElements();
                String childrenStr = "";
                while (children.hasNext()) {
                    childrenStr = childrenStr + children.next().toString().trim();
                }
                replacementValue = childrenStr;
            } else {
                replacementValue = omXML.toString();
            }
        }
        catch (AxisFault e) {
            this.handleException("Error converting JSON to XML, please check your JSON Path expressions return valid JSON: ");
        }
        return replacementValue;
    }

    private String convertJsonArgumentToXml(Map.Entry<String, ArgumentDetails> replacementEntry, String replacementValue) {
        try {
            replacementValue = replacementEntry.getKey();
            replacementValue = this.escapeSpecialCharactersOfXml(replacementValue);
            OMElement omXML = JsonUtil.toXml((InputStream)IOUtils.toInputStream((String)replacementValue), (boolean)false);
            if (JsonUtil.isAJsonPayloadElement((OMElement)omXML)) {
                Iterator children = omXML.getChildElements();
                String childrenStr = "";
                while (children.hasNext()) {
                    childrenStr = childrenStr + children.next().toString().trim();
                }
                replacementValue = childrenStr;
            } else {
                replacementValue = omXML.toString();
            }
        }
        catch (AxisFault e) {
            this.handleException("Error converting JSON to XML, please check your JSON Path expressions return valid JSON: ");
        }
        return replacementValue;
    }

    private String convertXmlArgumentToJson(Map.Entry<String, ArgumentDetails> replacementEntry, String replacementValue) {
        try {
            replacementValue = "<jsonObject>" + replacementEntry.getKey() + "</jsonObject>";
            OMElement omXML = this.convertStringToOM(replacementValue);
            replacementValue = JsonUtil.toJsonString((OMElement)omXML).toString();
            replacementValue = this.escapeSpecialCharactersOfJson(replacementValue);
        }
        catch (XMLStreamException e) {
            this.handleException("Error parsing XML for JSON conversion, please check your xPath expressions return valid XML: ");
        }
        catch (AxisFault e) {
            this.handleException("Error converting XML to JSON");
        }
        catch (OMException e) {
            replacementValue = replacementEntry.getKey();
            replacementValue = this.escapeSpecialChars(replacementValue);
        }
        return replacementValue;
    }

    protected String inferReplacementType(Map.Entry<String, ArgumentDetails> entry) {
        if (entry.getValue().isLiteral()) {
            return STRING_TYPE;
        }
        if (entry.getValue().getPathType().equals("X_PATH")) {
            if (entry.getValue().isXml()) {
                return XML_TYPE;
            }
            if (this.isJson(entry.getKey())) {
                return JSON_TYPE;
            }
        }
        if (entry.getValue().getPathType().equals("JSON_PATH") && this.isJson(entry.getKey())) {
            return JSON_TYPE;
        }
        return STRING_TYPE;
    }

    protected boolean isJson(String value) {
        return value != null && !value.trim().isEmpty() && (value.trim().charAt(0) == '{' || value.trim().charAt(0) == '[');
    }

    private boolean isJson(String value, SynapsePath expression) {
        return value != null && !value.trim().isEmpty() && (value.trim().charAt(0) == '{' || value.trim().charAt(0) == '[') && expression.getPathType().equals("JSON_PATH");
    }

    protected boolean isXML(String value) {
        try {
            value = value.trim();
            if (!value.endsWith(">") || value.length() < 4) {
                return false;
            }
            this.convertStringToOM(value);
            return true;
        }
        catch (XMLStreamException | OMException ignore) {
            return false;
        }
    }

    protected OMElement convertStringToOM(String value) throws XMLStreamException, OMException {
        XMLStreamReader xmlReader = this.inputFactory.createXMLStreamReader(new StringReader(value));
        StAXOMBuilder builder = new StAXOMBuilder(xmlReader);
        return builder.getDocumentElement();
    }

    protected String escapeSpecialChars(String replaceString) {
        return replaceString.replaceAll(Matcher.quoteReplacement("\\\\"), ESCAPE_BACK_SLASH_WITH_SIXTEEN_BACK_SLASHES).replaceAll("\"", ESCAPE_DOUBLE_QUOTE_WITH_NINE_BACK_SLASHES).replaceAll("\b", ESCAPE_BACKSPACE_WITH_EIGHT_BACK_SLASHES).replaceAll("\f", ESCAPE_FORMFEED_WITH_EIGHT_BACK_SLASHES).replaceAll("\n", ESCAPE_NEWLINE_WITH_EIGHT_BACK_SLASHES).replaceAll("\r", ESCAPE_CRETURN_WITH_EIGHT_BACK_SLASHES).replaceAll("\t", ESCAPE_TAB_WITH_EIGHT_BACK_SLASHES);
    }

    protected String escapeSpecialCharactersOfJson(String jsonString) {
        return jsonString.replaceAll(ESCAPE_DOUBLE_QUOTE_WITH_FIVE_BACK_SLASHES, ESCAPE_DOUBLE_QUOTE_WITH_NINE_BACK_SLASHES).replaceAll(ESCAPE_DOLLAR_WITH_TEN_BACK_SLASHES, ESCAPE_DOLLAR_WITH_SIX_BACK_SLASHES).replaceAll("\\\\b", ESCAPE_BACKSPACE_WITH_EIGHT_BACK_SLASHES).replaceAll("\\\\f", ESCAPE_FORMFEED_WITH_EIGHT_BACK_SLASHES).replaceAll("\\\\n", ESCAPE_NEWLINE_WITH_EIGHT_BACK_SLASHES).replaceAll("\\\\r", ESCAPE_CRETURN_WITH_EIGHT_BACK_SLASHES).replaceAll("\\\\t", ESCAPE_TAB_WITH_EIGHT_BACK_SLASHES);
    }

    protected String escapeSpecialCharactersOfXml(String xmlString) {
        return xmlString.replaceAll(ESCAPE_DOUBLE_QUOTE_WITH_FIVE_BACK_SLASHES, ESCAPE_DOUBLE_QUOTE_WITH_NINE_BACK_SLASHES).replaceAll("\\$", ESCAPE_DOLLAR_WITH_SIX_BACK_SLASHES).replaceAll("\\\\b", ESCAPE_BACKSPACE_WITH_EIGHT_BACK_SLASHES).replaceAll("\\\\f", ESCAPE_FORMFEED_WITH_EIGHT_BACK_SLASHES).replaceAll("\\\\n", ESCAPE_NEWLINE_WITH_EIGHT_BACK_SLASHES).replaceAll("\\\\r", ESCAPE_CRETURN_WITH_EIGHT_BACK_SLASHES).replaceAll("\\\\t", ESCAPE_TAB_WITH_EIGHT_BACK_SLASHES);
    }

    protected String escapeXMLSpecialChars(String replaceString) {
        return replaceString.replaceAll("\b", ESCAPE_BACKSPACE_WITH_EIGHT_BACK_SLASHES).replaceAll("\f", ESCAPE_FORMFEED_WITH_EIGHT_BACK_SLASHES).replaceAll("\n", ESCAPE_NEWLINE_WITH_EIGHT_BACK_SLASHES).replaceAll("\r", ESCAPE_CRETURN_WITH_EIGHT_BACK_SLASHES).replaceAll("\t", ESCAPE_TAB_WITH_EIGHT_BACK_SLASHES);
    }

    protected boolean isEscapeXmlChars() {
        return this.escapeXmlChars;
    }

    public void setEscapeXmlChars(boolean escapeXmlChars) {
        this.escapeXmlChars = escapeXmlChars;
    }

    public void addPathArgument(Argument arg) {
        this.pathArgumentList.add(arg);
    }

    public List<Argument> getPathArgumentList() {
        return this.pathArgumentList;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    protected void handleException(String msg) {
        throw new TemplateProcessorException(msg);
    }
}

