/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.transform.pfutils;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.mediators.transform.ArgumentDetails;
import org.apache.synapse.mediators.transform.pfutils.TemplateProcessor;

public class RegexTemplateProcessor
extends TemplateProcessor {
    private static final Log log = LogFactory.getLog(RegexTemplateProcessor.class);
    private final Pattern pattern = Pattern.compile("\\$(\\d)+");

    @Override
    public String processTemplate(String template, String mediaType, MessageContext synCtx) {
        StringBuffer result = new StringBuffer();
        this.replace(template, result, mediaType, synCtx);
        return result.toString();
    }

    @Override
    public void init() {
    }

    private void replace(String format, StringBuffer result, String mediaType, MessageContext synCtx) {
        HashMap<String, ArgumentDetails>[] argValues = this.getArgValues(mediaType, synCtx);
        Matcher matcher = "json".equals(mediaType) || "text".equals(mediaType) ? this.pattern.matcher(format) : this.pattern.matcher("<pfPadding>" + format + "</pfPadding>");
        try {
            while (matcher.find()) {
                String matchSeq = matcher.group();
                HashMap<String, ArgumentDetails> replacement = this.getReplacementValue(argValues, matchSeq);
                Map.Entry<String, ArgumentDetails> replacementEntry = replacement.entrySet().iterator().next();
                String replacementValue = this.prepareReplacementValue(mediaType, synCtx, replacementEntry);
                matcher.appendReplacement(result, replacementValue);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            log.error((Object)"#replace. Mis-match detected between number of formatters and arguments", (Throwable)e);
        }
        matcher.appendTail(result);
    }

    private HashMap<String, ArgumentDetails> getReplacementValue(HashMap<String, ArgumentDetails>[] argValues, String matchSeq) {
        int argIndex;
        try {
            argIndex = Integer.parseInt(matchSeq.substring(1));
        }
        catch (NumberFormatException e) {
            argIndex = Integer.parseInt(matchSeq.substring(2, matchSeq.length() - 1));
        }
        HashMap<String, ArgumentDetails> replacement = argValues[argIndex - 1];
        return replacement;
    }
}

