/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.transform.pfutils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import freemarker.ext.dom.NodeModel;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.synapse.MessageContext;
import org.apache.synapse.commons.json.JsonUtil;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.transform.ArgumentDetails;
import org.apache.synapse.mediators.transform.pfutils.TemplateProcessor;
import org.apache.synapse.util.PayloadHelper;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FreeMarkerTemplateProcessor
extends TemplateProcessor {
    private final Configuration cfg = new Configuration(Configuration.VERSION_2_3_30);
    private final Gson gson;
    private Template freeMarkerTemplate;
    private boolean usingPayload;
    private boolean usingPropertyCtx;
    private boolean usingPropertyAxis2;
    private boolean usingPropertyTransport;
    private boolean usingArgs;
    private static final Log log = LogFactory.getLog(FreeMarkerTemplateProcessor.class);

    public FreeMarkerTemplateProcessor() {
        this.cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.cfg.setLogTemplateExceptions(false);
        this.gson = new Gson();
    }

    @Override
    public void init() {
        String format = this.getFormat();
        if (format != null) {
            this.compileFreeMarkerTemplate(format, this.getMediaType());
        }
    }

    @Override
    public String processTemplate(String template, String mediaType, MessageContext messageContext) {
        try {
            HashMap<String, Object> data = new HashMap<String, Object>();
            int payloadType = this.getPayloadType(messageContext);
            this.injectPayloadVariables(messageContext, payloadType, data);
            this.injectArgs(messageContext, mediaType, data);
            this.injectProperties(messageContext, data);
            StringWriter out = new StringWriter();
            this.freeMarkerTemplate.process(data, (Writer)out);
            return ((Object)out).toString();
        }
        catch (IOException e) {
            this.handleException("Error parsing FreeMarker template");
        }
        catch (TemplateException e) {
            this.handleException(this.generateTemplateErrorMessage(e));
        }
        catch (ParserConfigurationException | SAXException e) {
            this.handleException("Error reading payload data");
        }
        return "";
    }

    private String generateTemplateErrorMessage(TemplateException e) {
        if (log.isDebugEnabled()) {
            return e.getMessageWithoutStackTop();
        }
        return "Error parsing FreeMarker template, Syntax error or invalid reference : " + e.getBlamedExpressionString() + " At line: " + e.getLineNumber() + " column: " + e.getColumnNumber();
    }

    private void compileFreeMarkerTemplate(String templateString, String mediaType) {
        try {
            if ("xml".equals(mediaType)) {
                templateString = "<pfPadding>" + templateString + "</pfPadding>";
            }
            this.freeMarkerTemplate = new Template("synapse-template", templateString, this.cfg);
            this.findRequiredInjections(templateString);
        }
        catch (IOException e) {
            this.handleException("Error compiling FreeMarking template : " + e.getMessage());
        }
    }

    private void findRequiredInjections(String templateString) {
        this.usingPayload = templateString.contains("payload");
        this.usingArgs = templateString.contains("args");
        this.usingPropertyCtx = templateString.contains("ctx");
        this.usingPropertyAxis2 = templateString.contains("axis2");
        this.usingPropertyTransport = templateString.contains("trp");
    }

    private void injectArgs(MessageContext messageContext, String mediaType, Map<String, Object> data) {
        if (this.usingArgs) {
            HashMap<String, String> argsValues = new HashMap<String, String>();
            HashMap<String, ArgumentDetails>[] argValues = this.getArgValues(mediaType, messageContext);
            for (int i = 0; i < argValues.length; ++i) {
                HashMap<String, ArgumentDetails> argValue = argValues[i];
                Map.Entry<String, ArgumentDetails> argumentDetailsEntry = argValue.entrySet().iterator().next();
                String replacementValue = this.prepareReplacementValue(mediaType, messageContext, argumentDetailsEntry);
                argsValues.put("arg" + (i + 1), replacementValue);
            }
            data.put("args", argsValues);
        }
    }

    private void injectPayloadVariables(MessageContext messageContext, int payloadType, Map<String, Object> data) throws SAXException, IOException, ParserConfigurationException {
        if (this.usingPayload) {
            if (payloadType == 0) {
                this.injectXmlPayload(messageContext, data);
            } else if (payloadType == 1) {
                this.injectJsonPayload((Axis2MessageContext)messageContext, data);
            } else if (payloadType == 2) {
                this.injectTextPayload(messageContext, data);
            } else {
                data.put("payload", "");
            }
        }
    }

    private void injectJsonPayload(Axis2MessageContext messageContext, Map<String, Object> data) {
        org.apache.axis2.context.MessageContext axis2MessageContext = messageContext.getAxis2MessageContext();
        String jsonPayloadString = JsonUtil.jsonPayloadToString((org.apache.axis2.context.MessageContext)axis2MessageContext);
        try {
            JsonElement jsonElement = new JsonParser().parse(jsonPayloadString);
            if (jsonElement.isJsonObject()) {
                this.injectJsonObject(data, jsonElement);
            } else if (jsonElement.isJsonArray()) {
                this.injectJsonArray(data, jsonElement);
            } else if (jsonElement.isJsonPrimitive()) {
                this.injectJsonPrimitive(data, jsonElement);
            } else if (jsonElement.isJsonNull()) {
                data.put("payload", "null");
            }
        }
        catch (JsonSyntaxException e) {
            this.handleException("Invalid JSON payload");
        }
    }

    private void injectJsonArray(Map<String, Object> data, JsonElement jsonElement) {
        Type type = new TypeToken<List<Object>>(){}.getType();
        List array = (List)this.gson.fromJson(jsonElement, type);
        data.put("payload", array);
    }

    private void injectJsonPrimitive(Map<String, Object> data, JsonElement jsonElement) {
        JsonPrimitive jsonPrimitive = jsonElement.getAsJsonPrimitive();
        data.put("payload", jsonPrimitive.toString());
    }

    private void injectJsonObject(Map<String, Object> data, JsonElement jsonElement) {
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        Map map = (Map)this.gson.fromJson(jsonElement, type);
        data.put("payload", map);
    }

    private void injectXmlPayload(MessageContext messageContext, Map<String, Object> data) throws SAXException, IOException, ParserConfigurationException {
        data.put("payload", NodeModel.parse((InputSource)new InputSource(new StringReader(messageContext.getEnvelope().getBody().getFirstElement().toString()))));
    }

    private void injectTextPayload(MessageContext messageContext, Map<String, Object> data) {
        OMElement el = PayloadHelper.getXMLPayload(messageContext.getEnvelope());
        String textPayload = el == null || !el.getQName().equals(PayloadHelper.TEXTELT) ? "" : this.getTextValue((OMNode)el);
        data.put("payload", textPayload);
    }

    private String getTextValue(OMNode node) {
        switch (node.getType()) {
            case 1: {
                StringBuilder sb = new StringBuilder();
                Iterator children = ((OMElement)node).getChildren();
                while (children.hasNext()) {
                    sb.append(this.getTextValue((OMNode)children.next()));
                }
                return sb.toString();
            }
            case 4: {
                String text = ((OMText)node).getText();
                return StringEscapeUtils.escapeXml11((String)text);
            }
        }
        return "";
    }

    private void injectProperties(MessageContext synCtx, Map<String, Object> data) {
        this.injectCtxProperties(synCtx, data);
        this.injectAxis2Properties(synCtx, data);
        this.injectTransportProperties(synCtx, data);
    }

    private void injectCtxProperties(MessageContext synCtx, Map<String, Object> data) {
        if (this.usingPropertyCtx) {
            HashMap<String, String> properties = new HashMap<String, String>();
            Map<String, Object> propertyMap = ((Axis2MessageContext)synCtx).getProperties();
            for (Map.Entry<String, Object> propertyEntry : propertyMap.entrySet()) {
                String propertyKey = propertyEntry.getKey();
                Object propertyValue = propertyEntry.getValue();
                if (propertyValue == null) continue;
                properties.put(propertyKey, propertyValue.toString());
            }
            data.put("ctx", properties);
        }
    }

    private void injectAxis2Properties(MessageContext synCtx, Map<String, Object> data) {
        if (this.usingPropertyAxis2) {
            HashMap<String, String> properties = new HashMap<String, String>();
            org.apache.axis2.context.MessageContext axis2MessageContext = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
            Iterator propertyNames = axis2MessageContext.getPropertyNames();
            while (propertyNames.hasNext()) {
                String propertyName = (String)propertyNames.next();
                Object propertyValue = axis2MessageContext.getProperty(propertyName);
                if (propertyValue == null) continue;
                properties.put(propertyName, propertyValue.toString());
            }
            data.put("axis2", properties);
        }
    }

    private void injectTransportProperties(MessageContext synCtx, Map<String, Object> data) {
        if (this.usingPropertyTransport) {
            HashMap<String, String> properties = new HashMap<String, String>();
            org.apache.axis2.context.MessageContext axis2MessageContext = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
            Object headers = axis2MessageContext.getProperty("TRANSPORT_HEADERS");
            if (headers instanceof Map) {
                Map headersMap = (Map)headers;
                for (Map.Entry propertyEntry : headersMap.entrySet()) {
                    if (!(propertyEntry instanceof Map.Entry)) continue;
                    Map.Entry entry = propertyEntry;
                    String propertyKey = entry.getKey().toString();
                    Object propertyValue = entry.getValue();
                    if (propertyValue == null) continue;
                    properties.put(propertyKey, propertyValue.toString());
                }
            }
            data.put("trp", properties);
        }
    }

    private int getPayloadType(MessageContext messageContext) {
        int payloadType = 0;
        try {
            payloadType = PayloadHelper.getPayloadType(messageContext);
        }
        catch (NullPointerException e) {
            return -1;
        }
        if (payloadType == 0) {
            if (JsonUtil.hasAJsonPayload((org.apache.axis2.context.MessageContext)((Axis2MessageContext)messageContext).getAxis2MessageContext())) {
                return 1;
            }
            return 0;
        }
        if (payloadType == 2) {
            return 2;
        }
        return -1;
    }
}

