/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.transform;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.commons.json.JsonUtil;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.MediatorProperty;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.util.jaxp.DOOMResultBuilderFactory;
import org.apache.synapse.util.jaxp.DOOMSourceBuilderFactory;
import org.apache.synapse.util.jaxp.ResultBuilder;
import org.apache.synapse.util.jaxp.ResultBuilderFactory;
import org.apache.synapse.util.jaxp.SourceBuilder;
import org.apache.synapse.util.jaxp.SourceBuilderFactory;
import org.apache.synapse.util.jaxp.StreamResultBuilder;
import org.apache.synapse.util.jaxp.StreamResultBuilderFactory;
import org.apache.synapse.util.jaxp.StreamSourceBuilderFactory;
import org.apache.synapse.util.resolver.CustomJAXPURIResolver;
import org.apache.synapse.util.resolver.ResourceMap;
import org.apache.synapse.util.xpath.SourceXPathSupport;
import org.apache.synapse.util.xpath.SynapseXPath;

public class XSLTMediator
extends AbstractMediator {
    public static final String USE_DOM_SOURCE_AND_RESULTS = "http://ws.apache.org/ns/synapse/transform/feature/dom";
    public static final String SOURCE_BUILDER_FACTORY = "http://ws.apache.org/ns/synapse/transform/attribute/sbf";
    public static final String RESULT_BUILDER_FACTORY = "http://ws.apache.org/ns/synapse/transform/attribute/rbf";
    public static final String TRANSFORM_XSLT_RESULT_DISABLE_BUILD = "transform.xslt.result.disableBuild";
    public static final String XSLT_TRANSFORMATION_ACTIVITY = "XSLT transformation";
    public static final String STYLESHEET_PARSING_ACTIVITY = "stylesheet parsing";
    private Value xsltKey = null;
    private final SourceXPathSupport source = new SourceXPathSupport();
    private String targetPropertyName = null;
    private final List<MediatorProperty> properties = new ArrayList<MediatorProperty>();
    private final List<MediatorProperty> transformerFactoryFeatures = new ArrayList<MediatorProperty>();
    private final List<MediatorProperty> transformerFactoryAttributes = new ArrayList<MediatorProperty>();
    private ResourceMap resourceMap;
    private Map<String, Templates> cachedTemplatesMap = new Hashtable<String, Templates>();
    private final TransformerFactory transFact = TransformerFactory.newInstance();
    private final Object transformerLock = new Object();
    private SourceBuilderFactory sourceBuilderFactory = new StreamSourceBuilderFactory();
    private ResultBuilderFactory resultBuilderFactory = new StreamResultBuilderFactory();
    private boolean useCache = true;

    @Override
    public boolean mediate(MessageContext synCtx) {
        if (synCtx.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(synCtx)) {
            return true;
        }
        SynapseLog synLog = this.getLog(synCtx);
        synLog.traceOrDebug("Start : XSLT mediator");
        if (synLog.isTraceTraceEnabled()) {
            synLog.traceTrace("Message : " + synCtx.getEnvelope());
        }
        if (this.source.getXPath() == null && synCtx.getEnvelope().getBody().getFirstElement() == null) {
            synLog.auditWarn("Found empty soap body, skipping XSLT transformation and continuing the mediation");
            return true;
        }
        try {
            this.performXSLT(synCtx, synLog);
        }
        catch (Exception e) {
            this.handleException("Unable to perform XSLT transformation using : " + this.xsltKey + " against source XPath : " + this.source + " reason : " + e.getMessage(), e, synCtx);
        }
        JsonUtil.removeJsonStream((org.apache.axis2.context.MessageContext)((Axis2MessageContext)synCtx).getAxis2MessageContext());
        synLog.traceOrDebug("End : XSLT mediator");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performXSLT(MessageContext synCtx, SynapseLog synLog) {
        Object object;
        OMNode sourceNode = this.source.selectOMNode(synCtx, synLog);
        boolean isSoapEnvelope = sourceNode == synCtx.getEnvelope();
        boolean isSoapBody = sourceNode == synCtx.getEnvelope().getBody();
        boolean isSoapHeader = sourceNode == synCtx.getEnvelope().getHeader();
        String generatedXsltKey = this.xsltKey.evaluateValue(synCtx);
        Templates cachedTemplates = null;
        if (synLog.isTraceTraceEnabled()) {
            synLog.traceTrace("Transformation source : " + sourceNode.toString());
        }
        if (this.isCreationOrRecreationRequired(synCtx)) {
            object = this.transformerLock;
            synchronized (object) {
                cachedTemplates = this.isCreationOrRecreationRequired(synCtx) ? this.createTemplate(synCtx, synLog, generatedXsltKey) : this.cachedTemplatesMap.get(generatedXsltKey);
            }
        }
        object = this.transformerLock;
        synchronized (object) {
            cachedTemplates = this.cachedTemplatesMap.get(generatedXsltKey);
        }
        try {
            ResultBuilderFactory.Output output;
            Transformer transformer = null;
            try {
                transformer = cachedTemplates.newTransformer();
            }
            catch (NullPointerException ex) {
                this.handleException("Unable to create Transformer using cached template", ex, synCtx);
            }
            if (!this.properties.isEmpty()) {
                this.applyProperties(transformer, synCtx, synLog);
            }
            transformer.setErrorListener(new ErrorListenerImpl(synLog, XSLT_TRANSFORMATION_ACTIVITY));
            String outputMethod = transformer.getOutputProperty("method");
            String encoding = transformer.getOutputProperty("encoding");
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("output method: " + outputMethod + "; encoding: " + encoding);
            }
            if ("text".equals(outputMethod)) {
                synLog.traceOrDebug("Processing non SOAP/XML (text) transformation result");
                output = ResultBuilderFactory.Output.TEXT;
            } else {
                output = isSoapEnvelope ? ResultBuilderFactory.Output.SOAP_ENVELOPE : ResultBuilderFactory.Output.ELEMENT;
            }
            SynapseEnvironment synEnv = synCtx.getEnvironment();
            ResultBuilder resultBuilder = this.resultBuilderFactory.createResultBuilder(synEnv, output);
            SourceBuilder sourceBuilder = this.sourceBuilderFactory.createSourceBuilder(synEnv);
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Using " + sourceBuilder.getClass().getName());
                synLog.traceOrDebug("Using " + resultBuilder.getClass().getName());
            }
            try {
                transformer.transform(sourceBuilder.getSource((OMElement)sourceNode), resultBuilder.getResult());
            }
            finally {
                sourceBuilder.release();
            }
            synLog.traceOrDebug("Transformation completed - processing result");
            if (this.targetPropertyName != null && resultBuilder instanceof StreamResultBuilder && synCtx.getProperty(TRANSFORM_XSLT_RESULT_DISABLE_BUILD) != null && synCtx.getProperty(TRANSFORM_XSLT_RESULT_DISABLE_BUILD) instanceof String && "true".equalsIgnoreCase((String)synCtx.getProperty(TRANSFORM_XSLT_RESULT_DISABLE_BUILD))) {
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("Adding result string as message context property : " + this.targetPropertyName);
                }
                synCtx.setProperty(this.targetPropertyName, ((StreamResultBuilder)resultBuilder).getResultAsString());
                return;
            }
            OMElement result = null;
            try {
                result = resultBuilder.getNode(encoding == null ? null : Charset.forName(encoding));
            }
            catch (Exception e) {
                throw new SynapseException("Unable to create an OMElement using XSLT result ", e);
            }
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Transformation result : " + result.toString());
            }
            if (this.targetPropertyName != null) {
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("Adding result as message context property : " + this.targetPropertyName);
                }
                synCtx.setProperty(this.targetPropertyName, result);
            } else {
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("Replace " + (isSoapEnvelope ? "SOAP envelope" : (isSoapBody ? "SOAP body" : "node")) + " with result");
                }
                if (isSoapEnvelope) {
                    try {
                        synCtx.setEnvelope((SOAPEnvelope)result);
                    }
                    catch (AxisFault ex) {
                        this.handleException("Unable to replace SOAP envelope with result", (Exception)((Object)ex), synCtx);
                    }
                } else if (isSoapBody) {
                    OMElement child;
                    Iterator itr = synCtx.getEnvelope().getBody().getChildElements();
                    while (itr.hasNext()) {
                        child = (OMElement)itr.next();
                        child.detach();
                    }
                    itr = result.getChildElements();
                    while (itr.hasNext()) {
                        child = (OMElement)itr.next();
                        synCtx.getEnvelope().getBody().addChild((OMNode)child);
                    }
                } else if (isSoapHeader) {
                    OMElement child;
                    Iterator itr = synCtx.getEnvelope().getHeader().getChildElements();
                    while (itr.hasNext()) {
                        child = (OMElement)itr.next();
                        child.detach();
                    }
                    itr = result.getChildElements();
                    while (itr.hasNext()) {
                        child = (OMElement)itr.next();
                        synCtx.getEnvelope().getHeader().addChild((OMNode)child);
                    }
                } else {
                    sourceNode.insertSiblingAfter((OMNode)result);
                    sourceNode.detach();
                }
            }
        }
        catch (TransformerException e) {
            this.handleException("Error performing XSLT transformation using : " + this.xsltKey, e, synCtx);
        }
    }

    private Templates createTemplate(MessageContext synCtx, SynapseLog synLog, String generatedXsltKey) {
        Templates cachedTemplates = null;
        this.transFact.setErrorListener(new ErrorListenerImpl(synLog, STYLESHEET_PARSING_ACTIVITY));
        this.transFact.setURIResolver(new CustomJAXPURIResolver(this.resourceMap, synCtx.getConfiguration(), synCtx));
        try {
            cachedTemplates = this.transFact.newTemplates(SynapseConfigUtils.getStreamSource(synCtx.getEntry(generatedXsltKey)));
            if (cachedTemplates == null) {
                this.handleException("Error compiling the XSLT with key : " + this.xsltKey, synCtx);
            } else if (this.useCache) {
                this.cachedTemplatesMap.put(generatedXsltKey, cachedTemplates);
            }
        }
        catch (Exception e) {
            this.handleException("Error creating XSLT transformer using : " + this.xsltKey, e, synCtx);
        }
        return cachedTemplates;
    }

    private boolean isCreationOrRecreationRequired(MessageContext synCtx) {
        if (!this.useCache) {
            return true;
        }
        String generatedXsltKey = this.xsltKey.evaluateValue(synCtx);
        if (this.cachedTemplatesMap.isEmpty() || !this.cachedTemplatesMap.containsKey(generatedXsltKey)) {
            return true;
        }
        Entry dp = synCtx.getConfiguration().getEntryDefinition(generatedXsltKey);
        return dp != null && dp.isDynamic() && (!dp.isCached() || dp.isExpired());
    }

    public SynapseXPath getSource() {
        return this.source.getXPath();
    }

    public void setSource(SynapseXPath source) {
        this.source.setXPath(source);
    }

    public Value getXsltKey() {
        return this.xsltKey;
    }

    public void setXsltKey(Value xsltKey) {
        this.xsltKey = xsltKey;
    }

    public void addProperty(MediatorProperty p) {
        this.properties.add(p);
    }

    private void applyProperties(Transformer transformer, MessageContext synCtx, SynapseLog synLog) {
        for (MediatorProperty prop : this.properties) {
            if (prop == null) continue;
            String value = prop.getValue() != null ? prop.getValue() : prop.getExpression().stringValueOf(synCtx);
            if (synLog.isTraceOrDebugEnabled()) {
                if (value == null) {
                    synLog.traceOrDebug("Not setting parameter '" + prop.getName() + "'");
                } else {
                    synLog.traceOrDebug("Setting parameter '" + prop.getName() + "' to '" + value + "'");
                }
            }
            if (value == null) continue;
            transformer.setParameter(prop.getName(), value);
        }
    }

    public void addFeature(String featureName, boolean isFeatureEnable) {
        MediatorProperty mp = new MediatorProperty();
        mp.setName(featureName);
        if (isFeatureEnable) {
            mp.setValue("true");
        } else {
            mp.setValue("false");
        }
        this.transformerFactoryFeatures.add(mp);
        if (USE_DOM_SOURCE_AND_RESULTS.equals(featureName)) {
            if (isFeatureEnable) {
                this.sourceBuilderFactory = new DOOMSourceBuilderFactory();
                this.resultBuilderFactory = new DOOMResultBuilderFactory();
            }
        } else {
            try {
                this.transFact.setFeature(featureName, isFeatureEnable);
            }
            catch (TransformerConfigurationException e) {
                String msg = "Error occurred when setting features to the TransformerFactory";
                this.log.error((Object)msg, (Throwable)e);
                throw new SynapseException(msg, e);
            }
        }
    }

    public void addAttribute(String name, String value) {
        MediatorProperty mp = new MediatorProperty();
        mp.setName(name);
        mp.setValue(value);
        this.transformerFactoryAttributes.add(mp);
        if (SOURCE_BUILDER_FACTORY.equals(name) || RESULT_BUILDER_FACTORY.equals(name)) {
            Object instance;
            try {
                instance = Class.forName(value).newInstance();
            }
            catch (ClassNotFoundException e) {
                String msg = "The class specified by the " + name + " attribute was not found";
                this.log.error((Object)msg, (Throwable)e);
                throw new SynapseException(msg, e);
            }
            catch (Exception e) {
                String msg = "The class " + value + " could not be instantiated";
                this.log.error((Object)msg, (Throwable)e);
                throw new SynapseException(msg, e);
            }
            if (SOURCE_BUILDER_FACTORY.equals(name)) {
                this.sourceBuilderFactory = (SourceBuilderFactory)instance;
            } else {
                this.resultBuilderFactory = (ResultBuilderFactory)instance;
            }
        } else {
            try {
                this.transFact.setAttribute(name, value);
            }
            catch (IllegalArgumentException e) {
                String msg = "Error occurred when setting attribute to the TransformerFactory";
                this.log.error((Object)msg, (Throwable)e);
                throw new SynapseException(msg, e);
            }
        }
    }

    public List<MediatorProperty> getFeatures() {
        return this.transformerFactoryFeatures;
    }

    public List<MediatorProperty> getAttributes() {
        return this.transformerFactoryAttributes;
    }

    public void addAllProperties(List<MediatorProperty> list) {
        this.properties.addAll(list);
    }

    public List<MediatorProperty> getProperties() {
        return this.properties;
    }

    public void setSourceXPathString(String sourceXPathString) {
        this.source.setXPathString(sourceXPathString);
    }

    public String getTargetPropertyName() {
        return this.targetPropertyName;
    }

    public void setTargetPropertyName(String targetPropertyName) {
        this.targetPropertyName = targetPropertyName;
    }

    public ResourceMap getResourceMap() {
        return this.resourceMap;
    }

    public void setResourceMap(ResourceMap resourceMap) {
        this.resourceMap = resourceMap;
    }

    @Override
    public boolean isContentAltering() {
        return true;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    private static class ErrorListenerImpl
    implements ErrorListener {
        private final SynapseLog synLog;
        private final String activity;
        private static final Log logger = LogFactory.getLog(XSLTMediator.class);

        public ErrorListenerImpl(SynapseLog synLog, String activity) {
            this.activity = activity;
            this.synLog = XSLTMediator.XSLT_TRANSFORMATION_ACTIVITY.equals(activity) ? synLog : null;
        }

        @Override
        public void warning(TransformerException e) throws TransformerException {
            if (XSLTMediator.XSLT_TRANSFORMATION_ACTIVITY.equals(this.activity) && this.synLog.isTraceOrDebugEnabled()) {
                this.synLog.traceOrDebugWarn("Warning encountered during " + this.activity + " : " + e);
            } else if (XSLTMediator.STYLESHEET_PARSING_ACTIVITY.equals(this.activity)) {
                logger.warn((Object)("Warning encountered during " + this.activity + " : " + e));
            }
        }

        @Override
        public void error(TransformerException e) throws TransformerException {
            if (XSLTMediator.XSLT_TRANSFORMATION_ACTIVITY.equals(this.activity)) {
                this.synLog.error("Error occurred in " + this.activity + " : " + e);
            } else {
                logger.error((Object)("Error occurred in " + this.activity + ". "), (Throwable)e);
            }
            throw e;
        }

        @Override
        public void fatalError(TransformerException e) throws TransformerException {
            if (XSLTMediator.XSLT_TRANSFORMATION_ACTIVITY.equals(this.activity)) {
                this.synLog.error("Fatal error occurred in " + this.activity + " : " + e);
            } else {
                logger.error((Object)("Fatal error occurred in " + this.activity + ". "), (Throwable)e);
            }
            throw e;
        }
    }
}

