/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.transform;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.commons.json.JsonUtil;
import org.apache.synapse.config.Entry;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.transform.pfutils.TemplateProcessor;
import org.apache.synapse.mediators.transform.pfutils.TemplateProcessorException;
import org.apache.synapse.util.AXIOMUtils;

public class PayloadFactoryMediator
extends AbstractMediator {
    private Value formatKey = null;
    private boolean isFormatDynamic = false;
    private String formatRaw;
    private String mediaType = "xml";
    private static final String XML_CONTENT_TYPE = "application/xml";
    private boolean escapeXmlChars = false;
    private long version = -1L;
    private final XMLInputFactory inputFactory = XMLInputFactory.newInstance();
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final String TEXT_CONTENT_TYPE = "text/plain";
    private static final String SOAP11_CONTENT_TYPE = "text/xml";
    private static final String SOAP12_CONTENT_TYPE = "application/soap+xml";
    private String templateType = "DEFAULT";
    private static final QName TEXT_ELEMENT = new QName("http://ws.apache.org/commons/ns/payload", "text");
    public static final String QUOTE_STRING_IN_PAYLOAD_FACTORY_JSON = "QUOTE_STRING_IN_PAYLOAD_FACTORY_JSON";
    private TemplateProcessor templateProcessor;
    private static final Log log = LogFactory.getLog(PayloadFactoryMediator.class);

    public PayloadFactoryMediator() {
        this.inputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        this.inputFactory.setProperty("javax.xml.stream.isCoalescing", true);
    }

    @Override
    public boolean mediate(MessageContext synCtx) {
        if (synCtx.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(synCtx)) {
            return true;
        }
        String format = this.formatRaw;
        return this.mediate(synCtx, format);
    }

    private boolean mediate(MessageContext synCtx, String format) {
        if (!this.isDoingXml(synCtx) && !this.isDoingJson(synCtx)) {
            log.error((Object)"#mediate. Could not identify the payload format of the existing payload prior to mediate.");
            return false;
        }
        org.apache.axis2.context.MessageContext axis2MessageContext = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        StringBuilder result = new StringBuilder();
        this.transform(result, synCtx, format);
        String out = result.toString().trim();
        if (log.isDebugEnabled()) {
            log.debug((Object)("#mediate. Transformed payload format>>> " + out));
        }
        if (this.mediaType.equals("xml")) {
            try {
                JsonUtil.removeJsonPayload((org.apache.axis2.context.MessageContext)axis2MessageContext);
                OMElement omXML = this.convertStringToOM(out);
                if (!this.checkAndReplaceEnvelope(omXML, synCtx)) {
                    axis2MessageContext.getEnvelope().getBody().addChild((OMNode)omXML.getFirstElement());
                }
            }
            catch (XMLStreamException e) {
                this.handleException("Error creating SOAP Envelope from source " + out, synCtx);
            }
        } else if (this.mediaType.equals("json")) {
            try {
                JsonUtil.getNewJsonPayload((org.apache.axis2.context.MessageContext)axis2MessageContext, (String)out, (boolean)true, (boolean)true);
            }
            catch (AxisFault axisFault) {
                this.handleException("Error creating JSON Payload from source " + out, synCtx);
            }
        } else if (this.mediaType.equals("text")) {
            JsonUtil.removeJsonPayload((org.apache.axis2.context.MessageContext)axis2MessageContext);
            axis2MessageContext.getEnvelope().getBody().addChild((OMNode)this.getTextElement(out));
        }
        this.setContentType(synCtx);
        return true;
    }

    private void transform(StringBuilder result, MessageContext synCtx, String format) {
        boolean reCreate = false;
        if (this.isFormatDynamic()) {
            String key;
            Object entry;
            Entry template;
            if (this.templateType.equals("FREEMARKER") && (!(template = synCtx.getConfiguration().getEntryDefinition(this.formatKey.getKeyValue())).isCached() || template.isExpired()) && this.version != template.getVersion()) {
                reCreate = true;
                this.version = template.getVersion();
            }
            if ((entry = synCtx.getEntry(key = this.formatKey.evaluateValue(synCtx))) == null) {
                this.handleException("Key " + key + " not found ", synCtx);
            }
            String text = "";
            if (entry instanceof OMElement) {
                OMElement omElement = ((OMElement)entry).cloneOMElement();
                this.removeIndentations(omElement);
                text = omElement.toString();
            } else if (entry instanceof OMText) {
                text = ((OMText)entry).getText();
            } else if (entry instanceof String) {
                text = (String)entry;
            }
            if (reCreate) {
                this.templateProcessor.setFormat(text);
                this.templateProcessor.init();
            }
            this.processTemplate(result, synCtx, text);
        } else {
            this.processTemplate(result, synCtx, format);
        }
    }

    private void processTemplate(StringBuilder result, MessageContext synCtx, String text) {
        try {
            result.append(this.templateProcessor.processTemplate(text, this.mediaType, synCtx));
        }
        catch (TemplateProcessorException e) {
            this.handleException(e.getMessage(), synCtx);
        }
    }

    private void setContentType(MessageContext synCtx) {
        org.apache.axis2.context.MessageContext a2mc = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        if (this.mediaType.equals("xml")) {
            if (!(XML_CONTENT_TYPE.equals(a2mc.getProperty("messageType")) || SOAP11_CONTENT_TYPE.equals(a2mc.getProperty("messageType")) || SOAP12_CONTENT_TYPE.equals(a2mc.getProperty("messageType")))) {
                a2mc.setProperty("messageType", (Object)XML_CONTENT_TYPE);
                a2mc.setProperty("ContentType", (Object)XML_CONTENT_TYPE);
                this.handleSpecialProperties(XML_CONTENT_TYPE, a2mc);
            }
        } else if (this.mediaType.equals("json")) {
            a2mc.setProperty("messageType", (Object)JSON_CONTENT_TYPE);
            a2mc.setProperty("ContentType", (Object)JSON_CONTENT_TYPE);
            this.handleSpecialProperties(JSON_CONTENT_TYPE, a2mc);
        } else if (this.mediaType.equals("text")) {
            a2mc.setProperty("messageType", (Object)TEXT_CONTENT_TYPE);
            a2mc.setProperty("ContentType", (Object)TEXT_CONTENT_TYPE);
            this.handleSpecialProperties(TEXT_CONTENT_TYPE, a2mc);
        }
        a2mc.removeProperty("NO_ENTITY_BODY");
    }

    private void handleSpecialProperties(Object resultValue, org.apache.axis2.context.MessageContext axis2MessageCtx) {
        axis2MessageCtx.setProperty("ContentType", resultValue);
        Object o = axis2MessageCtx.getProperty("TRANSPORT_HEADERS");
        Map headers = (Map)o;
        if (headers != null) {
            headers.remove("Content-Type");
            headers.put("Content-Type", resultValue);
        }
    }

    private boolean checkAndReplaceEnvelope(OMElement resultElement, MessageContext synCtx) {
        QName resultQName;
        OMElement firstChild = resultElement.getFirstElement();
        if (firstChild == null) {
            this.handleException("Generated content is not a valid XML payload", synCtx);
        }
        if ((resultQName = firstChild.getQName()).getLocalPart().equals("Envelope") && (resultQName.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/") || resultQName.getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope"))) {
            SOAPEnvelope soapEnvelope = AXIOMUtils.getSOAPEnvFromOM(resultElement.getFirstElement());
            if (soapEnvelope != null) {
                try {
                    soapEnvelope.buildWithAttachments();
                    synCtx.setEnvelope(soapEnvelope);
                }
                catch (AxisFault axisFault) {
                    this.handleException("Unable to attach SOAPEnvelope", (Exception)((Object)axisFault), synCtx);
                }
            }
        } else {
            return false;
        }
        return true;
    }

    private void removeIndentations(OMElement element) {
        ArrayList<OMText> removables = new ArrayList<OMText>();
        this.removeIndentations(element, removables);
        for (OMText node : removables) {
            node.detach();
        }
    }

    private void removeIndentations(OMElement element, List<OMText> removables) {
        Iterator children = element.getChildren();
        while (children.hasNext()) {
            Object next = children.next();
            if (next instanceof OMText) {
                OMText text = (OMText)next;
                if (!text.getText().trim().equals("")) continue;
                removables.add(text);
                continue;
            }
            if (!(next instanceof OMElement)) continue;
            this.removeIndentations((OMElement)next, removables);
        }
    }

    public String getFormat() {
        return this.formatRaw;
    }

    public void setFormat(String format) {
        this.formatRaw = format;
    }

    @Override
    public String getType() {
        return this.mediaType;
    }

    public void setType(String type) {
        this.mediaType = type;
    }

    public String getTemplateType() {
        return this.templateType;
    }

    public void setTemplateType(String templateType) {
        this.templateType = templateType;
    }

    public Value getFormatKey() {
        return this.formatKey;
    }

    public void setFormatKey(Value key) {
        this.formatKey = key;
    }

    public boolean isFormatDynamic() {
        return this.isFormatDynamic;
    }

    public void setFormatDynamic(boolean formatDynamic) {
        this.isFormatDynamic = formatDynamic;
    }

    @Override
    public String getOutputType() {
        return this.mediaType;
    }

    private OMElement getTextElement(String content) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement textElement = factory.createOMElement(TEXT_ELEMENT);
        if (content == null) {
            content = "";
        }
        textElement.setText(content);
        return textElement;
    }

    @Override
    public boolean isContentAltering() {
        return true;
    }

    public boolean isEscapeXmlChars() {
        return this.escapeXmlChars;
    }

    public void setEscapeXmlChars(boolean escapeXmlChars) {
        this.escapeXmlChars = escapeXmlChars;
    }

    private OMElement convertStringToOM(String value) throws XMLStreamException, OMException {
        XMLStreamReader xmlReader = this.inputFactory.createXMLStreamReader(new StringReader(value));
        StAXOMBuilder builder = new StAXOMBuilder(xmlReader);
        return builder.getDocumentElement();
    }

    public TemplateProcessor getTemplateProcessor() {
        return this.templateProcessor;
    }

    public void setTemplateProcessor(TemplateProcessor templateProcessor) {
        this.templateProcessor = templateProcessor;
    }

    private boolean isDoingJson(MessageContext messageContext) {
        return JsonUtil.hasAJsonPayload((org.apache.axis2.context.MessageContext)((Axis2MessageContext)messageContext).getAxis2MessageContext());
    }

    private boolean isDoingXml(MessageContext messageContext) {
        return !this.isDoingJson(messageContext);
    }
}

