/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.transform;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.ElementHelper;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.config.xml.SynapsePath;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;

public class HeaderMediator
extends AbstractMediator {
    public static final int ACTION_SET = 0;
    public static final int ACTION_REMOVE = 1;
    private static final String EMPTY_STRING = "";
    private QName qName = null;
    private String value = null;
    private int action = 0;
    private List<OMElement> embeddedXmlContent = new ArrayList<OMElement>();
    private SynapsePath expression = null;
    private String scope = null;

    @Override
    public boolean mediate(MessageContext synCtx) {
        String value;
        if (synCtx.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(synCtx)) {
            return true;
        }
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : Header mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        String string = value = this.getExpression() == null ? this.getValue() : this.expression.stringValueOf(synCtx);
        if (this.scope == null || "default".equals(this.scope)) {
            if (this.action == 0) {
                if (value == null) {
                    value = EMPTY_STRING;
                    this.log.warn((Object)("Setting SOAP header : " + this.qName + " to empty as evaluated value is null"));
                }
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("Set SOAP header : " + this.qName + " to : " + value);
                }
                if (!this.isImplicit() && (this.qName.getNamespaceURI() == null || EMPTY_STRING.equals(this.qName.getNamespaceURI()))) {
                    if ("To".equals(this.qName.getLocalPart())) {
                        synCtx.setTo(new EndpointReference(value));
                    } else if ("From".equals(this.qName.getLocalPart())) {
                        synCtx.setFrom(new EndpointReference(value));
                    } else if ("Action".equals(this.qName.getLocalPart())) {
                        synCtx.setWSAAction(value);
                    } else if ("FaultTo".equals(this.qName.getLocalPart())) {
                        synCtx.setFaultTo(new EndpointReference(value));
                    } else if ("ReplyTo".equals(this.qName.getLocalPart())) {
                        synCtx.setReplyTo(new EndpointReference(value));
                    } else if ("RelatesTo".equals(this.qName.getLocalPart())) {
                        synCtx.setRelatesTo(new RelatesTo[]{new RelatesTo(value)});
                    } else {
                        this.addCustomHeader(synCtx, value);
                    }
                } else {
                    this.addCustomHeader(synCtx, value);
                }
            } else {
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("Removing SOAP Header : " + this.qName);
                }
                if (this.qName.getNamespaceURI() == null || EMPTY_STRING.equals(this.qName.getNamespaceURI())) {
                    if ("To".equals(this.qName.getLocalPart())) {
                        synCtx.setTo(null);
                    } else if ("From".equals(this.qName.getLocalPart())) {
                        synCtx.setFrom(null);
                    } else if ("Action".equals(this.qName.getLocalPart())) {
                        synCtx.setWSAAction(null);
                    } else if ("FaultTo".equals(this.qName.getLocalPart())) {
                        synCtx.setFaultTo(null);
                    } else if ("ReplyTo".equals(this.qName.getLocalPart())) {
                        synCtx.setReplyTo(null);
                    } else if ("RelatesTo".equals(this.qName.getLocalPart())) {
                        synCtx.setRelatesTo(null);
                    } else {
                        SOAPHeader header;
                        SOAPEnvelope envelope = synCtx.getEnvelope();
                        if (envelope != null && (header = envelope.getHeader()) != null) {
                            this.removeFromHeaderList(header.getHeaderBlocksWithNSURI(EMPTY_STRING));
                        }
                    }
                } else {
                    SOAPHeader header;
                    SOAPEnvelope envelope = synCtx.getEnvelope();
                    if (envelope != null && (header = envelope.getHeader()) != null) {
                        this.removeFromHeaderList(header.getHeaderBlocksWithNSURI(this.qName.getNamespaceURI()));
                    }
                }
            }
        } else if ("transport".equals(this.scope)) {
            String headerName = this.qName.getLocalPart();
            if (this.action == 0) {
                TreeMap<String, String> headersMap;
                Axis2MessageContext axis2smc;
                org.apache.axis2.context.MessageContext axis2MessageCtx;
                Object headers;
                if (value == null) {
                    value = EMPTY_STRING;
                    this.log.warn((Object)("Setting HTTP header : " + headerName + " to empty as evaluated value is null"));
                }
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("Set HTTP header : " + headerName + " to : " + value);
                }
                if ((headers = (axis2MessageCtx = (axis2smc = (Axis2MessageContext)synCtx).getAxis2MessageContext()).getProperty("TRANSPORT_HEADERS")) != null && headers instanceof Map) {
                    headersMap = (TreeMap<String, String>)headers;
                    headersMap.put(headerName, value);
                }
                if (headers == null) {
                    headersMap = new TreeMap<String, String>(new Comparator<String>(){

                        @Override
                        public int compare(String o1, String o2) {
                            return o1.compareToIgnoreCase(o2);
                        }
                    });
                    headersMap.put(headerName, value);
                    axis2MessageCtx.setProperty("TRANSPORT_HEADERS", headersMap);
                }
            } else {
                Axis2MessageContext axis2smc;
                org.apache.axis2.context.MessageContext axis2MessageCtx;
                Object headers;
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("Removing HTTP Header : " + this.qName);
                }
                if ((headers = (axis2MessageCtx = (axis2smc = (Axis2MessageContext)synCtx).getAxis2MessageContext()).getProperty("TRANSPORT_HEADERS")) != null && headers instanceof Map) {
                    Map headersMap = (Map)headers;
                    headersMap.remove(headerName);
                } else {
                    synLog.traceOrDebug("No transport headers found for the message");
                }
            }
        }
        synLog.traceOrDebug("End : Header mediator");
        return true;
    }

    private void addCustomHeader(MessageContext synCtx, String value) {
        SOAPEnvelope env = synCtx.getEnvelope();
        if (env == null) {
            return;
        }
        SOAPFactory fac = (SOAPFactory)env.getOMFactory();
        SOAPHeader header = env.getHeader();
        if (header == null) {
            header = fac.createSOAPHeader(env);
        }
        if (!this.isImplicit()) {
            SOAPHeaderBlock hb = header.addHeaderBlock(this.qName.getLocalPart(), fac.createOMNamespace(this.qName.getNamespaceURI(), this.qName.getPrefix()));
            hb.setText(value);
        } else if (this.hasEmbeddedXml()) {
            this.addHeaderChildrenToMessageContext(synCtx, this.embeddedXmlContent);
        } else {
            this.handleException("Header mediator has an implicit xml element but its content cannot be found.", synCtx);
        }
    }

    private void addHeaderChildrenToMessageContext(MessageContext synCtx, List<OMElement> headerElements) {
        SOAPFactory factory = "http://schemas.xmlsoap.org/soap/envelope/".equals(synCtx.getEnvelope().getBody().getNamespace().getNamespaceURI()) ? OMAbstractFactory.getSOAP11Factory() : OMAbstractFactory.getSOAP12Factory();
        for (OMElement headerElement : headerElements) {
            try {
                synCtx.getEnvelope().getHeader().addChild((OMNode)ElementHelper.toSOAPHeaderBlock((OMElement)headerElement, (SOAPFactory)factory));
            }
            catch (Exception e) {
                this.log.error((Object)"Unable to convert to SoapHeader Block", (Throwable)e);
            }
        }
    }

    private void removeFromHeaderList(List headersList) {
        if (headersList == null || headersList.isEmpty()) {
            return;
        }
        for (Object o : headersList) {
            OMElement omElem;
            if (o instanceof SOAPHeaderBlock) {
                SOAPHeaderBlock header = (SOAPHeaderBlock)o;
                if (!header.getLocalName().equals(this.qName.getLocalPart())) continue;
                header.detach();
                continue;
            }
            if (!(o instanceof OMElement) || !(omElem = (OMElement)o).getLocalName().equals(this.qName.getLocalPart())) continue;
            omElem.detach();
        }
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int action) {
        this.action = action;
    }

    public QName getQName() {
        return this.qName;
    }

    public void setQName(QName qName) {
        this.qName = qName;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public SynapsePath getExpression() {
        return this.expression;
    }

    public List<OMElement> getEmbeddedXml() {
        return this.embeddedXmlContent;
    }

    public void addEmbeddedXml(OMElement element) {
        if (element != null && !this.embeddedXmlContent.contains(element)) {
            this.embeddedXmlContent.add(element);
        }
    }

    public boolean hasEmbeddedXml() {
        return !this.embeddedXmlContent.isEmpty();
    }

    public boolean isImplicit() {
        return this.getQName() == null;
    }

    public void setExpression(SynapsePath expression) {
        this.expression = expression;
    }

    @Override
    public boolean isContentAware() {
        if ("transport".equals(this.scope)) {
            return this.expression != null && this.expression.isContentAware();
        }
        return true;
    }

    @Override
    public String getMediatorName() {
        String headerName = this.qName != null ? this.qName.getLocalPart() : (this.hasEmbeddedXml() ? this.getEmbeddedXml().get(0).getLocalName() : EMPTY_STRING);
        return super.getMediatorName() + ":" + headerName;
    }
}

