/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.transaction;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.commons.transaction.TranscationManger;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;

public class TransactionMediator
extends AbstractMediator {
    public static final String ACTION_COMMIT = "commit";
    public static final String ACTION_ROLLBACK = "rollback";
    public static final String ACTION_NEW = "new";
    public static final String ACTION_USE_EXISTING_OR_NEW = "use-existing-or-new";
    public static final String ACTION_FAULT_IF_NO_TX = "fault-if-no-tx";
    private static final String USER_TX_LOOKUP_STR = "java:comp/UserTransaction";
    private static final String USER_TX_LOOKUP_STR1 = "java:comp/TransactionManager";
    private Context txContext;
    private String action = "";

    @Override
    public boolean mediate(MessageContext synCtx) {
        if (synCtx.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(synCtx)) {
            return true;
        }
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : Transaction mediator (" + this.action + ")");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        this.initContext(synCtx);
        try {
            TranscationManger.lookUp((Context)this.txContext);
        }
        catch (Exception e) {
            this.handleException("Cloud not get the context name java:comp/UserTransaction", e, synCtx);
        }
        if (this.action.equals(ACTION_COMMIT)) {
            try {
                long key = Thread.currentThread().getId();
                TranscationManger.endTransaction((boolean)true, (long)key);
            }
            catch (Exception e) {
                this.handleException("Unable to commit transaction", e, synCtx);
            }
        } else if (this.action.equals(ACTION_ROLLBACK)) {
            try {
                long key = Thread.currentThread().getId();
                TranscationManger.rollbackTransaction((boolean)true, (long)key);
            }
            catch (Exception e) {
                this.handleException("Unable to rollback transaction", e, synCtx);
            }
        } else if (this.action.equals(ACTION_NEW)) {
            int status = 5;
            try {
                status = TranscationManger.getStatus();
            }
            catch (Exception e) {
                this.handleException("Unable to query transaction status", e, synCtx);
            }
            if (status != 6 && status != 5) {
                throw new SynapseException("Require to begin a new transaction, but a transaction already exist");
            }
            this.beginNewTransaction(synCtx);
        } else if (this.action.equals(ACTION_USE_EXISTING_OR_NEW)) {
            int status = 5;
            try {
                status = TranscationManger.getStatus();
            }
            catch (Exception e) {
                this.handleException("Unable to query transaction status", e, synCtx);
            }
            if (status == 6) {
                this.beginNewTransaction(synCtx);
            }
        } else if (this.action.equals(ACTION_FAULT_IF_NO_TX)) {
            int status = 5;
            try {
                status = TranscationManger.getStatus();
            }
            catch (Exception e) {
                this.handleException("Unable to query transaction status", e, synCtx);
            }
            if (status != 0) {
                throw new SynapseException("No active transaction. Require an active transaction");
            }
        } else {
            this.handleException("Invalid transaction mediator action : " + this.action, synCtx);
        }
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("End : Transaction mediator");
        }
        return true;
    }

    private void beginNewTransaction(MessageContext synCtx) {
        try {
            TranscationManger.beginTransaction();
            org.apache.axis2.context.MessageContext axis2MsgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
            axis2MsgCtx.setProperty("distributedTx", (Object)TranscationManger.getTransaction());
            axis2MsgCtx.setProperty("distributedTxMgr", (Object)TranscationManger.getTransactionManager());
        }
        catch (Exception e) {
            this.handleException("Unable to begin a new transaction", e, synCtx);
        }
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    private void initContext(MessageContext synCtx) {
        try {
            this.txContext = new InitialContext();
        }
        catch (NamingException e) {
            this.handleException("Cloud not create initial context", e, synCtx);
        }
    }

    @Override
    public boolean isContentAware() {
        return false;
    }
}

