/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.template;

import java.util.Collection;
import java.util.Stack;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.mediators.AbstractListMediator;
import org.apache.synapse.mediators.MediatorFaultHandler;
import org.apache.synapse.mediators.template.TemplateContext;
import org.apache.synapse.mediators.template.TemplateParam;

public class TemplateMediator
extends AbstractListMediator {
    private Collection<TemplateParam> templateParams;
    private String eipPatternName;
    private String fileName;
    private boolean initialized = false;
    private boolean dynamic = false;
    private String artifactContainerName;
    private boolean isEdited;
    private boolean initializing = false;
    private String errorHandler = null;

    public void setParameters(Collection<TemplateParam> paramNames) {
        this.templateParams = paramNames;
    }

    public Collection<TemplateParam> getParameters() {
        return this.templateParams;
    }

    public void setName(String name) {
        this.eipPatternName = name;
    }

    public String getName() {
        return this.eipPatternName;
    }

    public String getArtifactContainerName() {
        return this.artifactContainerName;
    }

    public void setArtifactContainerName(String artifactContainerName) {
        this.artifactContainerName = artifactContainerName;
    }

    public boolean isEdited() {
        return this.isEdited;
    }

    public void setIsEdited(boolean isEdited) {
        this.isEdited = isEdited;
    }

    public String getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(String errorHandler) {
        this.errorHandler = errorHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mediate(MessageContext synCtx) {
        if (synCtx.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(synCtx)) {
            return true;
        }
        SynapseLog synLog = this.getLog(synCtx);
        Mediator errorHandlerMediator = null;
        if (this.errorHandler != null) {
            errorHandlerMediator = synCtx.getSequence(this.errorHandler);
            if (errorHandlerMediator != null) {
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("Setting the onError handler : " + this.errorHandler + " for sequence template : " + this.eipPatternName);
                }
                synCtx.pushFaultHandler(new MediatorFaultHandler(errorHandlerMediator));
            } else {
                synLog.auditWarn("onError handler : " + this.errorHandler + " for sequence template: " + this.eipPatternName + " cannot be found");
            }
        }
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : EIP Sequence templateParams : " + this.templateParams);
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        boolean result = false;
        try {
            this.pushFuncContextTo(synCtx);
            result = super.mediate(synCtx);
        }
        finally {
            FaultHandler faultHandler;
            Stack<FaultHandler> faultStack;
            if (result) {
                this.popFuncContextFrom(synCtx);
            }
            if (errorHandlerMediator != null && (faultStack = synCtx.getFaultStack()) != null && !faultStack.isEmpty() && (faultHandler = faultStack.peek()) instanceof MediatorFaultHandler && errorHandlerMediator.equals(((MediatorFaultHandler)faultHandler).getFaultMediator())) {
                faultStack.pop();
            }
        }
        return result;
    }

    private void pushFuncContextTo(MessageContext synCtx) {
        TemplateContext funcContext = new TemplateContext(this.eipPatternName, this.templateParams);
        funcContext.setupParams(synCtx);
        Object functionStackObj = synCtx.getProperty("_SYNAPSE_FUNCTION_STACK");
        Stack<TemplateContext> stack = null;
        if (functionStackObj instanceof Stack) {
            stack = (Stack<TemplateContext>)functionStackObj;
        }
        if (stack == null) {
            stack = new Stack<TemplateContext>();
            stack.push(funcContext);
            synCtx.setProperty("_SYNAPSE_FUNCTION_STACK", stack);
        } else {
            stack.push(funcContext);
        }
    }

    public void popFuncContextFrom(MessageContext synCtx) {
        Stack stack = (Stack)synCtx.getProperty("_SYNAPSE_FUNCTION_STACK");
        if (stack != null) {
            stack.pop();
        }
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public synchronized void init(SynapseEnvironment se) {
        if (!this.initialized) {
            this.initializing = true;
            super.init(se);
            this.initialized = true;
            this.initializing = false;
            if (!this.isDynamic()) {
                se.clearUnavailabilityOfArtifact(this.eipPatternName);
            }
        }
    }

    @Override
    public synchronized void destroy() {
        if (this.initialized) {
            super.destroy();
            this.initialized = false;
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isInitializing() {
        return this.initializing;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }
}

