/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.template;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMText;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.eip.EIPUtils;
import org.apache.synapse.mediators.template.TemplateParam;
import org.apache.synapse.transport.passthru.util.RelayUtils;
import org.apache.synapse.util.xpath.SynapseJsonPath;

public class TemplateContext {
    private String fName;
    private Collection<TemplateParam> parameters;
    private Map mappedValues;

    public TemplateContext(String name, Collection<TemplateParam> parameters) {
        this.fName = name;
        this.parameters = parameters;
        this.mappedValues = new HashMap();
    }

    public void setupParams(MessageContext synCtxt) {
        for (TemplateParam parameter : this.parameters) {
            String parameterName = parameter.getName();
            String mapping = EIPUtils.getTemplatePropertyMapping(this.fName, parameterName);
            Object propertyValue = synCtxt.getProperty(mapping);
            Object paramValue = null;
            if (propertyValue == null) {
                if (parameter.isMandatory()) {
                    String errorDetail = "Neither a value nor default value is provided for mandatory parameter: " + parameterName + " in seq-template " + this.fName;
                    synCtxt.setProperty("ERROR_CODE", 500101);
                    synCtxt.setProperty("ERROR_MESSAGE", errorDetail);
                    throw new SynapseException(errorDetail);
                }
                Object defaultValue = parameter.getDefaultValue();
                if (defaultValue != null) {
                    paramValue = defaultValue;
                }
            } else {
                try {
                    paramValue = this.getEvaluatedParamValue(synCtxt, parameterName, (Value)propertyValue);
                }
                catch (IOException | XMLStreamException e) {
                    throw new SynapseException("Error while evaluating parameters passed to template " + this.fName, e);
                }
            }
            if (paramValue != null) {
                this.mappedValues.put(parameterName, paramValue);
            }
            this.removeProperty(synCtxt, mapping);
        }
    }

    private Object getEvaluatedParamValue(MessageContext synCtx, String parameter, Value expression) throws IOException, XMLStreamException {
        if (expression != null) {
            if (expression.getExpression() != null) {
                if (expression.hasExprTypeKey()) {
                    if (expression.hasPropertyEvaluateExpr()) {
                        return expression.evalutePropertyExpression(synCtx);
                    }
                    return expression.getExpression();
                }
                org.apache.axis2.context.MessageContext axis2MessageContext = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
                if (expression.getExpression().contentAware && !Boolean.TRUE.equals(axis2MessageContext.getProperty("message.builder.invoked"))) {
                    RelayUtils.buildMessage((org.apache.axis2.context.MessageContext)((Axis2MessageContext)synCtx).getAxis2MessageContext());
                }
                if (expression.getExpression() instanceof SynapseJsonPath) {
                    return expression.evaluateValue(synCtx);
                }
                return this.resolveExpressionValue(synCtx, expression);
            }
            if (expression.getKeyValue() != null) {
                return expression.evaluateValue(synCtx);
            }
        }
        return null;
    }

    private Object resolveExpressionValue(MessageContext synCtx, Value expression) {
        Object result = expression.resolveObject(synCtx);
        if (result instanceof OMText) {
            return ((OMText)result).getText();
        }
        if (result instanceof OMAttribute) {
            return ((OMAttribute)result).getAttributeValue();
        }
        return result;
    }

    private void removeProperty(MessageContext synCtxt, String deletedMapping) {
        Set keys = synCtxt.getPropertyKeySet();
        if (keys != null) {
            keys.remove(deletedMapping);
        }
    }

    public Object getParameterValue(String paramName) {
        return this.mappedValues.get(paramName);
    }

    public Map getMappedValues() {
        return this.mappedValues;
    }

    public void setMappedValues(Map map) {
        this.mappedValues = map;
    }

    public String getName() {
        return this.fName;
    }

    public Collection getParameters() {
        return this.parameters;
    }
}

