/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.template;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.synapse.ContinuationState;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.flow.statistics.StatisticIdentityGenerator;
import org.apache.synapse.aspects.flow.statistics.collectors.RuntimeStatisticCollector;
import org.apache.synapse.aspects.flow.statistics.data.artifact.ArtifactHolder;
import org.apache.synapse.config.xml.SynapsePath;
import org.apache.synapse.continuation.ContinuationStackManager;
import org.apache.synapse.continuation.ReliantContinuationState;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.FlowContinuableMediator;
import org.apache.synapse.mediators.MediatorFaultHandler;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.eip.EIPUtils;
import org.apache.synapse.mediators.template.TemplateMediator;
import org.apache.synapse.transport.customlogsetter.CustomLogSetter;

public class InvokeMediator
extends AbstractMediator
implements ManagedLifecycle,
FlowContinuableMediator {
    private String targetTemplate;
    private String errorHandler = null;
    private String packageName;
    private Map<String, Value> pName2ExpressionMap = new LinkedHashMap<String, Value>();
    private boolean dynamicMediator = false;
    private Value key = null;
    private SynapseEnvironment synapseEnv;

    @Override
    public boolean mediate(MessageContext synCtx) {
        return this.mediate(synCtx, true);
    }

    private boolean mediate(MessageContext synCtx, boolean executePreFetchingSequence) {
        Mediator mediator;
        if (synCtx.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(synCtx)) {
            return true;
        }
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Invoking Target EIP Sequence " + this.targetTemplate + " paramNames : " + this.pName2ExpressionMap.keySet());
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        if ((mediator = synCtx.getSequenceTemplate(this.targetTemplate)) == null) {
            this.handleException("Sequence template " + this.targetTemplate + " cannot be found", synCtx);
        }
        if (mediator instanceof TemplateMediator) {
            CustomLogSetter.getInstance().setLogAppender(((TemplateMediator)mediator).getArtifactContainerName());
        }
        if (executePreFetchingSequence && this.key != null) {
            String defaultConfiguration = this.key.evaluateValue(synCtx);
            Mediator m = synCtx.getDefaultConfiguration(defaultConfiguration);
            if (m == null) {
                this.handleException("Sequence named " + this.key + " cannot be found", synCtx);
            } else {
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("Executing with key " + this.key);
                }
                ContinuationStackManager.addReliantContinuationState(synCtx, 1, this.getMediatorPosition());
                boolean result = m.mediate(synCtx);
                if (result) {
                    ContinuationStackManager.removeReliantContinuationState(synCtx);
                } else {
                    return false;
                }
            }
        }
        if (mediator != null && mediator instanceof TemplateMediator) {
            FaultHandler o;
            Stack<FaultHandler> faultStack;
            boolean result;
            this.populateParameters(synCtx, ((TemplateMediator)mediator).getName());
            if (executePreFetchingSequence) {
                ContinuationStackManager.addReliantContinuationState(synCtx, 0, this.getMediatorPosition());
            }
            Mediator errorHandlerMediator = null;
            if (this.errorHandler != null && (errorHandlerMediator = synCtx.getSequence(this.errorHandler)) != null) {
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("Setting the onError handler : " + this.errorHandler + " when invoking : " + this.targetTemplate);
                }
                synCtx.pushFaultHandler(new MediatorFaultHandler(errorHandlerMediator));
            }
            if ((result = mediator.mediate(synCtx)) && executePreFetchingSequence) {
                ContinuationStackManager.removeReliantContinuationState(synCtx);
            }
            if (errorHandlerMediator != null && (faultStack = synCtx.getFaultStack()) != null && !faultStack.isEmpty() && (o = faultStack.peek()) instanceof MediatorFaultHandler && errorHandlerMediator.equals(((MediatorFaultHandler)o).getFaultMediator())) {
                faultStack.pop();
            }
            return result;
        }
        return false;
    }

    @Override
    public boolean isContentAware() {
        for (String parameterName : this.pName2ExpressionMap.keySet()) {
            Value parameter;
            SynapsePath expression;
            if ("".equals(parameterName) || (expression = (parameter = this.pName2ExpressionMap.get(parameterName)).getExpression()) == null || !expression.isContentAware()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mediate(MessageContext synCtx, ContinuationState continuationState) {
        boolean result;
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Invoke mediator : Mediating from ContinuationState");
        }
        int subBranch = ((ReliantContinuationState)continuationState).getSubBranch();
        boolean isStatisticsEnabled = RuntimeStatisticCollector.isStatisticsEnabled();
        if (subBranch == 0) {
            TemplateMediator templateMediator = (TemplateMediator)synCtx.getSequenceTemplate(this.targetTemplate);
            if (!continuationState.hasChild()) {
                result = templateMediator.mediate(synCtx, continuationState.getPosition() + 1);
                if (result) {
                    templateMediator.popFuncContextFrom(synCtx);
                }
            } else {
                FlowContinuableMediator mediator = (FlowContinuableMediator)((Object)templateMediator.getChild(continuationState.getPosition()));
                result = mediator.mediate(synCtx, continuationState.getChildContState());
                if (isStatisticsEnabled) {
                    ((Mediator)((Object)mediator)).reportCloseStatistics(synCtx, null);
                }
            }
            if (isStatisticsEnabled) {
                templateMediator.reportCloseStatistics(synCtx, null);
            }
        } else {
            ContinuationState childContinuationState;
            String prefetchInvokeKey = this.key.evaluateValue(synCtx);
            InvokeMediator prefetchInvoke = (InvokeMediator)synCtx.getDefaultConfiguration(prefetchInvokeKey);
            result = prefetchInvoke.mediate(synCtx, childContinuationState = continuationState.getChildContState());
            if (result && !childContinuationState.hasChild()) {
                continuationState.removeLeafChild();
                ((ReliantContinuationState)continuationState).setSubBranch(0);
                result = this.mediate(synCtx, false);
            }
            if (isStatisticsEnabled) {
                prefetchInvoke.reportCloseStatistics(synCtx, null);
            }
        }
        return result;
    }

    private void populateParameters(MessageContext synCtx, String templateQualifiedName) {
        for (String parameter : this.pName2ExpressionMap.keySet()) {
            Value expression;
            if ("".equals(parameter) || (expression = this.pName2ExpressionMap.get(parameter)) == null) continue;
            EIPUtils.createSynapseEIPTemplateProperty(synCtx, templateQualifiedName, parameter, expression);
        }
    }

    public String getTargetTemplate() {
        return this.targetTemplate;
    }

    public void setTargetTemplate(String targetTemplate) {
        this.targetTemplate = targetTemplate;
    }

    public void setErrorHandler(String errorHandler) {
        this.errorHandler = errorHandler;
    }

    public String getErrorHandler() {
        return this.errorHandler;
    }

    public Map<String, Value> getpName2ExpressionMap() {
        return this.pName2ExpressionMap;
    }

    public void addExpressionForParamName(String pName, Value expr) {
        this.pName2ExpressionMap.put(pName, expr);
    }

    public boolean isDynamicMediator() {
        return this.dynamicMediator;
    }

    public void setDynamicMediator(boolean dynamicMediator) {
        this.dynamicMediator = dynamicMediator;
    }

    public Value getKey() {
        return this.key;
    }

    public void setKey(Value key) {
        this.key = key;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public void init(SynapseEnvironment se) {
        this.synapseEnv = se;
        TemplateMediator templateMediator = se.getSynapseConfiguration().getSequenceTemplate(this.targetTemplate);
        if (templateMediator != null && !templateMediator.isInitializing()) {
            templateMediator.init(se);
        }
        if (templateMediator == null || templateMediator.isDynamic()) {
            se.addUnavailableArtifactRef(this.targetTemplate);
        }
    }

    @Override
    public void destroy() {
        TemplateMediator templateMediator = this.synapseEnv.getSynapseConfiguration().getSequenceTemplate(this.targetTemplate);
        if (templateMediator != null) {
            templateMediator.destroy();
        }
        if (templateMediator == null || templateMediator.isDynamic()) {
            this.synapseEnv.removeUnavailableArtifactRef(this.targetTemplate);
        }
    }

    @Override
    public void setComponentStatisticsId(ArtifactHolder holder) {
        if (this.getAspectConfiguration() == null) {
            this.configure(new AspectConfiguration(this.getMediatorName()));
        }
        String mediatorId = StatisticIdentityGenerator.getIdForFlowContinuableMediator(this.getMediatorName(), ComponentType.MEDIATOR, holder);
        this.getAspectConfiguration().setUniqueId(mediatorId);
        StatisticIdentityGenerator.reportingFlowContinuableEndEvent(mediatorId, ComponentType.MEDIATOR, holder);
    }
}

