/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.store;

import org.apache.axis2.AxisFault;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.config.xml.SynapsePath;
import org.apache.synapse.continuation.ContinuationStackManager;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.message.store.MessageStore;
import org.apache.synapse.message.store.impl.jms.JmsStore;
import org.apache.synapse.util.MessageHelper;

public class MessageStoreMediator
extends AbstractMediator {
    private String name;
    private String messageStoreName;
    private SynapsePath messageStoreExp;
    private String onStoreSequence;
    private boolean isGuaranteedDeliveryEnabled = false;
    private String failoverMessageStoreName = null;
    private static final String PRODUCER_GUARANTEED_DELIVERY = "store.producer.guaranteed.delivery.enable";
    private static final String FAILOVER_MESSAGE_STORE_NAME = "store.failover.message.store.name";
    private final Object storeMessageLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mediate(MessageContext synCtx) {
        if (synCtx.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(synCtx)) {
            return true;
        }
        if (synCtx != null) {
            MessageStore messageStore = this.messageStoreExp != null ? synCtx.getConfiguration().getMessageStore(this.messageStoreExp.stringValueOf(synCtx)) : synCtx.getConfiguration().getMessageStore(this.messageStoreName);
            if (messageStore != null) {
                Axis2MessageContext msgCtx;
                boolean produceStatus;
                Mediator sequence;
                if (messageStore.getParameters().get(PRODUCER_GUARANTEED_DELIVERY) != null) {
                    this.isGuaranteedDeliveryEnabled = Boolean.parseBoolean(messageStore.getParameters().get(PRODUCER_GUARANTEED_DELIVERY).toString());
                }
                if (messageStore.getParameters().get(FAILOVER_MESSAGE_STORE_NAME) != null) {
                    this.failoverMessageStoreName = (String)messageStore.getParameters().get(FAILOVER_MESSAGE_STORE_NAME);
                }
                if (this.onStoreSequence != null && (sequence = synCtx.getSequence(this.onStoreSequence)) != null) {
                    sequence.mediate(synCtx);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Message Store mediator storing the message : \n " + synCtx.getEnvelope()));
                }
                synCtx.getEnvelope().buildWithAttachments();
                MessageContext newCtx = null;
                try {
                    newCtx = MessageHelper.cloneMessageContext(synCtx);
                    ContinuationStackManager.clearStack(newCtx);
                }
                catch (AxisFault af) {
                    this.handleException("Error when cloning the message context", (Exception)((Object)af), synCtx);
                }
                Object af = this.storeMessageLock;
                synchronized (af) {
                    produceStatus = messageStore.getProducer().storeMessage(newCtx);
                }
                if (!produceStatus) {
                    if (messageStore instanceof JmsStore) {
                        ((JmsStore)messageStore).setProducer(null);
                    }
                    if (this.isGuaranteedDeliveryEnabled && this.failoverMessageStoreName != null && !this.failoverMessageStoreName.isEmpty()) {
                        MessageStore failoverMessageStore = synCtx.getConfiguration().getMessageStore(this.failoverMessageStoreName);
                        boolean failoverProduceStatus = failoverMessageStore.getProducer().storeMessage(newCtx);
                        if (!failoverProduceStatus) {
                            synCtx.setProperty("HTTP_SC", 500);
                            synCtx.setProperty("ERROR_DETAIL", "Failed to store message.");
                            synCtx.setProperty("ERROR_MESSAGE", "Failed to store message [" + synCtx.getMessageID() + "] in store [" + messageStore.getName() + "].");
                            this.handleException("Failed to store message [" + synCtx.getMessageID() + "] in failover store [" + this.failoverMessageStoreName + "].", synCtx);
                        }
                        if (this.shouldTrace(synCtx)) {
                            trace.error((Object)("Message [" + synCtx.getMessageID() + "] store in the failover message store [" + this.failoverMessageStoreName + "]"));
                        }
                    } else {
                        synCtx.setProperty("HTTP_SC", 500);
                        synCtx.setProperty("ERROR_DETAIL", "Failed to store message.");
                        synCtx.setProperty("ERROR_MESSAGE", "Failed to store message [" + synCtx.getMessageID() + "] in store [" + messageStore.getName() + "].");
                        this.handleException("Failed to store message [" + synCtx.getMessageID() + "] in store [" + messageStore.getName() + "].", synCtx);
                    }
                }
                if (null != (msgCtx = (Axis2MessageContext)synCtx).getAxis2MessageContext() && null != msgCtx.getAxis2MessageContext().getOperationContext()) {
                    msgCtx.getAxis2MessageContext().getOperationContext().setProperty("RESPONSE_WRITTEN", (Object)"SKIP");
                }
                return true;
            }
            this.handleException("Message Store does not exist.", synCtx);
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMessageStoreName() {
        return this.messageStoreName;
    }

    public void setMessageStoreName(String messageStoreName) {
        this.messageStoreName = messageStoreName;
    }

    public String getOnStoreSequence() {
        return this.onStoreSequence;
    }

    public void setOnStoreSequence(String onStoreSequence) {
        this.onStoreSequence = onStoreSequence;
    }

    public void setMessageStoreExp(SynapsePath messageStoreExp) {
        this.messageStoreExp = messageStoreExp;
    }

    public SynapsePath getMessageStoreExp() {
        return this.messageStoreExp;
    }
}

