/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.filters;

import java.util.ArrayList;
import java.util.List;
import org.apache.synapse.ContinuationState;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.flow.statistics.StatisticIdentityGenerator;
import org.apache.synapse.aspects.flow.statistics.collectors.RuntimeStatisticCollector;
import org.apache.synapse.aspects.flow.statistics.data.artifact.ArtifactHolder;
import org.apache.synapse.config.xml.SwitchCase;
import org.apache.synapse.config.xml.SynapsePath;
import org.apache.synapse.continuation.ContinuationStackManager;
import org.apache.synapse.continuation.ReliantContinuationState;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.FlowContinuableMediator;

public class SwitchMediator
extends AbstractMediator
implements ManagedLifecycle,
FlowContinuableMediator {
    private SynapsePath source = null;
    private final List<SwitchCase> cases = new ArrayList<SwitchCase>();
    private SwitchCase defaultCase = null;

    @Override
    public void init(SynapseEnvironment se) {
        for (ManagedLifecycle managedLifecycle : this.cases) {
            managedLifecycle.init(se);
        }
        if (this.defaultCase != null) {
            this.defaultCase.init(se);
        }
    }

    @Override
    public void destroy() {
        for (ManagedLifecycle managedLifecycle : this.cases) {
            managedLifecycle.destroy();
        }
        if (this.defaultCase != null) {
            this.defaultCase.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mediate(MessageContext synCtx) {
        if (synCtx.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(synCtx)) {
            return true;
        }
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : Switch mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        int parentsEffectiveTraceState = synCtx.getTracingState();
        this.setEffectiveTraceState(synCtx);
        String sourceText = this.source.stringValueOf(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("XPath : " + (Object)((Object)this.source) + " evaluates to : " + sourceText);
        }
        try {
            if ((sourceText == null || this.cases.isEmpty()) && this.defaultCase != null) {
                synLog.traceOrDebug("Source XPath evaluated to : null or no switch cases found. Executing the default case");
                ContinuationStackManager.addReliantContinuationState(synCtx, 0, this.getMediatorPosition());
                boolean result = this.defaultCase.mediate(synCtx);
                if (result) {
                    ContinuationStackManager.removeReliantContinuationState(synCtx);
                }
                boolean bl = result;
                return bl;
            }
            for (int i = 0; i < this.cases.size(); ++i) {
                SwitchCase swCase = this.cases.get(i);
                if (swCase == null || !swCase.matches(sourceText)) continue;
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("Matching case found : " + swCase.getRegex());
                }
                ContinuationStackManager.addReliantContinuationState(synCtx, i + 1, this.getMediatorPosition());
                boolean result = swCase.mediate(synCtx);
                if (result) {
                    ContinuationStackManager.removeReliantContinuationState(synCtx);
                }
                boolean bl = result;
                return bl;
            }
            if (this.defaultCase != null) {
                synLog.traceOrDebug("None of the switch cases matched - executing default");
                ContinuationStackManager.addReliantContinuationState(synCtx, 0, this.getMediatorPosition());
                boolean result = this.defaultCase.mediate(synCtx);
                if (result) {
                    ContinuationStackManager.removeReliantContinuationState(synCtx);
                }
                boolean bl = result;
                return bl;
            }
            synLog.traceOrDebug("None of the switch cases matched - no default case");
        }
        finally {
            synCtx.setTracingState(parentsEffectiveTraceState);
        }
        synLog.traceOrDebug("End : Switch mediator");
        return true;
    }

    @Override
    public boolean mediate(MessageContext synCtx, ContinuationState continuationState) {
        boolean result;
        int subBranch;
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Switch mediator : Mediating from ContinuationState");
        }
        if ((subBranch = ((ReliantContinuationState)continuationState).getSubBranch()) == 0) {
            if (!continuationState.hasChild()) {
                result = this.defaultCase.getCaseMediator().mediate(synCtx, continuationState.getPosition() + 1);
            } else {
                FlowContinuableMediator mediator = (FlowContinuableMediator)((Object)this.defaultCase.getCaseMediator().getChild(continuationState.getPosition()));
                result = mediator.mediate(synCtx, continuationState.getChildContState());
                if (RuntimeStatisticCollector.isStatisticsEnabled()) {
                    ((Mediator)((Object)mediator)).reportCloseStatistics(synCtx, null);
                }
            }
        } else if (!continuationState.hasChild()) {
            result = this.cases.get(subBranch - 1).getCaseMediator().mediate(synCtx, continuationState.getPosition() + 1);
        } else {
            FlowContinuableMediator mediator = (FlowContinuableMediator)((Object)this.cases.get(subBranch - 1).getCaseMediator().getChild(continuationState.getPosition()));
            result = mediator.mediate(synCtx, continuationState.getChildContState());
            if (RuntimeStatisticCollector.isStatisticsEnabled()) {
                ((Mediator)((Object)mediator)).reportCloseStatistics(synCtx, null);
            }
        }
        return result;
    }

    public void addCase(SwitchCase m) {
        this.cases.add(m);
    }

    public List<SwitchCase> getCases() {
        return this.cases;
    }

    public SynapsePath getSource() {
        return this.source;
    }

    public void setSource(SynapsePath source) {
        this.source = source;
    }

    public SwitchCase getDefaultCase() {
        return this.defaultCase;
    }

    public void setDefaultCase(SwitchCase defaultCase) {
        this.defaultCase = defaultCase;
    }

    @Override
    public boolean isContentAware() {
        if (this.source != null) {
            return this.source.isContentAware();
        }
        return false;
    }

    @Override
    public void setComponentStatisticsId(ArtifactHolder holder) {
        if (this.getAspectConfiguration() == null) {
            this.configure(new AspectConfiguration(this.getMediatorName()));
        }
        String mediatorId = StatisticIdentityGenerator.getIdForFlowContinuableMediator(this.getMediatorName(), ComponentType.MEDIATOR, holder);
        this.getAspectConfiguration().setUniqueId(mediatorId);
        for (SwitchCase switchCase : this.cases) {
            switchCase.setStatisticIdForMediators(holder);
        }
        StatisticIdentityGenerator.reportingFlowContinuableEndEvent(mediatorId, ComponentType.MEDIATOR, holder);
    }
}

