/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.filters;

import org.apache.synapse.ContinuationState;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.flow.statistics.StatisticIdentityGenerator;
import org.apache.synapse.aspects.flow.statistics.collectors.OpenEventCollector;
import org.apache.synapse.aspects.flow.statistics.collectors.RuntimeStatisticCollector;
import org.apache.synapse.aspects.flow.statistics.data.artifact.ArtifactHolder;
import org.apache.synapse.continuation.ContinuationStackManager;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.mediators.AbstractListMediator;
import org.apache.synapse.mediators.FilterMediator;
import org.apache.synapse.mediators.FlowContinuableMediator;

public class InMediator
extends AbstractListMediator
implements FilterMediator,
FlowContinuableMediator {
    @Override
    public boolean mediate(MessageContext synCtx) {
        if (synCtx.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(synCtx)) {
            return true;
        }
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : In mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        boolean result = true;
        if (this.test(synCtx)) {
            synLog.traceOrDebug("Current message is incoming - executing child mediators");
            ContinuationStackManager.addReliantContinuationState(synCtx, 0, this.getMediatorPosition());
            result = super.mediate(synCtx);
            if (result) {
                ContinuationStackManager.removeReliantContinuationState(synCtx);
            }
        } else {
            synLog.traceOrDebug("Current message is a response - skipping child mediators");
        }
        synLog.traceOrDebug("End : In mediator");
        return result;
    }

    @Override
    public boolean mediate(MessageContext synCtx, ContinuationState continuationState) {
        boolean result;
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("In mediator : Mediating from ContinuationState");
        }
        if (!continuationState.hasChild()) {
            result = super.mediate(synCtx, continuationState.getPosition() + 1);
        } else {
            FlowContinuableMediator mediator = (FlowContinuableMediator)((Object)this.getChild(continuationState.getPosition()));
            result = mediator.mediate(synCtx, continuationState.getChildContState());
            if (RuntimeStatisticCollector.isStatisticsEnabled()) {
                ((Mediator)((Object)mediator)).reportCloseStatistics(synCtx, null);
            }
        }
        return result;
    }

    @Override
    public boolean test(MessageContext synCtx) {
        return !synCtx.isResponse();
    }

    @Override
    public boolean isContentAware() {
        return false;
    }

    @Override
    public void init(SynapseEnvironment se) {
        super.init(se);
    }

    @Override
    public Integer reportOpenStatistics(MessageContext messageContext, boolean isContentAltering) {
        if (!messageContext.isResponse()) {
            return OpenEventCollector.reportFlowContinuableEvent(messageContext, this.getMediatorName(), ComponentType.MEDIATOR, this.getAspectConfiguration(), this.isContentAltering() || isContentAltering);
        }
        return null;
    }

    @Override
    public void setComponentStatisticsId(ArtifactHolder holder) {
        if (this.getAspectConfiguration() == null) {
            this.configure(new AspectConfiguration(this.getMediatorName()));
        }
        String mediatorId = StatisticIdentityGenerator.getIdForFlowContinuableMediator(this.getMediatorName(), ComponentType.MEDIATOR, holder);
        this.getAspectConfiguration().setUniqueId(mediatorId);
        this.setStatisticIdForMediators(holder);
        StatisticIdentityGenerator.reportingFlowContinuableEndEvent(mediatorId, ComponentType.MEDIATOR, holder);
    }
}

