/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.filters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.synapse.ContinuationState;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.flow.statistics.StatisticIdentityGenerator;
import org.apache.synapse.aspects.flow.statistics.collectors.RuntimeStatisticCollector;
import org.apache.synapse.aspects.flow.statistics.data.artifact.ArtifactHolder;
import org.apache.synapse.config.xml.AnonymousListMediator;
import org.apache.synapse.config.xml.SynapsePath;
import org.apache.synapse.continuation.ContinuationStackManager;
import org.apache.synapse.continuation.ReliantContinuationState;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.mediators.AbstractListMediator;
import org.apache.synapse.mediators.FlowContinuableMediator;
import org.apache.synapse.mediators.ListMediator;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.util.xpath.SynapseJsonPath;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class FilterMediator
extends AbstractListMediator
implements org.apache.synapse.mediators.FilterMediator,
FlowContinuableMediator {
    private SynapsePath source = null;
    private Pattern regex = null;
    private SynapsePath xpath = null;
    private AnonymousListMediator elseMediator = null;
    private boolean thenElementPresent = false;
    private String thenKey = null;
    private String elseKey = null;
    private SynapseEnvironment synapseEnv;

    @Override
    public void init(SynapseEnvironment se) {
        SequenceMediator thenSequence;
        SequenceMediator elseSequence;
        super.init(se);
        this.synapseEnv = se;
        if (this.elseMediator != null) {
            this.elseMediator.init(se);
        } else if (this.elseKey != null && ((elseSequence = (SequenceMediator)se.getSynapseConfiguration().getSequence(this.elseKey)) == null || elseSequence.isDynamic())) {
            se.addUnavailableArtifactRef(this.elseKey);
        }
        if (this.thenKey != null && ((thenSequence = (SequenceMediator)se.getSynapseConfiguration().getSequence(this.thenKey)) == null || thenSequence.isDynamic())) {
            se.addUnavailableArtifactRef(this.thenKey);
        }
    }

    @Override
    public void destroy() {
        SequenceMediator thenSequence;
        SequenceMediator elseSequence;
        super.destroy();
        if (this.elseMediator != null) {
            this.elseMediator.destroy();
        } else if (this.elseKey != null && ((elseSequence = (SequenceMediator)this.synapseEnv.getSynapseConfiguration().getSequence(this.elseKey)) == null || elseSequence.isDynamic())) {
            this.synapseEnv.removeUnavailableArtifactRef(this.elseKey);
        }
        if (this.thenKey != null && ((thenSequence = (SequenceMediator)this.synapseEnv.getSynapseConfiguration().getSequence(this.thenKey)) == null || thenSequence.isDynamic())) {
            this.synapseEnv.removeUnavailableArtifactRef(this.thenKey);
        }
    }

    @Override
    public boolean mediate(MessageContext synCtx) {
        if (synCtx.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(synCtx)) {
            return true;
        }
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : Filter mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        boolean result = false;
        if (this.test(synCtx)) {
            if (this.thenKey != null) {
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug((this.xpath == null ? "Source : " + (Object)((Object)this.source) + " against : " + this.regex.pattern() + " matches" : "XPath expression : " + (Object)((Object)this.xpath) + " evaluates to true") + " - executing then sequence with key : " + this.thenKey);
                }
                ContinuationStackManager.updateSeqContinuationState(synCtx, this.getMediatorPosition());
                Mediator seq = synCtx.getSequence(this.thenKey);
                if (seq != null) {
                    result = seq.mediate(synCtx);
                } else {
                    this.handleException("Couldn't find the referred then sequence with key : " + this.thenKey, synCtx);
                }
            } else {
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug((this.xpath == null ? "Source : " + (Object)((Object)this.source) + " against : " + this.regex.pattern() + " matches" : "XPath expression : " + (Object)((Object)this.xpath) + " evaluates to true") + " - executing child mediators");
                }
                ContinuationStackManager.addReliantContinuationState(synCtx, 0, this.getMediatorPosition());
                result = super.mediate(synCtx);
                if (result) {
                    ContinuationStackManager.removeReliantContinuationState(synCtx);
                }
            }
        } else if (this.elseKey != null) {
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug((this.xpath == null ? "Source : " + (Object)((Object)this.source) + " against : " + this.regex.pattern() + " does not match" : "XPath expression : " + (Object)((Object)this.xpath) + " evaluates to false") + " - executing the else sequence with key : " + this.elseKey);
            }
            ContinuationStackManager.updateSeqContinuationState(synCtx, this.getMediatorPosition());
            Mediator elseSeq = synCtx.getSequence(this.elseKey);
            if (elseSeq != null) {
                result = elseSeq.mediate(synCtx);
            } else {
                this.handleException("Couldn't find the referred else sequence with key : " + this.elseKey, synCtx);
            }
        } else if (this.elseMediator != null) {
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug((this.xpath == null ? "Source : " + (Object)((Object)this.source) + " against : " + this.regex.pattern() + " does not match" : "XPath expression : " + (Object)((Object)this.xpath) + " evaluates to false") + " - executing the else path child mediators");
            }
            ContinuationStackManager.addReliantContinuationState(synCtx, 1, this.getMediatorPosition());
            result = this.elseMediator.mediate(synCtx);
            if (result) {
                ContinuationStackManager.removeReliantContinuationState(synCtx);
            }
        } else {
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug((this.xpath == null ? "Source : " + (Object)((Object)this.source) + " against : " + this.regex.pattern() + " does not match" : "XPath expression : " + (Object)((Object)this.xpath) + " evaluates to false and no else path") + " - skipping child mediators");
            }
            result = true;
        }
        synLog.traceOrDebug("End : Filter mediator ");
        return result;
    }

    @Override
    public boolean mediate(MessageContext synCtx, ContinuationState continuationState) {
        boolean result;
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Filter mediator : Mediating from ContinuationState");
        }
        int subBranch = ((ReliantContinuationState)continuationState).getSubBranch();
        boolean isStatisticsEnabled = RuntimeStatisticCollector.isStatisticsEnabled();
        if (subBranch == 0) {
            if (!continuationState.hasChild()) {
                result = super.mediate(synCtx, continuationState.getPosition() + 1);
            } else {
                FlowContinuableMediator mediator = (FlowContinuableMediator)((Object)this.getChild(continuationState.getPosition()));
                result = mediator.mediate(synCtx, continuationState.getChildContState());
                if (isStatisticsEnabled) {
                    ((Mediator)((Object)mediator)).reportCloseStatistics(synCtx, null);
                }
            }
        } else {
            if (!continuationState.hasChild()) {
                result = this.elseMediator.mediate(synCtx, continuationState.getPosition() + 1);
            } else {
                FlowContinuableMediator mediator = (FlowContinuableMediator)((Object)this.elseMediator.getChild(continuationState.getPosition()));
                result = mediator.mediate(synCtx, continuationState.getChildContState());
                if (isStatisticsEnabled) {
                    ((Mediator)((Object)mediator)).reportCloseStatistics(synCtx, null);
                }
            }
            if (isStatisticsEnabled) {
                this.elseMediator.reportCloseStatistics(synCtx, null);
            }
        }
        return result;
    }

    @Override
    public boolean test(MessageContext synCtx) {
        SynapseLog synLog = this.getLog(synCtx);
        if (this.xpath != null) {
            try {
                if (this.xpath instanceof SynapseXPath) {
                    return this.xpath.booleanValueOf(synCtx);
                }
                if (this.xpath instanceof SynapseJsonPath) {
                    return ((SynapseJsonPath)this.xpath).booleanValueOf(synCtx);
                }
            }
            catch (JaxenException e) {
                this.handleException("Error evaluating XPath expression : " + (Object)((Object)this.xpath), (Exception)((Object)e), synCtx);
            }
        } else if (this.source != null && this.regex != null) {
            String sourceString = this.source.stringValueOf(synCtx);
            if (sourceString == null) {
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("Source String : " + (Object)((Object)this.source) + " evaluates to null");
                }
                return false;
            }
            Matcher matcher = this.regex.matcher(sourceString);
            if (matcher == null) {
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("Regex pattern matcher for : " + this.regex.pattern() + "against source : " + sourceString + " is null");
                }
                return false;
            }
            return matcher.matches();
        }
        return false;
    }

    public SynapsePath getSource() {
        return this.source;
    }

    public void setSource(SynapsePath source) {
        this.source = source;
    }

    public Pattern getRegex() {
        return this.regex;
    }

    public void setRegex(Pattern regex) {
        this.regex = regex;
    }

    public SynapsePath getXpath() {
        return this.xpath;
    }

    public void setXpath(SynapsePath xpath) {
        this.xpath = xpath;
    }

    public ListMediator getElseMediator() {
        return this.elseMediator;
    }

    public void setElseMediator(AnonymousListMediator elseMediator) {
        this.elseMediator = elseMediator;
    }

    public boolean isThenElementPresent() {
        return this.thenElementPresent;
    }

    public void setThenElementPresent(boolean thenElementPresent) {
        this.thenElementPresent = thenElementPresent;
    }

    public String getThenKey() {
        return this.thenKey;
    }

    public void setThenKey(String thenKey) {
        this.thenKey = thenKey;
    }

    public String getElseKey() {
        return this.elseKey;
    }

    public void setElseKey(String elseKey) {
        this.elseKey = elseKey;
    }

    @Override
    public boolean isContentAware() {
        if (this.xpath != null) {
            return this.xpath.isContentAware();
        }
        if (this.source != null) {
            return this.source.isContentAware();
        }
        return false;
    }

    @Override
    public void setComponentStatisticsId(ArtifactHolder holder) {
        String childId;
        if (this.getAspectConfiguration() == null) {
            this.configure(new AspectConfiguration(this.getMediatorName()));
        }
        String mediatorId = StatisticIdentityGenerator.getIdForFlowContinuableMediator(this.getMediatorName(), ComponentType.MEDIATOR, holder);
        this.getAspectConfiguration().setUniqueId(mediatorId);
        StatisticIdentityGenerator.reportingBranchingEvents(holder);
        if (this.thenKey != null) {
            childId = StatisticIdentityGenerator.getIdReferencingComponent(this.thenKey, ComponentType.SEQUENCE, holder);
            StatisticIdentityGenerator.reportingEndEvent(childId, ComponentType.SEQUENCE, holder);
        } else {
            this.setStatisticIdForMediators(holder);
        }
        StatisticIdentityGenerator.reportingEndBranchingEvent(holder);
        StatisticIdentityGenerator.reportingBranchingEvents(holder);
        if (this.elseKey != null) {
            childId = StatisticIdentityGenerator.getIdReferencingComponent(this.elseKey, ComponentType.SEQUENCE, holder);
            StatisticIdentityGenerator.reportingEndEvent(childId, ComponentType.SEQUENCE, holder);
        } else if (this.elseMediator != null) {
            this.elseMediator.setStatisticIdForMediators(holder);
        }
        StatisticIdentityGenerator.reportingFlowContinuableEndEvent(mediatorId, ComponentType.MEDIATOR, holder);
        StatisticIdentityGenerator.reportingEndBranchingEvent(holder);
    }
}

