/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.ext;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.Command;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.commons.util.PropertyHelper;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.eip.EIPUtils;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class POJOCommandMediator
extends AbstractMediator {
    private Class command = null;
    private final Map<String, Object> staticSetterProperties = new HashMap<String, Object>();
    private final Map<String, SynapseXPath> messageSetterProperties = new HashMap<String, SynapseXPath>();
    private final Map<String, String> contextSetterProperties = new HashMap<String, String>();
    private final Map<String, String> contextGetterProperties = new HashMap<String, String>();
    private final Map<String, SynapseXPath> messageGetterProperties = new HashMap<String, SynapseXPath>();

    @Override
    public boolean mediate(MessageContext synCtx) {
        SynapseXPath xpath;
        if (synCtx.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(synCtx)) {
            return true;
        }
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : POJOCommand mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Creating a new instance of POJO class : " + this.command.getClass());
        }
        Object commandObject = null;
        try {
            commandObject = this.command.newInstance();
        }
        catch (Exception e) {
            this.handleException("Error creating an instance of the POJO command class : " + this.command.getClass(), e, synCtx);
        }
        synLog.traceOrDebug("Instance created, setting static and dynamic properties");
        for (String name : this.staticSetterProperties.keySet()) {
            PropertyHelper.setInstanceProperty((String)name, (Object)this.staticSetterProperties.get(name), commandObject);
        }
        for (String name : this.contextSetterProperties.keySet()) {
            PropertyHelper.setInstanceProperty((String)name, (Object)synCtx.getProperty(this.contextSetterProperties.get(name)), commandObject);
        }
        for (String name : this.messageSetterProperties.keySet()) {
            xpath = this.messageSetterProperties.get(name);
            String value = xpath.stringValueOf(synCtx);
            PropertyHelper.setInstanceProperty((String)name, (Object)value, commandObject);
        }
        synLog.traceOrDebug("POJO initialized successfully, invoking the execute() method");
        if (commandObject instanceof Command) {
            try {
                ((Command)commandObject).execute();
            }
            catch (Exception e) {
                this.handleException("Error invoking POJO command class : " + this.command.getClass(), e, synCtx);
            }
        } else {
            try {
                Method exeMethod = this.command.getMethod("execute", new Class[0]);
                exeMethod.invoke(commandObject, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                this.handleException("Cannot locate an execute() method on POJO class : " + this.command.getClass(), e, synCtx);
            }
            catch (Exception e) {
                this.handleException("Error invoking the execute() method on POJO class : " + this.command.getClass(), e, synCtx);
            }
        }
        for (String name : this.contextGetterProperties.keySet()) {
            synCtx.setProperty(this.contextGetterProperties.get(name), this.getInstanceProperty(name, commandObject, synCtx));
        }
        for (String name : this.messageGetterProperties.keySet()) {
            xpath = this.messageGetterProperties.get(name);
            Object resultValue = this.getInstanceProperty(name, commandObject, synCtx);
            try {
                List list = EIPUtils.getMatchingElements(synCtx.getEnvelope(), xpath);
                if (list.size() > 0) {
                    Object o = list.get(0);
                    if (resultValue instanceof String) {
                        OMAbstractFactory.getOMFactory().createOMText(((OMNode)o).getParent(), (String)resultValue);
                        ((OMNode)o).detach();
                        continue;
                    }
                    if (!(resultValue instanceof OMNode)) continue;
                    ((OMNode)o).insertSiblingAfter((OMNode)resultValue);
                    ((OMNode)o).detach();
                    continue;
                }
                if (!synLog.isTraceOrDebugEnabled()) continue;
                synLog.traceOrDebug("Unable to set the message property " + resultValue + "back to the message : Specified element by the xpath " + (Object)((Object)xpath) + " can not be found");
            }
            catch (JaxenException e) {
                this.handleException("Unable to set the command property " + name + " back to the message", (Exception)((Object)e), synCtx);
            }
        }
        synLog.traceOrDebug("End : POJOCommand mediator");
        return true;
    }

    private Object getInstanceProperty(String name, Object obj, MessageContext synCtx) {
        String mName = "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        try {
            Method[] methods;
            for (Method method : methods = obj.getClass().getMethods()) {
                if (!mName.equals(method.getName())) continue;
                return method.invoke(obj, new Object[0]);
            }
        }
        catch (InvocationTargetException e) {
            this.handleException("Unable to get the command property '" + name + "' back to the message", e, synCtx);
        }
        catch (IllegalAccessException e) {
            this.handleException("Unable to get the command property '" + name + "' back to the message", e, synCtx);
        }
        return null;
    }

    public Class getCommand() {
        return this.command;
    }

    public void setCommand(Class command) {
        this.command = command;
    }

    public void addStaticSetterProperty(String name, Object value) {
        this.staticSetterProperties.put(name, value);
    }

    public void addMessageSetterProperty(String name, SynapseXPath xpath) {
        this.messageSetterProperties.put(name, xpath);
    }

    public void addContextSetterProperty(String name, String ctxName) {
        this.contextSetterProperties.put(name, ctxName);
    }

    public void addContextGetterProperty(String name, String value) {
        this.contextGetterProperties.put(name, value);
    }

    public void addMessageGetterProperty(String name, SynapseXPath xpath) {
        this.messageGetterProperties.put(name, xpath);
    }

    public Map<String, Object> getStaticSetterProperties() {
        return this.staticSetterProperties;
    }

    public Map<String, SynapseXPath> getMessageSetterProperties() {
        return this.messageSetterProperties;
    }

    public Map<String, String> getContextSetterProperties() {
        return this.contextSetterProperties;
    }

    public Map<String, String> getContextGetterProperties() {
        return this.contextGetterProperties;
    }

    public Map<String, SynapseXPath> getMessageGetterProperties() {
        return this.messageGetterProperties;
    }
}

