/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.ext;

import java.util.ArrayList;
import java.util.List;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.config.xml.PropertyHelper;
import org.apache.synapse.config.xml.SynapsePath;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.MediatorProperty;

public class ClassMediator
extends AbstractMediator
implements ManagedLifecycle {
    private Mediator mediator = null;
    private final List<MediatorProperty> properties = new ArrayList<MediatorProperty>();
    private boolean hasContentAwareProperties = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mediate(MessageContext synCtx) {
        boolean result;
        SynapseLog synLog;
        block10: {
            if (synCtx.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(synCtx)) {
                return true;
            }
            synLog = this.getLog(synCtx);
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Start : Class mediator");
                if (synLog.isTraceTraceEnabled()) {
                    synLog.traceTrace("Message : " + synCtx.getEnvelope());
                }
            }
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("invoking : " + this.mediator.getClass() + ".mediate()");
            }
            try {
                if (this.hasContentAwareProperties) {
                    Mediator mediator = this.mediator;
                    synchronized (mediator) {
                        result = this.updateInstancePropertiesAndMediate(synCtx);
                        break block10;
                    }
                }
                result = this.updateInstancePropertiesAndMediate(synCtx);
            }
            catch (Exception e) {
                throw new SynapseException("Error occured in the mediation of the class mediator", e);
            }
        }
        synLog.traceOrDebug("End : Class mediator");
        return result;
    }

    @Override
    public void destroy() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Destroying class mediator instance for : " + this.mediator.getClass()));
        }
        if (this.mediator instanceof ManagedLifecycle) {
            ((ManagedLifecycle)((Object)this.mediator)).destroy();
        }
    }

    @Override
    public void init(SynapseEnvironment se) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Initializing class mediator instance for : " + this.mediator.getClass()));
        }
        if (this.mediator == null) {
            this.log.warn((Object)"init() called before mediator reference set");
            return;
        }
        if (this.mediator instanceof ManagedLifecycle) {
            ((ManagedLifecycle)((Object)this.mediator)).init(se);
        }
    }

    public void setMediator(Mediator mediator) {
        this.mediator = mediator;
    }

    public Mediator getMediator() {
        return this.mediator;
    }

    public void addProperty(MediatorProperty property) {
        this.properties.add(property);
    }

    public void addAllProperties(List<MediatorProperty> propertyList) {
        this.properties.addAll(propertyList);
        for (MediatorProperty property : this.properties) {
            SynapsePath expression = property.getExpression();
            if (expression == null || !expression.isContentAware()) continue;
            this.hasContentAwareProperties = true;
            break;
        }
    }

    public List<MediatorProperty> getProperties() {
        return this.properties;
    }

    @Override
    public boolean isContentAware() {
        return this.mediator.isContentAware();
    }

    @Override
    public boolean isContentAltering() {
        return true;
    }

    private boolean updateInstancePropertiesAndMediate(MessageContext synCtx) {
        for (MediatorProperty property : this.properties) {
            if (property.getExpression() == null) continue;
            PropertyHelper.setInstanceProperty(property.getName(), property.getEvaluatedExpression(synCtx), this.mediator);
        }
        return this.mediator.mediate(synCtx);
    }
}

