/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.ext;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.synapse.Command;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.commons.util.PropertyHelper;
import org.apache.synapse.mediators.annotations.Namespaces;
import org.apache.synapse.mediators.annotations.ReadAndUpdate;
import org.apache.synapse.mediators.annotations.ReadFromMessage;
import org.apache.synapse.mediators.annotations.UpdateMessage;
import org.apache.synapse.mediators.ext.POJOCommandMediator;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class AnnotatedCommandMediator
extends POJOCommandMediator {
    protected Map<Field, SynapseXPath> beforeFields;
    protected Map<Method, SynapseXPath> beforeMethods;
    protected Map<Field, SynapseXPath> afterFields;
    protected Map<Method, SynapseXPath> afterMethods;

    @Override
    public boolean mediate(MessageContext synCtx) {
        String v;
        SynapseXPath xpath;
        if (synCtx.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(synCtx)) {
            return true;
        }
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : POJOCommand mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Creating a new instance of POJO class : " + this.getCommand().getClass());
        }
        Object commandObject = null;
        try {
            commandObject = this.getCommand().newInstance();
        }
        catch (Exception e) {
            this.handleException("Error creating an instance of the POJO command class : " + this.getCommand().getClass(), e, synCtx);
        }
        synLog.traceOrDebug("Instance created, setting static and dynamic properties");
        for (String name : this.getStaticSetterProperties().keySet()) {
            PropertyHelper.setInstanceProperty((String)name, (Object)this.getStaticSetterProperties().get(name), commandObject);
        }
        for (Field f : this.beforeFields.keySet()) {
            xpath = this.beforeFields.get(f);
            if (!f.getType().equals(String.class)) {
                throw new UnsupportedOperationException("non-String types not supportted yet");
            }
            v = xpath.stringValueOf(synCtx);
            try {
                f.set(commandObject, v);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (Method m : this.beforeMethods.keySet()) {
            xpath = this.beforeMethods.get(m);
            if (m.getParameterTypes().length != 1 || !m.getParameterTypes()[0].equals(String.class)) {
                throw new UnsupportedOperationException("non-String types not supportted yet");
            }
            v = xpath.stringValueOf(synCtx);
            try {
                m.invoke(commandObject, v);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        synLog.traceOrDebug("POJO initialized successfully, invoking the execute() method");
        if (commandObject instanceof Command) {
            try {
                ((Command)commandObject).execute();
            }
            catch (Exception e) {
                this.handleException("Error invoking POJO command class : " + this.getCommand().getClass(), e, synCtx);
            }
        } else {
            Method exeMethod = null;
            try {
                exeMethod = this.getCommand().getMethod("execute", new Class[0]);
                exeMethod.invoke(commandObject, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                this.handleException("Cannot locate an execute() method on POJO class : " + this.getCommand().getClass(), e, synCtx);
            }
            catch (Exception e) {
                this.handleException("Error invoking the execute() method on POJO class : " + this.getCommand().getClass(), e, synCtx);
            }
        }
        synLog.traceOrDebug("End : POJOCommand mediator");
        return true;
    }

    @Override
    public void setCommand(Class commandClass) {
        super.setCommand(commandClass);
        this.introspectClass(commandClass);
    }

    protected void introspectClass(Class<?> commandClass) {
        SynapseXPath axiomXpath;
        UpdateMessage updateMessage;
        ReadFromMessage readFromMessage;
        this.beforeFields = new HashMap<Field, SynapseXPath>();
        this.afterFields = new HashMap<Field, SynapseXPath>();
        this.beforeMethods = new HashMap<Method, SynapseXPath>();
        this.afterMethods = new HashMap<Method, SynapseXPath>();
        for (Field field : commandClass.getDeclaredFields()) {
            ReadAndUpdate readAndUpdate;
            readFromMessage = field.getAnnotation(ReadFromMessage.class);
            if (readFromMessage != null) {
                SynapseXPath axiomXpath2 = this.createSynapseXPATH(readFromMessage.value(), field.getAnnotation(Namespaces.class));
                this.beforeFields.put(field, axiomXpath2);
            }
            if ((updateMessage = field.getAnnotation(UpdateMessage.class)) != null) {
                axiomXpath = this.createSynapseXPATH(updateMessage.value(), field.getAnnotation(Namespaces.class));
                this.afterFields.put(field, axiomXpath);
            }
            if ((readAndUpdate = field.getAnnotation(ReadAndUpdate.class)) == null) continue;
            SynapseXPath axiomXpath3 = this.createSynapseXPATH(readAndUpdate.value(), field.getAnnotation(Namespaces.class));
            this.beforeFields.put(field, axiomXpath3);
            this.afterFields.put(field, axiomXpath3);
        }
        for (AccessibleObject accessibleObject : commandClass.getDeclaredMethods()) {
            readFromMessage = ((Method)accessibleObject).getAnnotation(ReadFromMessage.class);
            if (readFromMessage != null) {
                SynapseXPath axiomXpath2 = this.createSynapseXPATH(readFromMessage.value(), ((Method)accessibleObject).getAnnotation(Namespaces.class));
                this.beforeMethods.put((Method)accessibleObject, axiomXpath2);
            }
            if ((updateMessage = ((Method)accessibleObject).getAnnotation(UpdateMessage.class)) == null) continue;
            axiomXpath = this.createSynapseXPATH(updateMessage.value(), ((Method)accessibleObject).getAnnotation(Namespaces.class));
            this.afterMethods.put((Method)accessibleObject, axiomXpath);
        }
    }

    protected SynapseXPath createSynapseXPATH(String xpath, Namespaces nsAnnotation) {
        Map<String, String> namespaces = this.getNamespaces(nsAnnotation);
        try {
            SynapseXPath axiomXPath = new SynapseXPath(xpath);
            for (Map.Entry<String, String> entry : namespaces.entrySet()) {
                axiomXPath.addNamespace(entry.getKey(), entry.getValue());
            }
            return axiomXPath;
        }
        catch (JaxenException e) {
            throw new RuntimeException("Error creating SynapseXPath: " + xpath, e);
        }
    }

    protected Map<String, String> getNamespaces(Namespaces namespaces) {
        String namespace;
        String prefix;
        int i;
        HashMap<String, String> allNamespaces = new HashMap<String, String>();
        Namespaces defaultNamespaces = this.getCommand().getAnnotation(Namespaces.class);
        if (defaultNamespaces != null) {
            for (String namespaceValue : defaultNamespaces.value()) {
                i = namespaceValue.indexOf(58);
                if (i <= 0) continue;
                prefix = namespaceValue.substring(0, i);
                namespace = namespaceValue.substring(i + 1);
                allNamespaces.put(prefix, namespace);
            }
        }
        if (namespaces != null) {
            for (String namespaceValue : namespaces.value()) {
                i = namespaceValue.indexOf(58);
                if (i <= 0) continue;
                prefix = namespaceValue.substring(0, i);
                namespace = namespaceValue.substring(i + 1);
                allNamespaces.put(prefix, namespace);
            }
        }
        return allNamespaces;
    }
}

