/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.elementary;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.om.util.ElementHelper;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.impl.llom.SOAPHeaderImpl;
import org.apache.axis2.AxisFault;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.commons.json.JsonUtil;
import org.apache.synapse.config.xml.SynapsePath;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.eip.EIPUtils;
import org.apache.synapse.util.InlineExpressionUtil;
import org.apache.synapse.util.xpath.SynapseJsonPath;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class Target {
    private SynapsePath xpath = null;
    private String property = null;
    private int targetType = 0;
    public static final String ACTION_REMOVE = "remove";
    public static final String ACTION_REPLACE = "replace";
    public static final String ACTION_ADD_CHILD = "child";
    public static final String ACTION_ADD_SIBLING = "sibling";
    private String action = "replace";
    public static final String XPATH_PROPERTY_PATTERN = "'[^']*'";
    private static final Log log = LogFactory.getLog(Target.class);
    private final JsonParser jsonParser = new JsonParser();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(MessageContext synContext, ArrayList<OMNode> sourceNodeList, SynapseLog synLog) throws JaxenException {
        if (this.targetType == 0) {
            assert (this.xpath != null) : "Xpath cannot be null for CUSTOM";
            if (sourceNodeList.isEmpty()) {
                synLog.error("Cannot Enrich message from an empty source.");
                return;
            }
            Object targetObj = this.xpath.selectSingleNode(synContext);
            if (this.xpath.getExpression().startsWith("get-property")) {
                this.handleProperty((SynapseXPath)this.xpath, synContext, sourceNodeList, synLog);
            } else if (targetObj instanceof SOAPHeaderImpl) {
                OMElement targetElem = (OMElement)targetObj;
                ArrayList<OMNode> headerSourceNodeList = new ArrayList<OMNode>();
                for (OMNode o : sourceNodeList) {
                    OMElement ins = ((OMElement)o).cloneOMElement();
                    SOAPFactory fac = (SOAPFactory)synContext.getEnvelope().getOMFactory();
                    try {
                        headerSourceNodeList.add((OMNode)ElementHelper.toSOAPHeaderBlock((OMElement)ins, (SOAPFactory)fac));
                    }
                    catch (Exception e) {
                        log.error((Object)"Error occurred while transforming the OMElement to SOAPHeaderBlock ", (Throwable)e);
                        throw new JaxenException((Throwable)e);
                    }
                }
                this.insertElement(headerSourceNodeList, targetElem, synLog);
            } else if (targetObj instanceof OMElement) {
                OMElement targetElem = (OMElement)targetObj;
                this.insertElement(sourceNodeList, targetElem, synLog);
            } else if (targetObj instanceof OMText) {
                OMContainer targetParent;
                OMText targetText = (OMText)targetObj;
                if (sourceNodeList.get(0) instanceof OMText) {
                    OMContainer parent;
                    if (targetText.getParent() != null && (parent = targetText.getParent()) instanceof OMElement) {
                        ((OMElement)parent).setText(((OMText)sourceNodeList.get(0)).getText());
                    }
                } else if (sourceNodeList.get(0) instanceof OMElement && (targetParent = targetText.getParent()) instanceof OMElement) {
                    targetText.detach();
                    OMNode oMNode = sourceNodeList.get(0);
                    synchronized (oMNode) {
                        ((OMElement)targetParent).addChild(sourceNodeList.get(0));
                    }
                }
            } else if (targetObj instanceof OMAttribute) {
                OMAttribute attribute = (OMAttribute)targetObj;
                attribute.setAttributeValue(((OMText)sourceNodeList.get(0)).getText());
            } else {
                synLog.error("Invalid Target object to be enrich.");
                throw new SynapseException("Invalid Target object to be enrich.");
            }
            this.removeOutdatedJsonStream(((Axis2MessageContext)synContext).getAxis2MessageContext());
        } else if (this.targetType == 2) {
            SOAPEnvelope env = synContext.getEnvelope();
            SOAPBody body = env.getBody();
            OMElement e = body.getFirstElement();
            if (e != null) {
                this.insertElementToBody(sourceNodeList, e, synLog, synContext);
            } else {
                for (OMNode elem : sourceNodeList) {
                    if (elem instanceof OMElement) {
                        OMNode oMNode = elem;
                        synchronized (oMNode) {
                            body.addChild(elem);
                            continue;
                        }
                    }
                    synLog.error("Invalid Object type to be inserted into message body");
                }
                this.removeOutdatedJsonStream(((Axis2MessageContext)synContext).getAxis2MessageContext());
            }
        } else if (this.targetType == 1) {
            OMNode node = sourceNodeList.get(0);
            if (node instanceof SOAPEnvelope) {
                try {
                    synContext.setEnvelope((SOAPEnvelope)node);
                }
                catch (AxisFault axisFault) {
                    synLog.error("Failed to set the SOAP Envelope");
                    throw new SynapseException("Failed to set the SOAP Envelope");
                }
            } else {
                synLog.error("SOAPEnvelope is expected");
                throw new SynapseException("A SOAPEnvelope is expected");
            }
            this.removeOutdatedJsonStream(((Axis2MessageContext)synContext).getAxis2MessageContext());
        } else if (this.targetType == 3) {
            assert (this.property != null) : "Property cannot be null for PROPERTY type";
            if (this.action != null && this.property != null) {
                Object propertyObj = synContext.getProperty(this.property);
                OMElement documentElement = null;
                try {
                    documentElement = this.isOMElement(propertyObj) ? (OMElement)propertyObj : AXIOMUtil.stringToOM((String)((String)propertyObj));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (documentElement != null && this.action.equals(ACTION_ADD_CHILD)) {
                    this.insertElement(sourceNodeList, documentElement, synLog);
                    if (this.isOMElement(propertyObj)) {
                        synContext.setProperty(this.property, documentElement);
                    } else {
                        synContext.setProperty(this.property, documentElement.getText());
                    }
                } else {
                    synContext.setProperty(this.property, sourceNodeList);
                }
            } else {
                synContext.setProperty(this.property, sourceNodeList);
            }
        }
    }

    private boolean isOMElement(Object propObject) {
        return propObject instanceof OMElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertElement(ArrayList<OMNode> sourceNodeList, OMElement e, SynapseLog synLog) {
        block12: {
            block11: {
                if (!this.action.equals(ACTION_REPLACE)) break block11;
                boolean isInserted = false;
                for (OMNode elem : sourceNodeList) {
                    if (elem instanceof OMElement) {
                        e.insertSiblingBefore(elem);
                        isInserted = true;
                        continue;
                    }
                    if (elem instanceof OMText) {
                        e.setText(((OMText)elem).getText());
                        continue;
                    }
                    synLog.error("Invalid Source object to be inserted.");
                }
                if (!isInserted) break block12;
                e.detach();
                break block12;
            }
            if (this.action.equals(ACTION_ADD_CHILD)) {
                for (OMNode elem : sourceNodeList) {
                    if (!(elem instanceof OMElement)) continue;
                    OMNode oMNode = elem;
                    synchronized (oMNode) {
                        e.addChild(elem);
                    }
                }
            } else if (this.action.equals(ACTION_ADD_SIBLING)) {
                for (OMNode elem : sourceNodeList) {
                    if (!(elem instanceof OMElement)) continue;
                    e.insertSiblingAfter(elem);
                }
            }
        }
    }

    private void insertElementToBody(ArrayList<OMNode> sourceNodeList, OMElement e, SynapseLog synLog, MessageContext synCtx) {
        if (this.action.equals(ACTION_REPLACE) && !sourceNodeList.isEmpty() && sourceNodeList.get(0) instanceof OMText) {
            String sourceString = ((OMText)sourceNodeList.get(0)).getText();
            try {
                JsonElement jsonElement = this.jsonParser.parse(sourceString);
                if (jsonElement instanceof JsonObject || jsonElement instanceof JsonArray) {
                    try {
                        JsonUtil.getNewJsonPayload((org.apache.axis2.context.MessageContext)((Axis2MessageContext)synCtx).getAxis2MessageContext(), (String)sourceString, (boolean)true, (boolean)true);
                        synCtx.getEnvelope().getBody().toString();
                        return;
                    }
                    catch (AxisFault af) {
                        log.error((Object)"Could not add json object to the json stream", (Throwable)af);
                    }
                }
            }
            catch (JsonSyntaxException ex) {
                synLog.traceOrDebug("Source property string is not a valid json");
                this.insertElement(sourceNodeList, e, synLog);
                this.removeOutdatedJsonStream(((Axis2MessageContext)synCtx).getAxis2MessageContext());
            }
        }
        this.insertElement(sourceNodeList, e, synLog);
        this.removeOutdatedJsonStream(((Axis2MessageContext)synCtx).getAxis2MessageContext());
    }

    private void handleProperty(SynapseXPath xpath, MessageContext synContext, ArrayList<OMNode> sourceNodeList, SynapseLog synLog) {
        String scope = "default";
        Pattern p = Pattern.compile(XPATH_PROPERTY_PATTERN);
        Matcher m = p.matcher(xpath.getExpression());
        ArrayList<String> propList = new ArrayList<String>();
        while (m.find()) {
            propList.add(StringUtils.substringBetween((String)m.group(), (String)"'", (String)"'"));
        }
        if (propList.size() > 1) {
            this.property = (String)propList.get(1);
            scope = (String)propList.get(0);
        } else {
            this.property = (String)propList.get(0);
        }
        OMElement documentElement = null;
        Object propertyObj = null;
        Axis2MessageContext axis2smc = (Axis2MessageContext)synContext;
        if (this.action != null && this.property != null) {
            if ("default".equals(scope)) {
                propertyObj = synContext.getProperty(this.property);
            } else if ("axis2".equals(scope)) {
                propertyObj = axis2smc.getAxis2MessageContext().getProperty(this.property);
            } else if ("operation".equals(scope)) {
                propertyObj = axis2smc.getAxis2MessageContext().getOperationContext().getProperty(this.property);
            }
            if (propertyObj != null && propertyObj instanceof OMElement && this.action.equals(ACTION_ADD_CHILD)) {
                documentElement = (OMElement)propertyObj;
                documentElement = documentElement.cloneOMElement();
                this.insertElement(sourceNodeList, documentElement, synLog);
                this.setProperty(scope, synContext, documentElement);
            } else {
                this.setProperty(scope, synContext, sourceNodeList);
            }
        } else {
            this.setProperty(scope, synContext, sourceNodeList);
        }
    }

    public void setProperty(String scope, MessageContext messageContext, Object documentElement) {
        if ("default".equals(scope)) {
            messageContext.setProperty(this.property, documentElement);
        } else if ("axis2".equals(scope)) {
            ((Axis2MessageContext)messageContext).getAxis2MessageContext().setProperty(this.property, documentElement);
        } else if ("operation".equals(scope)) {
            ((Axis2MessageContext)messageContext).getAxis2MessageContext().getOperationContext().setProperty(this.property, documentElement);
        }
    }

    public void insertJson(MessageContext synCtx, Object sourceJsonElement, SynapseLog synLog) {
        String jsonPath = null;
        SynapseJsonPath sourceJsonPath = null;
        if (this.xpath != null) {
            sourceJsonPath = (SynapseJsonPath)this.xpath;
            jsonPath = sourceJsonPath.getJsonPathExpression();
        }
        switch (this.targetType) {
            case 0: {
                assert (jsonPath != null) : "JSONPath should be non null in case of CUSTOM";
                this.setEnrichResultToBody(synCtx, sourceJsonPath, sourceJsonElement);
                break;
            }
            case 2: {
                if (this.action.equalsIgnoreCase(ACTION_REPLACE)) {
                    org.apache.axis2.context.MessageContext context = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
                    try {
                        String jsonString = sourceJsonElement.toString();
                        JsonElement element = this.jsonParser.parse(jsonString);
                        if (element instanceof JsonObject || element instanceof JsonArray) {
                            JsonUtil.getNewJsonPayload((org.apache.axis2.context.MessageContext)context, (String)jsonString, (boolean)true, (boolean)true);
                            break;
                        }
                        synLog.error("Unsupported JSON payload : " + jsonString + ".Only JSON arrays and objects can be enriched to the body");
                    }
                    catch (AxisFault axisFault) {
                        synLog.error("Error occurred while adding a new JSON payload");
                    }
                    break;
                }
                synLog.error("Unsupported action : " + this.action + ". Only replace is supported for target body.");
                break;
            }
            case 3: {
                JsonElement jsonElement = this.jsonParser.parse(sourceJsonElement.toString());
                if (this.action.equalsIgnoreCase(ACTION_REPLACE)) {
                    synCtx.setProperty(this.property, sourceJsonElement.toString());
                    break;
                }
                if (this.action.equalsIgnoreCase(ACTION_ADD_CHILD)) {
                    Object propertyObj = synCtx.getProperty(this.property);
                    if (propertyObj != null) {
                        try {
                            JsonElement sourceElement = EIPUtils.tryParseJsonString(this.jsonParser, propertyObj.toString());
                            if (sourceElement.isJsonArray()) {
                                sourceElement.getAsJsonArray().add(jsonElement);
                                synCtx.setProperty(this.property, sourceElement.toString());
                                break;
                            }
                            synLog.error("Cannot add child, since the target " + sourceElement.toString() + " is not an JSON array");
                        }
                        catch (JsonSyntaxException ex) {
                            synLog.error("Value inside the given property : " + this.property + " is not a valid JSON");
                        }
                        break;
                    }
                    synLog.error("Cannot find the property with name \"" + this.property + "\" to enrich");
                    break;
                }
                if (!this.action.equalsIgnoreCase(ACTION_ADD_SIBLING)) break;
                synLog.error("Action sibling is not supported when enriching properties with JSON data");
                break;
            }
            default: {
                synLog.error("Case mismatch for type: " + this.targetType);
            }
        }
    }

    public void removeJsonFromBody(MessageContext synCtx, SynapsePath jsonPath) throws IOException, PathNotFoundException {
        Axis2MessageContext axis2smc = (Axis2MessageContext)synCtx;
        org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
        String jsonString = IOUtils.toString((InputStream)JsonUtil.getJsonPayload((org.apache.axis2.context.MessageContext)axis2MessageCtx));
        String result = this.removeJSONFromString(synCtx, jsonString, jsonPath);
        JsonUtil.getNewJsonPayload((org.apache.axis2.context.MessageContext)axis2MessageCtx, (String)result, (boolean)true, (boolean)true);
    }

    public void removeJsonFromProperty(MessageContext synCtx, String property, SynapsePath jsonPath) {
        Object propertyObject = synCtx.getProperty(property);
        String propertyValue = "";
        if (propertyObject instanceof String) {
            propertyValue = (String)propertyObject;
        } else if (propertyObject instanceof JsonElement) {
            propertyValue = propertyObject.toString();
        } else {
            throw new SynapseException("Cannot perform the remove operation. Data type of the property " + property + " is not string | JSON");
        }
        String result = this.removeJSONFromString(synCtx, propertyValue, jsonPath);
        synCtx.setProperty(property, result);
    }

    private String removeJSONFromString(MessageContext synCtx, String inputString, SynapsePath jsonPath) {
        String[] jsonPathArray;
        String result = inputString;
        SynapseJsonPath synapseJsonPath = (SynapseJsonPath)jsonPath;
        String jsonPathString = synapseJsonPath.toString();
        if (InlineExpressionUtil.checkForInlineExpressions(jsonPathString = jsonPathString.substring(10, jsonPathString.length() - 1))) {
            try {
                jsonPathString = InlineExpressionUtil.replaceDynamicValues(synCtx, jsonPathString);
                jsonPathString = jsonPathString.replaceAll("^\"|\"$", "");
            }
            catch (Exception e) {
                log.error((Object)"Error occurred while evaluating JSONPath", (Throwable)e);
            }
        }
        if ((jsonPathArray = jsonPathString.split(",")).length > 0) {
            for (String path : jsonPathArray) {
                if (path.equals("$") || path.equals("$.")) {
                    result = "";
                    continue;
                }
                DocumentContext doc = JsonPath.parse((String)result);
                doc.delete(path, new Predicate[0]);
                result = doc.jsonString();
            }
        }
        return result;
    }

    public void renameKey(MessageContext synapseContext, String jsonPath, String keyName, String newKeyName) throws IOException {
        org.apache.axis2.context.MessageContext axis2MessageCtx = ((Axis2MessageContext)synapseContext).getAxis2MessageContext();
        String payload = JsonUtil.jsonPayloadToString((org.apache.axis2.context.MessageContext)((Axis2MessageContext)synapseContext).getAxis2MessageContext());
        DocumentContext doc = JsonPath.parse((String)payload).renameKey(jsonPath, keyName, newKeyName, new Predicate[0]);
        JsonUtil.getNewJsonPayload((org.apache.axis2.context.MessageContext)axis2MessageCtx, (String)doc.jsonString(), (boolean)true, (boolean)true);
    }

    private void setEnrichResultToBody(MessageContext synapseContext, SynapseJsonPath synapseJsonPath, Object sourceNode) {
        String expression;
        if (InlineExpressionUtil.checkForInlineExpressions(synapseJsonPath.toString())) {
            try {
                String jsonpath = synapseJsonPath.toString();
                if (jsonpath.startsWith("json-eval(")) {
                    jsonpath = jsonpath.substring(10, jsonpath.length() - 1);
                }
                synapseJsonPath = new SynapseJsonPath(InlineExpressionUtil.replaceDynamicValues(synapseContext, jsonpath));
            }
            catch (JaxenException e) {
                log.error((Object)"Error occurred while evaluating JSONPath", (Throwable)e);
            }
        }
        if ((expression = synapseJsonPath.getJsonPathExpression()).endsWith(".")) {
            expression = expression.substring(0, expression.length() - 1);
        }
        boolean isRootPath = "$".equals(expression);
        org.apache.axis2.context.MessageContext context = ((Axis2MessageContext)synapseContext).getAxis2MessageContext();
        assert (JsonUtil.hasAJsonPayload((org.apache.axis2.context.MessageContext)context)) : "Message Context does not contain a JSON payload";
        String jsonString = JsonUtil.jsonPayloadToString((org.apache.axis2.context.MessageContext)context);
        String newJsonString = "";
        if (this.action.equalsIgnoreCase(ACTION_REPLACE)) {
            newJsonString = JsonPath.parse((String)jsonString).set(expression, sourceNode, new Predicate[0]).jsonString();
        } else if (this.action.equalsIgnoreCase(ACTION_ADD_CHILD)) {
            newJsonString = this.getNewJSONString(sourceNode, expression, jsonString, isRootPath);
        } else if (this.action.equalsIgnoreCase(ACTION_ADD_SIBLING)) {
            log.error((Object)"Action sibling is not supported. Please use child action instead");
        } else {
            log.error((Object)("Invalid action set: " + this.action));
        }
        try {
            if (!newJsonString.trim().isEmpty()) {
                JsonUtil.getNewJsonPayload((org.apache.axis2.context.MessageContext)context, (String)newJsonString, (boolean)true, (boolean)true);
            }
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Error occurred while setting new JSON payload", (Throwable)axisFault);
        }
    }

    private String getNewJSONString(Object sourceNode, String expression, String jsonString, boolean isRootPath) {
        String newJsonString;
        DocumentContext documentContext = JsonPath.parse((String)jsonString);
        JsonElement receivingElement = (JsonElement)documentContext.read(expression, new Predicate[0]);
        JsonElement sourceElement = EIPUtils.tryParseJsonString(this.jsonParser, sourceNode.toString());
        if (receivingElement.isJsonArray()) {
            receivingElement.getAsJsonArray().add(sourceElement);
        } else if (receivingElement.isJsonObject() && sourceElement.isJsonObject()) {
            EIPUtils.mergeJsonObjects(receivingElement.getAsJsonObject(), sourceElement.getAsJsonObject());
        } else {
            log.error((Object)("Cannot append since the target element is not a JSON array or JSONObject: " + receivingElement.toString()));
        }
        if (isRootPath) {
            newJsonString = receivingElement.toString();
        } else {
            documentContext.set(expression, (Object)receivingElement, new Predicate[0]);
            newJsonString = documentContext.json().toString();
        }
        return newJsonString;
    }

    private void removeOutdatedJsonStream(org.apache.axis2.context.MessageContext axis2MsgCtx) {
        axis2MsgCtx.removeProperty("org.apache.synapse.commons.json.JsonInputStream");
    }

    public SynapsePath getXpath() {
        return this.xpath;
    }

    public String getProperty() {
        return this.property;
    }

    public int getTargetType() {
        return this.targetType;
    }

    public void setXpath(SynapsePath xpath) {
        this.xpath = xpath;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setTargetType(int targetType) {
        this.targetType = targetType;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }
}

