/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.elementary;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.List;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.llom.OMTextImpl;
import org.apache.axiom.om.util.ElementHelper;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.commons.json.JsonUtil;
import org.apache.synapse.config.xml.SynapsePath;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.util.InlineExpressionUtil;
import org.apache.synapse.util.MessageHelper;
import org.apache.synapse.util.xpath.SynapseJsonPath;
import org.jaxen.JaxenException;

public class Source {
    private SynapsePath xpath = null;
    private String property = null;
    private int sourceType = 0;
    private boolean clone = true;
    private OMNode inlineOMNode = null;
    private OMNode initialInlineOMNode = null;
    private String inlineKey = null;
    private static final Log log = LogFactory.getLog(Source.class);

    public ArrayList<OMNode> evaluate(MessageContext synCtx, SynapseLog synLog) throws JaxenException {
        ArrayList<OMNode> sourceNodeList = new ArrayList<OMNode>();
        if (this.sourceType == 0) {
            assert (this.xpath != null) : "XPath should be non null in case of CUSTOM";
            List selectedNodeList = this.xpath.selectNodes(synCtx);
            if (selectedNodeList != null && selectedNodeList.size() != 0) {
                for (Object o : selectedNodeList) {
                    if (o instanceof OMElement) {
                        if (this.clone) {
                            OMElement ins = ((OMElement)o).cloneOMElement();
                            if (o instanceof SOAPHeaderBlock) {
                                SOAPFactory fac = (SOAPFactory)((OMElement)o).getOMFactory();
                                try {
                                    sourceNodeList.add((OMNode)ElementHelper.toSOAPHeaderBlock((OMElement)ins, (SOAPFactory)fac));
                                    continue;
                                }
                                catch (Exception e) {
                                    synLog.error(e);
                                    throw new JaxenException((Throwable)e);
                                }
                            }
                            sourceNodeList.add((OMNode)ins);
                            continue;
                        }
                        sourceNodeList.add((OMNode)((OMElement)o));
                        continue;
                    }
                    if (o instanceof OMText) {
                        sourceNodeList.add((OMNode)((OMText)o));
                        continue;
                    }
                    if (!(o instanceof String)) continue;
                    OMFactory fac = OMAbstractFactory.getOMFactory();
                    sourceNodeList.add((OMNode)fac.createOMText(o.toString()));
                }
            } else {
                synLog.error("Specified node by xpath cannot be found.");
            }
        } else if (this.sourceType == 2) {
            if (this.clone) {
                if (synCtx.getEnvelope().getBody().getFirstElement() != null) {
                    sourceNodeList.add((OMNode)synCtx.getEnvelope().getBody().getFirstElement().cloneOMElement());
                }
            } else if (synCtx.getEnvelope().getBody().getFirstElement() != null) {
                sourceNodeList.add((OMNode)synCtx.getEnvelope().getBody().getFirstElement());
            }
        } else if (this.sourceType == 1) {
            if (this.clone) {
                sourceNodeList.add((OMNode)MessageHelper.cloneSOAPEnvelope(synCtx.getEnvelope()));
            } else {
                sourceNodeList.add((OMNode)synCtx.getEnvelope());
            }
        } else if (this.sourceType == 3) {
            assert (this.property != null) : "property shouldn't be null when type is PROPERTY";
            Object o = synCtx.getProperty(this.property);
            if (o instanceof OMElement) {
                if (this.clone) {
                    sourceNodeList.add((OMNode)((OMElement)o).cloneOMElement());
                } else {
                    sourceNodeList.add((OMNode)((OMElement)o));
                }
            } else if (o instanceof String) {
                String sourceStr = (String)o;
                OMFactory fac = OMAbstractFactory.getOMFactory();
                sourceNodeList.add((OMNode)fac.createOMText(sourceStr));
            } else if (o instanceof ArrayList) {
                ArrayList<Object> nodesList = this.clone ? MessageHelper.cloneArrayList((ArrayList)o) : (ArrayList<Object>)o;
                for (Object node : nodesList) {
                    if (node instanceof OMElement) {
                        if (node instanceof SOAPEnvelope) {
                            SOAPEnvelope soapEnvelope = (SOAPEnvelope)node;
                            String soapNamespace = null;
                            if (soapEnvelope.getNamespace() != null) {
                                soapNamespace = soapEnvelope.getNamespace().getNamespaceURI();
                            }
                            if (soapEnvelope.getHeader() == null && soapNamespace != null) {
                                SOAPFactory soapFactory = soapNamespace.equals("http://www.w3.org/2003/05/soap-envelope") ? OMAbstractFactory.getSOAP12Factory() : OMAbstractFactory.getSOAP11Factory();
                                soapFactory.createSOAPHeader(soapEnvelope);
                            }
                            sourceNodeList.add((OMNode)soapEnvelope);
                            continue;
                        }
                        OMElement ele = (OMElement)node;
                        sourceNodeList.add((OMNode)ele);
                        continue;
                    }
                    if (!(node instanceof OMText)) continue;
                    sourceNodeList.add((OMNode)((OMText)node));
                }
            } else if (o instanceof JsonElement) {
                String sourceStr = o.toString();
                OMFactory fac = OMAbstractFactory.getOMFactory();
                sourceNodeList.add((OMNode)fac.createOMText(sourceStr));
            } else {
                synLog.error("Invalid source property type.");
            }
        } else if (this.sourceType == 4) {
            if (this.inlineOMNode instanceof OMElement) {
                OMElement inlineOMElement = (OMElement)this.inlineOMNode;
                if (inlineOMElement.getQName().getLocalPart().equals("Envelope")) {
                    SOAPEnvelope soapEnvelope = this.getSOAPEnvFromOM(inlineOMElement);
                    if (soapEnvelope != null) {
                        sourceNodeList.add((OMNode)soapEnvelope);
                    } else {
                        synLog.error("Inline Source is not a valid SOAPEnvelope.");
                    }
                } else {
                    sourceNodeList.add((OMNode)inlineOMElement.cloneOMElement());
                }
            } else if (this.inlineOMNode instanceof OMText) {
                sourceNodeList.add(this.inlineOMNode);
            } else if (this.inlineKey != null) {
                Object inlineObj = synCtx.getEntry(this.inlineKey);
                if (inlineObj instanceof OMElement) {
                    if (((OMElement)inlineObj).getQName().getLocalPart().equals("Envelope")) {
                        SOAPEnvelope soapEnvelope = this.getSOAPEnvFromOM((OMElement)inlineObj);
                        if (soapEnvelope != null) {
                            sourceNodeList.add((OMNode)soapEnvelope);
                        } else {
                            synLog.error("Specified Resource as Source is not a valid SOAPEnvelope.");
                        }
                    } else {
                        sourceNodeList.add((OMNode)((OMElement)inlineObj));
                    }
                } else if (inlineObj instanceof OMText) {
                    sourceNodeList.add((OMNode)((OMText)inlineObj));
                } else if (inlineObj instanceof String) {
                    sourceNodeList.add((OMNode)OMAbstractFactory.getOMFactory().createOMText(inlineObj.toString()));
                } else {
                    synLog.error("Specified Resource as Source is not valid.");
                }
            } else {
                synLog.error("Inline Source Content is not valid.");
            }
            if (this.initialInlineOMNode != null) {
                this.inlineOMNode = this.initialInlineOMNode;
            }
        }
        return sourceNodeList;
    }

    private SOAPEnvelope getSOAPEnvFromOM(OMElement inlineElement) {
        SOAPFactory soapFactory = inlineElement.getQName().getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope") ? OMAbstractFactory.getSOAP12Factory() : OMAbstractFactory.getSOAP11Factory();
        StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(inlineElement.getXMLStreamReader(), soapFactory, inlineElement.getQName().getNamespaceURI());
        return builder.getSOAPEnvelope();
    }

    public JsonElement evaluateJson(MessageContext synCtx, SynapseLog synLog, JsonElement sourcePropertyJson) throws JaxenException {
        org.apache.axis2.context.MessageContext context;
        JsonElement object = null;
        String jsonPath = null;
        JsonParser parser = new JsonParser();
        if (this.xpath != null) {
            SynapseJsonPath sourceJsonPath = (SynapseJsonPath)this.xpath;
            if (InlineExpressionUtil.checkForInlineExpressions(sourceJsonPath.toString())) {
                try {
                    String jsonpath = sourceJsonPath.toString();
                    if (jsonpath.startsWith("json-eval(")) {
                        jsonpath = jsonpath.substring(10, jsonpath.length() - 1);
                    }
                    sourceJsonPath = new SynapseJsonPath(InlineExpressionUtil.replaceDynamicValues(synCtx, jsonpath));
                }
                catch (JaxenException e) {
                    log.error((Object)"Error occurred while evaluating JSONPath", (Throwable)e);
                }
            }
            jsonPath = sourceJsonPath.getJsonPathExpression();
        }
        if (!JsonUtil.hasAJsonPayload((org.apache.axis2.context.MessageContext)(context = ((Axis2MessageContext)synCtx).getAxis2MessageContext()))) {
            synLog.error("JSON payload not found in message context");
        }
        switch (this.sourceType) {
            case 0: {
                assert (jsonPath != null) : "JSONPath should be non null in case of CUSTOM";
                String jsonString = JsonUtil.jsonPayloadToString((org.apache.axis2.context.MessageContext)context);
                object = (JsonElement)JsonPath.parse((String)jsonString).read(jsonPath, new Predicate[0]);
                if (this.clone) break;
                String modifiedJsonString = JsonPath.parse((String)jsonString).delete(jsonPath, new Predicate[0]).jsonString();
                try {
                    JsonUtil.getNewJsonPayload((org.apache.axis2.context.MessageContext)context, (String)modifiedJsonString, (boolean)true, (boolean)true);
                }
                catch (Exception ex) {
                    synLog.error("Error while setting json payload, when cloning is false");
                }
                break;
            }
            case 2: {
                String jsonPayload = JsonUtil.jsonPayloadToString((org.apache.axis2.context.MessageContext)context);
                object = parser.parse(jsonPayload);
                break;
            }
            case 4: {
                assert (this.inlineOMNode != null || this.inlineKey != null) : "inlineJSONNode or key shouldn't be null when type is INLINE";
                if (this.inlineOMNode instanceof OMText) {
                    object = (JsonElement)JsonPath.parse((String)((OMTextImpl)this.inlineOMNode).getText()).json();
                } else if (this.inlineKey != null && !this.inlineKey.trim().equals("")) {
                    Object inlineObj = synCtx.getEntry(this.inlineKey);
                    if (inlineObj instanceof String && !((String)inlineObj).trim().equals("")) {
                        object = (JsonElement)JsonPath.parse((String)((String)inlineObj)).json();
                    } else {
                        synLog.error("Source failed to get inline JSONinlineKey=" + this.inlineKey);
                    }
                } else {
                    synLog.error("Source failed to get inline JSONinlineJSONNode=" + this.inlineOMNode + ", inlineKey=" + this.inlineKey);
                }
                if (this.initialInlineOMNode == null) break;
                this.inlineOMNode = this.initialInlineOMNode;
                break;
            }
            case 3: {
                assert (this.property != null) : "property shouldn't be null when type is PROPERTY";
                if (sourcePropertyJson != null) {
                    object = sourcePropertyJson;
                    break;
                }
                synLog.error("Source json object cannot be null");
                break;
            }
            default: {
                synLog.error("Case mismatch for type: " + this.sourceType);
            }
        }
        return object;
    }

    public SynapsePath getXpath() {
        return this.xpath;
    }

    public void setXpath(SynapsePath xpath) {
        this.xpath = xpath;
    }

    public int getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(int sourceType) {
        this.sourceType = sourceType;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public boolean isClone() {
        return this.clone;
    }

    public void setClone(boolean clone) {
        this.clone = clone;
    }

    public void setInlineOMNode(OMNode inlineOMNode) {
        this.inlineOMNode = inlineOMNode;
    }

    public OMNode getInlineOMNode() {
        return this.inlineOMNode;
    }

    public String getInlineKey() {
        return this.inlineKey;
    }

    public void setInlineKey(String inlineKey) {
        this.inlineKey = inlineKey;
    }

    public OMNode getInitialInlineOMNode() {
        return this.initialInlineOMNode;
    }

    public void setInitialInlineOMNode(OMNode inlineOMNodeWithExpressions) {
        this.initialInlineOMNode = inlineOMNodeWithExpressions;
    }
}

