/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.elementary;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.jayway.jsonpath.PathNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.llom.OMTextImpl;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.commons.json.JsonUtil;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.elementary.Source;
import org.apache.synapse.mediators.elementary.Target;
import org.apache.synapse.util.InlineExpressionUtil;
import org.apache.synapse.util.xpath.SynapseJsonPath;
import org.jaxen.JaxenException;

public class EnrichMediator
extends AbstractMediator {
    public static final int CUSTOM = 0;
    public static final int ENVELOPE = 1;
    public static final int BODY = 2;
    public static final int PROPERTY = 3;
    public static final int INLINE = 4;
    public static final int KEY = 5;
    private Source source = null;
    private Target target = null;
    private boolean isNativeJsonSupportEnabled = false;
    private boolean containsInlineExpressions = false;
    public static final String ACTION_REMOVE = "remove";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean mediate(MessageContext synCtx) {
        org.apache.axis2.context.MessageContext axis2MsgCtx;
        SynapseLog synLog;
        block38: {
            block43: {
                boolean isInlineTextXML;
                boolean isSourcePropertyXML;
                JsonElement sourcePropertyJson;
                block37: {
                    Iterator iterator;
                    JsonParser jsonParser;
                    block42: {
                        Object sourceProperty;
                        block41: {
                            block40: {
                                block39: {
                                    if (synCtx.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(synCtx)) {
                                        return true;
                                    }
                                    synLog = this.getLog(synCtx);
                                    if (synLog.isTraceOrDebugEnabled()) {
                                        synLog.traceOrDebug("Start : Enrich mediator");
                                        if (synLog.isTraceTraceEnabled()) {
                                            synLog.traceTrace("Message : " + synCtx.getEnvelope());
                                        }
                                    }
                                    axis2MsgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
                                    jsonParser = new JsonParser();
                                    sourcePropertyJson = null;
                                    isSourcePropertyXML = false;
                                    sourceProperty = synCtx.getProperty(this.source.getProperty());
                                    if (!(sourceProperty instanceof JsonElement)) break block39;
                                    sourcePropertyJson = (JsonElement)sourceProperty;
                                    isSourcePropertyXML = false;
                                    break block37;
                                }
                                if (!(sourceProperty instanceof OMElement)) break block40;
                                isSourcePropertyXML = true;
                                break block37;
                            }
                            if (!(sourceProperty instanceof ArrayList)) break block41;
                            iterator = ((ArrayList)sourceProperty).iterator();
                            break block42;
                        }
                        if (!(sourceProperty instanceof String)) break block37;
                        try {
                            sourcePropertyJson = jsonParser.parse((String)sourceProperty);
                            if (!(sourcePropertyJson instanceof JsonObject || sourcePropertyJson instanceof JsonArray || sourcePropertyJson instanceof JsonPrimitive)) {
                                isSourcePropertyXML = true;
                            }
                            break block37;
                        }
                        catch (JsonSyntaxException e) {
                            try {
                                String enclosedSourceProperty = "\"" + sourceProperty + "\"";
                                sourcePropertyJson = jsonParser.parse(enclosedSourceProperty);
                                if (sourcePropertyJson instanceof JsonObject || sourcePropertyJson instanceof JsonArray || sourcePropertyJson instanceof JsonPrimitive) break block37;
                                isSourcePropertyXML = true;
                                break block37;
                            }
                            catch (JsonSyntaxException ex) {
                                synLog.traceOrDebug("Source string is not a valid json");
                                isSourcePropertyXML = true;
                            }
                        }
                        break block37;
                    }
                    while (iterator.hasNext()) {
                        Object node = iterator.next();
                        if (node instanceof OMText) {
                            String propertyString = ((OMTextImpl)node).getText();
                            try {
                                sourcePropertyJson = jsonParser.parse(propertyString);
                                if (sourcePropertyJson instanceof JsonObject || sourcePropertyJson instanceof JsonArray) continue;
                                isSourcePropertyXML = true;
                                break;
                            }
                            catch (JsonSyntaxException e) {
                                synLog.traceOrDebug("Source is not a valid json");
                                isSourcePropertyXML = true;
                                continue;
                            }
                        }
                        if (!(node instanceof OMElement)) continue;
                        isSourcePropertyXML = true;
                        break;
                    }
                }
                boolean bl = isInlineTextXML = !this.isNativeJsonSupportEnabled;
                if (this.containsInlineExpressions()) {
                    OMNode inlineOMNode = this.source.getInlineOMNode();
                    this.source.setInitialInlineOMNode(inlineOMNode);
                    if (inlineOMNode != null) {
                        if (inlineOMNode instanceof OMText) {
                            isInlineTextXML = this.setDynamicValuesInNode(synCtx, ((OMTextImpl)inlineOMNode).getText());
                        } else if (inlineOMNode instanceof OMElement) {
                            isInlineTextXML = this.setDynamicValuesInNode(synCtx, inlineOMNode.toString());
                        }
                    }
                }
                boolean hasJSONPayload = JsonUtil.hasAJsonPayload((org.apache.axis2.context.MessageContext)((Axis2MessageContext)synCtx).getAxis2MessageContext());
                if (!this.isNativeJsonSupportEnabled || !hasJSONPayload || isSourcePropertyXML || isInlineTextXML) break block43;
                if (this.target.getAction().equals(ACTION_REMOVE)) {
                    try {
                        if (this.source.getXpath() != null && this.source.getXpath() instanceof SynapseJsonPath) {
                            if (this.target.getTargetType() == 2) {
                                this.target.removeJsonFromBody(synCtx, this.source.getXpath());
                                break block38;
                            }
                            if (this.target.getTargetType() == 3) {
                                this.target.removeJsonFromProperty(synCtx, this.target.getProperty(), this.source.getXpath());
                                break block38;
                            } else {
                                this.handleException("Target type " + this.target.getTargetType() + " is invalid for the remove action", synCtx);
                            }
                            break block38;
                        }
                        this.handleException("source Xpath is mandatory for the Remove action", synCtx);
                    }
                    catch (PathNotFoundException | IOException e) {
                        this.handleException("Error occurred while executing the action : remove", (Exception)e, synCtx);
                    }
                    break block38;
                } else {
                    try {
                        JsonElement sourceNode = this.source.evaluateJson(synCtx, synLog, sourcePropertyJson);
                        if (sourceNode == null) {
                            this.handleException("Failed to get the source for Enriching : ", synCtx);
                            break block38;
                        }
                        if (this.target.getTargetType() == 5) {
                            try {
                                if (sourceNode instanceof JsonPrimitive) {
                                    String jsonPathString = this.target.getXpath().toString();
                                    jsonPathString = jsonPathString.substring(10, jsonPathString.length() - 1);
                                    int lastIndex = jsonPathString.lastIndexOf(".");
                                    String jsonPath = jsonPathString.substring(0, lastIndex);
                                    String keyName = jsonPathString.substring(lastIndex + 1);
                                    this.target.renameKey(synCtx, jsonPath, keyName, ((JsonPrimitive)sourceNode).getAsString());
                                    break block38;
                                }
                                this.handleException("Failed to get the new key name from source for Enriching. Key name must be a string.", synCtx);
                            }
                            catch (IOException e) {
                                this.handleException("Failed to rename the key.", e, synCtx);
                            }
                            break block38;
                        }
                        this.target.insertJson(synCtx, sourceNode, synLog);
                    }
                    catch (JaxenException e) {
                        this.handleException("Failed to get the source for Enriching", (Exception)((Object)e), synCtx);
                    }
                }
                break block38;
            }
            try {
                ArrayList<OMNode> sourceNodeList = this.source.evaluate(synCtx, synLog);
                if (sourceNodeList == null) {
                    this.handleException("Failed to get the source for Enriching : ", synCtx);
                } else {
                    this.target.insert(synCtx, sourceNodeList, synLog);
                }
            }
            catch (JaxenException e) {
                this.handleException("Failed to get the source for Enriching", (Exception)((Object)e), synCtx);
            }
        }
        if (this.target.getTargetType() == 2 || this.target.getTargetType() == 1) {
            axis2MsgCtx.removeProperty("NO_ENTITY_BODY");
        }
        synLog.traceOrDebug("End : Enrich mediator");
        return true;
    }

    private boolean setDynamicValuesInNode(MessageContext messageContext, String inlineStringWithExpressions) {
        boolean isInlineTextXML = false;
        String inlineString = InlineExpressionUtil.replaceDynamicValues(messageContext, inlineStringWithExpressions);
        try {
            this.source.setInlineOMNode((OMNode)AXIOMUtil.stringToOM((String)inlineString));
            isInlineTextXML = true;
        }
        catch (XMLStreamException | OMException e) {
            this.source.setInlineOMNode((OMNode)OMAbstractFactory.getOMFactory().createOMText(inlineString));
        }
        return isInlineTextXML;
    }

    public Source getSource() {
        return this.source;
    }

    public Target getTarget() {
        return this.target;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    @Override
    public boolean isContentAltering() {
        return true;
    }

    public void setNativeJsonSupportEnabled(boolean nativeJsonSupportEnabled) {
        this.isNativeJsonSupportEnabled = nativeJsonSupportEnabled;
    }

    public boolean containsInlineExpressions() {
        return this.containsInlineExpressions;
    }

    public void setContainsInlineExpressions(boolean containsInlineExpressions) {
        this.containsInlineExpressions = containsInlineExpressions;
    }
}

