/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.eip.splitter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.jayway.jsonpath.JsonPath;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.OperationContext;
import org.apache.synapse.ContinuationState;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.flow.statistics.StatisticIdentityGenerator;
import org.apache.synapse.aspects.flow.statistics.collectors.OpenEventCollector;
import org.apache.synapse.aspects.flow.statistics.collectors.RuntimeStatisticCollector;
import org.apache.synapse.aspects.flow.statistics.data.artifact.ArtifactHolder;
import org.apache.synapse.commons.json.JsonUtil;
import org.apache.synapse.config.xml.SynapsePath;
import org.apache.synapse.continuation.ContinuationStackManager;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.FlowContinuableMediator;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.mediators.eip.EIPUtils;
import org.apache.synapse.mediators.eip.SharedDataHolder;
import org.apache.synapse.mediators.eip.Target;
import org.apache.synapse.util.MessageHelper;
import org.apache.synapse.util.xpath.SynapseJsonPath;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class IterateMediator
extends AbstractMediator
implements ManagedLifecycle,
FlowContinuableMediator {
    private boolean continueParent = false;
    private boolean preservePayload = false;
    private SynapsePath expression = null;
    private SynapsePath attachPath = null;
    private Target target = null;
    private String id = null;
    private SynapseEnvironment synapseEnv;
    private boolean isAttachPathPresent;

    @Override
    public boolean mediate(MessageContext synCtx) {
        if (synCtx.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(synCtx)) {
            return true;
        }
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : Iterate mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        synCtx.setProperty(this.id != null ? "EIP_SHARED_DATA_HOLDER." + this.id : "EIP_SHARED_DATA_HOLDER", new SharedDataHolder());
        try {
            if (this.expression != null && this.expression instanceof SynapseJsonPath) {
                Object resultValue = this.expression.evaluate(synCtx);
                JsonParser parser = new JsonParser();
                String rootJSON = parser.parse(JsonUtil.jsonPayloadToString((org.apache.axis2.context.MessageContext)((Axis2MessageContext)synCtx).getAxis2MessageContext())).toString();
                if (!((SynapseJsonPath)this.expression).getJsonPathExpression().equals(((SynapseJsonPath)this.attachPath).getJsonPathExpression())) {
                    JsonElement rootJsonElement = parser.parse(rootJSON.toString());
                    if (!(EIPUtils.formatJsonPathResponse(JsonPath.parse((String)rootJsonElement.toString()).read(((SynapseJsonPath)this.expression).getJsonPath())) instanceof JsonArray)) {
                        this.handleException("JSON element expressed by the path " + ((SynapseJsonPath)this.expression).getJsonPathExpression() + " is not a valid JSON array that can be iterated", synCtx);
                    }
                    rootJSON = JsonPath.parse((String)rootJsonElement.toString()).set(((SynapseJsonPath)this.expression).getJsonPath(), (Object)new JsonArray()).jsonString();
                }
                if (resultValue instanceof List) {
                    List list = (List)resultValue;
                    int msgNumber = 0;
                    int msgCount = list.size();
                    for (Object o : list) {
                        MessageContext iteratedMsgCtx = this.getIteratedMessage(synCtx, msgNumber++, msgCount, rootJSON, o);
                        ContinuationStackManager.addReliantContinuationState(iteratedMsgCtx, 0, this.getMediatorPosition());
                        if (this.target.isAsynchronous()) {
                            this.target.mediate(iteratedMsgCtx);
                            continue;
                        }
                        try {
                            this.target.mediate(iteratedMsgCtx);
                        }
                        catch (SynapseException synEx) {
                            this.copyFaultyIteratedMessage(synCtx, iteratedMsgCtx);
                            throw synEx;
                        }
                        catch (Exception e) {
                            this.copyFaultyIteratedMessage(synCtx, iteratedMsgCtx);
                            this.handleException("Exception occurred while executing sequential iteration in the Iterator Mediator", e, synCtx);
                        }
                    }
                }
            } else {
                SOAPEnvelope envelope = MessageHelper.cloneSOAPEnvelope(synCtx.getEnvelope());
                List<OMNode> splitElements = EIPUtils.getDetachedMatchingElements(envelope, synCtx, (SynapseXPath)this.expression);
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("Splitting with XPath : " + (Object)((Object)this.expression) + " resulted in " + splitElements.size() + " elements");
                }
                if (!this.preservePayload && envelope.getBody() != null) {
                    Iterator itr = envelope.getBody().getChildren();
                    while (itr.hasNext()) {
                        ((OMNode)itr.next()).detach();
                    }
                }
                int msgCount = splitElements.size();
                int msgNumber = 0;
                for (OMNode o : splitElements) {
                    if (!(o instanceof OMNode)) {
                        this.handleException("Error splitting message with XPath : " + (Object)((Object)this.expression) + " - result not an OMNode", synCtx);
                    }
                    if (synLog.isTraceOrDebugEnabled()) {
                        synLog.traceOrDebug("Submitting " + (msgNumber + 1) + " of " + msgCount + (this.target.isAsynchronous() ? " messages for processing in parallel" : " messages for processing in sequentially"));
                    }
                    MessageContext iteratedMsgCtx = this.getIteratedMessage(synCtx, msgNumber++, msgCount, envelope, o);
                    ContinuationStackManager.addReliantContinuationState(iteratedMsgCtx, 0, this.getMediatorPosition());
                    if (this.target.isAsynchronous()) {
                        this.target.mediate(iteratedMsgCtx);
                        continue;
                    }
                    try {
                        this.target.mediate(iteratedMsgCtx);
                    }
                    catch (SynapseException synEx) {
                        this.copyFaultyIteratedMessage(synCtx, iteratedMsgCtx);
                        throw synEx;
                    }
                    catch (Exception e) {
                        this.copyFaultyIteratedMessage(synCtx, iteratedMsgCtx);
                        this.handleException("Exception occurred while executing sequential iteration in the Iterator Mediator", e, synCtx);
                    }
                }
            }
        }
        catch (JaxenException e) {
            this.handleException("Error evaluating split XPath expression : " + (Object)((Object)this.expression), (Exception)((Object)e), synCtx);
        }
        catch (AxisFault af) {
            this.handleException("Error creating an iterated copy of the message", (Exception)((Object)af), synCtx);
        }
        catch (SynapseException synEx) {
            throw synEx;
        }
        catch (Exception e) {
            this.handleException("Exception occurred while executing the Iterate Mediator", e, synCtx);
        }
        OperationContext opCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext().getOperationContext();
        if (!this.continueParent && opCtx != null) {
            opCtx.setProperty("RESPONSE_WRITTEN", (Object)"SKIP");
        }
        synLog.traceOrDebug("End : Iterate mediator");
        return this.continueParent;
    }

    private void copyFaultyIteratedMessage(MessageContext synCtx, MessageContext iteratedMsgCtx) {
        synCtx.getFaultStack().clear();
        Stack<FaultHandler> faultStack = iteratedMsgCtx.getFaultStack();
        if (!faultStack.isEmpty()) {
            ArrayList<FaultHandler> newFaultStack = new ArrayList<FaultHandler>();
            newFaultStack.addAll(faultStack);
            for (FaultHandler faultHandler : newFaultStack) {
                if (faultHandler == null) continue;
                synCtx.pushFaultHandler(faultHandler);
            }
        }
        for (Object keyObject : iteratedMsgCtx.getPropertyKeySet()) {
            if (!(keyObject instanceof String)) continue;
            String stringKey = (String)keyObject;
            synCtx.setProperty(stringKey, iteratedMsgCtx.getProperty(stringKey));
        }
    }

    @Override
    public boolean mediate(MessageContext synCtx, ContinuationState continuationState) {
        boolean result;
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Iterate mediator : Mediating from ContinuationState");
        }
        SequenceMediator branchSequence = this.target.getSequence();
        boolean isStatisticsEnabled = RuntimeStatisticCollector.isStatisticsEnabled();
        if (!continuationState.hasChild()) {
            result = branchSequence.mediate(synCtx, continuationState.getPosition() + 1);
        } else {
            FlowContinuableMediator mediator = (FlowContinuableMediator)((Object)branchSequence.getChild(continuationState.getPosition()));
            result = mediator.mediate(synCtx, continuationState.getChildContState());
            if (isStatisticsEnabled) {
                ((Mediator)((Object)mediator)).reportCloseStatistics(synCtx, null);
            }
        }
        if (isStatisticsEnabled) {
            branchSequence.reportCloseStatistics(synCtx, null);
        }
        return result;
    }

    private MessageContext getIteratedMessage(MessageContext synCtx, int msgNumber, int msgCount, Object rootJsonObject, Object node) throws AxisFault, JaxenException {
        MessageContext newCtx = MessageHelper.cloneMessageContext(synCtx);
        JsonUtil.removeJsonPayload((org.apache.axis2.context.MessageContext)((Axis2MessageContext)newCtx).getAxis2MessageContext());
        if (this.id != null) {
            newCtx.setProperty("aggregateCorelation." + this.id, synCtx.getMessageID());
            newCtx.setProperty("messageSequence." + this.id, msgNumber + "/" + msgCount);
        } else {
            newCtx.setProperty("messageSequence", msgNumber + "/" + msgCount);
        }
        Object rootObject = node;
        if (this.preservePayload) {
            rootObject = rootJsonObject;
            if (rootObject != null) {
                rootObject = ((SynapseJsonPath)this.attachPath).replace(rootObject, node);
            } else {
                this.handleException("Error in attaching the splitted elements :: Unable to get the attach path specified by the expression " + (Object)((Object)this.attachPath), synCtx);
            }
        }
        JsonUtil.getNewJsonPayload((org.apache.axis2.context.MessageContext)((Axis2MessageContext)newCtx).getAxis2MessageContext(), (String)rootObject.toString(), (boolean)true, (boolean)true);
        ((Axis2MessageContext)newCtx).getAxis2MessageContext().setServerSide(((Axis2MessageContext)synCtx).getAxis2MessageContext().isServerSide());
        return newCtx;
    }

    private MessageContext getIteratedMessage(MessageContext synCtx, int msgNumber, int msgCount, SOAPEnvelope envelope, OMNode o) throws AxisFault, JaxenException {
        MessageContext newCtx = MessageHelper.cloneMessageContext(synCtx, false, false);
        if (this.id != null) {
            newCtx.setProperty("aggregateCorelation." + this.id, synCtx.getMessageID());
            newCtx.setProperty("messageSequence." + this.id, msgNumber + "/" + msgCount);
        } else {
            newCtx.setProperty("messageSequence", msgNumber + "/" + msgCount);
        }
        SOAPEnvelope newEnvelope = MessageHelper.cloneSOAPEnvelope(envelope);
        if (this.preservePayload) {
            Object attachElem = ((SynapseXPath)this.attachPath).evaluate(newEnvelope, synCtx);
            if (attachElem != null && attachElem instanceof List && !((List)attachElem).isEmpty()) {
                attachElem = ((List)attachElem).get(0);
            }
            if (attachElem != null && attachElem instanceof OMElement) {
                ((OMElement)attachElem).addChild(o);
            } else {
                this.handleException("Error in attaching the splitted elements :: Unable to get the attach path specified by the expression " + (Object)((Object)this.attachPath), synCtx);
            }
        } else if (newEnvelope.getBody() != null) {
            if (newEnvelope.getBody().getFirstElement() != null) {
                newEnvelope.getBody().getFirstElement().detach();
            }
            newEnvelope.getBody().addChild(o);
        }
        newCtx.setEnvelope(newEnvelope);
        ((Axis2MessageContext)newCtx).getAxis2MessageContext().setServerSide(((Axis2MessageContext)synCtx).getAxis2MessageContext().isServerSide());
        return newCtx;
    }

    public boolean isContinueParent() {
        return this.continueParent;
    }

    public void setContinueParent(boolean continueParent) {
        this.continueParent = continueParent;
    }

    public boolean isPreservePayload() {
        return this.preservePayload;
    }

    public void setPreservePayload(boolean preservePayload) {
        this.preservePayload = preservePayload;
    }

    public SynapsePath getExpression() {
        return this.expression;
    }

    public void setExpression(SynapsePath expression) {
        this.expression = expression;
    }

    public SynapsePath getAttachPath() {
        return this.attachPath;
    }

    public void setAttachPath(SynapsePath attachPath) {
        this.attachPath = attachPath;
    }

    public Target getTarget() {
        return this.target;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public boolean isContentAltering() {
        return true;
    }

    public boolean isAttachPathPresent() {
        return this.isAttachPathPresent;
    }

    public void setAttachPathPresent(boolean attachPathPresent) {
        this.isAttachPathPresent = attachPathPresent;
    }

    @Override
    public void init(SynapseEnvironment se) {
        this.synapseEnv = se;
        if (this.target != null) {
            SequenceMediator targetSequence;
            SequenceMediator seq;
            Endpoint endpoint = this.target.getEndpoint();
            if (endpoint != null) {
                endpoint.init(se);
            }
            if ((seq = this.target.getSequence()) != null) {
                seq.init(se);
            } else if (this.target.getSequenceRef() != null && ((targetSequence = (SequenceMediator)se.getSynapseConfiguration().getSequence(this.target.getSequenceRef())) == null || targetSequence.isDynamic())) {
                se.addUnavailableArtifactRef(this.target.getSequenceRef());
            }
        }
    }

    @Override
    public void destroy() {
        if (this.target != null) {
            SequenceMediator targetSequence;
            SequenceMediator seq;
            Endpoint endpoint = this.target.getEndpoint();
            if (endpoint != null && endpoint.isInitialized()) {
                endpoint.destroy();
            }
            if ((seq = this.target.getSequence()) != null) {
                seq.destroy();
            } else if (this.target.getSequenceRef() != null && ((targetSequence = (SequenceMediator)this.synapseEnv.getSynapseConfiguration().getSequence(this.target.getSequenceRef())) == null || targetSequence.isDynamic())) {
                this.synapseEnv.removeUnavailableArtifactRef(this.target.getSequenceRef());
            }
        }
    }

    @Override
    public Integer reportOpenStatistics(MessageContext messageContext, boolean isContentAltering) {
        return OpenEventCollector.reportFlowSplittingEvent(messageContext, this.getMediatorName(), ComponentType.MEDIATOR, this.getAspectConfiguration(), this.isContentAltering() || isContentAltering);
    }

    @Override
    public void setComponentStatisticsId(ArtifactHolder holder) {
        if (this.getAspectConfiguration() == null) {
            this.configure(new AspectConfiguration(this.getMediatorName()));
        }
        String mediatorId = StatisticIdentityGenerator.getIdForFlowContinuableMediator(this.getMediatorName(), ComponentType.MEDIATOR, holder);
        this.getAspectConfiguration().setUniqueId(mediatorId);
        if (this.target != null) {
            this.target.setStatisticIdForMediators(holder);
        }
        StatisticIdentityGenerator.reportingFlowContinuableEndEvent(mediatorId, ComponentType.MEDIATOR, holder);
    }
}

