/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.eip.splitter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.OperationContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.synapse.ContinuationState;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.flow.statistics.StatisticIdentityGenerator;
import org.apache.synapse.aspects.flow.statistics.collectors.OpenEventCollector;
import org.apache.synapse.aspects.flow.statistics.collectors.RuntimeStatisticCollector;
import org.apache.synapse.aspects.flow.statistics.data.artifact.ArtifactHolder;
import org.apache.synapse.continuation.ContinuationStackManager;
import org.apache.synapse.continuation.ReliantContinuationState;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.FlowContinuableMediator;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.mediators.eip.SharedDataHolder;
import org.apache.synapse.mediators.eip.Target;
import org.apache.synapse.util.MessageHelper;

public class CloneMediator
extends AbstractMediator
implements ManagedLifecycle,
FlowContinuableMediator {
    private boolean continueParent = false;
    private List<Target> targets = new ArrayList<Target>();
    private String id = null;
    private boolean sequential = false;
    private SynapseEnvironment synapseEnv;
    private String iterations;
    private Value dynamicIterationsValue;
    private static final String ITERATION_INDEX_PROPERTY_NAME = "CLONED_ITERATION_INDEX";
    private static final String STOP_FLOW_ON_FAILURE_PROPERTY_NAME = "STOP_TARGET_EXECUTION_ON_FAILURE";

    @Override
    public boolean mediate(MessageContext synCtx) {
        if (synCtx.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(synCtx)) {
            return true;
        }
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : Clone mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        synCtx.setProperty(this.id != null ? "EIP_SHARED_DATA_HOLDER." + this.id : "EIP_SHARED_DATA_HOLDER", new SharedDataHolder());
        if (!StringUtils.isEmpty((CharSequence)this.iterations)) {
            this.executeTargetIterations(synCtx);
        } else {
            Iterator<Target> iter = this.targets.iterator();
            int i = 0;
            boolean isStopFlowOnFailure = "true".equalsIgnoreCase((String)synCtx.getProperty(STOP_FLOW_ON_FAILURE_PROPERTY_NAME));
            while (iter.hasNext()) {
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("Submitting " + (i + 1) + " of " + this.targets.size() + " messages for " + (this.isSequential() ? "sequential processing" : "parallel processing"));
                }
                MessageContext clonedMsgCtx = this.getClonedMessageContext(synCtx, i++, this.targets.size());
                ContinuationStackManager.addReliantContinuationState(clonedMsgCtx, i - 1, this.getMediatorPosition());
                iter.next().mediate(clonedMsgCtx);
                boolean isFailure = "true".equalsIgnoreCase((String)clonedMsgCtx.getProperty("ERROR_ON_TARGET_EXECUTION"));
                if (!isFailure || !this.sequential || !isStopFlowOnFailure) continue;
                break;
            }
        }
        OperationContext opCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext().getOperationContext();
        if (!this.continueParent && opCtx != null) {
            opCtx.setProperty("RESPONSE_WRITTEN", (Object)"SKIP");
        }
        synLog.traceOrDebug("End : Clone mediator");
        return this.continueParent;
    }

    private void executeTargetIterations(MessageContext synCtx) {
        int noOfIterations = this.resolveIterationsCount(synCtx);
        SynapseLog synLog = this.getLog(synCtx);
        Target target = this.targets.get(0);
        boolean isStopFlowOnFailure = "true".equalsIgnoreCase((String)synCtx.getProperty(STOP_FLOW_ON_FAILURE_PROPERTY_NAME));
        for (int i = 0; i < noOfIterations; ++i) {
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Submitting " + (i + 1) + " of " + noOfIterations + " messages for " + (this.isSequential() ? "sequential processing" : "parallel processing"));
            }
            synCtx.setProperty(ITERATION_INDEX_PROPERTY_NAME, i + 1);
            MessageContext clonedMsgCtx = this.getClonedMessageContext(synCtx, i, noOfIterations);
            ContinuationStackManager.addReliantContinuationState(clonedMsgCtx, i - 1, this.getMediatorPosition());
            target.mediate(clonedMsgCtx);
            boolean isFailure = "true".equalsIgnoreCase((String)clonedMsgCtx.getProperty("ERROR_ON_TARGET_EXECUTION"));
            if (isFailure && this.sequential && isStopFlowOnFailure) break;
        }
    }

    private int resolveIterationsCount(MessageContext synCtx) {
        String countStr = "";
        countStr = this.getDynamicIterationsValue() != null ? this.getDynamicIterationsValue().evaluateValue(synCtx) : this.getIterations();
        try {
            return Integer.parseInt(countStr.trim());
        }
        catch (NumberFormatException e) {
            this.handleException("Error while parsing iterations number in clone mediator", synCtx);
            return 0;
        }
    }

    @Override
    public boolean mediate(MessageContext synCtx, ContinuationState continuationState) {
        boolean result;
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Clone mediator : Mediating from ContinuationState");
        }
        int subBranch = ((ReliantContinuationState)continuationState).getSubBranch();
        SequenceMediator branchSequence = this.targets.get(subBranch).getSequence();
        boolean isStatisticsEnabled = RuntimeStatisticCollector.isStatisticsEnabled();
        if (!continuationState.hasChild()) {
            result = branchSequence.mediate(synCtx, continuationState.getPosition() + 1);
        } else {
            FlowContinuableMediator mediator = (FlowContinuableMediator)((Object)branchSequence.getChild(continuationState.getPosition()));
            result = mediator.mediate(synCtx, continuationState.getChildContState());
            if (isStatisticsEnabled) {
                ((Mediator)((Object)mediator)).reportCloseStatistics(synCtx, null);
            }
        }
        if (isStatisticsEnabled) {
            branchSequence.reportCloseStatistics(synCtx, null);
        }
        return result;
    }

    private MessageContext getClonedMessageContext(MessageContext synCtx, int messageSequence, int messageCount) {
        MessageContext newCtx = null;
        try {
            newCtx = MessageHelper.cloneMessageContext(synCtx);
            ((Axis2MessageContext)newCtx).getAxis2MessageContext().setServerSide(((Axis2MessageContext)synCtx).getAxis2MessageContext().isServerSide());
            if (this.id != null) {
                newCtx.setProperty("aggregateCorelation." + this.id, synCtx.getMessageID());
                newCtx.setProperty("messageSequence." + this.id, String.valueOf(messageSequence) + "/" + messageCount);
            } else {
                newCtx.setProperty("messageSequence", String.valueOf(messageSequence) + "/" + messageCount);
            }
        }
        catch (AxisFault axisFault) {
            this.handleException("Error cloning the message context", (Exception)((Object)axisFault), synCtx);
        }
        return newCtx;
    }

    public boolean isContinueParent() {
        return this.continueParent;
    }

    public void setContinueParent(boolean continueParent) {
        this.continueParent = continueParent;
    }

    public String getIterations() {
        return this.iterations;
    }

    public void setIterations(String iterations) {
        this.iterations = iterations;
    }

    public Value getDynamicIterationsValue() {
        return this.dynamicIterationsValue;
    }

    public void setDynamicIterationsValue(Value dynamicIterationsValue) {
        this.dynamicIterationsValue = dynamicIterationsValue;
    }

    public List<Target> getTargets() {
        return this.targets;
    }

    public void setTargets(List<Target> targets) {
        this.targets = targets;
    }

    public void addTarget(Target target) {
        this.targets.add(target);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isSequential() {
        return this.sequential;
    }

    public void setSequential(boolean sequential) {
        this.sequential = sequential;
    }

    @Override
    public boolean isContentAltering() {
        return true;
    }

    @Override
    public void init(SynapseEnvironment se) {
        this.synapseEnv = se;
        for (Target target : this.targets) {
            Endpoint endpoint;
            SequenceMediator targetSequence;
            SequenceMediator seq = target.getSequence();
            if (seq != null) {
                seq.init(se);
            } else if (target.getSequenceRef() != null && ((targetSequence = (SequenceMediator)se.getSynapseConfiguration().getSequence(target.getSequenceRef())) == null || targetSequence.isDynamic())) {
                se.addUnavailableArtifactRef(target.getSequenceRef());
            }
            if ((endpoint = target.getEndpoint()) == null) continue;
            endpoint.init(se);
        }
    }

    @Override
    public void destroy() {
        for (Target target : this.targets) {
            Endpoint endpoint;
            SequenceMediator targetSequence;
            SequenceMediator seq = target.getSequence();
            if (seq != null) {
                seq.destroy();
            } else if (target.getSequenceRef() != null && ((targetSequence = (SequenceMediator)this.synapseEnv.getSynapseConfiguration().getSequence(target.getSequenceRef())) == null || targetSequence.isDynamic())) {
                this.synapseEnv.removeUnavailableArtifactRef(target.getSequenceRef());
            }
            if ((endpoint = target.getEndpoint()) == null) continue;
            endpoint.destroy();
        }
    }

    @Override
    public Integer reportOpenStatistics(MessageContext messageContext, boolean isContentAltering) {
        return OpenEventCollector.reportFlowSplittingEvent(messageContext, this.getMediatorName(), ComponentType.MEDIATOR, this.getAspectConfiguration(), this.isContentAltering() || isContentAltering);
    }

    @Override
    public void setComponentStatisticsId(ArtifactHolder holder) {
        if (this.getAspectConfiguration() == null) {
            this.configure(new AspectConfiguration(this.getMediatorName()));
        }
        String sequenceId = StatisticIdentityGenerator.getIdForFlowContinuableMediator(this.getMediatorName(), ComponentType.MEDIATOR, holder);
        this.getAspectConfiguration().setUniqueId(sequenceId);
        for (Target target : this.targets) {
            target.setStatisticIdForMediators(holder);
        }
        StatisticIdentityGenerator.reportingFlowContinuableEndEvent(sequenceId, ComponentType.MEDIATOR, holder);
    }
}

