/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.eip.sample;

import java.util.Timer;
import java.util.TimerTask;
import org.apache.axis2.context.OperationContext;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.eip.Target;
import org.apache.synapse.mediators.eip.sample.MessageQueue;
import org.apache.synapse.mediators.eip.sample.UnboundedMessageQueue;

public class SamplingThrottleMediator
extends AbstractMediator
implements ManagedLifecycle {
    private int samplingRate = 1;
    private long unitTime = 1000L;
    private String id;
    private Target target;
    private MessageQueue messageQueue = new UnboundedMessageQueue();
    private boolean messageQueueExplicitlySet;
    private TimerTask messageProcessor;

    @Override
    public void init(SynapseEnvironment synapseEnvironment) {
        if (this.messageQueue.isPersistent()) {
            this.log.info((Object)"Loading the persisted messages if there are any to the message queue");
            this.messageQueue.load();
        }
        Timer samplingTimer = synapseEnvironment.getSynapseConfiguration().getSynapseTimer();
        this.messageProcessor = new MessageProcessor();
        this.log.info((Object)("Scheduling the sampling timer to invoke the message processor at an interval of : " + this.unitTime));
        samplingTimer.schedule(this.messageProcessor, 0L, this.unitTime);
    }

    @Override
    public void destroy() {
        this.messageProcessor.cancel();
        if (!this.messageQueue.isEmpty()) {
            this.log.warn((Object)"There are messages on the sampling message queue, but the message processor has been destroyed.");
            if (this.messageQueue.isPersistent()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Persisting the messages on the message queue");
                }
                if (this.messageQueue.persist()) {
                    this.log.info((Object)"Completed persisting the messages on the message queue");
                } else {
                    this.log.error((Object)"Couldn't persist the messages on the message queue");
                }
            } else {
                this.log.warn((Object)"You are not using a persistent message queue, you will be loosing messages which are on the queue");
            }
        }
    }

    @Override
    public boolean mediate(MessageContext messageContext) {
        if (messageContext.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(messageContext)) {
            return true;
        }
        SynapseLog synLog = this.getLog(messageContext);
        synLog.traceOrDebug("Start : Sampler mediator");
        if (synLog.isTraceTraceEnabled()) {
            synLog.traceTrace("Message : " + messageContext.getEnvelope());
        }
        if (!messageContext.isResponse()) {
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Adding the message with message id : " + messageContext.getMessageID() + " into the message queue for sampling");
            }
            this.messageQueue.add(messageContext);
        } else {
            synLog.auditWarn("Encountered a response message which will not be sampled");
        }
        OperationContext opCtx = ((Axis2MessageContext)messageContext).getAxis2MessageContext().getOperationContext();
        if (opCtx != null) {
            opCtx.setProperty("RESPONSE_WRITTEN", (Object)"SKIP");
        }
        synLog.traceOrDebug("End : Sampler mediator");
        return false;
    }

    public int getSamplingRate() {
        return this.samplingRate;
    }

    public void setSamplingRate(int samplingRate) {
        this.samplingRate = samplingRate;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Target getTarget() {
        return this.target;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public long getUnitTime() {
        return this.unitTime;
    }

    public void setUnitTime(long unitTime) {
        this.unitTime = unitTime;
    }

    public MessageQueue getMessageQueue() {
        return this.messageQueue;
    }

    public void setMessageQueue(MessageQueue messageQueue) {
        this.messageQueue = messageQueue;
        this.messageQueueExplicitlySet = true;
    }

    public boolean isMessageQueueExplicitlySet() {
        return this.messageQueueExplicitlySet;
    }

    private class MessageProcessor
    extends TimerTask {
        private MessageProcessor() {
        }

        @Override
        public void run() {
            if (SamplingThrottleMediator.this.log.isDebugEnabled()) {
                SamplingThrottleMediator.this.log.debug((Object)"Started running the message processor");
            }
            for (int i = 0; i < SamplingThrottleMediator.this.samplingRate && !SamplingThrottleMediator.this.messageQueue.isEmpty(); ++i) {
                MessageContext synCtx = SamplingThrottleMediator.this.messageQueue.get();
                if (SamplingThrottleMediator.this.log.isDebugEnabled()) {
                    SamplingThrottleMediator.this.log.debug((Object)("Mediating the message on the message queue with message id : " + synCtx.getMessageID()));
                }
                SamplingThrottleMediator.this.target.mediate(synCtx);
            }
            if (SamplingThrottleMediator.this.log.isDebugEnabled()) {
                SamplingThrottleMediator.this.log.debug((Object)"Message processing completed for the given sampling rate");
            }
        }
    }
}

