/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.eip.aggregator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ContinuationState;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.flow.statistics.StatisticIdentityGenerator;
import org.apache.synapse.aspects.flow.statistics.collectors.OpenEventCollector;
import org.apache.synapse.aspects.flow.statistics.collectors.RuntimeStatisticCollector;
import org.apache.synapse.aspects.flow.statistics.data.artifact.ArtifactHolder;
import org.apache.synapse.aspects.flow.statistics.util.StatisticDataCollectionHelper;
import org.apache.synapse.commons.json.JsonUtil;
import org.apache.synapse.config.xml.SynapsePath;
import org.apache.synapse.continuation.ContinuationStackManager;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.FlowContinuableMediator;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.mediators.eip.EIPUtils;
import org.apache.synapse.mediators.eip.SharedDataHolder;
import org.apache.synapse.mediators.eip.aggregator.Aggregate;
import org.apache.synapse.util.JSONMergeUtils;
import org.apache.synapse.util.MessageHelper;
import org.apache.synapse.util.xpath.SynapseJsonPath;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class AggregateMediator
extends AbstractMediator
implements ManagedLifecycle,
FlowContinuableMediator {
    private static final Log log = LogFactory.getLog(AggregateMediator.class);
    private long completionTimeoutMillis;
    private Value minMessagesToComplete;
    private Value maxMessagesToComplete;
    private SynapsePath correlateExpression;
    private SynapsePath aggregationExpression;
    private Value aggregateElementType;
    private String onCompleteSequenceRef;
    private SequenceMediator onCompleteSequence;
    private Map<String, Aggregate> activeAggregates;
    private String id;
    private String enclosingElementPropertyName;
    private final Object lock;
    private SynapseEnvironment synapseEnv;
    private boolean isAggregateComplete;
    private boolean isAggregationMessageCollected;

    public AggregateMediator() {
        block2: {
            this.completionTimeoutMillis = 0L;
            this.correlateExpression = null;
            this.aggregationExpression = null;
            this.onCompleteSequenceRef = null;
            this.onCompleteSequence = null;
            this.activeAggregates = Collections.synchronizedMap(new HashMap());
            this.id = null;
            this.enclosingElementPropertyName = null;
            this.lock = new Object();
            this.isAggregateComplete = false;
            this.isAggregationMessageCollected = false;
            try {
                this.aggregationExpression = new SynapseXPath("/s11:Envelope/s11:Body/child::*[position()=1] | /s12:Envelope/s12:Body/child::*[position()=1]");
                this.aggregationExpression.addNamespace("s11", "http://schemas.xmlsoap.org/soap/envelope/");
                this.aggregationExpression.addNamespace("s12", "http://www.w3.org/2003/05/soap-envelope");
            }
            catch (JaxenException e) {
                if (!log.isDebugEnabled()) break block2;
                this.handleException("Unable to set the default aggregationExpression for the aggregation", (Exception)((Object)e), null);
            }
        }
    }

    @Override
    public void init(SynapseEnvironment se) {
        SequenceMediator referredOnCompleteSeq;
        this.synapseEnv = se;
        if (this.onCompleteSequence != null) {
            this.onCompleteSequence.init(se);
        } else if (this.onCompleteSequenceRef != null && ((referredOnCompleteSeq = (SequenceMediator)se.getSynapseConfiguration().getSequence(this.onCompleteSequenceRef)) == null || referredOnCompleteSeq.isDynamic())) {
            se.addUnavailableArtifactRef(this.onCompleteSequenceRef);
        }
    }

    @Override
    public void destroy() {
        SequenceMediator referredOnCompleteSeq;
        if (this.onCompleteSequence != null) {
            this.onCompleteSequence.destroy();
        } else if (this.onCompleteSequenceRef != null && ((referredOnCompleteSeq = (SequenceMediator)this.synapseEnv.getSynapseConfiguration().getSequence(this.onCompleteSequenceRef)) == null || referredOnCompleteSeq.isDynamic())) {
            this.synapseEnv.removeUnavailableArtifactRef(this.onCompleteSequenceRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean mediate(MessageContext synCtx) {
        SynapseLog synLog;
        block41: {
            Aggregate aggregate;
            block42: {
                String correlation;
                block40: {
                    block39: {
                        if (synCtx.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(synCtx)) {
                            return true;
                        }
                        synLog = this.getLog(synCtx);
                        if (synLog.isTraceOrDebugEnabled()) {
                            synLog.traceOrDebug("Start : Aggregate mediator");
                            if (synLog.isTraceTraceEnabled()) {
                                synLog.traceTrace("Message : " + synCtx.getEnvelope());
                            }
                        }
                        try {
                            aggregate = null;
                            String correlationIdName = this.id != null ? "aggregateCorelation." + this.id : "aggregateCorelation";
                            Object result = null;
                            if (this.correlateExpression != null) {
                                Object object = result = this.correlateExpression instanceof SynapseXPath ? this.correlateExpression.evaluate(synCtx) : ((SynapseJsonPath)this.correlateExpression).evaluate(synCtx);
                                if (result instanceof List && ((List)result).isEmpty()) {
                                    this.handleException("Failed to evaluate correlate expression: " + this.correlateExpression.toString(), synCtx);
                                }
                                if (result instanceof Boolean && !((Boolean)result).booleanValue()) {
                                    return true;
                                }
                            }
                            if (result != null) break block39;
                            if (synCtx.getProperty(correlationIdName) == null) {
                                synLog.traceOrDebug("Unable to find aggrgation correlation XPath or property");
                                return true;
                            }
                            Object o = synCtx.getProperty(correlationIdName);
                            if (o != null && o instanceof String) {
                                correlation = (String)o;
                                break block40;
                            }
                            synLog.traceOrDebug("Unable to find aggrgation correlation property");
                            return true;
                        }
                        catch (JaxenException e) {
                            this.handleException("Unable to execute the XPATH over the message", (Exception)((Object)e), synCtx);
                            break block41;
                        }
                    }
                    while (aggregate == null) {
                        Object object = this.lock;
                        synchronized (object) {
                            if (this.activeAggregates.containsKey(this.correlateExpression.toString())) {
                                aggregate = this.activeAggregates.get(this.correlateExpression.toString());
                                if (aggregate != null && !aggregate.getLock()) {
                                    aggregate = null;
                                }
                            } else {
                                if (synLog.isTraceOrDebugEnabled()) {
                                    synLog.traceOrDebug("Creating new Aggregator - " + (this.completionTimeoutMillis > 0L ? "expires in : " + this.completionTimeoutMillis / 1000L + "secs" : "without expiry time"));
                                }
                                if (this.isAggregationCompleted(synCtx)) {
                                    return false;
                                }
                                Double minMsg = Double.parseDouble(this.minMessagesToComplete.evaluateValue(synCtx));
                                Double maxMsg = Double.parseDouble(this.maxMessagesToComplete.evaluateValue(synCtx));
                                aggregate = new Aggregate(synCtx.getEnvironment(), this.correlateExpression.toString(), this.completionTimeoutMillis, minMsg.intValue(), maxMsg.intValue(), this, synCtx.getFaultStack().peek());
                                if (this.completionTimeoutMillis > 0L) {
                                    synCtx.getConfiguration().getSynapseTimer().schedule((TimerTask)aggregate, this.completionTimeoutMillis);
                                }
                                aggregate.getLock();
                                this.activeAggregates.put(this.correlateExpression.toString(), aggregate);
                            }
                        }
                    }
                    break block42;
                }
                while (aggregate == null) {
                    Object object = this.lock;
                    synchronized (object) {
                        block43: {
                            if (!this.activeAggregates.containsKey(correlation)) break block43;
                            aggregate = this.activeAggregates.get(correlation);
                            if (aggregate != null) {
                                if (!aggregate.getLock()) {
                                    aggregate = null;
                                }
                            } else {
                                break;
                            }
                        }
                        if (synLog.isTraceOrDebugEnabled()) {
                            synLog.traceOrDebug("Creating new Aggregator - " + (this.completionTimeoutMillis > 0L ? "expires in : " + this.completionTimeoutMillis / 1000L + "secs" : "without expiry time"));
                        }
                        if (this.isAggregationCompleted(synCtx)) {
                            return false;
                        }
                        Double minMsg = -1.0;
                        if (this.minMessagesToComplete != null) {
                            minMsg = Double.parseDouble(this.minMessagesToComplete.evaluateValue(synCtx));
                        }
                        Double maxMsg = -1.0;
                        if (this.maxMessagesToComplete != null) {
                            maxMsg = Double.parseDouble(this.maxMessagesToComplete.evaluateValue(synCtx));
                        }
                        aggregate = new Aggregate(synCtx.getEnvironment(), correlation, this.completionTimeoutMillis, minMsg.intValue(), maxMsg.intValue(), this, synCtx.getFaultStack().peek());
                        if (this.completionTimeoutMillis > 0L) {
                            Aggregate aggregate2 = aggregate;
                            synchronized (aggregate2) {
                                if (!aggregate.isCompleted()) {
                                    try {
                                        synCtx.getConfiguration().getSynapseTimer().schedule((TimerTask)aggregate, this.completionTimeoutMillis);
                                    }
                                    catch (IllegalStateException e) {
                                        log.warn((Object)"Synapse timer already cancelled. Resetting Synapse timer");
                                        synCtx.getConfiguration().setSynapseTimer(new Timer(true));
                                        synCtx.getConfiguration().getSynapseTimer().schedule((TimerTask)aggregate, this.completionTimeoutMillis);
                                    }
                                }
                            }
                        }
                        aggregate.getLock();
                        this.activeAggregates.put(correlation, aggregate);
                    }
                }
            }
            if (aggregate == null) {
                synLog.traceOrDebug("Unable to find an aggregate for this message - skip");
                return true;
            }
            synCtx.getEnvelope().build();
            boolean collected = aggregate.addMessage(synCtx);
            if (synLog.isTraceOrDebugEnabled() && collected) {
                synLog.traceOrDebug("Collected a message during aggregation");
                if (synLog.isTraceTraceEnabled()) {
                    synLog.traceTrace("Collected message : " + synCtx);
                }
            }
            if (aggregate.isComplete(synLog)) {
                synLog.traceOrDebug("Aggregation completed - invoking onComplete");
                boolean onCompleteSeqResult = this.completeAggregate(aggregate);
                synLog.traceOrDebug("End : Aggregate mediator");
                this.isAggregateComplete = onCompleteSeqResult;
                return onCompleteSeqResult;
            }
            aggregate.releaseLock();
        }
        synLog.traceOrDebug("End : Aggregate mediator");
        return false;
    }

    private boolean isAggregationCompleted(MessageContext synCtx) {
        SharedDataHolder sharedDataHolder;
        Object aggregateTimeoutHolderObj = synCtx.getProperty(this.id != null ? "EIP_SHARED_DATA_HOLDER." + this.id : "EIP_SHARED_DATA_HOLDER");
        if (aggregateTimeoutHolderObj != null && (sharedDataHolder = (SharedDataHolder)aggregateTimeoutHolderObj).isAggregationCompleted()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Received a response for already completed Aggregate");
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mediate(MessageContext synCtx, ContinuationState contState) {
        boolean result;
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Aggregate mediator : Mediating from ContinuationState");
        }
        SequenceMediator onCompleteSequence = this.getOnCompleteSequence();
        boolean isStatisticsEnabled = RuntimeStatisticCollector.isStatisticsEnabled();
        if (!contState.hasChild()) {
            result = onCompleteSequence.mediate(synCtx, contState.getPosition() + 1);
        } else {
            FlowContinuableMediator mediator = (FlowContinuableMediator)((Object)onCompleteSequence.getChild(contState.getPosition()));
            result = mediator.mediate(synCtx, contState.getChildContState());
            if (isStatisticsEnabled) {
                ((Mediator)((Object)mediator)).reportCloseStatistics(synCtx, null);
            }
        }
        if (isStatisticsEnabled) {
            onCompleteSequence.reportCloseStatistics(synCtx, null);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean completeAggregate(Aggregate aggregate) {
        boolean markedCompletedNow = false;
        boolean wasComplete = aggregate.isCompleted();
        if (wasComplete) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Aggregation completed or timed out");
        }
        AggregateMediator aggregateMediator = this;
        synchronized (aggregateMediator) {
            if (!aggregate.isCompleted()) {
                Object aggregateTimeoutHolderObj;
                aggregate.cancel();
                aggregate.setCompleted(true);
                MessageContext lastMessage = aggregate.getLastMessage();
                if (lastMessage != null && (aggregateTimeoutHolderObj = lastMessage.getProperty(this.id != null ? "EIP_SHARED_DATA_HOLDER." + this.id : "EIP_SHARED_DATA_HOLDER")) != null) {
                    SharedDataHolder sharedDataHolder = (SharedDataHolder)aggregateTimeoutHolderObj;
                    sharedDataHolder.markAggregationCompletion();
                }
                markedCompletedNow = true;
            }
        }
        if (!markedCompletedNow) {
            return false;
        }
        MessageContext newSynCtx = this.getAggregatedMessage(aggregate);
        if (newSynCtx == null) {
            log.warn((Object)"An aggregation of messages timed out with no aggregated messages", null);
            return false;
        }
        this.isAggregationMessageCollected = true;
        if (newSynCtx.isContinuationEnabled()) {
            try {
                aggregate.getLastMessage().setEnvelope(MessageHelper.cloneSOAPEnvelope(newSynCtx.getEnvelope()));
            }
            catch (AxisFault axisFault) {
                log.warn((Object)"Error occurred while assigning aggregated message back to the last received message context");
            }
        }
        aggregate.clear();
        this.activeAggregates.remove(aggregate.getCorrelation());
        if (this.correlateExpression != null && this.correlateExpression.toString().equals(aggregate.getCorrelation()) || this.correlateExpression == null) {
            if (this.onCompleteSequence != null) {
                ContinuationStackManager.addReliantContinuationState(newSynCtx, 0, this.getMediatorPosition());
                boolean result = this.onCompleteSequence.mediate(newSynCtx);
                if (result) {
                    ContinuationStackManager.removeReliantContinuationState(newSynCtx);
                }
                return result;
            }
            if (this.onCompleteSequenceRef != null && newSynCtx.getSequence(this.onCompleteSequenceRef) != null) {
                ContinuationStackManager.updateSeqContinuationState(newSynCtx, this.getMediatorPosition());
                return newSynCtx.getSequence(this.onCompleteSequenceRef).mediate(newSynCtx);
            }
            this.handleException("Unable to find the sequence for the mediation of the aggregated message", newSynCtx);
        }
        return false;
    }

    private MessageContext getAggregatedMessage(Aggregate aggregate) {
        MessageContext newCtx = null;
        JsonArray jsonArray = new JsonArray();
        boolean isJSONAggregation = this.aggregationExpression instanceof SynapseJsonPath;
        JsonObject resultJSONObject = new JsonObject();
        for (MessageContext synCtx : aggregate.getMessages()) {
            if (newCtx == null) {
                try {
                    newCtx = MessageHelper.cloneMessageContext(synCtx, true, false, true);
                }
                catch (AxisFault axisFault) {
                    this.handleException(aggregate, "Error creating a copy of the message", (Exception)((Object)axisFault), synCtx);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Generating Aggregated message from : " + newCtx.getEnvelope()));
                }
                if (isJSONAggregation) {
                    if (this.getAggregateElementType() != null) {
                        if ("root".equals(this.getAggregateElementType().getKeyValue())) {
                            jsonArray.add(EIPUtils.getJSONElement(synCtx, (SynapseJsonPath)this.aggregationExpression));
                            continue;
                        }
                        if (!"child".equals(this.getAggregateElementType().getKeyValue())) continue;
                        try {
                            JSONMergeUtils.extendJSONObject(resultJSONObject, JSONMergeUtils.ConflictStrategy.MERGE_INTO_ARRAY, EIPUtils.getJSONObjectAsElement(synCtx, (SynapseJsonPath)this.aggregationExpression).getAsJsonObject());
                        }
                        catch (Exception e) {
                            this.handleException(aggregate, "Error merging aggregation results using JSONPath : " + this.aggregationExpression.toString(), e, synCtx);
                        }
                        continue;
                    }
                    jsonArray.add(EIPUtils.getJSONElement(synCtx, (SynapseJsonPath)this.aggregationExpression));
                    continue;
                }
                try {
                    EIPUtils.enrichEnvelope(newCtx.getEnvelope(), synCtx, (SynapseXPath)this.aggregationExpression);
                }
                catch (JaxenException e) {
                    this.handleException(aggregate, "Error merging aggregation results using XPath : " + this.aggregationExpression.toString(), (Exception)((Object)e), synCtx);
                }
                continue;
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Merging message : " + synCtx.getEnvelope() + " using XPath : " + (Object)((Object)this.aggregationExpression)));
                }
                if (isJSONAggregation) {
                    if (this.getAggregateElementType() != null) {
                        if ("root".equals(this.getAggregateElementType().getKeyValue())) {
                            jsonArray.add(EIPUtils.getJSONElement(synCtx, (SynapseJsonPath)this.aggregationExpression));
                        } else if ("child".equals(this.getAggregateElementType().getKeyValue())) {
                            try {
                                JSONMergeUtils.extendJSONObject(resultJSONObject, JSONMergeUtils.ConflictStrategy.MERGE_INTO_ARRAY, EIPUtils.getJSONObjectAsElement(synCtx, (SynapseJsonPath)this.aggregationExpression).getAsJsonObject());
                            }
                            catch (Exception e) {
                                this.handleException(aggregate, "Error merging aggregation results using JSONPath : " + this.aggregationExpression.toString(), e, synCtx);
                            }
                        }
                    } else {
                        jsonArray.add(EIPUtils.getJSONElement(synCtx, (SynapseJsonPath)this.aggregationExpression));
                    }
                } else {
                    EIPUtils.enrichEnvelope(newCtx.getEnvelope(), synCtx.getEnvelope(), synCtx, (SynapseXPath)this.aggregationExpression);
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Merged result : " + newCtx.getEnvelope()));
            }
            catch (JaxenException e) {
                this.handleException(aggregate, "Error merging aggregation results using XPath : " + this.aggregationExpression.toString(), (Exception)((Object)e), synCtx);
            }
            catch (SynapseException e) {
                this.handleException(aggregate, "Error evaluating expression: " + this.aggregationExpression.toString(), e, synCtx);
            }
            catch (JsonSyntaxException e) {
                this.handleException(aggregate, "Error reading JSON element: " + this.aggregationExpression.toString(), (Exception)((Object)e), synCtx);
            }
        }
        Object result = this.getAggregateElementType() != null && "child".equals(this.getAggregateElementType().getKeyValue()) ? resultJSONObject : jsonArray;
        if (this.enclosingElementPropertyName != null) {
            Object enclosingElementProperty;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Enclosing the aggregated message with enclosing element: " + this.enclosingElementPropertyName));
            }
            if ((enclosingElementProperty = newCtx.getProperty(this.enclosingElementPropertyName)) != null) {
                if (enclosingElementProperty instanceof OMElement) {
                    OMElement enclosingElement = ((OMElement)enclosingElementProperty).cloneOMElement();
                    if (isJSONAggregation) {
                        JsonObject jsonObject = new JsonObject();
                        String key = enclosingElement.getLocalName();
                        if (this.getAggregateElementType() != null && "child".equals(this.getAggregateElementType().getKeyValue())) {
                            jsonObject.add(key, (JsonElement)resultJSONObject);
                        } else {
                            jsonObject.add(key, (JsonElement)jsonArray);
                        }
                        result = jsonObject;
                    } else {
                        EIPUtils.encloseWithElement(newCtx.getEnvelope(), enclosingElement);
                    }
                } else {
                    this.handleException(aggregate, "Enclosing Element defined in the property: " + this.enclosingElementPropertyName + " is not an OMElement ", null, newCtx);
                }
            } else {
                this.handleException(aggregate, "Enclosing Element property: " + this.enclosingElementPropertyName + " not found ", null, newCtx);
            }
        }
        StatisticDataCollectionHelper.collectAggregatedParents(aggregate.getMessages(), newCtx);
        if (isJSONAggregation) {
            try {
                JsonUtil.getNewJsonPayload((org.apache.axis2.context.MessageContext)((Axis2MessageContext)newCtx).getAxis2MessageContext(), (InputStream)new ByteArrayInputStream(result.toString().getBytes()), (boolean)true, (boolean)true);
            }
            catch (AxisFault axisFault) {
                log.error((Object)"Error occurred while setting the new JSON payload to the msg context", (Throwable)axisFault);
            }
        } else {
            ((Axis2MessageContext)newCtx).getAxis2MessageContext().removeProperty("org.apache.synapse.commons.json.JsonInputStream");
        }
        return newCtx;
    }

    public SynapsePath getCorrelateExpression() {
        return this.correlateExpression;
    }

    public void setCorrelateExpression(SynapsePath correlateExpression) {
        this.correlateExpression = correlateExpression;
    }

    public long getCompletionTimeoutMillis() {
        return this.completionTimeoutMillis;
    }

    public void setCompletionTimeoutMillis(long completionTimeoutMillis) {
        this.completionTimeoutMillis = completionTimeoutMillis;
    }

    public SynapsePath getAggregationExpression() {
        return this.aggregationExpression;
    }

    public void setAggregationExpression(SynapsePath aggregationExpression) {
        this.aggregationExpression = aggregationExpression;
    }

    public String getOnCompleteSequenceRef() {
        return this.onCompleteSequenceRef;
    }

    public void setOnCompleteSequenceRef(String onCompleteSequenceRef) {
        this.onCompleteSequenceRef = onCompleteSequenceRef;
    }

    public SequenceMediator getOnCompleteSequence() {
        return this.onCompleteSequence;
    }

    public void setOnCompleteSequence(SequenceMediator onCompleteSequence) {
        this.onCompleteSequence = onCompleteSequence;
    }

    public Map getActiveAggregates() {
        return this.activeAggregates;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Value getMinMessagesToComplete() {
        return this.minMessagesToComplete;
    }

    public void setMinMessagesToComplete(Value minMessagesToComplete) {
        this.minMessagesToComplete = minMessagesToComplete;
    }

    public Value getMaxMessagesToComplete() {
        return this.maxMessagesToComplete;
    }

    public void setMaxMessagesToComplete(Value maxMessagesToComplete) {
        this.maxMessagesToComplete = maxMessagesToComplete;
    }

    public String getEnclosingElementPropertyName() {
        return this.enclosingElementPropertyName;
    }

    public void setEnclosingElementPropertyName(String enclosingElementPropertyName) {
        this.enclosingElementPropertyName = enclosingElementPropertyName;
    }

    public Value getAggregateElementType() {
        return this.aggregateElementType;
    }

    public void setAggregateElementType(Value aggregateElementType) {
        this.aggregateElementType = aggregateElementType;
    }

    @Override
    public boolean isContentAltering() {
        return true;
    }

    @Override
    public Integer reportOpenStatistics(MessageContext messageContext, boolean isContentAltering) {
        return OpenEventCollector.reportFlowAggregateEvent(messageContext, this.getMediatorName(), ComponentType.MEDIATOR, this.getAspectConfiguration(), this.isContentAltering() || isContentAltering);
    }

    @Override
    public void setComponentStatisticsId(ArtifactHolder holder) {
        if (this.getAspectConfiguration() == null) {
            this.configure(new AspectConfiguration(this.getMediatorName()));
        }
        String mediatorId = StatisticIdentityGenerator.getIdForFlowContinuableMediator(this.getMediatorName(), ComponentType.MEDIATOR, holder);
        this.getAspectConfiguration().setUniqueId(mediatorId);
        if (this.onCompleteSequence != null) {
            this.onCompleteSequence.setComponentStatisticsId(holder);
        } else if (this.onCompleteSequenceRef != null) {
            String childId = StatisticIdentityGenerator.getIdReferencingComponent(this.onCompleteSequenceRef, ComponentType.SEQUENCE, holder);
            StatisticIdentityGenerator.reportingEndEvent(childId, ComponentType.SEQUENCE, holder);
        }
        StatisticIdentityGenerator.reportingFlowContinuableEndEvent(mediatorId, ComponentType.MEDIATOR, holder);
    }

    private void handleException(Aggregate aggregate, String msg, Exception exception, MessageContext msgContext) {
        aggregate.clear();
        this.activeAggregates.clear();
        if (exception != null) {
            super.handleException(msg, exception, msgContext);
        } else {
            super.handleException(msg, msgContext);
        }
    }
}

