/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.eip.aggregator;

import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.mediators.eip.aggregator.AggregateMediator;

public class Aggregate
extends TimerTask {
    private static final Log log = LogFactory.getLog(Aggregate.class);
    private long timeoutMillis = 0L;
    private long expiryTimeMillis = 0L;
    private int minCount = -1;
    private int maxCount = -1;
    private String correlation = null;
    private AggregateMediator aggregateMediator = null;
    private List<MessageContext> messages = new ArrayList<MessageContext>();
    private boolean locked = false;
    private boolean completed = false;
    private SynapseEnvironment synEnv = null;
    private FaultHandler faultHandler;

    public Aggregate(SynapseEnvironment synEnv, String corelation, long timeoutMillis, int min, int max, AggregateMediator mediator, FaultHandler faultHandler) {
        this.synEnv = synEnv;
        this.correlation = corelation;
        if (timeoutMillis > 0L) {
            this.expiryTimeMillis = System.currentTimeMillis() + timeoutMillis;
        }
        if (min > 0) {
            this.minCount = min;
        }
        if (max > 0) {
            this.maxCount = max;
        }
        this.faultHandler = faultHandler;
        this.aggregateMediator = mediator;
    }

    public synchronized boolean addMessage(MessageContext synCtx) {
        if (this.maxCount <= 0 || this.maxCount > 0 && this.messages.size() < this.maxCount) {
            this.messages.add(synCtx);
            return true;
        }
        return false;
    }

    public synchronized boolean isComplete(SynapseLog synLog) {
        if (!this.completed) {
            if (!this.messages.isEmpty()) {
                MessageContext mc = this.messages.get(0);
                Object prop = mc.getProperty("messageSequence" + (this.aggregateMediator.getId() != null ? "." + this.aggregateMediator.getId() : ""));
                if (prop != null && prop instanceof String) {
                    String[] msgSequence = prop.toString().split("/");
                    int total = Integer.parseInt(msgSequence[1]);
                    if (synLog.isTraceOrDebugEnabled()) {
                        synLog.traceOrDebug(this.messages.size() + " messages of " + total + " collected in current aggregation");
                    }
                    if (this.messages.size() >= total) {
                        synLog.traceOrDebug("Aggregation complete");
                        return true;
                    }
                }
            } else {
                synLog.traceOrDebug("No messages collected in current aggregation");
            }
            if (this.minCount > 0 && this.messages.size() >= this.minCount) {
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("Aggregation complete - the minimum : " + this.minCount + " messages has been reached");
                }
                return true;
            }
            if (this.maxCount > 0 && this.messages.size() >= this.maxCount) {
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("Aggregation complete - the maximum : " + this.maxCount + " messages has been reached");
                }
                return true;
            }
            if (this.expiryTimeMillis > 0L && System.currentTimeMillis() >= this.expiryTimeMillis) {
                synLog.traceOrDebug("Aggregation complete - the aggregation has timed out");
                return true;
            }
        } else {
            synLog.traceOrDebug("Aggregation already completed - this message will not be processed in aggregation");
        }
        return false;
    }

    public MessageContext getLastMessage() {
        return this.messages.get(this.messages.size() - 1);
    }

    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public void setTimeoutMillis(long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public void setMinCount(int minCount) {
        this.minCount = minCount;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public String getCorrelation() {
        return this.correlation;
    }

    public void setCorrelation(String correlation) {
        this.correlation = correlation;
    }

    public synchronized List<MessageContext> getMessages() {
        return new ArrayList<MessageContext>(this.messages);
    }

    public void setMessages(List<MessageContext> messages) {
        this.messages = messages;
    }

    public long getExpiryTimeMillis() {
        return this.expiryTimeMillis;
    }

    public void setExpiryTimeMillis(long expiryTimeMillis) {
        this.expiryTimeMillis = expiryTimeMillis;
    }

    @Override
    public void run() {
        while (!this.completed) {
            if (!this.getLock()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Time : " + System.currentTimeMillis() + " and this aggregator expired at : " + this.expiryTimeMillis));
            }
            this.synEnv.getExecutorService().execute(new AggregateTimeout(this));
            break;
        }
    }

    public void clear() {
        this.messages = null;
    }

    public synchronized boolean getLock() {
        return !this.locked;
    }

    public void releaseLock() {
        this.locked = false;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    private class AggregateTimeout
    implements Runnable {
        private Aggregate aggregate = null;

        AggregateTimeout(Aggregate aggregate2) {
            this.aggregate = aggregate2;
        }

        @Override
        public void run() {
            MessageContext messageContext = this.aggregate.getLastMessage();
            try {
                log.warn((Object)"Aggregate mediator timeout occurred.");
                Aggregate.this.aggregateMediator.completeAggregate(this.aggregate);
            }
            catch (Exception ex) {
                if (Aggregate.this.faultHandler != null && messageContext != null) {
                    Aggregate.this.faultHandler.handleFault(messageContext, ex);
                }
                log.error((Object)("Synapse encountered an exception, No error handlers found or no messages were aggregated - [Message Dropped]\n" + ex.getMessage()));
            }
        }
    }
}

