/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.eip;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.spi.json.GsonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.GsonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.JSONObjectExtensionException;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.util.JSONMergeUtils;
import org.apache.synapse.util.xpath.SynapseJsonPath;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class EIPUtils {
    private static final Log log = LogFactory.getLog(EIPUtils.class);
    private static final String JSON_MEMBERS = "members";
    private static final String JSON_ELEMENTS = "elements";

    public static List getMatchingElements(SOAPEnvelope envelope, SynapseXPath expression) throws JaxenException {
        return EIPUtils.getMatchingElements(envelope, null, expression);
    }

    public static List getMatchingElements(SOAPEnvelope envelope, MessageContext synCtxt, SynapseXPath expression) throws JaxenException {
        Object o = expression.evaluate(envelope, synCtxt);
        if (o instanceof OMNode) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(o);
            return list;
        }
        if (o instanceof List) {
            return (List)o;
        }
        return new ArrayList();
    }

    public static List<OMNode> getDetachedMatchingElements(SOAPEnvelope envelope, MessageContext synCtxt, SynapseXPath expression) throws JaxenException {
        ArrayList<OMNode> elementList = new ArrayList<OMNode>();
        Object o = expression.evaluate(envelope, synCtxt);
        if (o instanceof OMNode) {
            elementList.add(((OMNode)o).detach());
        } else if (o instanceof List) {
            for (Object elem : (List)o) {
                if (!(elem instanceof OMNode)) continue;
                elementList.add(((OMNode)elem).detach());
            }
        }
        return elementList;
    }

    public static void enrichEnvelope(SOAPEnvelope envelope, MessageContext synCtxt, SynapseXPath expression) throws JaxenException {
        Object o;
        List elementList = EIPUtils.getMatchingElements(envelope, synCtxt, expression);
        if (EIPUtils.checkNotEmpty(elementList) && (o = elementList.get(0)) instanceof OMElement && ((OMElement)o).getParent() != null && ((OMElement)o).getParent() instanceof OMElement) {
            OMElement enrichingElement = (OMElement)((OMElement)o).getParent();
            SOAPBody body = envelope.getBody();
            if (!EIPUtils.isBody((OMElement)body, enrichingElement)) {
                OMElement nonBodyElem = enrichingElement;
                enrichingElement = envelope.getBody();
                EIPUtils.addChildren(elementList, enrichingElement);
                while (!EIPUtils.isBody((OMElement)body, (OMElement)nonBodyElem.getParent())) {
                    nonBodyElem = (OMElement)nonBodyElem.getParent();
                }
                nonBodyElem.detach();
            }
        }
    }

    public static void enrichEnvelope(SOAPEnvelope envelope, SOAPEnvelope enricher, MessageContext synCtxt, SynapseXPath expression) throws JaxenException {
        SOAPBody enrichingElement;
        enricher.toString();
        List list = EIPUtils.getMatchingElements(enricher, synCtxt, expression);
        if (EIPUtils.checkNotEmpty(list)) {
            enrichingElement = envelope.getBody();
            for (Object child : list) {
                if (!(child instanceof SOAPEnvelope)) continue;
                throw new SynapseException("Could not add SOAPEnvelope as child element.");
            }
        } else {
            throw new SynapseException("Could not find matching elements to aggregate.");
        }
        EIPUtils.addChildren(list, (OMElement)enrichingElement);
    }

    private static boolean isBody(OMElement body, OMElement enrichingElement) {
        try {
            return body.getLocalName().equals(enrichingElement.getLocalName()) && body.getNamespace().getNamespaceURI().equals(enrichingElement.getNamespace().getNamespaceURI());
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    private static boolean checkNotEmpty(List list) {
        return list != null && !list.isEmpty();
    }

    private static void addChildren(List list, OMElement element) {
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (o != null && o instanceof OMElement) {
                element.addChild((OMNode)((OMElement)o));
            }
            itr.remove();
        }
    }

    public static String getTemplatePropertyMapping(String templateName, String parameter) {
        return templateName + ":" + parameter;
    }

    public static void createSynapseEIPTemplateProperty(MessageContext synCtxt, String templateName, String paramName, Object value) {
        String targetSynapsePropName = EIPUtils.getTemplatePropertyMapping(templateName, paramName);
        synCtxt.setProperty(targetSynapsePropName, value);
    }

    public static SOAPEnvelope encloseWithElement(SOAPEnvelope envelope, OMElement encloseElement) {
        Iterator itr = envelope.getBody().getChildElements();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (o == null || !(o instanceof OMElement)) continue;
            encloseElement.addChild((OMNode)((OMElement)o));
        }
        envelope.getBody().addChild((OMNode)encloseElement);
        return envelope;
    }

    public static JsonElement getJSONElement(MessageContext messageContext, SynapseJsonPath jsonPath) {
        List list;
        JsonParser parser = new JsonParser();
        Object objectList = jsonPath.evaluate(messageContext);
        if (objectList instanceof List && !(list = (List)objectList).isEmpty()) {
            if (list.size() > 1) {
                String result = "[" + StringUtils.join((Collection)list, (char)',') + "]";
                JsonElement element = parser.parse(result);
                return element.getAsJsonArray();
            }
            String resultString = list.get(0).toString().trim();
            JsonElement result = EIPUtils.tryParseJsonString(parser, resultString);
            return result;
        }
        return null;
    }

    public static JsonElement getJSONObjectAsElement(MessageContext messageContext, SynapseJsonPath jsonPath) throws JsonParseException, JSONObjectExtensionException {
        List list;
        JsonParser parser = new JsonParser();
        Object objectList = jsonPath.evaluate(messageContext);
        if (objectList instanceof List && !(list = (List)objectList).isEmpty()) {
            if (list.size() > 1) {
                JsonObject resultObject = new JsonObject();
                for (Object obj : list) {
                    String objString = obj.toString().trim();
                    JsonElement element = EIPUtils.tryParseJsonString(parser, objString);
                    if (element == null) continue;
                    if (element.isJsonObject()) {
                        try {
                            JSONMergeUtils.extendJSONObject(resultObject, JSONMergeUtils.ConflictStrategy.MERGE_INTO_ARRAY, element.getAsJsonObject());
                            continue;
                        }
                        catch (UnsupportedOperationException | JSONObjectExtensionException e) {
                            throw new JSONObjectExtensionException("Could not extend JSON object.");
                        }
                    }
                    throw new JsonParseException("Invalid JSON object. Could not extend.");
                }
                return resultObject;
            }
            String resultString = list.get(0).toString().trim();
            JsonElement result = EIPUtils.tryParseJsonString(parser, resultString);
            if (!result.isJsonObject()) {
                throw new JsonParseException("Invalid JSON object. Could not extend.");
            }
            return result;
        }
        return null;
    }

    public static JsonElement tryParseJsonString(JsonParser parser, String inputJson) {
        try {
            return parser.parse(EIPUtils.validateStringForGson(inputJson));
        }
        catch (JsonSyntaxException e) {
            log.error((Object)(inputJson + " cannot be parsed to a valid JSON payload"), (Throwable)e);
            return null;
        }
    }

    private static String validateStringForGson(String input) {
        String output;
        block2: {
            output = input;
            try {
                Double.parseDouble(input);
            }
            catch (NumberFormatException e) {
                if (input.equals("true") || input.equals("false") || input.startsWith("[") && input.endsWith("]") || input.startsWith("{") && input.endsWith("}") || input.startsWith("\"") && input.endsWith("\"")) break block2;
                output = "\"" + input + "\"";
            }
        }
        return output;
    }

    public static Object formatJsonPathResponse(Object input) {
        JsonElement jsonElement = (JsonElement)input;
        if (jsonElement.isJsonPrimitive()) {
            return jsonElement.getAsString();
        }
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (jsonObject.has(JSON_MEMBERS)) {
                return jsonObject.get(JSON_MEMBERS);
            }
            if (jsonObject.has(JSON_ELEMENTS)) {
                return jsonObject.get(JSON_ELEMENTS);
            }
            return jsonObject.toString();
        }
        return jsonElement.isJsonArray() ? jsonElement : null;
    }

    public static void mergeJsonObjects(JsonObject primaryPayload, JsonObject secondaryPayload) {
        for (String key : secondaryPayload.keySet()) {
            primaryPayload.add(key, secondaryPayload.get(key));
        }
    }

    public static void setJsonPathConfiguration() {
        Configuration.setDefaults((Configuration.Defaults)new Configuration.Defaults(){
            private final JsonProvider jsonProvider = new GsonJsonProvider(new GsonBuilder().serializeNulls().create());
            private final MappingProvider mappingProvider = new GsonMappingProvider();

            public JsonProvider jsonProvider() {
                return this.jsonProvider;
            }

            public MappingProvider mappingProvider() {
                return this.mappingProvider;
            }

            public Set<Option> options() {
                return EnumSet.noneOf(Option.class);
            }
        });
    }
}

