/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.commons.transaction.TranscationManger;
import org.apache.synapse.mediators.db.AbstractDBMediator;
import org.apache.synapse.mediators.db.Statement;

public class DBReportMediator
extends AbstractDBMediator {
    public static final String MODIFIED_ROW_COUNT_PROP_NAME = "DBREPORT_MODIFIED_RAW_COUNT";
    boolean useTransaction = false;

    public boolean isUseTransaction() {
        return this.useTransaction;
    }

    public void setUseTransaction(boolean useTransaction) {
        this.useTransaction = useTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processStatement(Statement stmnt, MessageContext msgCtx) {
        SynapseLog synLog = this.getLog(msgCtx);
        Connection con = null;
        boolean threadInTx = false;
        try {
            PreparedStatement ps;
            int count;
            if (TranscationManger.isThreadHasEnlistment() || this.useTransaction) {
                threadInTx = true;
                try {
                    con = TranscationManger.addConnection((DataSource)this.getDataSource());
                    if (this.useTransaction) {
                        TranscationManger.bindConnection((Connection)con);
                    }
                }
                catch (Exception e) {
                    this.handleException("SQL Error while bind connection to tx : " + stmnt.getRawStatement() + " against DataSource : " + this.getDSName(), e, msgCtx);
                }
            } else {
                con = this.getDataSource().getConnection();
            }
            if ((count = (ps = this.getPreparedStatement(stmnt, con, msgCtx)).executeUpdate()) > 0) {
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("Inserted " + count + " row/s using statement : " + stmnt.getRawStatement());
                }
            } else if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("No rows were inserted for statement : " + stmnt.getRawStatement());
            }
            msgCtx.setProperty(MODIFIED_ROW_COUNT_PROP_NAME, count);
            if (!(threadInTx || this.useTransaction || con.getAutoCommit())) {
                con.commit();
            }
        }
        catch (SQLException e) {
            this.handleException("SQL Error while executing insert statement : " + stmnt.getRawStatement() + " against DataSource : " + this.getDSName(), e, msgCtx);
        }
        catch (Exception e) {
            this.handleException("Error while executing insert statement : " + stmnt.getRawStatement() + " against DataSource : " + this.getDSName(), e, msgCtx);
        }
        finally {
            if (con != null && !threadInTx && !this.useTransaction) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    @Override
    protected void closeConnection(long key) {
        TranscationManger.removeConnectionUsed((long)key);
    }
}

