/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.commons.transaction.TranscationManger;
import org.apache.synapse.mediators.db.AbstractDBMediator;
import org.apache.synapse.mediators.db.Statement;

public class DBLookupMediator
extends AbstractDBMediator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processStatement(Statement stmnt, MessageContext msgCtx) {
        block46: {
            SynapseLog synLog = this.getLog(msgCtx);
            Connection con = null;
            ResultSet rs = null;
            java.sql.Statement ps = null;
            boolean threadInTx = false;
            try {
                if (TranscationManger.isThreadHasEnlistment()) {
                    threadInTx = true;
                    try {
                        con = TranscationManger.addConnection((DataSource)this.getDataSource());
                    }
                    catch (Exception e) {
                        this.handleException("SQL Error while adding/getting connection to/from cache : " + stmnt.getRawStatement() + " against DataSource : " + this.getDSName(), e, msgCtx);
                    }
                } else {
                    con = this.getDataSource().getConnection();
                }
                if ((rs = (ps = this.getPreparedStatement(stmnt, con, msgCtx)).executeQuery()).next()) {
                    if (synLog.isTraceOrDebugEnabled()) {
                        synLog.traceOrDebug("Processing the first row returned : " + stmnt.getRawStatement());
                    }
                    for (String propName : stmnt.getResultsMap().keySet()) {
                        Object obj;
                        String columnStr = stmnt.getResultsMap().get(propName);
                        try {
                            int colNum = Integer.parseInt(columnStr);
                            obj = rs.getObject(colNum);
                        }
                        catch (NumberFormatException ignore) {
                            obj = rs.getObject(columnStr);
                        }
                        if (obj != null) {
                            if (synLog.isTraceOrDebugEnabled()) {
                                synLog.traceOrDebug("Column : " + columnStr + " returned value : " + obj + " Setting this as the message property : " + propName);
                            }
                            msgCtx.setProperty(propName, obj.toString());
                            continue;
                        }
                        if (!synLog.isTraceOrDebugEnabled()) continue;
                        synLog.traceOrDebugWarn("Column : " + columnStr + " returned null Skip setting message property : " + propName);
                    }
                    break block46;
                }
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("Statement : " + stmnt.getRawStatement() + " returned 0 rows");
                }
            }
            catch (SQLException e) {
                this.handleException("SQL Exception occurred while executing statement : " + stmnt.getRawStatement() + " against DataSource : " + this.getDSName(), e, msgCtx);
            }
            catch (Exception e) {
                this.handleException("Error executing statement : " + stmnt.getRawStatement() + " against DataSource : " + this.getDSName(), e, msgCtx);
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {}
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException e) {}
                }
                if (con != null && !threadInTx) {
                    try {
                        con.close();
                    }
                    catch (SQLException e) {}
                }
            }
        }
    }

    @Override
    public boolean isContentAltering() {
        return true;
    }

    @Override
    protected void closeConnection(long key) {
    }
}

