/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.builtin;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.llom.OMTextImpl;
import org.apache.synapse.ContinuationState;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.flow.statistics.StatisticIdentityGenerator;
import org.apache.synapse.aspects.flow.statistics.collectors.RuntimeStatisticCollector;
import org.apache.synapse.aspects.flow.statistics.data.artifact.ArtifactHolder;
import org.apache.synapse.commons.json.JsonUtil;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.SynapsePath;
import org.apache.synapse.continuation.ContinuationStackManager;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractListMediator;
import org.apache.synapse.mediators.FlowContinuableMediator;
import org.apache.synapse.mediators.MediatorProperty;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.util.AXIOMUtils;
import org.apache.synapse.util.jaxp.SchemaResourceResolver;
import org.apache.synapse.util.resolver.ResourceMap;
import org.apache.synapse.util.resolver.UserDefinedXmlSchemaURIResolver;
import org.apache.synapse.util.xpath.SourceXPathSupport;
import org.apache.synapse.util.xpath.SynapseJsonPath;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ValidateMediator
extends AbstractListMediator
implements FlowContinuableMediator {
    private List<Value> schemaKeys = new ArrayList<Value>();
    private ResourceMap resourceMap;
    private final SourceXPathSupport source = new SourceXPathSupport();
    private final List<MediatorProperty> explicityFeatures = new ArrayList<MediatorProperty>();
    private final Object validatorLock = new Object();
    private final SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    private final JsonSchemaFactory jsonSchemaFactory = JsonSchemaFactory.byDefault();
    private JsonNode jsonSchemaNode;
    private SynapsePath sourcePath;
    private Map<String, Schema> cachedSchemaMap = new ConcurrentHashMap<String, Schema>();
    private Map<String, JsonSchema> cachedJsonSchemaMap = new ConcurrentHashMap<String, JsonSchema>();
    private boolean cacheSchema = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mediate(MessageContext synCtx) {
        org.apache.axis2.context.MessageContext a2mc;
        Schema cachedSchema = null;
        JsonSchema cachedJsonSchema = null;
        if (synCtx.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(synCtx)) {
            return true;
        }
        SynapseLog synLog = this.getLog(synCtx);
        synLog.traceOrDebug("Start : Validate mediator");
        if (synLog.isTraceTraceEnabled()) {
            synLog.traceTrace("Message : " + synCtx.getEnvelope());
        }
        if (JsonUtil.hasAJsonPayload((org.apache.axis2.context.MessageContext)(a2mc = ((Axis2MessageContext)synCtx).getAxis2MessageContext()))) {
            String msg;
            boolean reCreate2;
            JsonSchema uncachedJsonSchema = null;
            JsonNode uncachedJsonSchemaNode = null;
            StringBuilder combinedPropertyKey = new StringBuilder();
            StringBuilder cachedJsonSchemaKey = new StringBuilder();
            boolean bl = reCreate2 = !this.cacheSchema || this.isReCreate(synCtx, combinedPropertyKey);
            if (this.cachedJsonSchemaMap.containsKey(combinedPropertyKey.toString())) {
                cachedJsonSchema = this.cachedJsonSchemaMap.get(combinedPropertyKey.toString());
            } else {
                reCreate2 = true;
            }
            Object object = this.validatorLock;
            synchronized (object) {
                if (reCreate2 || cachedJsonSchema == null) {
                    Object jsonSchemaObj = null;
                    for (Value schemaKey : this.schemaKeys) {
                        String propName = schemaKey.evaluateValue(synCtx);
                        jsonSchemaObj = synCtx.getEntry(propName);
                        cachedJsonSchemaKey.append(propName);
                    }
                    if (jsonSchemaObj == null) {
                        this.handleException("Can not find JSON Schema " + cachedJsonSchemaKey.toString(), synCtx);
                    }
                    try {
                        if (jsonSchemaObj instanceof String) {
                            if (this.cacheSchema) {
                                this.jsonSchemaNode = JsonLoader.fromString((String)((String)jsonSchemaObj));
                            } else {
                                uncachedJsonSchemaNode = JsonLoader.fromString((String)((String)jsonSchemaObj));
                            }
                        } else if (jsonSchemaObj instanceof OMTextImpl) {
                            InputStreamReader reader = null;
                            try {
                                reader = new InputStreamReader(((OMTextImpl)jsonSchemaObj).getInputStream());
                                if (this.cacheSchema) {
                                    this.jsonSchemaNode = JsonLoader.fromReader((Reader)reader);
                                }
                                uncachedJsonSchemaNode = JsonLoader.fromReader((Reader)reader);
                            }
                            finally {
                                if (reader != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (IOException e) {
                                        this.log.warn((Object)("Error while closing registry resource stream. " + e));
                                    }
                                }
                            }
                        } else {
                            this.handleException("Can not find valid JSON Schema content", synCtx);
                        }
                        if (this.cacheSchema) {
                            cachedJsonSchema = this.jsonSchemaFactory.getJsonSchema(this.jsonSchemaNode);
                            if (!this.cachedJsonSchemaMap.containsKey(cachedJsonSchemaKey.toString())) {
                                this.cachedJsonSchemaMap.put(cachedJsonSchemaKey.toString(), cachedJsonSchema);
                            } else if (this.cachedJsonSchemaMap.containsKey(cachedJsonSchemaKey.toString())) {
                                this.cachedJsonSchemaMap.remove(cachedJsonSchemaKey.toString());
                                this.cachedJsonSchemaMap.put(cachedJsonSchemaKey.toString(), cachedJsonSchema);
                            }
                        } else {
                            uncachedJsonSchema = this.jsonSchemaFactory.getJsonSchema(uncachedJsonSchemaNode);
                        }
                    }
                    catch (ProcessingException | IOException e) {
                        this.handleException("Error while validating the JSON Schema", (Exception)e, synCtx);
                    }
                }
            }
            try {
                Iterator itrErrorMessages;
                ProcessingReport report;
                if (cachedJsonSchema == null && uncachedJsonSchema == null) {
                    this.handleException("Failed to create JSON Schema Validator", synCtx);
                }
                String jsonPayload = null;
                if (this.sourcePath != null) {
                    if (this.sourcePath instanceof SynapseJsonPath) {
                        jsonPayload = this.sourcePath.stringValueOf(synCtx);
                    } else {
                        this.handleException("Could not find the JSONPath evaluator for Source", synCtx);
                    }
                } else {
                    jsonPayload = JsonUtil.jsonPayloadToString((org.apache.axis2.context.MessageContext)a2mc);
                }
                if (jsonPayload == null || jsonPayload.length() == 0) {
                    jsonPayload = "{}";
                }
                if ((report = this.cacheSchema ? cachedJsonSchema.validate(JsonLoader.fromString((String)jsonPayload)) : uncachedJsonSchema.validate(JsonLoader.fromString((String)jsonPayload))).isSuccess()) {
                    return true;
                }
                if (synLog.isTraceOrDebugEnabled()) {
                    msg = "Validation of JSON failed against the given schema(s) " + cachedJsonSchemaKey.toString() + " with error : " + report + " Executing 'on-fail' sequence";
                    synLog.traceOrDebug(msg);
                    synCtx.getServiceLog().warn((Object)msg);
                    if (synLog.isTraceTraceEnabled()) {
                        synLog.traceTrace("Failed message envelope : " + synCtx.getEnvelope());
                    }
                }
                if ((itrErrorMessages = report.iterator()).hasNext()) {
                    ProcessingMessage processingMessage = (ProcessingMessage)itrErrorMessages.next();
                    String errorMessage = processingMessage.getMessage();
                    String errorDetail = processingMessage.toString();
                    synCtx.setProperty("ERROR_MESSAGE", errorMessage);
                    synCtx.setProperty("ERROR_DETAIL", "Error while validating Json message " + errorDetail);
                }
                return this.invokeOnFailSequence(synCtx);
            }
            catch (ProcessingException | IOException e) {
                msg = "";
                if (this.sourcePath != null) {
                    msg = " for JSONPath " + this.sourcePath.getExpression();
                }
                this.handleException("Error while validating the JSON Schema" + msg, (Exception)e, synCtx);
            }
        } else {
            boolean reCreate;
            Source validateSrc;
            try {
                validateSrc = this.getValidationSource(synCtx, synLog);
            }
            catch (SynapseException e) {
                String errorMessage = "Error occurred while accessing source element: " + this.source;
                if (synLog.isTraceOrDebugEnabled()) {
                    String msg = "Error occurred while accessing source element : " + this.source + "with error : '" + e.getMessage() + "'. Executing 'on-fail' sequence";
                    synLog.traceOrDebug(msg);
                    synCtx.getServiceLog().warn((Object)msg);
                    if (synLog.isTraceTraceEnabled()) {
                        synLog.traceTrace("Failed message envelope : " + synCtx.getEnvelope());
                    }
                }
                synCtx.setProperty("ERROR_MESSAGE", errorMessage);
                synCtx.setProperty("ERROR_DETAIL", e.getMessage());
                return this.invokeOnFailSequence(synCtx);
            }
            StringBuilder combinedPropertyKey = new StringBuilder();
            boolean bl = reCreate = !this.cacheSchema || this.isReCreate(synCtx, combinedPropertyKey);
            if (this.cachedSchemaMap.containsKey(combinedPropertyKey.toString())) {
                cachedSchema = this.cachedSchemaMap.get(combinedPropertyKey.toString());
            } else {
                reCreate = true;
            }
            ValidateMediatorErrorHandler errorHandler = new ValidateMediatorErrorHandler();
            Schema uncachedSchema = null;
            Object reCreate2 = this.validatorLock;
            synchronized (reCreate2) {
                if (reCreate || cachedSchema == null) {
                    this.factory.setErrorHandler(errorHandler);
                    Source[] sources = new StreamSource[this.schemaKeys.size()];
                    StringBuilder cachedSchemaKey = new StringBuilder();
                    int i = 0;
                    for (Value schemaKey : this.schemaKeys) {
                        String propName = schemaKey.evaluateValue(synCtx);
                        Object schemaObject = synCtx.getEntry(propName);
                        if (schemaObject == null) {
                            throw new SynapseException("No Schema is available with the key  : " + propName);
                        }
                        sources[i++] = SynapseConfigUtils.getStreamSource(schemaObject);
                        cachedSchemaKey.append(propName);
                    }
                    try {
                        SynapseConfiguration synCfg = synCtx.getConfiguration();
                        if (synCfg.getProperty("synapse.schema.resolver") != null) {
                            this.setUserDefinedSchemaResourceResolver(synCtx);
                        } else {
                            this.factory.setResourceResolver(new SchemaResourceResolver(synCtx.getConfiguration(), this.resourceMap, synCtx));
                        }
                        if (this.cacheSchema) {
                            cachedSchema = this.factory.newSchema(sources);
                            if (!this.cachedSchemaMap.containsKey(cachedSchemaKey.toString())) {
                                this.cachedSchemaMap.put(cachedSchemaKey.toString(), cachedSchema);
                            } else if (this.cachedSchemaMap.containsKey(cachedSchemaKey.toString())) {
                                this.cachedSchemaMap.remove(cachedSchemaKey.toString());
                                this.cachedSchemaMap.put(cachedSchemaKey.toString(), cachedSchema);
                            }
                        } else {
                            uncachedSchema = this.factory.newSchema(sources);
                        }
                    }
                    catch (SAXException e) {
                        this.handleException("Error creating a new schema objects for schemas : " + this.schemaKeys.toString(), e, synCtx);
                    }
                    catch (RuntimeException e) {
                        this.handleException("Error creating a new schema objects for schemas : " + this.schemaKeys.toString(), e, synCtx);
                    }
                    if (errorHandler.isValidationError()) {
                        errorHandler.setValidationError(false);
                        cachedSchema = null;
                        if (this.cachedSchemaMap.containsKey(cachedSchemaKey.toString())) {
                            this.cachedSchemaMap.remove(cachedSchemaKey.toString());
                        }
                        this.handleException("Error creating a new schema objects for schemas : " + this.schemaKeys.toString(), errorHandler.getSaxParseException(), synCtx);
                    }
                }
            }
            try {
                Validator validator = this.cacheSchema ? cachedSchema.newValidator() : uncachedSchema.newValidator();
                validator.setErrorHandler(errorHandler);
                validator.validate(validateSrc);
                if (errorHandler.isValidationError()) {
                    if (synLog.isTraceOrDebugEnabled()) {
                        String msg = "Validation of element returned by XPath : " + this.source + " failed against the given schema(s) " + this.schemaKeys + "with error : " + errorHandler.getSaxParseException().getMessage() + " Executing 'on-fail' sequence";
                        synLog.traceOrDebug(msg);
                        synCtx.getServiceLog().warn((Object)msg);
                        if (synLog.isTraceTraceEnabled()) {
                            synLog.traceTrace("Failed message envelope : " + synCtx.getEnvelope());
                        }
                    }
                    synCtx.setProperty("ERROR_MESSAGE", errorHandler.getAllExceptions());
                    synCtx.setProperty("ERROR_EXCEPTION", errorHandler.getSaxParseException());
                    synCtx.setProperty("ERROR_DETAIL", FaultHandler.getStackTrace(errorHandler.getSaxParseException()));
                    return this.invokeOnFailSequence(synCtx);
                }
            }
            catch (SAXException e) {
                this.handleException("Error validating " + this.source + " element", e, synCtx);
            }
            catch (IOException e) {
                this.handleException("Error validating " + this.source + " element", e, synCtx);
            }
        }
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Validation of element returned by the XPath expression : " + this.source + " succeeded against the given schemas and the current message");
            synLog.traceOrDebug("End : Validate mediator");
        }
        return true;
    }

    private boolean isReCreate(MessageContext synCtx, StringBuilder combinedPropertyKey) {
        boolean reCreate = false;
        for (Value schemaKey : this.schemaKeys) {
            String propKey = schemaKey.evaluateValue(synCtx);
            combinedPropertyKey.append(propKey);
            Entry dp = synCtx.getConfiguration().getEntryDefinition(propKey);
            if (dp == null || !dp.isDynamic() || dp.isCached() && !dp.isExpired()) continue;
            reCreate = true;
        }
        return reCreate;
    }

    @Override
    public boolean mediate(MessageContext synCtx, ContinuationState continuationState) {
        boolean result;
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Validate mediator : Mediating from ContinuationState");
        }
        if (!continuationState.hasChild()) {
            result = super.mediate(synCtx, continuationState.getPosition() + 1);
        } else {
            FlowContinuableMediator mediator = (FlowContinuableMediator)((Object)this.getChild(continuationState.getPosition()));
            result = mediator.mediate(synCtx, continuationState.getChildContState());
            if (RuntimeStatisticCollector.isStatisticsEnabled()) {
                ((Mediator)((Object)mediator)).reportCloseStatistics(synCtx, null);
            }
        }
        return result;
    }

    @Override
    public void init(SynapseEnvironment synapseEnvironment) {
        super.init(synapseEnvironment);
    }

    private void setUserDefinedSchemaResourceResolver(MessageContext synCtx) {
        Class<?> schemaClazz;
        SynapseConfiguration synCfg = synCtx.getConfiguration();
        String schemaResolverName = synCfg.getProperty("synapse.schema.resolver");
        try {
            schemaClazz = Class.forName(schemaResolverName);
        }
        catch (ClassNotFoundException e) {
            String msg = "System could not find the class defined for the specific properties\n SchemaResolverImplementation:" + schemaResolverName;
            this.handleException(msg, e, synCtx);
            return;
        }
        try {
            Object schemaClazzObject = schemaClazz.newInstance();
            UserDefinedXmlSchemaURIResolver userDefSchemaResResolver = (UserDefinedXmlSchemaURIResolver)schemaClazzObject;
            userDefSchemaResResolver.init(this.resourceMap, synCfg, this.schemaKeys);
            this.factory.setResourceResolver(userDefSchemaResResolver);
        }
        catch (Exception e) {
            String msg = "Could not create an instance from the class";
            this.handleException(msg, e, synCtx);
        }
    }

    private boolean invokeOnFailSequence(MessageContext synCtx) {
        ContinuationStackManager.addReliantContinuationState(synCtx, 0, this.getMediatorPosition());
        boolean result = super.mediate(synCtx);
        if (result) {
            ContinuationStackManager.removeReliantContinuationState(synCtx);
        }
        return result;
    }

    private Source getValidationSource(MessageContext synCtx, SynapseLog synLog) throws SynapseException {
        OMNode validateSource = this.source.selectOMNode(synCtx, synLog);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Validation source : " + validateSource.toString());
        }
        return AXIOMUtils.asSource(validateSource);
    }

    public Object getFeature(String key) {
        for (MediatorProperty prop : this.explicityFeatures) {
            if (!key.equals(prop.getName())) continue;
            return prop.getValue();
        }
        return null;
    }

    public void addFeature(String featureName, boolean isFeatureEnable) throws SAXException {
        MediatorProperty mp = new MediatorProperty();
        mp.setName(featureName);
        if (isFeatureEnable) {
            mp.setValue("true");
        } else {
            mp.setValue("false");
        }
        this.explicityFeatures.add(mp);
        this.factory.setFeature(featureName, isFeatureEnable);
    }

    public void setSchemaKeys(List<Value> schemaKeys) {
        this.schemaKeys = schemaKeys;
    }

    public void setSource(SynapsePath source) {
        this.sourcePath = source;
        if (source instanceof SynapseXPath) {
            this.source.setXPath((SynapseXPath)source);
        }
    }

    public void setResourceMap(ResourceMap resourceMap) {
        this.resourceMap = resourceMap;
    }

    public SynapsePath getSource() {
        return this.sourcePath;
    }

    public List<Value> getSchemaKeys() {
        return this.schemaKeys;
    }

    public List<MediatorProperty> getFeatures() {
        return this.explicityFeatures;
    }

    public ResourceMap getResourceMap() {
        return this.resourceMap;
    }

    public void setCacheSchema(boolean cacheSchema) {
        this.cacheSchema = cacheSchema;
    }

    public boolean isCacheSchema() {
        return this.cacheSchema;
    }

    @Override
    public boolean isContentAware() {
        return true;
    }

    @Override
    public void setComponentStatisticsId(ArtifactHolder holder) {
        if (this.getAspectConfiguration() == null) {
            this.configure(new AspectConfiguration(this.getMediatorName()));
        }
        String mediatorId = StatisticIdentityGenerator.getIdForFlowContinuableMediator(this.getMediatorName(), ComponentType.MEDIATOR, holder);
        this.getAspectConfiguration().setUniqueId(mediatorId);
        StatisticIdentityGenerator.reportingFlowContinuableEndEvent(mediatorId, ComponentType.MEDIATOR, holder);
    }

    private static class ValidateMediatorErrorHandler
    extends DefaultHandler {
        private boolean validationError = false;
        private SAXParseException saxParseException = null;
        private List<SAXParseException> saxParseExceptionList = new ArrayList<SAXParseException>();

        private ValidateMediatorErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.validationError = true;
            this.saxParseException = exception;
            this.saxParseExceptionList.add(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.validationError = true;
            this.saxParseException = exception;
            this.saxParseExceptionList.add(exception);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }

        public boolean isValidationError() {
            return this.validationError;
        }

        public SAXParseException getSaxParseException() {
            return this.saxParseException;
        }

        public List<SAXParseException> getSaxParseExceptionList() {
            return this.saxParseExceptionList;
        }

        public String getAllExceptions() {
            StringBuilder errors = new StringBuilder();
            for (SAXParseException e : this.saxParseExceptionList) {
                errors.append(e.getMessage());
                errors.append("\n");
            }
            return errors.toString();
        }

        public void setValidationError(boolean validationError) {
            this.validationError = validationError;
        }
    }
}

