/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.builtin;

import java.util.Set;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.flow.statistics.StatisticIdentityGenerator;
import org.apache.synapse.aspects.flow.statistics.data.artifact.ArtifactHolder;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.util.MessageHelper;

public class SendMediator
extends AbstractMediator
implements ManagedLifecycle {
    private Endpoint endpoint = null;
    private Value receivingSequence = null;
    private boolean buildMessage = false;

    @Override
    public boolean mediate(MessageContext synCtx) {
        Set keySet;
        if (synCtx.getEnvironment().isDebuggerEnabled()) {
            MessageHelper.setWireLogHolderProperties(synCtx, this.isBreakPoint(), this.getRegisteredMediationFlowPoint());
            if (super.divertMediationRoute(synCtx)) {
                return true;
            }
        }
        SynapseLog synLog = this.getLog(synCtx);
        synLog.traceOrDebug("Start : Send mediator");
        if (synLog.isTraceTraceEnabled()) {
            synLog.traceTrace("Message : " + synCtx.getEnvelope());
        }
        synCtx.setProperty("LAST_SEQ_FAULT_HANDLER", this.getLastSequenceFaultHandler(synCtx));
        if (this.buildMessage) {
            synCtx.getEnvelope().buildWithAttachments();
        }
        if ((keySet = synCtx.getPropertyKeySet()) != null) {
            keySet.remove("RECEIVING_SEQUENCE");
            keySet.remove("continuation.call");
            keySet.remove("DYNAMIC_URL_VALUE");
            keySet.remove("last_endpoint");
            keySet.remove("blockingMsgSender");
            keySet.remove("blocking.sender.error");
        }
        if (this.receivingSequence != null) {
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Receiving sequence is set to: " + this.receivingSequence);
            }
            synCtx.setProperty("RECEIVING_SEQUENCE", this.receivingSequence.evaluateValue(synCtx));
        }
        if (this.endpoint == null) {
            if (synLog.isTraceOrDebugEnabled()) {
                StringBuffer sb = new StringBuffer();
                sb.append("Sending ").append(synCtx.isResponse() ? "response" : "request").append(" message using implicit message properties..");
                sb.append("\nSending To: ").append(synCtx.getTo() != null ? synCtx.getTo().getAddress() : "null");
                sb.append("\nSOAPAction: ").append(synCtx.getWSAAction() != null ? synCtx.getWSAAction() : "null");
                synLog.traceOrDebug(sb.toString());
            }
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Envelope : " + synCtx.getEnvelope());
            }
            synCtx.getEnvironment().send(null, synCtx);
        } else {
            this.endpoint.send(synCtx);
        }
        synLog.traceOrDebug("End : Send mediator");
        return false;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Value getReceivingSequence() {
        return this.receivingSequence;
    }

    public void setReceivingSequence(Value receivingSequence) {
        this.receivingSequence = receivingSequence;
    }

    public void setBuildMessage(boolean buildMessage) {
        this.buildMessage = buildMessage;
    }

    public boolean isBuildMessage() {
        return this.buildMessage;
    }

    @Override
    public void init(SynapseEnvironment synapseEnvironment) {
        if (this.endpoint != null) {
            this.endpoint.init(synapseEnvironment);
        }
    }

    @Override
    public void destroy() {
        if (this.endpoint != null) {
            this.endpoint.destroy();
        }
    }

    @Override
    public boolean isContentAware() {
        return false;
    }

    @Override
    public void setComponentStatisticsId(ArtifactHolder holder) {
        if (this.getAspectConfiguration() == null) {
            this.configure(new AspectConfiguration(this.getMediatorName()));
        }
        String cloneId = StatisticIdentityGenerator.getIdForComponent(this.getMediatorName(), ComponentType.MEDIATOR, holder);
        this.getAspectConfiguration().setUniqueId(cloneId);
        if (this.endpoint != null) {
            this.endpoint.setComponentStatisticsId(holder);
        }
        if (this.receivingSequence != null) {
            String childId = StatisticIdentityGenerator.getIdReferencingComponent(this.receivingSequence.getName(), ComponentType.SEQUENCE, holder);
            StatisticIdentityGenerator.reportingEndEvent(childId, ComponentType.SEQUENCE, holder);
        }
        StatisticIdentityGenerator.reportingEndEvent(cloneId, ComponentType.MEDIATOR, holder);
    }
}

