/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.builtin;

import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.api.cors.CORSHelper;
import org.apache.synapse.api.cors.SynapseCORSConfiguration;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.Axis2Sender;
import org.apache.synapse.mediators.AbstractMediator;

public class RespondMediator
extends AbstractMediator {
    @Override
    public boolean mediate(MessageContext synCtx) {
        if (synCtx.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(synCtx)) {
            return true;
        }
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : Respond Mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        synCtx.setTo(null);
        synCtx.setResponse(true);
        String proxyName = (String)synCtx.getProperty("proxy.name");
        if (proxyName == null || proxyName.isEmpty()) {
            CORSHelper.handleCORSHeadersForResponse(SynapseCORSConfiguration.getInstance(), synCtx);
        }
        Axis2MessageContext axis2smc = (Axis2MessageContext)synCtx;
        org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
        axis2MessageCtx.getOperationContext().setProperty("RESPONSE_WRITTEN", (Object)"SKIP");
        Axis2Sender.sendBack(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("End : Respond Mediator");
        }
        return false;
    }

    @Override
    public boolean isContentAware() {
        return false;
    }
}

