/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.builtin;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.flow.statistics.collectors.CloseEventCollector;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.xml.SynapsePath;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.registry.Registry;
import org.apache.synapse.util.MediatorPropertyUtils;

public class PropertyMediator
extends AbstractMediator {
    private String name = null;
    private Value dynamicNameValue = null;
    private Object value = null;
    private String type = null;
    private OMElement valueElement = null;
    private SynapsePath expression = null;
    private String scope = null;
    public static final int ACTION_SET = 0;
    public static final int ACTION_REMOVE = 1;
    private int action = 0;
    private Pattern pattern;
    private int group = 0;
    public static final String CONTENT_TYPE = "text/plain";
    private static final String EMPTY_CONTENT = "";
    private String propertyValue = null;

    @Override
    public boolean mediate(MessageContext synCtx) {
        if (synCtx.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(synCtx)) {
            return true;
        }
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : Property mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        String name = this.name;
        if (this.dynamicNameValue != null && StringUtils.isEmpty((String)(name = this.dynamicNameValue.evaluateValue(synCtx)))) {
            this.log.warn((Object)("Evaluated value for " + this.name + " is empty"));
        }
        if (this.action == 0) {
            Object resultValue = this.getResultValue(synCtx);
            if (resultValue instanceof String && this.pattern != null) {
                resultValue = this.getMatchedValue((String)resultValue, synLog);
            }
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Setting property : " + name + " at scope : " + (this.scope == null ? "default" : this.scope) + " to : " + resultValue + " (i.e. " + (this.value != null ? "constant : " + this.value : "result of expression : " + (Object)((Object)this.expression)) + ")");
            }
            if (this.scope == null || "default".equals(this.scope)) {
                if (resultValue != null && resultValue instanceof OMElement) {
                    ((OMElement)resultValue).build();
                }
                synCtx.setProperty(name, resultValue);
            } else if ("trace".equals(this.scope)) {
                if (resultValue != null) {
                    if (resultValue instanceof OMElement) {
                        ((OMElement)resultValue).build();
                    }
                    this.propertyValue = resultValue.toString();
                }
            } else if ("axis2".equals(this.scope) && synCtx instanceof Axis2MessageContext) {
                Axis2MessageContext axis2smc = (Axis2MessageContext)synCtx;
                org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
                axis2MessageCtx.setProperty(name, resultValue);
                MediatorPropertyUtils.handleSpecialProperties(name, resultValue, axis2MessageCtx);
            } else if ("axis2-client".equals(this.scope) && synCtx instanceof Axis2MessageContext) {
                Axis2MessageContext axis2smc = (Axis2MessageContext)synCtx;
                org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
                axis2MessageCtx.getOptions().setProperty(name, resultValue);
            } else if ("transport".equals(this.scope) && synCtx instanceof Axis2MessageContext) {
                TreeMap<String, Object> headersMap;
                Axis2MessageContext axis2smc = (Axis2MessageContext)synCtx;
                org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
                Object headers = axis2MessageCtx.getProperty("TRANSPORT_HEADERS");
                if (resultValue == null) {
                    resultValue = EMPTY_CONTENT;
                }
                if (headers != null && headers instanceof Map) {
                    headersMap = (TreeMap<String, Object>)headers;
                    headersMap.put(name, resultValue);
                }
                if (headers == null) {
                    headersMap = new TreeMap<String, Object>(new Comparator<String>(){

                        @Override
                        public int compare(String o1, String o2) {
                            return o1.compareToIgnoreCase(o2);
                        }
                    });
                    headersMap.put(name, resultValue);
                    axis2MessageCtx.setProperty("TRANSPORT_HEADERS", headersMap);
                }
            } else if ("operation".equals(this.scope) && synCtx instanceof Axis2MessageContext) {
                Axis2MessageContext axis2smc = (Axis2MessageContext)synCtx;
                org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
                axis2smc.getAxis2MessageContext().getOperationContext().setProperty(name, resultValue);
            } else if ("registry".equals(this.scope) && synCtx instanceof Axis2MessageContext) {
                String[] args = name.split("@");
                String path = EMPTY_CONTENT;
                String propertyName = EMPTY_CONTENT;
                Registry registry = synCtx.getConfiguration().getRegistry();
                if (args.length == 1) {
                    path = args[0];
                    registry.newNonEmptyResource(path, false, CONTENT_TYPE, resultValue.toString(), propertyName);
                } else if (args.length == 2) {
                    path = args[0];
                    propertyName = args[1];
                    registry.newNonEmptyResource(path, false, CONTENT_TYPE, resultValue.toString(), propertyName);
                    registry.updateResource(path, EMPTY_CONTENT);
                }
            }
        } else {
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Removing property : " + name + " (scope:" + (this.scope == null ? "default" : this.scope) + ")");
            }
            if (this.scope == null || "default".equals(this.scope)) {
                Set pros = synCtx.getPropertyKeySet();
                if (pros != null) {
                    pros.remove(name);
                }
            } else if ("axis2".equals(this.scope) && synCtx instanceof Axis2MessageContext) {
                Axis2MessageContext axis2smc = (Axis2MessageContext)synCtx;
                org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
                axis2MessageCtx.removeProperty(name);
            } else if ("axis2-client".equals(this.scope) && synCtx instanceof Axis2MessageContext) {
                Axis2MessageContext axis2smc = (Axis2MessageContext)synCtx;
                org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
                axis2MessageCtx.getOptions().setProperty(name, null);
            } else if ("transport".equals(this.scope) && synCtx instanceof Axis2MessageContext) {
                Axis2MessageContext axis2smc = (Axis2MessageContext)synCtx;
                org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
                Object headers = axis2MessageCtx.getProperty("TRANSPORT_HEADERS");
                if (headers != null && headers instanceof Map) {
                    Map headersMap = (Map)headers;
                    headersMap.remove(name);
                } else {
                    synLog.traceOrDebug("No transport headers found for the message");
                }
            } else if ("operation".equals(this.scope) && synCtx instanceof Axis2MessageContext) {
                Axis2MessageContext axis2smc = (Axis2MessageContext)synCtx;
                org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
                OperationContext axis2oc = axis2MessageCtx.getOperationContext();
                axis2oc.removeProperty(name);
            }
        }
        synLog.traceOrDebug("End : Property mediator");
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.setValue(value, null);
    }

    public void setValue(String value, String type) {
        this.type = type;
        this.value = this.convertValue(value, type);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public OMElement getValueElement() {
        return this.valueElement;
    }

    public void setValueElement(OMElement valueElement) {
        this.valueElement = valueElement;
    }

    public SynapsePath getExpression() {
        return this.expression;
    }

    public void setExpression(SynapsePath expression) {
        this.setExpression(expression, null);
    }

    @Override
    public void reportCloseStatistics(MessageContext messageContext, Integer currentIndex) {
        CloseEventCollector.closeEntryEvent(messageContext, this.getMediatorName(), ComponentType.MEDIATOR, currentIndex, this.isContentAltering(), this.propertyValue);
    }

    public void setExpression(SynapsePath expression, String type) {
        this.expression = expression;
        this.type = type;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int action) {
        this.action = action;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public int getGroup() {
        return this.group;
    }

    public void setGroup(int group) {
        this.group = group;
    }

    private Object getResultValue(MessageContext synCtx) {
        if (this.value != null) {
            return this.value;
        }
        if (this.valueElement != null) {
            return this.valueElement.cloneOMElement();
        }
        if (this.expression != null) {
            return this.convertValue(this.expression.stringValueOf(synCtx), this.type);
        }
        return null;
    }

    private Object convertValue(String value, String type) {
        if (type == null) {
            return value;
        }
        try {
            XMLConfigConstants.DATA_TYPES dataType = XMLConfigConstants.DATA_TYPES.valueOf(type);
            switch (dataType) {
                case BOOLEAN: {
                    return JavaUtils.isTrueExplicitly((String)value);
                }
                case DOUBLE: {
                    return Double.parseDouble(value);
                }
                case FLOAT: {
                    return Float.valueOf(Float.parseFloat(value));
                }
                case INTEGER: {
                    return Integer.parseInt(value);
                }
                case LONG: {
                    return Long.parseLong(value);
                }
                case OM: {
                    return this.buildOMElement(value);
                }
                case SHORT: {
                    return Short.parseShort(value);
                }
                case JSON: {
                    return this.buildJSONElement(value);
                }
            }
            return value;
        }
        catch (IllegalArgumentException e) {
            String msg = "Unknown type : " + type + " for the property mediator or the property value cannot be converted into the specified type.";
            this.log.error((Object)msg, (Throwable)e);
            throw new SynapseException(msg, e);
        }
    }

    private String getMatchedValue(String value, SynapseLog synLog) {
        String matchedValue = value;
        Matcher matcher = this.pattern.matcher(value);
        if (matcher.matches()) {
            if (matcher.groupCount() < this.group) {
                if (synLog.isTraceOrDebugEnabled()) {
                    String msg = "Failed to get a match for regx : " + this.pattern.toString() + " with the property value :" + value + " for group :" + this.group;
                    synLog.traceOrDebug(msg);
                }
                return EMPTY_CONTENT;
            }
        } else {
            if (synLog.isTraceOrDebugEnabled()) {
                String msg = "Unable to find a match for regx : " + this.pattern.toString() + " with the property value :" + value;
                synLog.traceOrDebug(msg);
            }
            return EMPTY_CONTENT;
        }
        matchedValue = matcher.group(this.group);
        return matchedValue;
    }

    @Override
    public boolean isContentAware() {
        boolean contentAware = false;
        if (this.expression != null) {
            contentAware = this.expression.isContentAware();
        }
        if (this.dynamicNameValue != null && this.dynamicNameValue.getExpression() != null) {
            boolean bl = contentAware = contentAware || this.dynamicNameValue.getExpression().isContentAware();
        }
        if ("axis2".equals(this.scope)) {
            if ("messageType".equals(this.name) || "DISABLE_CHUNKING".equals(this.name) || "FORCE_HTTP_1.0".equals(this.name)) {
                contentAware = true;
            }
        } else if ("transport".equals(this.scope) && "Content-Encoding".equals(this.name)) {
            contentAware = true;
        }
        return contentAware;
    }

    private OMElement buildOMElement(String xml) {
        if (xml == null) {
            return null;
        }
        OMElement result = SynapseConfigUtils.stringToOM(xml);
        result.buildWithAttachments();
        return result;
    }

    private JsonElement buildJSONElement(String jsonPayload) {
        JsonParser jsonParser = new JsonParser();
        try {
            return jsonParser.parse(jsonPayload);
        }
        catch (JsonSyntaxException ex) {
            String enclosed = "\"" + jsonPayload + "\"";
            try {
                return jsonParser.parse(enclosed);
            }
            catch (JsonSyntaxException e) {
                this.log.error((Object)("Malformed JSON payload : " + jsonPayload), (Throwable)ex);
                return null;
            }
        }
    }

    @Override
    public String getMediatorName() {
        return super.getMediatorName() + ":" + this.name;
    }

    public void setDynamicNameValue(Value nameValue) {
        this.dynamicNameValue = nameValue;
    }
}

