/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.builtin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jcifs.Config;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.auth.AuthPolicy;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.util.CustomNTLMV1AuthScheme;
import org.apache.synapse.util.CustomNTLMV2AuthScheme;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class NTLMMediator
extends AbstractMediator
implements ManagedLifecycle {
    private static final Log log = LogFactory.getLog(NTLMMediator.class);
    private String username = null;
    private String password = null;
    private String host = null;
    private String domain = null;
    private String ntlmVersion = null;
    private Value dynamicUsername = null;
    private Value dynamicPassword = null;
    private Value dynamicHost = null;
    private Value dynamicDomain = null;
    private Value dynamicNtmlVersion = null;
    private ConfigurationContext configCtx = null;
    private int maxConnectionManagerCacheSize = 32;
    private static final String SECURE_VAULT_REGEX = "\\{(wso2:vault-lookup\\('(.*?)'\\))\\}";
    private static final String NTLM_V1 = "v1";
    private static final String NTLM_V2 = "v2";
    private Pattern vaultLookupPattern = Pattern.compile("\\{(wso2:vault-lookup\\('(.*?)'\\))\\}");
    private Map<String, MultiThreadedHttpConnectionManager> connectionManagerCache = Collections.synchronizedMap(new LinkedHashMap<String, MultiThreadedHttpConnectionManager>(16, 0.75f, true){

        @Override
        public boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > NTLMMediator.this.maxConnectionManagerCacheSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MultiThreadedHttpConnectionManager put(String key, MultiThreadedHttpConnectionManager value) {
            if (!this.containsKey(key)) {
                1 var3_3 = this;
                synchronized (var3_3) {
                    if (!this.containsKey(key)) {
                        return super.put(key, value);
                    }
                }
            }
            return (MultiThreadedHttpConnectionManager)this.get(key);
        }
    });

    @Override
    public boolean mediate(MessageContext messageContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"[NTLMMediator] mediate method Invoked.");
        }
        HttpTransportProperties.Authenticator authenticator = new HttpTransportProperties.Authenticator();
        ArrayList<String> authScheme = new ArrayList<String>();
        authScheme.add("NTLM");
        authenticator.setAuthSchemes(authScheme);
        String username = this.username;
        if (this.dynamicUsername != null && StringUtils.isEmpty((String)(username = this.dynamicUsername.evaluateValue(messageContext)))) {
            log.warn((Object)("Evaluated value for " + this.username + " is empty"));
        }
        String password = this.password;
        if (this.dynamicPassword != null && StringUtils.isEmpty((String)(password = this.dynamicPassword.evaluateValue(messageContext)))) {
            log.warn((Object)("Evaluated value for " + this.password + " is empty"));
        }
        String domain = this.domain;
        if (this.dynamicDomain != null && StringUtils.isEmpty((String)(domain = this.dynamicDomain.evaluateValue(messageContext)))) {
            log.warn((Object)("Evaluated value for " + this.domain + " is empty"));
        }
        String host = this.host;
        if (this.dynamicHost != null && StringUtils.isEmpty((String)(host = this.dynamicHost.evaluateValue(messageContext)))) {
            log.warn((Object)("Evaluated value for " + this.host + " is empty"));
        }
        String ntlmVersion = this.ntlmVersion;
        if (this.dynamicNtmlVersion != null && StringUtils.isEmpty((String)(ntlmVersion = this.dynamicNtmlVersion.evaluateValue(messageContext)))) {
            log.warn((Object)("Evaluated value for " + this.ntlmVersion + " is empty"));
        }
        if (username != null) {
            authenticator.setUsername(username);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"[NTLMMediator] Username not specified.");
        }
        if (password != null) {
            authenticator.setPassword(this.resolveSecureVaultExpressions(password, messageContext));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"[NTLMMediator] Password not specified.");
        }
        if (host != null) {
            authenticator.setHost(host);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"[NTLMMediator] Host not specified.");
        }
        if (domain != null) {
            authenticator.setDomain(domain);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"[NTLMMediator] Domain not specified.");
        }
        if (ntlmVersion != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[NTLMMediator] NTLM version is: " + ntlmVersion));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"[NTLMMediator] NTLM version is not specified.");
        }
        org.apache.axis2.context.MessageContext axis2MessageContext = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
        axis2MessageContext.getOptions().setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", (Object)authenticator);
        String cacheKey = authenticator.getUsername() + "@" + authenticator.getDomain() + ":" + authenticator.getPassword();
        MultiThreadedHttpConnectionManager connectionManager = this.connectionManagerCache.containsKey(cacheKey) ? this.connectionManagerCache.get(cacheKey) : this.connectionManagerCache.put(cacheKey, new MultiThreadedHttpConnectionManager());
        axis2MessageContext.getOptions().setProperty("MULTITHREAD_HTTP_CONNECTION_MANAGER", (Object)connectionManager);
        axis2MessageContext.getEnvelope().buildWithAttachments();
        return true;
    }

    @Override
    public void init(SynapseEnvironment synapseEnvironment) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"[NTLMMediator] Init method Invoked.");
        }
        log.info((Object)"[NTLMMediator] Init method Invoked.");
        Config.setProperty((String)"jcifs.encoding", (String)"ASCII");
        if (NTLM_V2.equalsIgnoreCase(this.ntlmVersion)) {
            AuthPolicy.registerAuthScheme((String)"NTLM", CustomNTLMV2AuthScheme.class);
        } else {
            AuthPolicy.registerAuthScheme((String)"NTLM", CustomNTLMV1AuthScheme.class);
        }
    }

    private String resolveSecureVaultExpressions(String value, MessageContext synCtx) {
        if (value == null) {
            return null;
        }
        Matcher lookupMatcher = this.vaultLookupPattern.matcher(value);
        String resolvedValue = value;
        if (lookupMatcher.find()) {
            Value expression = null;
            String expressionStr = lookupMatcher.group(1);
            try {
                expression = new Value(new SynapseXPath(expressionStr));
            }
            catch (JaxenException e) {
                throw new SynapseException("Error while building the expression : " + expressionStr, e);
            }
            resolvedValue = expression.evaluateValue(synCtx);
            if (StringUtils.isEmpty((String)resolvedValue)) {
                log.warn((Object)("Found Empty value for expression : " + (Object)((Object)expression.getExpression())));
                resolvedValue = "";
            }
        }
        return resolvedValue;
    }

    @Override
    public void destroy() {
        if (this.configCtx != null) {
            try {
                this.configCtx.terminate();
            }
            catch (AxisFault axisFault) {
                // empty catch block
            }
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getNtlmVersion() {
        return this.ntlmVersion;
    }

    public void setNtlmVersion(String ntlmVersion) {
        this.ntlmVersion = ntlmVersion;
    }

    public void setDynamicUsername(Value dynamicUsername) {
        this.dynamicUsername = dynamicUsername;
    }

    public void setDynamicPassword(Value dynamicPassword) {
        this.dynamicPassword = dynamicPassword;
    }

    public void setDynamicHost(Value dynamicHost) {
        this.dynamicHost = dynamicHost;
    }

    public void setDynamicDomain(Value dynamicDomain) {
        this.dynamicDomain = dynamicDomain;
    }

    public void setDynamicNtmlVersion(Value dynamicNtmlVersion) {
        this.dynamicNtmlVersion = dynamicNtmlVersion;
    }
}

