/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.builtin;

import com.github.fge.jackson.JsonLoader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.impl.llom.OMTextImpl;
import org.apache.axis2.AxisFault;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.commons.json.JsonUtil;
import org.apache.synapse.commons.json.jsonprocessor.exceptions.ParserException;
import org.apache.synapse.commons.json.jsonprocessor.exceptions.ValidatorException;
import org.apache.synapse.commons.json.jsonprocessor.parser.JsonProcessor;
import org.apache.synapse.commons.staxon.core.json.JsonXMLOutputFactory;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.MediatorProperty;
import org.apache.synapse.mediators.Value;

public class JSONTransformMediator
extends AbstractMediator {
    private Value schemaKey = null;
    private List<MediatorProperty> propertiesArrayList = new ArrayList<MediatorProperty>();
    private JsonXMLOutputFactory jsonOutputFactory;

    @Override
    public boolean mediate(MessageContext synCtx) {
        if (synCtx.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(synCtx)) {
            return true;
        }
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : JSONTransform mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        if (!this.propertiesArrayList.isEmpty()) {
            try {
                String jsonPayloadFromOMElement = JsonUtil.toJsonString((OMElement)((Axis2MessageContext)synCtx).getAxis2MessageContext().getEnvelope().getBody().getFirstElement(), (JsonXMLOutputFactory)this.jsonOutputFactory).toString();
                JsonUtil.getNewJsonPayload((org.apache.axis2.context.MessageContext)((Axis2MessageContext)synCtx).getAxis2MessageContext(), (String)jsonPayloadFromOMElement, (boolean)true, (boolean)true);
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("JSON stream after converting xml to json : " + jsonPayloadFromOMElement);
                }
            }
            catch (AxisFault af) {
                this.handleException("Axisfault occured when updating the JSON stream after applying the properties: ", (Exception)((Object)af), synCtx);
            }
        }
        if (this.schemaKey != null) {
            String generatedSchemaKey = this.schemaKey.evaluateValue(synCtx);
            Object jsonSchemaObj = synCtx.getEntry(generatedSchemaKey);
            if (jsonSchemaObj != null) {
                String schema = "";
                if (jsonSchemaObj instanceof OMTextImpl) {
                    try {
                        schema = JsonLoader.fromReader((Reader)new InputStreamReader(((OMTextImpl)jsonSchemaObj).getInputStream())).toString();
                    }
                    catch (OMException e) {
                        schema = ((OMTextImpl)jsonSchemaObj).getText();
                    }
                    catch (IOException e) {
                        this.handleException("Error while reading schema from registry", e, synCtx);
                    }
                } else if (jsonSchemaObj instanceof String) {
                    schema = (String)jsonSchemaObj;
                } else {
                    this.handleException("Can not find valid JSON Schema content", synCtx);
                }
                try {
                    String jsonPayload = JsonUtil.hasAJsonPayload((org.apache.axis2.context.MessageContext)((Axis2MessageContext)synCtx).getAxis2MessageContext()) ? JsonUtil.jsonPayloadToString((org.apache.axis2.context.MessageContext)((Axis2MessageContext)synCtx).getAxis2MessageContext()) : JsonUtil.toJsonString((OMElement)((Axis2MessageContext)synCtx).getAxis2MessageContext().getEnvelope().getBody().getFirstElement()).toString();
                    String result = JsonProcessor.parseJson((String)jsonPayload, (String)schema);
                    JsonUtil.getNewJsonPayload((org.apache.axis2.context.MessageContext)((Axis2MessageContext)synCtx).getAxis2MessageContext(), (String)result, (boolean)true, (boolean)true);
                    if (synLog.isTraceOrDebugEnabled()) {
                        synLog.traceOrDebug("JSON stream after applying schema : " + (result != null ? result : ""));
                    }
                }
                catch (ParserException | ValidatorException e) {
                    this.handleException(e.getMessage(), (Exception)e, synCtx);
                }
                catch (AxisFault af) {
                    this.handleException("Axisfault fault occured when updating the JSON stream after applying the JSON schema", (Exception)((Object)af), synCtx);
                }
            } else {
                this.handleException("Schema does not exist in the specified location : " + generatedSchemaKey, synCtx);
            }
        }
        synLog.traceOrDebug("End : JSON Transform mediator");
        return true;
    }

    public Value getSchemaKey() {
        return this.schemaKey;
    }

    public void setSchemaKey(Value schemaKey) {
        this.schemaKey = schemaKey;
    }

    public void addAllProperties(List<MediatorProperty> list) {
        this.propertiesArrayList = list;
        Properties properties = new Properties();
        for (MediatorProperty prop : list) {
            properties.setProperty(prop.getName(), prop.getValue());
        }
        this.jsonOutputFactory = JsonUtil.generateJSONOutputFactoryWithOveride((Properties)properties);
    }

    public List<MediatorProperty> getProperties() {
        return this.propertiesArrayList;
    }
}

