/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.builtin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import java.util.ArrayList;
import java.util.List;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.commons.json.JsonUtil;
import org.apache.synapse.config.xml.SynapsePath;
import org.apache.synapse.continuation.ContinuationStackManager;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.mediators.builtin.CallMediator;
import org.apache.synapse.mediators.builtin.CalloutMediator;
import org.apache.synapse.mediators.builtin.SendMediator;
import org.apache.synapse.mediators.eip.EIPUtils;
import org.apache.synapse.util.MessageHelper;
import org.apache.synapse.util.xpath.SynapseJsonPath;
import org.apache.synapse.util.xpath.SynapseXPath;

public class ForEachMediator
extends AbstractMediator
implements ManagedLifecycle {
    private SynapsePath expression = null;
    private SynapseEnvironment synapseEnv;
    private SequenceMediator sequence;
    private String sequenceRef;
    private String id;
    private static final String FOREACH_ORIGINAL_MESSAGE = "FOREACH_ORIGINAL_MESSAGE";
    private static final String FOREACH_COUNTER = "FOREACH_COUNTER";

    @Override
    public boolean mediate(MessageContext synCtx) {
        if (synCtx.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(synCtx)) {
            return true;
        }
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : Foreach mediator");
        }
        if (this.expression == null) {
            this.handleException("ForEach: expression is null", synCtx);
        }
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("ForEach expression : " + this.expression.toString());
        }
        String idPrefix = this.getId() == null ? "" : this.getId() + "_";
        String originalMsgPropName = idPrefix + FOREACH_ORIGINAL_MESSAGE;
        SOAPEnvelope originalEnvelope = MessageHelper.cloneSOAPEnvelope(synCtx.getEnvelope());
        synCtx.setProperty(originalMsgPropName, originalEnvelope);
        String counterPropName = idPrefix + FOREACH_COUNTER;
        int msgCounter = 0;
        synCtx.setProperty(counterPropName, msgCounter);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Saved original message property : " + originalMsgPropName + " = " + originalEnvelope + "Initialized foreach counter property, " + counterPropName + " = " + msgCounter);
        }
        if (this.expression != null && this.expression instanceof SynapseJsonPath) {
            JsonParser parser = new JsonParser();
            String jsonPayload = JsonUtil.jsonPayloadToString((org.apache.axis2.context.MessageContext)((Axis2MessageContext)synCtx).getAxis2MessageContext());
            DocumentContext parsedJsonPayload = JsonPath.parse((String)jsonPayload);
            JsonElement iterableChildElements = (JsonElement)parsedJsonPayload.read(((SynapseJsonPath)this.expression).getJsonPath());
            if (!(iterableChildElements instanceof JsonArray)) {
                this.handleException("JSON element expressed by the path " + ((SynapseJsonPath)this.expression).getJsonPathExpression() + " is not a valid JSON array", synCtx);
            }
            JsonArray iterableJsonArray = iterableChildElements.getAsJsonArray();
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Splitting with JSONPath : " + (Object)((Object)this.expression) + " resulted in " + iterableJsonArray.size() + " elements.");
            }
            JsonArray modifiedPayloadArray = new JsonArray();
            for (JsonElement element : iterableJsonArray) {
                try {
                    this.updateIteratedMessage(synCtx, element);
                    boolean mediateResult = this.mediateSequence(synCtx);
                    modifiedPayloadArray.add(EIPUtils.tryParseJsonString(parser, JsonUtil.jsonPayloadToString((org.apache.axis2.context.MessageContext)((Axis2MessageContext)synCtx).getAxis2MessageContext())));
                    ++msgCounter;
                    if (synLog.isTraceOrDebugEnabled()) {
                        synLog.traceOrDebug("Incrementing foreach counter , " + counterPropName + " = " + msgCounter);
                    }
                    synCtx.setProperty(counterPropName, msgCounter);
                    if (mediateResult) continue;
                    break;
                }
                catch (AxisFault axisFault) {
                    this.handleException("Error updating the stream with iterater element : " + element.toString(), (Exception)((Object)axisFault), synCtx);
                }
            }
            Object jsonPayloadElement = ((SynapseJsonPath)this.expression).isWholeBody() ? modifiedPayloadArray : (JsonElement)parsedJsonPayload.set(((SynapseJsonPath)this.expression).getJsonPath(), (Object)modifiedPayloadArray).json();
            try {
                JsonUtil.getNewJsonPayload((org.apache.axis2.context.MessageContext)((Axis2MessageContext)synCtx).getAxis2MessageContext(), (String)jsonPayloadElement.toString(), (boolean)true, (boolean)true);
            }
            catch (AxisFault af) {
                this.handleException("Error updating the json stream after foreach transformation", (Exception)((Object)af), synCtx);
            }
        } else {
            SOAPEnvelope processingEnvelope = synCtx.getEnvelope();
            DetachedElementContainer detachedElementContainer = this.getDetachedMatchingElements(processingEnvelope, synCtx, (SynapseXPath)this.expression);
            List<OMNode> splitElements = detachedElementContainer.getDetachedElements();
            int splitElementCount = splitElements.size();
            if (splitElementCount == 0) {
                return true;
            }
            OMContainer parent = detachedElementContainer.getParent();
            if (parent == null) {
                this.handleException("Error detecting parent element to merge", synCtx);
            }
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Splitting with XPath : " + (Object)((Object)this.expression) + " resulted in " + splitElementCount + " elements. Parent node for merging is : " + parent.toString());
            }
            for (OMNode element : splitElements) {
                if (!(element instanceof OMNode)) {
                    this.handleException("Error splitting message with XPath : " + (Object)((Object)this.expression) + " - result not an OMNode", synCtx);
                }
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("Submitting " + msgCounter + " of " + splitElementCount + " messages for processing in sequentially, in a general loop");
                }
                MessageContext iteratedMsgCtx = null;
                try {
                    iteratedMsgCtx = this.getIteratedMessage(synCtx, processingEnvelope, element);
                    ((Axis2MessageContext)iteratedMsgCtx).getAxis2MessageContext().removeProperty("org.apache.synapse.commons.json.JsonInputStream");
                }
                catch (AxisFault axisFault) {
                    this.handleException("Error creating an iterated copy of the message", (Exception)((Object)axisFault), synCtx);
                }
                boolean mediateResult = this.mediateSequence(iteratedMsgCtx);
                parent.addChild((OMNode)iteratedMsgCtx.getEnvelope().getBody().getFirstElement());
                ++msgCounter;
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("Incrementing foreach counter , " + counterPropName + " = " + msgCounter);
                }
                synCtx.setProperty(counterPropName, msgCounter);
                if (mediateResult) continue;
                break;
            }
            try {
                synCtx.setEnvelope(processingEnvelope);
            }
            catch (AxisFault axisFault) {
                this.handleException("Error while setting the envelope to the message context", (Exception)((Object)axisFault), synCtx);
            }
        }
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("After mediation foreach counter, " + counterPropName + " = " + msgCounter);
            synLog.traceOrDebug("End : For Each mediator");
        }
        return true;
    }

    private boolean mediateSequence(MessageContext synCtx) {
        if (this.sequence != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Synchronously mediating using the in-line anonymous sequence");
            }
            ContinuationStackManager.addReliantContinuationState(synCtx, 1, this.getMediatorPosition());
            return this.sequence.mediate(synCtx);
        }
        if (this.sequenceRef != null) {
            SequenceMediator referredSequence = (SequenceMediator)synCtx.getSequence(this.sequenceRef);
            if (referredSequence != null) {
                if (!this.validateSequence(referredSequence)) {
                    this.handleException("ForEach: Referred sequence cannot contain Call, Send or CallOut mediators", synCtx);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Synchronously mediating using the sequence named : " + this.sequenceRef));
                }
                return referredSequence.mediate(synCtx);
            }
            this.handleException("Couldn't find the sequence named : " + this.sequenceRef, synCtx);
        } else {
            this.handleException("Couldn't find sequence information", synCtx);
        }
        return false;
    }

    private boolean validateSequence(SequenceMediator seqMediator) {
        List<Mediator> mediators = seqMediator.getList();
        for (Mediator m : mediators) {
            if (!(m instanceof CallMediator) && !(m instanceof CalloutMediator) && !(m instanceof SendMediator)) continue;
            return false;
        }
        return true;
    }

    private MessageContext getIteratedMessage(MessageContext synCtx, SOAPEnvelope originalEnvelope, OMNode omNode) throws AxisFault {
        SOAPEnvelope newEnvelope = this.createNewSoapEnvelope(originalEnvelope);
        if (newEnvelope.getBody() != null) {
            newEnvelope.getBody().addChild(omNode);
        }
        synCtx.setEnvelope(newEnvelope);
        return synCtx;
    }

    private void updateIteratedMessage(MessageContext synCtx, JsonElement splitElement) throws AxisFault {
        JsonUtil.getNewJsonPayload((org.apache.axis2.context.MessageContext)((Axis2MessageContext)synCtx).getAxis2MessageContext(), (String)splitElement.toString(), (boolean)true, (boolean)true);
    }

    private SOAPEnvelope createNewSoapEnvelope(SOAPEnvelope envelope) {
        SOAPFactory fac = "http://schemas.xmlsoap.org/soap/envelope/".equals(envelope.getBody().getNamespace().getNamespaceURI()) ? OMAbstractFactory.getSOAP11Factory() : OMAbstractFactory.getSOAP12Factory();
        return fac.getDefaultEnvelope();
    }

    private DetachedElementContainer getDetachedMatchingElements(SOAPEnvelope envelope, MessageContext synCtx, SynapseXPath expression) {
        DetachedElementContainer resultContainer = new DetachedElementContainer();
        ArrayList<OMNode> elementList = new ArrayList<OMNode>();
        Object o = expression.evaluate(envelope, synCtx);
        if (o instanceof OMNode) {
            resultContainer.setParent(((OMNode)o).getParent());
            elementList.add(((OMNode)o).detach());
        } else if (o instanceof List) {
            List oList = (List)o;
            if (oList.size() > 0) {
                resultContainer.setParent(((OMNode)oList.get(0)).getParent());
            }
            for (Object elem : oList) {
                if (!(elem instanceof OMNode)) continue;
                elementList.add(((OMNode)elem).detach());
            }
        }
        resultContainer.setDetachedElements(elementList);
        return resultContainer;
    }

    @Override
    public void init(SynapseEnvironment se) {
        SequenceMediator refferedSeq;
        this.synapseEnv = se;
        if (null != this.sequence) {
            this.sequence.init(se);
        } else if (null != this.sequenceRef && ((refferedSeq = (SequenceMediator)se.getSynapseConfiguration().getSequence(this.sequenceRef)) == null || refferedSeq.isDynamic())) {
            se.addUnavailableArtifactRef(this.sequenceRef);
        }
    }

    @Override
    public void destroy() {
        SequenceMediator refferedSeq;
        if (null != this.sequence) {
            this.sequence.destroy();
        } else if (null != this.sequenceRef && ((refferedSeq = (SequenceMediator)this.synapseEnv.getSynapseConfiguration().getSequence(this.sequenceRef)) == null || refferedSeq.isDynamic())) {
            this.synapseEnv.removeUnavailableArtifactRef(this.sequenceRef);
        }
    }

    public SynapsePath getExpression() {
        return this.expression;
    }

    public void setExpression(SynapsePath expression) {
        this.expression = expression;
    }

    public SequenceMediator getSequence() {
        return this.sequence;
    }

    public void setSequence(SequenceMediator sequence) {
        this.sequence = sequence;
    }

    public String getSequenceRef() {
        return this.sequenceRef;
    }

    public void setSequenceRef(String sequenceKey) {
        this.sequenceRef = sequenceKey;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    private class DetachedElementContainer {
        private OMContainer parent;
        private List<OMNode> detachedElements;

        private DetachedElementContainer() {
        }

        public OMContainer getParent() {
            return this.parent;
        }

        public void setParent(OMContainer parent) {
            this.parent = parent;
        }

        public List<OMNode> getDetachedElements() {
            return this.detachedElements;
        }

        public void setDetachedElements(List<OMNode> detachedElements) {
            this.detachedElements = detachedElements;
        }
    }
}

