/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.builtin;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.ElementHelper;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.flow.statistics.StatisticIdentityGenerator;
import org.apache.synapse.aspects.flow.statistics.data.artifact.ArtifactHolder;
import org.apache.synapse.commons.json.JsonUtil;
import org.apache.synapse.commons.transaction.TranscationManger;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.AbstractEndpoint;
import org.apache.synapse.endpoints.AddressEndpoint;
import org.apache.synapse.endpoints.DefaultEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.EndpointDefinition;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.MediatorFaultHandler;
import org.apache.synapse.message.senders.blocking.BlockingMsgSender;
import org.apache.synapse.util.MessageHelper;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class CalloutMediator
extends AbstractMediator
implements ManagedLifecycle {
    private ConfigurationContext configCtx = null;
    private String serviceURL = null;
    private String action = null;
    private String requestKey = null;
    private SynapseXPath requestXPath = null;
    private SynapseXPath targetXPath = null;
    private String targetKey = null;
    private String clientRepository = null;
    private String axis2xml = null;
    private String useServerConfig = null;
    private boolean initClientOptions = true;
    private Endpoint endpoint;
    private String endpointKey = null;
    private boolean useEnvelopeAsSource = false;
    private boolean securityOn = false;
    private String wsSecPolicyKey = null;
    private String inboundWsSecPolicyKey = null;
    private String outboundWsSecPolicyKey = null;
    public static final String DEFAULT_CLIENT_REPO = "./repository/deployment/client";
    public static final String DEFAULT_AXIS2_XML;
    private boolean isWrappingEndpointCreated = false;
    private Context txContext;
    private static final String USER_TX_LOOKUP_STR = "java:comp/UserTransaction";
    private static final String DISTRIBUTED_TX_BEGIN_CHECK_STR = "transport.jms.TransactionCommand=begin";
    BlockingMsgSender blockingMsgSender = null;

    @Override
    public boolean mediate(MessageContext synCtx) {
        SynapseLog synLog;
        block48: {
            if (synCtx.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(synCtx)) {
                return true;
            }
            synLog = this.getLog(synCtx);
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Start : Callout mediator");
                if (synLog.isTraceTraceEnabled()) {
                    synLog.traceTrace("Message : " + synCtx.getEnvelope());
                }
            }
            try {
                if (!this.initClientOptions) {
                    this.blockingMsgSender.setInitClientOptions(false);
                }
                if (this.endpointKey != null) {
                    this.endpoint = synCtx.getEndpoint(this.endpointKey);
                }
                if (synLog.isTraceOrDebugEnabled()) {
                    if (!this.isWrappingEndpointCreated) {
                        synLog.traceOrDebug("Using the defined endpoint : " + this.endpoint.getName());
                    } else {
                        if (this.serviceURL != null) {
                            synLog.traceOrDebug("Using the serviceURL : " + this.serviceURL);
                        } else {
                            synLog.traceOrDebug("Using the To header as the EPR ");
                        }
                        if (this.securityOn) {
                            synLog.traceOrDebug("Security enabled within the Callout Mediator config");
                            if (this.wsSecPolicyKey != null) {
                                synLog.traceOrDebug("Using security policy key : " + this.wsSecPolicyKey);
                            } else {
                                if (this.inboundWsSecPolicyKey != null) {
                                    synLog.traceOrDebug("Using inbound security policy key : " + this.inboundWsSecPolicyKey);
                                }
                                if (this.outboundWsSecPolicyKey != null) {
                                    synLog.traceOrDebug("Using outbound security policy key : " + this.outboundWsSecPolicyKey);
                                }
                            }
                        }
                    }
                }
                org.apache.axis2.context.MessageContext axis2MsgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
                if (this.isWrappingEndpointCreated && "true".equals(axis2MsgCtx.getProperty("enableMTOM"))) {
                    ((AbstractEndpoint)this.endpoint).getDefinition().setUseMTOM(true);
                }
                if (this.serviceURL != null && this.serviceURL.contains(DISTRIBUTED_TX_BEGIN_CHECK_STR)) {
                    try {
                        this.initContext(synCtx);
                        try {
                            TranscationManger.lookUp((Context)this.txContext);
                        }
                        catch (Exception e) {
                            this.handleException("Cloud not get the context name java:comp/UserTransaction", e, synCtx);
                        }
                        TranscationManger.beginTransaction();
                        axis2MsgCtx.setProperty("distributedTx", (Object)TranscationManger.getTransaction());
                        axis2MsgCtx.setProperty("distributedTxMgr", (Object)TranscationManger.getTransactionManager());
                    }
                    catch (Exception e) {
                        this.handleException("Error starting transaction", synCtx);
                    }
                }
                MessageContext synapseOutMsgCtx = MessageHelper.cloneMessageContext(synCtx);
                this.setSoapHeaderBlock(synapseOutMsgCtx);
                this.setNTLMOptions(synCtx, synapseOutMsgCtx);
                if (!this.useEnvelopeAsSource && !JsonUtil.hasAJsonPayload((org.apache.axis2.context.MessageContext)((Axis2MessageContext)synapseOutMsgCtx).getAxis2MessageContext())) {
                    SOAPBody soapBody = synapseOutMsgCtx.getEnvelope().getBody();
                    Iterator itr = soapBody.getChildElements();
                    while (itr.hasNext()) {
                        OMElement child = (OMElement)itr.next();
                        child.detach();
                    }
                    soapBody.addChild((OMNode)this.getRequestPayload(synCtx));
                }
                if (this.action != null) {
                    synapseOutMsgCtx.setWSAAction(this.action);
                }
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("About to invoke the service");
                    if (synLog.isTraceTraceEnabled()) {
                        synLog.traceTrace("Request message payload : " + synapseOutMsgCtx.getEnvelope());
                    }
                }
                synapseOutMsgCtx.setProperty("blockingMsgSender", this.blockingMsgSender);
                Set keySet = synapseOutMsgCtx.getPropertyKeySet();
                if (keySet != null) {
                    keySet.remove("RECEIVING_SEQUENCE");
                    keySet.remove("DYNAMIC_URL_VALUE");
                    keySet.remove("last_endpoint");
                    keySet.remove("blocking.sender.error");
                }
                MediatorFaultHandler faultHandlerBeforeInvocation = this.getLastSequenceFaultHandler(synapseOutMsgCtx);
                synapseOutMsgCtx.setProperty("LAST_SEQ_FAULT_HANDLER", faultHandlerBeforeInvocation);
                this.endpoint.send(synapseOutMsgCtx);
                org.apache.axis2.context.MessageContext outAxis2MsgCtx = ((Axis2MessageContext)synapseOutMsgCtx).getAxis2MessageContext();
                if (outAxis2MsgCtx.getProperty("SET_ROLLBACK_ONLY") != null) {
                    axis2MsgCtx.setProperty("SET_ROLLBACK_ONLY", outAxis2MsgCtx.getProperty("SET_ROLLBACK_ONLY"));
                }
                if (faultHandlerBeforeInvocation != this.getLastSequenceFaultHandler(synapseOutMsgCtx)) {
                    return false;
                }
                if (!"true".equals(synapseOutMsgCtx.getProperty("blocking.sender.error"))) {
                    if (synapseOutMsgCtx.getProperty("OUT_ONLY") == null || "false".equals(synapseOutMsgCtx.getProperty("OUT_ONLY"))) {
                        this.setResponseHttpSc(synapseOutMsgCtx, synCtx);
                        if (synLog.isTraceTraceEnabled()) {
                            synLog.traceTrace("Response payload received : " + synapseOutMsgCtx.getEnvelope());
                        }
                        if (synapseOutMsgCtx.getEnvelope() != null) {
                            org.apache.axis2.context.MessageContext resultAxisMsgCtx = ((Axis2MessageContext)synapseOutMsgCtx).getAxis2MessageContext();
                            org.apache.axis2.context.MessageContext inAxisMsgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
                            if (JsonUtil.hasAJsonPayload((org.apache.axis2.context.MessageContext)resultAxisMsgCtx)) {
                                JsonUtil.cloneJsonPayload((org.apache.axis2.context.MessageContext)resultAxisMsgCtx, (org.apache.axis2.context.MessageContext)inAxisMsgCtx);
                            } else if (this.targetXPath != null) {
                                Object o = this.targetXPath.evaluate(synCtx);
                                OMElement result = synapseOutMsgCtx.getEnvelope().getBody().getFirstElement();
                                if (o != null && o instanceof OMElement) {
                                    OMElement tgtNode = (OMElement)o;
                                    tgtNode.insertSiblingAfter((OMNode)result);
                                    tgtNode.detach();
                                } else if (o != null && o instanceof List && !((List)o).isEmpty()) {
                                    OMElement tgtNode = (OMElement)((List)o).get(0);
                                    tgtNode.insertSiblingAfter((OMNode)result);
                                    tgtNode.detach();
                                } else {
                                    this.handleException("Evaluation of target XPath expression : " + this.targetXPath.toString() + " did not yeild an OMNode", synCtx);
                                }
                            } else if (this.targetKey != null) {
                                OMElement result = synapseOutMsgCtx.getEnvelope().getBody().getFirstElement();
                                synCtx.setProperty(this.targetKey, result);
                            } else {
                                synCtx.setEnvelope(synapseOutMsgCtx.getEnvelope());
                            }
                            inAxisMsgCtx.setProperty("HTTP_SC", resultAxisMsgCtx.getProperty("HTTP_SC"));
                            if ("false".equals(synCtx.getProperty("BLOCKING_SENDER_PRESERVE_REQ_HEADERS"))) {
                                inAxisMsgCtx.setProperty("TRANSPORT_HEADERS", resultAxisMsgCtx.getProperty("TRANSPORT_HEADERS"));
                            }
                        } else {
                            synLog.traceOrDebug("Service returned a null response");
                        }
                    }
                    break block48;
                }
                this.log.info((Object)"Error while performing the callout operation");
                return false;
            }
            catch (AxisFault e) {
                this.handleException("Error invoking service : " + this.serviceURL + (this.action != null ? " with action : " + this.action : ""), (Exception)((Object)e), synCtx);
            }
            catch (JaxenException e) {
                this.handleException("Error while evaluating the XPath expression: " + (Object)((Object)this.targetXPath), (Exception)((Object)e), synCtx);
            }
        }
        synLog.traceOrDebug("End : Callout mediator");
        return true;
    }

    private void setSoapHeaderBlock(MessageContext synCtx) {
        if (synCtx.getEnvelope().getHeader() != null) {
            Iterator iHeader = synCtx.getEnvelope().getHeader().getChildren();
            SOAPFactory fac = "http://schemas.xmlsoap.org/soap/envelope/".equals(synCtx.getEnvelope().getBody().getNamespace().getNamespaceURI()) ? OMAbstractFactory.getSOAP11Factory() : OMAbstractFactory.getSOAP12Factory();
            ArrayList<OMElement> newHeaderNodes = new ArrayList<OMElement>();
            while (iHeader.hasNext()) {
                try {
                    Object element = iHeader.next();
                    if (element instanceof SOAPHeaderBlock) continue;
                    if (element instanceof OMElement) {
                        newHeaderNodes.add(ElementHelper.toSOAPHeaderBlock((OMElement)((OMElement)element), (SOAPFactory)fac).cloneOMElement());
                    }
                    iHeader.remove();
                }
                catch (OMException e) {
                    this.log.error((Object)"Unable to convert to SoapHeader Block", (Throwable)e);
                }
                catch (Exception e) {
                    this.log.error((Object)"Unable to convert to SoapHeader Block", (Throwable)e);
                }
            }
            for (OMNode oMNode : newHeaderNodes) {
                synCtx.getEnvelope().getHeader().addChild(oMNode);
            }
        }
    }

    private void handleFault(MessageContext synCtx, Exception ex) {
        synCtx.setProperty("SENDING_FAULT", Boolean.TRUE);
        if (ex instanceof AxisFault) {
            AxisFault axisFault = (AxisFault)((Object)ex);
            int errorCode = 401000;
            if (axisFault.getFaultCodeElement() != null && !"".equals(axisFault.getFaultCodeElement().getText())) {
                try {
                    errorCode = Integer.parseInt(axisFault.getFaultCodeElement().getText());
                }
                catch (NumberFormatException e) {
                    errorCode = 401000;
                }
            }
            synCtx.setProperty("ERROR_CODE", errorCode);
            if (axisFault.getMessage() != null) {
                synCtx.setProperty("ERROR_MESSAGE", axisFault.getMessage());
            } else {
                synCtx.setProperty("ERROR_MESSAGE", "Error while performing the callout operation");
            }
            if (axisFault.getFaultDetailElement() != null) {
                if (axisFault.getFaultDetailElement().getFirstElement() != null) {
                    synCtx.setProperty("ERROR_DETAIL", axisFault.getFaultDetailElement().getFirstElement());
                } else {
                    synCtx.setProperty("ERROR_DETAIL", axisFault.getFaultDetailElement().getText());
                }
            }
        }
        synCtx.setProperty("ERROR_EXCEPTION", ex);
        throw new SynapseException("Error while performing the callout operation", ex);
    }

    private OMElement getRequestPayload(MessageContext synCtx) throws AxisFault {
        if (this.requestKey != null) {
            Object request = synCtx.getProperty(this.requestKey);
            if (request == null) {
                request = synCtx.getEntry(this.requestKey);
            }
            if (request != null && request instanceof OMElement) {
                return (OMElement)request;
            }
            this.handleException("The property : " + this.requestKey + " is not an OMElement", synCtx);
        } else if (this.requestXPath != null) {
            try {
                Object o = this.requestXPath.evaluate(MessageHelper.cloneMessageContext(synCtx));
                if (o instanceof OMElement) {
                    return (OMElement)o;
                }
                if (o instanceof List && !((List)o).isEmpty()) {
                    return (OMElement)((List)o).get(0);
                }
                this.handleException("The evaluation of the XPath expression : " + this.requestXPath.toString() + " did not result in an OMElement", synCtx);
            }
            catch (JaxenException e) {
                this.handleException("Error evaluating XPath expression : " + this.requestXPath.toString(), (Exception)((Object)e), synCtx);
            }
        }
        return null;
    }

    @Override
    public void init(SynapseEnvironment synEnv) {
        try {
            this.configCtx = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)(this.clientRepository != null ? this.clientRepository : DEFAULT_CLIENT_REPO), (String)(this.axis2xml != null ? this.axis2xml : DEFAULT_AXIS2_XML));
            if (this.serviceURL != null) {
                this.serviceURL = this.changeEndPointReference(this.serviceURL);
            }
            this.blockingMsgSender = new BlockingMsgSender();
            this.blockingMsgSender.setConfigurationContext(this.configCtx);
            this.blockingMsgSender.init();
            EndpointDefinition endpointDefinition = null;
            if (this.serviceURL != null) {
                this.endpoint = new AddressEndpoint();
                endpointDefinition = new EndpointDefinition();
                endpointDefinition.setAddress(this.serviceURL);
                endpointDefinition.addSuspendErrorCode(-1);
                endpointDefinition.addTimeoutErrorCode(-1);
                ((AddressEndpoint)this.endpoint).setDefinition(endpointDefinition);
                this.isWrappingEndpointCreated = true;
            } else if (this.endpoint == null && this.endpointKey == null) {
                this.endpoint = new DefaultEndpoint();
                endpointDefinition = new EndpointDefinition();
                ((DefaultEndpoint)this.endpoint).setDefinition(endpointDefinition);
                this.isWrappingEndpointCreated = true;
            }
            if (endpointDefinition != null && this.isSecurityOn()) {
                endpointDefinition.setSecurityOn(true);
                if (this.wsSecPolicyKey != null) {
                    endpointDefinition.setWsSecPolicyKey(this.wsSecPolicyKey);
                } else {
                    if (this.inboundWsSecPolicyKey != null) {
                        endpointDefinition.setInboundWsSecPolicyKey(this.inboundWsSecPolicyKey);
                    }
                    if (this.outboundWsSecPolicyKey != null) {
                        endpointDefinition.setOutboundWsSecPolicyKey(this.outboundWsSecPolicyKey);
                    }
                }
            }
            if (this.endpoint != null) {
                this.endpoint.init(synEnv);
            }
        }
        catch (AxisFault e) {
            String msg = "Error initializing callout mediator : " + e.getMessage();
            this.log.error((Object)msg, (Throwable)e);
            throw new SynapseException(msg, e);
        }
    }

    @Override
    public void destroy() {
        try {
            this.configCtx.terminate();
        }
        catch (AxisFault axisFault) {
            // empty catch block
        }
    }

    public String getServiceURL() {
        return this.serviceURL;
    }

    public void setServiceURL(String serviceURL) {
        this.serviceURL = serviceURL;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getUseServerConfig() {
        return this.useServerConfig;
    }

    public void setUseServerConfig(String useServerConfig) {
        this.useServerConfig = useServerConfig;
    }

    public String getRequestKey() {
        return this.requestKey;
    }

    public void setRequestKey(String requestKey) {
        this.requestKey = requestKey;
    }

    public void setRequestXPath(SynapseXPath requestXPath) throws JaxenException {
        this.requestXPath = requestXPath;
    }

    public void setTargetXPath(SynapseXPath targetXPath) throws JaxenException {
        this.targetXPath = targetXPath;
    }

    public String getTargetKey() {
        return this.targetKey;
    }

    public void setTargetKey(String targetKey) {
        this.targetKey = targetKey;
    }

    public SynapseXPath getRequestXPath() {
        return this.requestXPath;
    }

    public SynapseXPath getTargetXPath() {
        return this.targetXPath;
    }

    public String getClientRepository() {
        return this.clientRepository;
    }

    public void setClientRepository(String clientRepository) {
        this.clientRepository = clientRepository;
    }

    public String getAxis2xml() {
        return this.axis2xml;
    }

    public void setAxis2xml(String axis2xml) {
        this.axis2xml = axis2xml;
    }

    public void setEndpointKey(String key) {
        this.endpointKey = key;
    }

    public String getEndpointKey() {
        return this.endpointKey;
    }

    public boolean getInitClientOptions() {
        return this.initClientOptions;
    }

    public void setInitClientOptions(boolean initClientOptions) {
        this.initClientOptions = initClientOptions;
    }

    public boolean isUseEnvelopeAsSource() {
        return this.useEnvelopeAsSource;
    }

    public void setUseEnvelopeAsSource(boolean useEnvelopeAsSource) {
        this.useEnvelopeAsSource = useEnvelopeAsSource;
    }

    public boolean isSecurityOn() {
        return this.securityOn;
    }

    public void setSecurityOn(boolean securityOn) {
        this.securityOn = securityOn;
    }

    public String getWsSecPolicyKey() {
        return this.wsSecPolicyKey;
    }

    public void setWsSecPolicyKey(String wsSecPolicyKey) {
        this.wsSecPolicyKey = wsSecPolicyKey;
    }

    public String getOutboundWsSecPolicyKey() {
        return this.outboundWsSecPolicyKey;
    }

    public void setOutboundWsSecPolicyKey(String outboundWsSecPolicyKey) {
        this.outboundWsSecPolicyKey = outboundWsSecPolicyKey;
    }

    public String getInboundWsSecPolicyKey() {
        return this.inboundWsSecPolicyKey;
    }

    public void setInboundWsSecPolicyKey(String inboundWsSecPolicyKey) {
        this.inboundWsSecPolicyKey = inboundWsSecPolicyKey;
    }

    private String changeEndPointReference(String epr) {
        if (epr.toLowerCase().contains("system.prop")) {
            Pattern p = Pattern.compile("\\{(.*?)\\}");
            Matcher m = p.matcher(epr);
            HashMap<String, String> result = new HashMap<String, String>();
            while (m.find()) {
                result.put(m.group(1), "");
                String propName = System.getProperty(m.group(1).replace("system.prop.", ""));
                if (propName != null) {
                    epr = epr.replace("{" + m.group(1) + "}", propName);
                    continue;
                }
                this.log.warn((Object)"System property is not initialized");
            }
            this.log.info((Object)"Dynamic properties of url are replaced");
        }
        return epr;
    }

    public Endpoint getEndpoint() {
        if (!this.isWrappingEndpointCreated) {
            return this.endpoint;
        }
        return null;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    private void setResponseHttpSc(MessageContext sourceSynCtx, MessageContext destinationSynCtx) {
        if (sourceSynCtx != null) {
            org.apache.axis2.context.MessageContext axis2MessageContext = ((Axis2MessageContext)destinationSynCtx).getAxis2MessageContext();
            axis2MessageContext.setProperty("HTTP_SC", ((Axis2MessageContext)sourceSynCtx).getAxis2MessageContext().getProperty("HTTP_SC"));
        }
    }

    @Override
    public void setComponentStatisticsId(ArtifactHolder holder) {
        if (this.getAspectConfiguration() == null) {
            this.configure(new AspectConfiguration(this.getMediatorName()));
        }
        String cloneId = StatisticIdentityGenerator.getIdForComponent(this.getMediatorName(), ComponentType.MEDIATOR, holder);
        this.getAspectConfiguration().setUniqueId(cloneId);
        if (this.endpointKey != null) {
            String childId = StatisticIdentityGenerator.getIdReferencingComponent(this.endpointKey, ComponentType.ENDPOINT, holder);
            StatisticIdentityGenerator.reportingEndEvent(childId, ComponentType.ENDPOINT, holder);
        } else if (this.endpoint != null) {
            this.endpoint.setComponentStatisticsId(holder);
        }
        StatisticIdentityGenerator.reportingEndEvent(cloneId, ComponentType.MEDIATOR, holder);
    }

    private void initContext(MessageContext synCtx) {
        try {
            this.txContext = new InitialContext();
        }
        catch (NamingException e) {
            this.handleException("Cloud not create initial context", e, synCtx);
        }
    }

    private void setNTLMOptions(MessageContext synCtx, MessageContext clonedSynCtx) {
        org.apache.axis2.context.MessageContext axis2MsgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        org.apache.axis2.context.MessageContext clonedAxis2MsgCtx = ((Axis2MessageContext)clonedSynCtx).getAxis2MessageContext();
        clonedAxis2MsgCtx.getOptions().setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", axis2MsgCtx.getOptions().getProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_"));
        clonedAxis2MsgCtx.getOptions().setProperty("MULTITHREAD_HTTP_CONNECTION_MANAGER", axis2MsgCtx.getOptions().getProperty("MULTITHREAD_HTTP_CONNECTION_MANAGER"));
    }

    static {
        String confPath = System.getProperty("conf.location");
        if (confPath == null && (confPath = System.getProperty("carbon.config.dir.path")) == null) {
            confPath = Paths.get("repository", "conf").toString();
        }
        DEFAULT_AXIS2_XML = Paths.get(confPath, "axis2", "axis2_blocking_client.xml").toString();
    }
}

