/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.builtin;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Set;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.synapse.ContinuationState;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.flow.statistics.StatisticIdentityGenerator;
import org.apache.synapse.aspects.flow.statistics.data.artifact.ArtifactHolder;
import org.apache.synapse.commons.json.JsonUtil;
import org.apache.synapse.continuation.ContinuationStackManager;
import org.apache.synapse.continuation.SeqContinuationState;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.EndpointDefinition;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.MediatorFaultHandler;
import org.apache.synapse.mediators.elementary.Source;
import org.apache.synapse.mediators.elementary.Target;
import org.apache.synapse.message.senders.blocking.BlockingMsgSender;
import org.apache.synapse.util.CallMediatorEnrichUtil;
import org.apache.synapse.util.MessageHelper;

public class CallMediator
extends AbstractMediator
implements ManagedLifecycle {
    public static final String DEFAULT_CLIENT_REPO = "./repository/deployment/client";
    public static final String DEFAULT_AXIS2_XML;
    private BlockingMsgSender blockingMsgSender = null;
    private ConfigurationContext configCtx = null;
    private Endpoint endpoint = null;
    private boolean blocking = false;
    private SynapseEnvironment synapseEnv;
    private boolean initClientOptions = true;
    private String clientRepository = null;
    private String axis2xml = null;
    private boolean isSourceAvailable = false;
    private boolean isTargetAvailable = false;
    private String sourceMessageType = null;
    private Source sourceForOutboundPayload;
    private Target targetForInboundPayload;
    public static final String INTERMEDIATE_ORIGINAL_BODY = "_INTERMEDIATE_ORIGINAL_BODY";
    public static final String TARGET_FOR_INBOUND_PAYLOAD = "_TARGET_FOR_INBOUND_PAYLOAD";
    public static final String ORIGINAL_MESSAGE_TYPE = "_ORIGINAL_MESSAGE_TYPE";
    public static final String SOURCE_MESSAGE_TYPE = "_SOURCE_MESSAGE_TYPE";
    public static final String IS_SOURCE_AVAILABLE = "_IS_SOURCE_AVAILABLE";
    public static final String IS_TARGET_AVAILABLE = "IS_TARGET_AVAILABLE";
    public static final String ORIGINAL_TRANSPORT_HEADERS = "_ORIGINAL_TRANSPORT_HEADERS";
    public static final String ORIGINAL_CONTENT_TYPE = "_ORIGINAL_CONTENT_TYPE";
    public static final String JSON_TYPE = "application/json";
    private boolean isWrappingEndpointCreated;

    @Override
    public boolean mediate(MessageContext synInCtx) {
        if (synInCtx.getEnvironment().isDebuggerEnabled()) {
            MessageHelper.setWireLogHolderProperties(synInCtx, this.isBreakPoint(), this.getRegisteredMediationFlowPoint());
            if (super.divertMediationRoute(synInCtx)) {
                return true;
            }
        }
        org.apache.axis2.context.MessageContext axis2MessageContext = ((Axis2MessageContext)synInCtx).getAxis2MessageContext();
        Object messageType = axis2MessageContext.getProperty("messageType");
        Object contentType = axis2MessageContext.getProperty("ContentType");
        Object headers = axis2MessageContext.getProperty("TRANSPORT_HEADERS");
        Map originalTransportHeaders = (Map)headers;
        String originalMessageType = (String)messageType;
        String originalContentType = (String)contentType;
        if (this.sourceMessageType == null) {
            this.sourceMessageType = originalMessageType;
        }
        if (this.isSourceAvailable) {
            CallMediatorEnrichUtil.buildMessage(synInCtx);
        }
        if (this.isSourceAvailable && this.isTargetAvailable) {
            Source sourceForInboundPayload = CallMediatorEnrichUtil.createSourceWithBody();
            Target targetForOriginalPayload = CallMediatorEnrichUtil.createTargetWithProperty(INTERMEDIATE_ORIGINAL_BODY);
            Target targetForOutboundPayload = CallMediatorEnrichUtil.createTargetWithBody();
            sourceForInboundPayload.setClone(true);
            CallMediatorEnrichUtil.doEnrich(synInCtx, sourceForInboundPayload, targetForOriginalPayload, originalMessageType);
            CallMediatorEnrichUtil.doEnrich(synInCtx, this.sourceForOutboundPayload, targetForOutboundPayload, this.getSourceMessageType());
            if (!this.sourceMessageType.equalsIgnoreCase(originalMessageType)) {
                CallMediatorEnrichUtil.setContentType(synInCtx, this.sourceMessageType, this.sourceMessageType);
                if (originalMessageType.equalsIgnoreCase(JSON_TYPE)) {
                    JsonUtil.removeJsonStream((org.apache.axis2.context.MessageContext)axis2MessageContext);
                }
            }
        } else if (this.isSourceAvailable) {
            Target targetForOutboundPayload = CallMediatorEnrichUtil.createTargetWithBody();
            CallMediatorEnrichUtil.doEnrich(synInCtx, this.sourceForOutboundPayload, targetForOutboundPayload, this.getSourceMessageType());
            if (!this.sourceMessageType.equalsIgnoreCase(originalMessageType)) {
                CallMediatorEnrichUtil.setContentType(synInCtx, this.sourceMessageType, this.sourceMessageType);
                if (originalMessageType.equalsIgnoreCase(JSON_TYPE)) {
                    JsonUtil.removeJsonStream((org.apache.axis2.context.MessageContext)axis2MessageContext);
                }
            }
        }
        synInCtx.setProperty(TARGET_FOR_INBOUND_PAYLOAD, this.targetForInboundPayload);
        synInCtx.setProperty(SOURCE_MESSAGE_TYPE, this.sourceMessageType);
        synInCtx.setProperty(ORIGINAL_MESSAGE_TYPE, originalMessageType);
        synInCtx.setProperty(IS_SOURCE_AVAILABLE, this.isSourceAvailable);
        synInCtx.setProperty(IS_TARGET_AVAILABLE, this.isTargetAvailable);
        synInCtx.setProperty(ORIGINAL_CONTENT_TYPE, originalContentType);
        synInCtx.setProperty(ORIGINAL_TRANSPORT_HEADERS, originalTransportHeaders);
        if (this.blocking) {
            return this.handleBlockingCall(synInCtx, originalMessageType, originalContentType, originalTransportHeaders);
        }
        return this.handleNonBlockingCall(synInCtx);
    }

    private boolean handleBlockingCall(MessageContext synInCtx, String originalMessageType, String originalContentType, Map originalTransportHeaders) {
        SynapseLog synLog = this.getLog(synInCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : Call mediator - Blocking Call");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synInCtx.getEnvelope());
            }
        }
        this.blockingMsgSender.setInitClientOptions(this.initClientOptions);
        synInCtx.setProperty("blockingMsgSender", this.blockingMsgSender);
        Set keySet = synInCtx.getPropertyKeySet();
        if (keySet != null) {
            keySet.remove("RECEIVING_SEQUENCE");
            keySet.remove("DYNAMIC_URL_VALUE");
            keySet.remove("last_endpoint");
            keySet.remove("blocking.sender.error");
        }
        MediatorFaultHandler faultHandlerBeforeInvocation = this.getLastSequenceFaultHandler(synInCtx);
        synInCtx.setProperty("LAST_SEQ_FAULT_HANDLER", faultHandlerBeforeInvocation);
        if (this.endpoint == null) {
            EndpointDefinition endpointDefinition = new EndpointDefinition();
            synInCtx.getEnvironment().send(endpointDefinition, synInCtx);
        } else {
            this.endpoint.send(synInCtx);
        }
        if (faultHandlerBeforeInvocation != this.getLastSequenceFaultHandler(synInCtx)) {
            return false;
        }
        if (!"true".equals(synInCtx.getProperty("blocking.sender.error"))) {
            if (synInCtx.getProperty("OUT_ONLY") == null || "false".equals(synInCtx.getProperty("OUT_ONLY"))) {
                if (synInCtx.getEnvelope() != null) {
                    if (synLog.isTraceTraceEnabled()) {
                        synLog.traceTrace("Response payload received : " + synInCtx.getEnvelope());
                    }
                    if (synLog.isTraceOrDebugEnabled()) {
                        synLog.traceOrDebug("End : Call mediator - Blocking Call");
                    }
                } else if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("Service returned a null response");
                }
            }
        } else {
            this.log.error((Object)"Error while performing the call operation in blocking mode");
            return false;
        }
        this.postMediate(synInCtx, originalMessageType, originalContentType, originalTransportHeaders);
        return true;
    }

    public void postMediate(MessageContext response, String originalMessageType, String originalContentType, Map originalTransportHeaders) {
        if (this.isTargetAvailable()) {
            CallMediatorEnrichUtil.buildMessage(response);
        }
        if (this.isTargetAvailable && this.isSourceAvailable) {
            Source sourceForResponsePayload = CallMediatorEnrichUtil.createSourceWithBody();
            Source sourceForOriginalPayload = CallMediatorEnrichUtil.createSourceWithProperty(INTERMEDIATE_ORIGINAL_BODY);
            Target targetForResponsePayload = CallMediatorEnrichUtil.createTargetWithBody();
            CallMediatorEnrichUtil.doEnrich(response, sourceForResponsePayload, this.targetForInboundPayload, this.getSourceMessageType());
            CallMediatorEnrichUtil.doEnrich(response, sourceForOriginalPayload, targetForResponsePayload, originalMessageType);
            CallMediatorEnrichUtil.preservetransportHeaders(response, originalTransportHeaders);
            if (!this.sourceMessageType.equalsIgnoreCase(originalMessageType)) {
                CallMediatorEnrichUtil.setContentType(response, originalMessageType, originalContentType);
                if (this.sourceMessageType.equalsIgnoreCase(JSON_TYPE)) {
                    JsonUtil.removeJsonStream((org.apache.axis2.context.MessageContext)((Axis2MessageContext)response).getAxis2MessageContext());
                }
            }
        } else if (this.isTargetAvailable) {
            Source sourceForResponsePayload = CallMediatorEnrichUtil.createSourceWithBody();
            CallMediatorEnrichUtil.doEnrich(response, sourceForResponsePayload, this.targetForInboundPayload, this.getSourceMessageType());
        }
    }

    private boolean handleNonBlockingCall(MessageContext synInCtx) {
        SynapseLog synLog = this.getLog(synInCtx);
        if (synInCtx.getContinuationStateStack().isEmpty()) {
            throw new SynapseException("Continuation Stack Empty! Cannot proceed with the call");
        }
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : Contents of Continuation Stack");
            for (ContinuationState state : synInCtx.getContinuationStateStack()) {
                SeqContinuationState seqstate = (SeqContinuationState)state;
                synLog.traceOrDebug("Sequence Type : " + (Object)((Object)seqstate.getSeqType()) + " Sequence Name : " + seqstate.getSeqName());
            }
            synLog.traceOrDebug("End : Contents of Continuation Stack");
        }
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : Call mediator - Non Blocking Call");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synInCtx.getEnvelope());
            }
        }
        MediatorFaultHandler faultHandlerBeforeInvocation = this.getLastSequenceFaultHandler(synInCtx);
        synInCtx.setProperty("LAST_SEQ_FAULT_HANDLER", faultHandlerBeforeInvocation);
        Set keySet = synInCtx.getPropertyKeySet();
        if (keySet != null) {
            keySet.remove("RECEIVING_SEQUENCE");
            keySet.remove("DYNAMIC_URL_VALUE");
            keySet.remove("last_endpoint");
            keySet.remove("blockingMsgSender");
            keySet.remove("blocking.sender.error");
        }
        boolean outOnlyMessage = "true".equals(synInCtx.getProperty("OUT_ONLY"));
        MessageContext synOutCtx = null;
        if (outOnlyMessage) {
            try {
                synOutCtx = MessageHelper.cloneMessageContext(synInCtx, true, true, false, false);
            }
            catch (AxisFault axisFault) {
                this.handleException("Error occurred while cloning msg context", (Exception)((Object)axisFault), synInCtx);
            }
        } else {
            synOutCtx = synInCtx;
        }
        synOutCtx.setProperty("continuation.call", true);
        ContinuationStackManager.updateSeqContinuationState(synOutCtx, this.getMediatorPosition());
        try {
            if (this.endpoint == null) {
                if (synLog.isTraceOrDebugEnabled()) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("Calling ").append(synOutCtx.isResponse() ? "response" : "request").append(" message using implicit message properties..");
                    sb.append("\nCalling To: ").append(synOutCtx.getTo() != null ? synOutCtx.getTo().getAddress() : "null");
                    sb.append("\nSOAPAction: ").append(synOutCtx.getWSAAction() != null ? synOutCtx.getWSAAction() : "null");
                    synLog.traceOrDebug(sb.toString());
                }
                if (synLog.isTraceTraceEnabled()) {
                    synLog.traceTrace("Envelope : " + synOutCtx.getEnvelope());
                }
                synOutCtx.getEnvironment().send(null, synOutCtx);
            } else {
                this.endpoint.send(synOutCtx);
            }
            MediatorFaultHandler lastSequenceFaultHandler = this.getLastSequenceFaultHandler(synOutCtx);
            if (lastSequenceFaultHandler != null && faultHandlerBeforeInvocation != lastSequenceFaultHandler) {
                return false;
            }
        }
        catch (Exception e) {
            this.handleFault(synInCtx, e);
        }
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("End : Call mediator - Non Blocking Call");
        }
        return outOnlyMessage;
    }

    public Endpoint getEndpoint() {
        if (this.isWrappingEndpointCreated) {
            return null;
        }
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public void init(SynapseEnvironment synapseEnvironment) {
        this.synapseEnv = synapseEnvironment;
        if (this.endpoint != null) {
            this.endpoint.init(synapseEnvironment);
        }
        if (this.blocking) {
            try {
                this.configCtx = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)(this.clientRepository != null ? this.clientRepository : DEFAULT_CLIENT_REPO), (String)(this.axis2xml != null ? this.axis2xml : DEFAULT_AXIS2_XML));
                this.blockingMsgSender = new BlockingMsgSender();
                this.blockingMsgSender.setConfigurationContext(this.configCtx);
                this.blockingMsgSender.init();
            }
            catch (AxisFault axisFault) {
                String msg = "Error while initializing the Call mediator";
                this.log.error((Object)msg, (Throwable)axisFault);
                throw new SynapseException(msg, axisFault);
            }
        } else {
            synapseEnvironment.updateCallMediatorCount(true);
        }
    }

    @Override
    public void destroy() {
        if (this.endpoint != null) {
            this.endpoint.destroy();
        }
        if (!this.blocking) {
            this.synapseEnv.updateCallMediatorCount(false);
        }
    }

    @Override
    public boolean isContentAware() {
        return this.blocking;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    public boolean getInitClientOptions() {
        return this.initClientOptions;
    }

    public void setInitClientOptions(boolean initClientOptions) {
        this.initClientOptions = initClientOptions;
    }

    public String getClientRepository() {
        return this.clientRepository;
    }

    public void setClientRepository(String clientRepository) {
        this.clientRepository = clientRepository;
    }

    public String getAxis2xml() {
        return this.axis2xml;
    }

    public void setAxis2xml(String axis2xml) {
        this.axis2xml = axis2xml;
    }

    private void handleFault(MessageContext synCtx, Exception ex) {
        synCtx.setProperty("SENDING_FAULT", Boolean.TRUE);
        AxisFault axisFault = null;
        if (ex instanceof SynapseException) {
            if (ex.getCause() != null && ex.getCause() instanceof AxisFault) {
                axisFault = (AxisFault)ex.getCause();
            }
        } else if (ex instanceof AxisFault) {
            axisFault = (AxisFault)((Object)ex);
        }
        int errorCode = 401003;
        if (axisFault != null) {
            if (axisFault.getFaultCodeElement() != null && !"".equals(axisFault.getFaultCodeElement().getText())) {
                try {
                    errorCode = Integer.parseInt(axisFault.getFaultCodeElement().getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            synCtx.setProperty("ERROR_CODE", errorCode);
            if (axisFault.getCause() != null && axisFault.getCause().getCause() != null && axisFault.getCause().getCause() instanceof IOException) {
                synCtx.setProperty("ERROR_MESSAGE", axisFault.getCause().getCause().getMessage());
            } else if (axisFault.getMessage() != null) {
                synCtx.setProperty("ERROR_MESSAGE", axisFault.getMessage());
            } else {
                synCtx.setProperty("ERROR_MESSAGE", "Error while performing the call operation");
            }
            if (axisFault.getFaultDetailElement() != null) {
                if (axisFault.getFaultDetailElement().getFirstElement() != null) {
                    synCtx.setProperty("ERROR_DETAIL", axisFault.getFaultDetailElement().getFirstElement());
                } else {
                    synCtx.setProperty("ERROR_DETAIL", axisFault.getFaultDetailElement().getText());
                }
            }
        }
        synCtx.setProperty("ERROR_EXCEPTION", ex);
        throw new SynapseException("Error while performing the call operation", ex);
    }

    @Override
    public void setComponentStatisticsId(ArtifactHolder holder) {
        if (this.getAspectConfiguration() == null) {
            this.configure(new AspectConfiguration(this.getMediatorName()));
        }
        String cloneId = StatisticIdentityGenerator.getIdForComponent(this.getMediatorName(), ComponentType.MEDIATOR, holder);
        this.getAspectConfiguration().setUniqueId(cloneId);
        if (this.endpoint != null && !this.blocking) {
            this.endpoint.setComponentStatisticsId(holder);
        }
        StatisticIdentityGenerator.reportingEndEvent(cloneId, ComponentType.MEDIATOR, holder);
    }

    public boolean isSourceAvailable() {
        return this.isSourceAvailable;
    }

    public void setSourceAvailable(boolean sourceAvailable) {
        this.isSourceAvailable = sourceAvailable;
    }

    public boolean isTargetAvailable() {
        return this.isTargetAvailable;
    }

    public void setTargetAvailable(boolean targetAvailable) {
        this.isTargetAvailable = targetAvailable;
    }

    public Source getSourceForOutboundPayload() {
        return this.sourceForOutboundPayload;
    }

    public void setSourceForOutboundPayload(Source sourceForOutboundPayload) {
        this.sourceForOutboundPayload = sourceForOutboundPayload;
    }

    public Target getTargetForInboundPayload() {
        return this.targetForInboundPayload;
    }

    public void setTargetForInboundPayload(Target targetForInboundPayload) {
        this.targetForInboundPayload = targetForInboundPayload;
    }

    public String getSourceMessageType() {
        return this.sourceMessageType;
    }

    public void setSourceMessageType(String sourceMessageType) {
        this.sourceMessageType = sourceMessageType;
    }

    static {
        String confPath = System.getProperty("conf.location");
        if (confPath == null && (confPath = System.getProperty("carbon.config.dir.path")) == null) {
            confPath = Paths.get("repository", "conf").toString();
        }
        DEFAULT_AXIS2_XML = Paths.get(confPath, "axis2", "axis2_blocking_client.xml").toString();
    }
}

