/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.bean;

import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMText;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.ValueFactory;
import org.apache.synapse.config.xml.ValueSerializer;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class Target {
    private static final Log log = LogFactory.getLog(Target.class);
    private Value value;

    public Target(String attributeName, OMElement element) {
        this.value = new ValueFactory().createValue(attributeName, element);
    }

    public void insert(MessageContext synCtx, Object object) {
        if (this.value.getExpression() != null && this.value.getExpression() instanceof SynapseXPath) {
            SynapseXPath expression = (SynapseXPath)this.value.getExpression();
            Object targetObj = null;
            try {
                targetObj = expression.selectSingleNode(synCtx);
            }
            catch (JaxenException e) {
                this.handleException("Failed to select the target.", e);
            }
            if (targetObj instanceof OMText) {
                OMContainer targetParent = ((OMText)targetObj).getParent();
                if (targetParent != null && targetParent instanceof OMElement) {
                    ((OMElement)targetParent).setText(object == null ? "" : object.toString());
                } else {
                    this.handleException("Invalid target is specified by the expression: " + (Object)((Object)expression));
                }
            } else {
                this.handleException("Invalid target is specified by the expression: " + (Object)((Object)expression));
            }
        } else if (this.value.getKeyValue() != null) {
            synCtx.setProperty(this.value.getKeyValue(), object);
        } else {
            this.handleException("Invalid target description. " + this.value);
        }
    }

    public OMElement serializeTarget(String attributeName, OMElement element) {
        return new ValueSerializer().serializeValue(this.value, attributeName, element);
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private void handleException(String msg, Throwable e) {
        log.error((Object)msg);
        throw new SynapseException(msg, e);
    }
}

