/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.bean;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.Map;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.bean.BeanUtils;
import org.apache.synapse.mediators.bean.Target;

public class BeanMediator
extends AbstractMediator {
    private Action action;
    private String varName;
    private String propertyName;
    private Value value;
    private Target target;
    private boolean replace = true;
    private Class clazz;

    @Override
    public boolean mediate(MessageContext synCtx) {
        if (synCtx.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(synCtx)) {
            return true;
        }
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : Bean mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        boolean output = false;
        switch (this.action) {
            case CREATE: {
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("Creating a new bean of type '" + this.clazz.getName() + "' with var name '" + this.varName + "'.");
                }
                output = this.mediateCreateBeanAction(synCtx);
                break;
            }
            case REMOVE: {
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("Removing the bean with var name '" + this.varName + "'.");
                }
                output = this.mediateRemoveBeanAction(synCtx);
                break;
            }
            case SET_PROPERTY: {
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("Setting the '" + this.propertyName + "' property of the bean with var name '" + this.varName + "'.");
                }
                output = this.mediateSetPropertyAction(synCtx);
                break;
            }
            case GET_PROPERTY: {
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug("Retrieving the '" + this.propertyName + "' property of the bean with var name '" + this.varName + "'.");
                }
                output = this.mediateGetPropertyAction(synCtx);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("End : Bean mediator");
        }
        return output;
    }

    private boolean mediateCreateBeanAction(MessageContext synCtx) {
        if (!this.replace && synCtx.getProperty(this.varName) != null) {
            return true;
        }
        Object instance = null;
        try {
            instance = this.clazz.newInstance();
        }
        catch (Exception ex) {
            this.handleException("An error occurred while instantiating '" + this.clazz.getName() + "' class.", ex, synCtx);
        }
        synCtx.setProperty(this.varName, instance);
        return true;
    }

    private boolean mediateRemoveBeanAction(MessageContext synCtx) {
        synCtx.getPropertyKeySet().remove(this.varName);
        return true;
    }

    private boolean mediateSetPropertyAction(MessageContext synCtx) {
        Object bean = synCtx.getProperty(this.varName);
        if (bean == null) {
            this.handleException("Bean with var name '" + this.varName + "' was not found.", synCtx);
            return false;
        }
        Object valueObj = this.value.evaluateObjectValue(synCtx);
        if (bean instanceof Map) {
            ((Map)bean).put(this.propertyName, valueObj);
        } else {
            try {
                BeanUtils.invokeInstanceMethod(bean, new PropertyDescriptor(this.propertyName, bean.getClass()).getWriteMethod(), new Object[]{valueObj});
            }
            catch (IntrospectionException e) {
                this.handleException("Could not resolve the setter method for '" + this.propertyName + "' property in '" + bean.getClass() + "'.", e, synCtx);
            }
            catch (SynapseException e) {
                this.handleException("Error while invoking the setter method for '" + this.propertyName + "' property on '" + bean.getClass() + "'.", e, synCtx);
            }
        }
        return true;
    }

    private boolean mediateGetPropertyAction(MessageContext synCtx) {
        Object bean = synCtx.getProperty(this.varName);
        if (bean == null) {
            this.handleException("Bean with var name '" + this.varName + "' was not found.", synCtx);
            return false;
        }
        Object value = null;
        if (bean instanceof Map) {
            value = ((Map)bean).get(this.propertyName);
        } else {
            try {
                value = BeanUtils.invokeInstanceMethod(bean, new PropertyDescriptor(this.propertyName, bean.getClass()).getReadMethod(), new Object[0]);
            }
            catch (IntrospectionException e) {
                this.handleException("Could not resolve the getter method for '" + this.propertyName + "' property in '" + bean.getClass() + "'.", e, synCtx);
            }
            catch (SynapseException e) {
                this.handleException("Error while invoking the getter method for '" + this.propertyName + "' property on '" + bean.getClass() + "'.", e, synCtx);
            }
        }
        try {
            this.target.insert(synCtx, value);
        }
        catch (SynapseException e) {
            this.handleException("Failed to set the target after retrieving the bean property.", e, synCtx);
        }
        return true;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String varName) {
        this.varName = varName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public Value getValue() {
        return this.value;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public Target getTarget() {
        return this.target;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public boolean isReplace() {
        return this.replace;
    }

    public void setReplace(boolean replace) {
        this.replace = replace;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public void setClazz(Class clazz) {
        this.clazz = clazz;
    }

    public static enum Action {
        CREATE,
        REMOVE,
        SET_PROPERTY,
        GET_PROPERTY;

    }
}

