/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.base;

import java.util.Stack;
import org.apache.synapse.ContinuationState;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.Nameable;
import org.apache.synapse.SequenceType;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.flow.statistics.StatisticIdentityGenerator;
import org.apache.synapse.aspects.flow.statistics.collectors.CloseEventCollector;
import org.apache.synapse.aspects.flow.statistics.collectors.OpenEventCollector;
import org.apache.synapse.aspects.flow.statistics.collectors.RuntimeStatisticCollector;
import org.apache.synapse.aspects.flow.statistics.data.artifact.ArtifactHolder;
import org.apache.synapse.continuation.ContinuationStackManager;
import org.apache.synapse.continuation.SeqContinuationState;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.mediators.AbstractListMediator;
import org.apache.synapse.mediators.FlowContinuableMediator;
import org.apache.synapse.mediators.MediatorFaultHandler;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.transport.customlogsetter.CustomLogSetter;

public class SequenceMediator
extends AbstractListMediator
implements Nameable,
FlowContinuableMediator {
    private String name = null;
    private Value key = null;
    private String errorHandler = null;
    private boolean dynamic = false;
    private boolean initialized = false;
    private String registryKey = null;
    private String fileName;
    private SequenceType sequenceType = SequenceType.NAMED;
    private SynapseEnvironment synapseEnv;
    private String artifactContainerName;
    private boolean isEdited;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mediate(MessageContext synCtx) {
        if (synCtx.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(synCtx)) {
            return true;
        }
        SynapseLog synLog = this.getLog(synCtx);
        if (this.sequenceType == SequenceType.NAMED) {
            CustomLogSetter.getInstance().setLogAppender(this.artifactContainerName);
        }
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : Sequence " + (this.name == null ? (this.key == null ? "<anonymous" : "key=<" + this.key) : "<" + this.name) + ">");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        if (this.key == null) {
            Mediator errorHandlerMediator = null;
            Integer statisticReportingIndex = null;
            if (RuntimeStatisticCollector.isStatisticsEnabled()) {
                statisticReportingIndex = this.reportOpenStatistics(synCtx, false);
            }
            try {
                FaultHandler o;
                Stack<FaultHandler> faultStack;
                boolean result;
                boolean skipAddition;
                if (this.errorHandler != null) {
                    errorHandlerMediator = synCtx.getSequence(this.errorHandler);
                    if (errorHandlerMediator != null) {
                        if (synLog.isTraceOrDebugEnabled()) {
                            synLog.traceOrDebug("Setting the onError handler : " + this.errorHandler + " for the sequence : " + this.name);
                        }
                        synCtx.pushFaultHandler(new MediatorFaultHandler(errorHandlerMediator));
                    } else {
                        synLog.auditWarn("onError handler : " + this.errorHandler + " for sequence : " + this.name + " cannot be found");
                    }
                }
                if (!(skipAddition = ContinuationStackManager.isSkipSeqContinuationStateAddition(synCtx))) {
                    if (this.dynamic && this.registryKey != null) {
                        ContinuationStackManager.addSeqContinuationState(synCtx, this.registryKey, this.sequenceType);
                    } else {
                        ContinuationStackManager.addSeqContinuationState(synCtx, this.name, this.sequenceType);
                    }
                }
                if ((result = super.mediate(synCtx)) && !skipAddition) {
                    ContinuationStackManager.removeSeqContinuationState(synCtx, this.sequenceType);
                }
                if (result && errorHandlerMediator != null && (faultStack = synCtx.getFaultStack()) != null && !faultStack.isEmpty() && (o = faultStack.peek()) instanceof MediatorFaultHandler && errorHandlerMediator.equals(((MediatorFaultHandler)o).getFaultMediator())) {
                    faultStack.pop();
                }
                if (synLog.isTraceOrDebugEnabled()) {
                    if (synLog.isTraceTraceEnabled()) {
                        synLog.traceTrace("Message : " + synCtx.getEnvelope());
                    }
                    synLog.traceOrDebug("End : Sequence <" + (this.name == null ? "anonymous" : this.name) + ">");
                }
                boolean bl = result;
                return bl;
            }
            finally {
                if (RuntimeStatisticCollector.isStatisticsEnabled()) {
                    this.reportCloseStatistics(synCtx, statisticReportingIndex);
                }
            }
        }
        String sequenceKey = this.key.evaluateValue(synCtx);
        Mediator m = synCtx.getSequence(sequenceKey);
        if (m != null) {
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Executing with key " + this.key);
            }
            ContinuationStackManager.updateSeqContinuationState(synCtx, this.getMediatorPosition());
            boolean result = m.mediate(synCtx);
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("End : Sequence key=<" + this.key + ">");
            }
            return result;
        }
        this.handleException("Sequence named " + this.key + " cannot be found", synCtx);
        return false;
    }

    @Override
    public boolean mediate(MessageContext synCtx, ContinuationState continuationState) {
        boolean result;
        SynapseLog synLog = this.getLog(synCtx);
        if (this.sequenceType == SequenceType.NAMED) {
            CustomLogSetter.getInstance().setLogAppender(this.artifactContainerName);
        }
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Mediating using the SeqContinuationState type : " + (Object)((Object)((SeqContinuationState)continuationState).getSeqType()) + " name : " + ((SeqContinuationState)continuationState).getSeqName());
        }
        if (!continuationState.hasChild()) {
            result = super.mediate(synCtx, continuationState.getPosition() + 1);
        } else {
            do {
                FlowContinuableMediator mediator = (FlowContinuableMediator)((Object)this.getChild(continuationState.getPosition()));
                result = mediator.mediate(synCtx, continuationState.getChildContState());
                if (RuntimeStatisticCollector.isStatisticsEnabled()) {
                    ((Mediator)((Object)mediator)).reportCloseStatistics(synCtx, null);
                }
                if (!result) continue;
                continuationState.removeLeafChild();
            } while (result && continuationState.hasChild());
            if (result) {
                result = super.mediate(synCtx, continuationState.getPosition() + 1);
            }
        }
        if (result) {
            Stack<FaultHandler> faultStack = synCtx.getFaultStack();
            if (faultStack != null && !faultStack.isEmpty()) {
                FaultHandler o = faultStack.peek();
                if (this.errorHandler != null) {
                    Mediator errorHandlerMediator = synCtx.getSequence(this.errorHandler);
                    if (o instanceof MediatorFaultHandler && errorHandlerMediator.equals(((MediatorFaultHandler)o).getFaultMediator())) {
                        faultStack.pop();
                    }
                }
            }
            ContinuationStackManager.popContinuationStateStack(synCtx);
        }
        return result;
    }

    @Override
    public synchronized void init(SynapseEnvironment se) {
        if (!this.initialized) {
            this.synapseEnv = se;
            super.init(se);
            this.initialized = true;
            if (!this.isDynamic()) {
                se.clearUnavailabilityOfArtifact(this.name);
            }
            if (this.key != null) {
                if (this.key.getKeyValue() != null) {
                    SequenceMediator sequenceMediator = (SequenceMediator)se.getSynapseConfiguration().getSequence(this.key.getKeyValue());
                    if (sequenceMediator == null || sequenceMediator.isDynamic()) {
                        se.addUnavailableArtifactRef(this.key.getKeyValue());
                    }
                } else {
                    se.addUnavailableArtifactRef(this.key.getExpression().toString());
                }
            }
        }
    }

    @Override
    public synchronized void destroy() {
        if (this.initialized) {
            super.destroy();
            this.initialized = false;
            if (this.key != null) {
                if (this.key.getKeyValue() != null) {
                    SequenceMediator sequenceMediator = (SequenceMediator)this.synapseEnv.getSynapseConfiguration().getSequence(this.key.getKeyValue());
                    if (sequenceMediator == null || sequenceMediator.isDynamic()) {
                        this.synapseEnv.removeUnavailableArtifactRef(this.key.getKeyValue());
                    }
                } else {
                    this.synapseEnv.removeUnavailableArtifactRef(this.key.getExpression().toString());
                }
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public Value getKey() {
        return this.key;
    }

    public void setKey(Value key) {
        this.key = key;
    }

    public String getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(String errorHandler) {
        this.errorHandler = errorHandler;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public String getRegistryKey() {
        return this.registryKey;
    }

    public void setRegistryKey(String registryKey) {
        this.registryKey = registryKey;
    }

    public String getAuditId() {
        return this.getName();
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setArtifactContainerName(String name) {
        this.artifactContainerName = name;
    }

    public String getArtifactContainerName() {
        return this.artifactContainerName;
    }

    public boolean isEdited() {
        return this.isEdited;
    }

    public void setIsEdited(boolean isEdited) {
        this.isEdited = isEdited;
    }

    @Override
    public boolean isContentAware() {
        return false;
    }

    public void setSequenceType(SequenceType sequenceType) {
        this.sequenceType = sequenceType;
    }

    public String getSequenceNameForStatistics() {
        if (this.name != null) {
            return this.name;
        }
        if (this.sequenceType != SequenceType.ANON) {
            return this.sequenceType.toString();
        }
        return "AnonymousSequence";
    }

    @Override
    public Integer reportOpenStatistics(MessageContext messageContext, boolean isContentAltering) {
        if (this.key == null) {
            return OpenEventCollector.reportEntryEvent(messageContext, this.getSequenceNameForStatistics(), this.getAspectConfiguration(), ComponentType.SEQUENCE);
        }
        return null;
    }

    @Override
    public void reportCloseStatistics(MessageContext messageContext, Integer currentIndex) {
        if (this.key == null) {
            CloseEventCollector.tryEndFlow(messageContext, this.getSequenceNameForStatistics(), ComponentType.SEQUENCE, currentIndex, this.isContentAltering());
        }
    }

    @Override
    public void setComponentStatisticsId(ArtifactHolder holder) {
        String sequenceId = null;
        if (this.getAspectConfiguration() == null) {
            this.configure(new AspectConfiguration(this.name));
        }
        sequenceId = this.getKey() != null ? StatisticIdentityGenerator.getIdReferencingComponent(this.getKey().getKeyValue(), ComponentType.SEQUENCE, holder) : StatisticIdentityGenerator.getIdForFlowContinuableMediator(this.getSequenceNameForStatistics(), ComponentType.SEQUENCE, holder);
        this.getAspectConfiguration().setUniqueId(sequenceId);
        this.setStatisticIdForMediators(holder);
        if (this.sequenceType != SequenceType.ANON) {
            StatisticIdentityGenerator.reportingFlowContinuableEndEvent(sequenceId, ComponentType.SEQUENCE, holder);
        }
    }
}

