/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.aspects.flow.statistics.collectors.CloseEventCollector;
import org.apache.synapse.aspects.flow.statistics.collectors.RuntimeStatisticCollector;
import org.apache.synapse.carbonext.TenantInfoConfigurator;
import org.apache.synapse.debug.SynapseDebugManager;
import org.apache.synapse.util.logging.LoggingUtils;

public class MediatorWorker
implements Runnable {
    private static final Log log = LogFactory.getLog(MediatorWorker.class);
    private static final Log trace = LogFactory.getLog((String)"TRACE_LOGGER");
    private Mediator seq = null;
    private MessageContext synCtx = null;

    public MediatorWorker(Mediator seq, MessageContext synCtx) {
        this.seq = seq;
        this.synCtx = synCtx;
    }

    public MediatorWorker(MessageContext synCtx) {
        this.synCtx = synCtx;
        this.seq = synCtx.getMainSequence();
    }

    @Override
    public void run() {
        try {
            TenantInfoConfigurator configurator = this.synCtx.getEnvironment().getTenantInfoConfigurator();
            if (configurator != null) {
                configurator.applyTenantInfo(this.synCtx);
            }
            if (this.synCtx.getEnvironment().isDebuggerEnabled()) {
                SynapseDebugManager debugManager = this.synCtx.getEnvironment().getSynapseDebugManager();
                debugManager.acquireMediationFlowLock();
                debugManager.advertiseMediationFlowStartPoint(this.synCtx);
            }
            this.seq.mediate(this.synCtx);
        }
        catch (SynapseException syne) {
            if (!this.synCtx.getFaultStack().isEmpty()) {
                this.warn(false, "Executing fault handler due to exception encountered", this.synCtx);
                this.synCtx.getFaultStack().pop().handleFault(this.synCtx, syne);
            } else {
                this.warn(false, "Exception encountered but no fault handler found - message dropped", this.synCtx);
            }
        }
        catch (Exception e) {
            String msg = "Unexpected error executing task/async inject";
            log.error((Object)LoggingUtils.getFormattedLog(this.synCtx, msg), (Throwable)e);
            if (this.synCtx.getServiceLog() != null) {
                this.synCtx.getServiceLog().error((Object)msg, (Throwable)e);
            }
            if (!this.synCtx.getFaultStack().isEmpty()) {
                this.warn(false, "Executing fault handler due to exception encountered", this.synCtx);
                this.synCtx.getFaultStack().pop().handleFault(this.synCtx, e);
            } else {
                this.warn(false, "Exception encountered but no fault handler found - message dropped", this.synCtx);
            }
        }
        catch (Throwable e) {
            String msg = "Unexpected error executing task/async inject, message dropped";
            log.error((Object)LoggingUtils.getFormattedLog(this.synCtx, msg), e);
            if (this.synCtx.getServiceLog() != null) {
                this.synCtx.getServiceLog().error((Object)msg, e);
            }
        }
        finally {
            if (this.synCtx.getEnvironment().isDebuggerEnabled()) {
                SynapseDebugManager debugManager = this.synCtx.getEnvironment().getSynapseDebugManager();
                debugManager.advertiseMediationFlowTerminatePoint(this.synCtx);
                debugManager.releaseMediationFlowLock();
            }
            if (RuntimeStatisticCollector.isStatisticsEnabled()) {
                CloseEventCollector.closeFlowForcefully(this.synCtx, false);
            }
        }
        this.synCtx = null;
        this.seq = null;
    }

    private void warn(boolean traceOn, String msg, MessageContext msgContext) {
        String formattedLog = LoggingUtils.getFormattedLog(msgContext, msg);
        if (traceOn) {
            trace.warn((Object)formattedLog);
        }
        if (log.isDebugEnabled()) {
            log.warn((Object)formattedLog);
        }
        if (msgContext.getServiceLog() != null) {
            msgContext.getServiceLog().warn((Object)msg);
        }
    }
}

